package com.els.base.wechat.msg.web.controller;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.wechat.msg.entity.WxMsgRule;
import com.els.base.wechat.msg.entity.WxMsgRuleExample;
import com.els.base.wechat.msg.service.WxMsgRuleService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(value="微信-公众号后台消息规则")
@Controller
@RequestMapping("wechatMsgRule")
public class WechatMsgRuleController {
    @Resource
    protected WxMsgRuleService wxMsgRuleService;

    @ApiOperation(httpMethod="POST", value="创建微信消息规则")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody WxMsgRule wxMsgRule) {
        this.wxMsgRuleService.addObj(wxMsgRule);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑微信消息规则")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody WxMsgRule wxMsgRule) {
        if (StringUtils.isBlank(wxMsgRule.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.wxMsgRuleService.modifyObj(wxMsgRule);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除微信消息规则")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(String id) {
        this.wxMsgRuleService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="查询微信消息规则")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<WxMsgRule>> findByPage(
    		@ApiParam(name="分页索引",defaultValue="0") @RequestParam(defaultValue="1") int pageNo, 
    		@ApiParam(name="每页的数量",defaultValue="10") @RequestParam(defaultValue="10") int pageSize, 
    		@ApiParam(name="查询条件") String sSearch,
    		@ApiParam(name="公众号原始id") String originId) {
    	PageView<WxMsgRule> pageView = new PageView<>(pageNo, pageSize);
        WxMsgRuleExample example = new WxMsgRuleExample();
        example.setPageView(pageView);
        example.createCriteria().andWxAccountOriginIdEqualTo(originId);
        
        if (StringUtils.isNotBlank(sSearch)) {
            // TODO Auto-generated method stub
        }
        
        example.setOrderByClause("priority DESC");
        return ResponseResult.success(this.wxMsgRuleService.queryObjByPage(example));
    }
    
    @ApiOperation(httpMethod = "GET", value = "启用或禁用消息规则")
	@RequestMapping("service/setIsEnableById")
	@ResponseBody
	public ResponseResult<String> setIsEnableById(String id, int isEnable) {
		// this.snsModuleService.deleteObjById(id);
		WxMsgRule tmp = this.wxMsgRuleService.queryObjById(id);
		tmp.setId(id);
		if (Constant.YES_INT.equals(isEnable)) {
			tmp.setIsEnable(Constant.YES_INT);
		} else {
			tmp.setIsEnable(Constant.NO_INT);
		}
		
		this.wxMsgRuleService.modifyObj(tmp);
		
		return ResponseResult.success();
	}
}