package com.els.base.wechat.msg.web.controller;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.wechat.account.utils.WxAccountConfigUtils;
import com.els.base.wechat.msg.entity.WxTemplateMessage;
import com.els.base.wechat.msg.entity.WxTemplateMessageExample;
import com.els.base.wechat.msg.service.WxTemplateMessageService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="微信-公众号模板消息")
@Controller
@RequestMapping("wxTemplateMessage")
public class WxTemplateMessageController {
    @Resource
    protected WxTemplateMessageService wxTemplateMessageService;

    @ApiOperation(httpMethod="POST", value="创建公众号模板消息")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody WxTemplateMessage wxTemplateMessage) {
    	
    	if (StringUtils.isBlank(wxTemplateMessage.getWxAccountId())) {
			wxTemplateMessage.setWxAccountId(WxAccountConfigUtils.getDefaultAccountFromConfig().getId());
		}
    	
        this.wxTemplateMessageService.addObj(wxTemplateMessage);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑公众号模板消息")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody WxTemplateMessage wxTemplateMessage) {
        if (StringUtils.isBlank(wxTemplateMessage.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.wxTemplateMessageService.modifyObj(wxTemplateMessage);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除公众号模板消息")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.wxTemplateMessageService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询公众号模板消息")
    @ApiImplicitParams({ 
	 @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
	 @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
	 @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 WxTemplateMessage", paramType = "body", dataType = "QueryParamWapper" )  
}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<WxTemplateMessage>> findByPage( 
	 @RequestParam(defaultValue="0") int pageNo,  
	 @RequestParam(defaultValue="10") int pageSize, 
	 @RequestBody(required=false) QueryParamWapper wapper) {
        WxTemplateMessageExample example = new WxTemplateMessageExample();
        example.setPageView(new PageView<WxTemplateMessage>(pageNo, pageSize));
        
        if (wapper != null) {
            WxTemplateMessageExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        PageView<WxTemplateMessage> pageData = this.wxTemplateMessageService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}