package com.els.base.wechat.pay.web.controller;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.http.HttpRequestUtils;
import com.els.base.wechat.common.WxConstant;
import com.els.base.wechat.common.utils.XmlUtils;
import com.els.base.wechat.pay.entity.WxMpXmlInOrderQueryMessage;
import com.els.base.wechat.pay.entity.WxMpXmlUnifiedOrderInMessage;
import com.els.base.wechat.pay.service.WechatPayNotifyService;

import io.swagger.annotations.Api;

/**
 * 微信支付接口
 * @author hzy
 *
 */
@Api("微信-网页支付")
@Controller("wechatPayController")
public class WechatPayController {
	
	private Logger logger = LoggerFactory.getLogger(WechatPayController.class);
	
	@RequestMapping(WxConstant.URL_PAID_NOTIFY)
	@ResponseBody
	public String payResultNotify(HttpServletRequest request) throws IOException{
		WechatPayNotifyService wechatPayNotifyService = SpringContextHolder.getOneBean(WechatPayNotifyService.class);
		
		String requestBody = HttpRequestUtils.getRequestBody(request);
		logger.info("receive PayResult notify:" +requestBody);
		
		WxMpXmlInOrderQueryMessage inMsg = XmlUtils.parseXMl(requestBody, WxMpXmlInOrderQueryMessage.class);
		if (wechatPayNotifyService != null) {
			wechatPayNotifyService.handlePaidNotifyMsg(inMsg);
		}
		
		WxMpXmlUnifiedOrderInMessage resultMsg = new WxMpXmlUnifiedOrderInMessage();
		resultMsg.setReturnCode("SUCCESS");
		resultMsg.setResultCode("OK");
		return resultMsg.toXml();
	}

}
