package com.els.base.wechat.account.web.controller;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.account.entity.AccountConfigExample;
import com.els.base.wechat.account.service.AccountConfigService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(value = "微信-公众号账号表")
@Controller
@RequestMapping("accountConfig")
public class AccountConfigController {
	@Resource
	protected AccountConfigService accountConfigService;

	@ApiOperation(httpMethod = "POST", value = "创建微信账号表")
	@RequestMapping("service/create")
	@ResponseBody
	public ResponseResult<String> create(@RequestBody AccountConfig accountConfig) {
		this.accountConfigService.addObj(accountConfig);
		return ResponseResult.success();
	}

	@ApiOperation(httpMethod = "POST", value = "编辑微信账号表")
	@RequestMapping("service/edit")
	@ResponseBody
	public ResponseResult<String> edit(@RequestBody AccountConfig accountConfig) {
		Assert.isNotBlank(accountConfig.getId(), "id 为空，保存失败");
		
		this.accountConfigService.modifyObj(accountConfig);
		return ResponseResult.success();
	}

	@ApiOperation(httpMethod = "POST", value = "删除微信账号表")
	@RequestMapping("service/deleteById")
	@ResponseBody
	public ResponseResult<String> deleteById(String id) {
		this.accountConfigService.deleteObjById(id);
		return ResponseResult.success();
	}

	@ApiOperation(httpMethod = "GET", value = "查询微信账号表")
	@RequestMapping("service/findByPage")
	@ResponseBody
	public ResponseResult<PageView<AccountConfig>> findByPage(
			@ApiParam(name = "分页索引", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
			@ApiParam(name = "每页的数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
			@ApiParam(value = "查询条件") @RequestBody(required=false) QueryParamWapper queryParams) {
		
		PageView<AccountConfig> pageView = new PageView<>(pageNo, pageSize);
		AccountConfigExample example = new AccountConfigExample();
		example.setPageView(pageView);
		
		if (queryParams!=null) {
			CriteriaUtils.addCriterion(example.createCriteria(), queryParams);
		}
		return ResponseResult.success(this.accountConfigService.queryObjByPage(example));
	}
}