/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.oauth.utils;

import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.common.WxMpServiceUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Hashtable;
import java.util.Map;
import me.chanjar.weixin.mp.api.WxMpService;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatOauthUtils {
    private static Logger logger = LoggerFactory.getLogger(WechatOauthUtils.class);

    public static String createOauthUrlForOpenid(String targetUrl, Map<String, String> paramsMap, AccountConfig accountConfig) throws Exception {
        if (accountConfig == null) {
            throw new NullPointerException("\u6ca1\u6709\u5bf9\u5e94\u7684\u5fae\u4fe1\u516c\u4f17\u53f7\u7684\u8d26\u53f7\u914d\u7f6e\uff0c\u65e0\u6cd5\u8fdb\u884c\u6388\u6743");
        }
        if (paramsMap == null) {
            paramsMap = new Hashtable<String, String>();
        }
        paramsMap.put("TU", targetUrl);
        paramsMap.put("APPID", accountConfig.getOriginId());
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString(paramsMap);
        String params = Base64.encodeBase64String((byte[])json.getBytes());
        String domain = accountConfig.getDomain().replaceAll("/$", "");
        domain = domain.replaceAll(":\\w+", "");
        String getCodeUrl = domain + "/wechatOauth/front/oauth2Openid" + "/" + params;
        WxMpService wxMpService = WxMpServiceUtils.getWxMpServiceByAccount(accountConfig);
        String oauth2Url = wxMpService.oauth2buildAuthorizationUrl(getCodeUrl, "snsapi_base", null);
        return oauth2Url;
    }

    public static String createOauthUrlForWxUserInfo(String targetUrl, Map<String, String> paramsMap, AccountConfig accountConfig) throws Exception {
        if (accountConfig == null) {
            throw new NullPointerException("\u6ca1\u6709\u5bf9\u5e94\u7684\u5fae\u4fe1\u516c\u4f17\u53f7\u7684\u8d26\u53f7\u914d\u7f6e\uff0c\u65e0\u6cd5\u8fdb\u884c\u6388\u6743");
        }
        if (paramsMap == null) {
            paramsMap = new Hashtable<String, String>();
        }
        paramsMap.put("TU", targetUrl);
        paramsMap.put("APPID", accountConfig.getOriginId());
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString(paramsMap);
        String params = Base64.encodeBase64String((byte[])json.getBytes());
        String domain = accountConfig.getDomain().replaceAll("/$", "");
        logger.debug("[create oauth url] domain:" + domain);
        domain = domain.replaceAll(":\\w+", "");
        String getCodeUrl = domain + "/wechatOauth/front/oauth2WxUserInfo" + "/" + params;
        logger.debug("[create oauth url] getCodeUrl:" + getCodeUrl);
        WxMpService wxMpService = WxMpServiceUtils.getWxMpServiceByAccount(accountConfig);
        String oauth2Url = wxMpService.oauth2buildAuthorizationUrl(getCodeUrl, "snsapi_userinfo", null);
        return oauth2Url;
    }
}

