package com.els.base.wechat.msg.web.controller;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.wechat.account.service.AccountConfigService;
import com.els.base.wechat.msg.entity.WxMsgReplyNews;
import com.els.base.wechat.msg.entity.WxMsgReplyNewsExample;
import com.els.base.wechat.msg.service.WxMsgReplyNewsService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="微信-公众号自定义图文消息")
@Controller
@RequestMapping("wxMsgReplyNews")
public class WxMsgReplyNewsController {
    @Resource
    protected WxMsgReplyNewsService wxMsgReplyNewsService;
    
    @Autowired
    protected AccountConfigService accountConfigService;

    @ApiIgnore
    @RequestMapping("service/toAddView")
    public ModelAndView toAddView(@RequestParam(required=true, name="originId") String originId) {
    	ModelAndView view = new ModelAndView("wechat/wxMsgReplyNews/toAddView");
    	view.addObject("account", accountConfigService.queryByOriginId(originId));
        return view;
    }

    @ApiIgnore
    @RequestMapping("service/toMainView")
    public ModelAndView toMainView() {
        return new ModelAndView("wechat/wxMsgReplyNews/toMainView");
    }

    @ApiIgnore
    @RequestMapping("service/toUpdateViewById")
    public ModelAndView toUpdateViewById(int id, @RequestParam(required=true, name="originId")String originId) {
        ModelAndView view = new ModelAndView();
        WxMsgReplyNews wxMsgReplyNews = this.wxMsgReplyNewsService.queryObjById(id);
        view.addObject("wxMsgReplyNews", wxMsgReplyNews);
        view.addObject("account", accountConfigService.queryByOriginId(originId));
        view.setViewName("wechat/wxMsgReplyNews/toAddView");
        return view;
    }

    @ApiOperation(httpMethod="POST", value="创建自定义图文消息")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody WxMsgReplyNews wxMsgReplyNews) {
        this.wxMsgReplyNewsService.addObj(wxMsgReplyNews);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑自定义图文消息")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody WxMsgReplyNews wxMsgReplyNews) {
        if (wxMsgReplyNews.getId() == null || wxMsgReplyNews.getId() <=0) {
            throw new CommonException("id 为空，保存失败");
        }
        this.wxMsgReplyNewsService.modifyObj(wxMsgReplyNews);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除自定义图文消息")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(int id) {
        this.wxMsgReplyNewsService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="查询自定义图文消息")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<WxMsgReplyNews>> findByPage(
    		@ApiParam(name="分页索引",defaultValue="0") @RequestParam(defaultValue="1") int pageNo, 
    		@ApiParam(name="每页的数量",defaultValue="10") @RequestParam(defaultValue="10") int pageSize, 
    		@ApiParam(value="查询条件") String sSearch) {
        PageView<WxMsgReplyNews> pageView = new PageView<>(pageNo, pageSize);
        WxMsgReplyNewsExample example = new WxMsgReplyNewsExample();
        example.setPageView(pageView);
        if (StringUtils.isNotBlank(sSearch)) {
            // TODO Auto-generated method stub
        }
        return ResponseResult.success(this.wxMsgReplyNewsService.queryObjByPage(example));
    }
}