package com.els.base.wechat.account.utils;

import java.util.List;
import java.util.Properties;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import com.els.base.core.exception.CommonException;
import com.els.base.utils.SpringContextHolder;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.account.service.AccountConfigService;

public abstract class WxAccountConfigUtils {
	
	private static AccountConfigService accountConfigService = SpringContextHolder.getOneBean(AccountConfigService.class);
	
	public static AccountConfig getByOrginId(String originId){
		return accountConfigService.queryByOriginId(originId);
	}
	
	public static AccountConfig getDefaultAccountFromConfig(){
		
		List<AccountConfig> defaultConfList = accountConfigService.queryAllObjByExample(null);
		if (CollectionUtils.isEmpty(defaultConfList)) {
			throw new CommonException("系统没有配置默认的公众号帐号 [wx.account.originId] ");
		}
		
		if (defaultConfList.size() == 1) {
			return defaultConfList.get(0);
		}
		
		String originId = SpringContextHolder.getProperty("wx.account.originId");
		if (StringUtils.isBlank(originId)) {
			throw new CommonException("系统没有配置默认的公众号帐号 [wx.account.originId] ");
		}
		
		return getByOrginId(originId);
	}
	
}
