package com.els.base.wechat.member.service;

import com.els.base.core.service.BaseService;
import com.els.base.wechat.member.entity.WxMember;
import com.els.base.wechat.member.entity.WxMemberExample;

import me.chanjar.weixin.mp.bean.result.WxMpUser;

public interface WxMemberService extends BaseService<WxMember, WxMemberExample, String>{
	
	/**
	 * 根据openid查询微信会员资料
	 * @param openid
	 * @return
	 */
	public WxMember queryByOpenId(String openid);
	
	/**
	 * 根据微信用户资料添加或者更新 微信会员信息
	 * @param wxMpUser
	 */
//	public WxMember createOrEditWxMember(WxMpUser wxMpUser);
	
	/**
	 * 根据微信用户资料添加或者更新 微信会员信息
	 * @param wxMpUser 关注公众号后，查询结果
	 * @param subscribeKey 关注公众号的，事件key
	 */
//	public WxMember createOrEditWxMember(WxMpUser wxMpUser, String subscribeKey);
	
	/**
	 * 当会员取消关注的时候，更新微信会员的关注状态
	 * @param openid
	 */
	public void updateForUnsubscribe(String openid);

	/**
	 * 创建或更新微信会员信息
	 * @param wxMpUser
	 * @param subscribeKey
	 * @param originId
	 * @return
	 */
	WxMember createOrEditWxMember(WxMpUser wxMpUser, String subscribeKey, String originId);

	/**
	 * 解绑会员和微信会员的信息
	 * @param id
	 */
	public void unTieMemberId(String memeberId);
}
