/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.redpack;

import com.els.base.wechat.member.entity.WxMember;
import com.els.base.wechat.member.service.WxMemberService;
import com.els.base.wechat.redpack.WxRedpackSentEvent;
import com.els.base.wechat.redpack.entity.WxRedpackSendRecord;
import com.els.base.wechat.redpack.service.WxRedpackSendRecordService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class WxRedpackSentListener
implements ApplicationListener<WxRedpackSentEvent> {
    @Autowired
    protected WxRedpackSendRecordService wxRedpackSendRecordService;
    @Autowired
    protected WxMemberService wxMemberService;

    public void onApplicationEvent(WxRedpackSentEvent event) {
        String status = null;
        status = "SUCCESS".equals(event.getInMessage().getReturnCode()) && "SUCCESS".equals(event.getInMessage().getResultCode()) ? "SENT" : "FAILED";
        String remark = event.getInMessage().getErrCodeDes();
        String billNo = event.getOutMessage().getMchBillNo();
        WxRedpackSendRecord record = this.wxRedpackSendRecordService.queryByBillNo(billNo);
        if (record != null) {
            WxRedpackSendRecord tmp = new WxRedpackSendRecord();
            tmp.setId(record.getId());
            tmp.setRemark(remark);
            tmp.setSendTime(new Date());
            tmp.setStatus(status);
            this.wxRedpackSendRecordService.modifyObj(tmp);
            return;
        }
        WxMember wxMember = this.wxMemberService.queryByOpenId(event.getOutMessage().getReOpenid());
        record = new WxRedpackSendRecord();
        record.setAccountId(event.getAccountConfig().getId());
        record.setAccountName(event.getAccountConfig().getName());
        record.setBillNo(event.getOutMessage().getMchBillNo());
        record.setOpenid(event.getOutMessage().getReOpenid());
        record.setRedpackId(event.getWxRedpack().getId());
        record.setRedpackCode(event.getWxRedpack().getRedpackCode());
        record.setTotalAmount(event.getOutMessage().getTotalAmount());
        record.setSceneId(event.getOutMessage().getSceneId());
        record.setActName(event.getOutMessage().getActName());
        record.setSendName(event.getOutMessage().getSendName());
        record.setWishing(event.getOutMessage().getWishing());
        record.setSendTime(new Date());
        if (wxMember != null) {
            record.setMemberName(wxMember.getWxNickname());
        }
        record.setStatus(status);
        record.setRemark(remark);
        this.wxRedpackSendRecordService.addObj(record);
    }
}

