-- ----------------------------
-- 审批流
-- ----------------------------
-- DROP TABLE "T_BASE_WF_DEPLOYMENT";
CREATE TABLE "T_BASE_WF_DEPLOYMENT"
(
    "ID"            VARCHAR2(32 CHAR)  NOT NULL,
    "BUSINESS_CODE" VARCHAR2(255 CHAR),
    "BUSINESS_NAME" VARCHAR2(255 CHAR),
    "NAME"          VARCHAR2(255 CHAR) NOT NULL,
    "IS_ENABLE"     NUMBER(5),
    "CREATE_USER"   VARCHAR2(255 CHAR),
    "CREATE_TIME"   DATE,
    "UPDATE_USER"   VARCHAR2(255 CHAR),
    "UPDATE_TIME"   DATE,
    "REMARK"        VARCHAR2(255 CHAR)
);

COMMENT ON COLUMN "T_BASE_WF_DEPLOYMENT"."ID" IS '序号';
COMMENT ON COLUMN "T_BASE_WF_DEPLOYMENT"."BUSINESS_CODE" IS '菜单编码';
COMMENT ON COLUMN "T_BASE_WF_DEPLOYMENT"."BUSINESS_NAME" IS '菜单名称';
COMMENT ON COLUMN "T_BASE_WF_DEPLOYMENT"."NAME" IS '审批流名称';
COMMENT ON COLUMN "T_BASE_WF_DEPLOYMENT"."IS_ENABLE" IS '是否启用审批流,是1,否0';
COMMENT ON COLUMN "T_BASE_WF_DEPLOYMENT"."CREATE_USER" IS '创建人';
COMMENT ON COLUMN "T_BASE_WF_DEPLOYMENT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_WF_DEPLOYMENT"."UPDATE_USER" IS '修改人';
COMMENT ON COLUMN "T_BASE_WF_DEPLOYMENT"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BASE_WF_DEPLOYMENT"."REMARK" IS '备注';
COMMENT ON TABLE "T_BASE_WF_DEPLOYMENT" IS '审批流';

ALTER TABLE "T_BASE_WF_DEPLOYMENT"
    ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 审批流设置
-- ----------------------------
-- DROP TABLE "T_BASE_WF_SET";
CREATE TABLE "T_BASE_WF_SET"
(
    "ID"               VARCHAR2(32 CHAR) NOT NULL,
    "CURRENT_PROCESS"  VARCHAR2(255 CHAR),
    "CONDITION_SET_UP" NUMBER(7),
    "CONDITION_"       VARCHAR2(255 CHAR),
    "APPROVE_GROUP"    VARCHAR2(255 CHAR),
    "APPROVE_ASSIGNEE" VARCHAR2(255 CHAR),
    "GROUP_ID"         VARCHAR2(2000 BYTE),
    "ASSIGNEE_ID"      VARCHAR2(2000 BYTE),
    "REMARK"           VARCHAR2(255 CHAR),
    "DEPLOYMENT_ID"    VARCHAR2(32 BYTE)
);


COMMENT ON COLUMN "T_BASE_WF_SET"."ID" IS '编号';
COMMENT ON COLUMN "T_BASE_WF_SET"."CURRENT_PROCESS" IS '当前审批';
COMMENT ON COLUMN "T_BASE_WF_SET"."CONDITION_SET_UP" IS '条件设置(0=所有人,1=任意一人)';
COMMENT ON COLUMN "T_BASE_WF_SET"."CONDITION_" IS '审批设置';
COMMENT ON COLUMN "T_BASE_WF_SET"."APPROVE_GROUP" IS '审批角色组';
COMMENT ON COLUMN "T_BASE_WF_SET"."APPROVE_ASSIGNEE" IS '审批人';
COMMENT ON COLUMN "T_BASE_WF_SET"."GROUP_ID" IS '审批角色组ID';
COMMENT ON COLUMN "T_BASE_WF_SET"."ASSIGNEE_ID" IS '审批人ID';
COMMENT ON COLUMN "T_BASE_WF_SET"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_WF_SET"."DEPLOYMENT_ID" IS '部署关联id';
COMMENT ON TABLE "T_BASE_WF_SET" IS '审批流设置';


ALTER TABLE "T_BASE_WF_SET"
    ADD PRIMARY KEY ("ID");
