/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.workflow.common.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.file.entity.FileData;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.workflow.common.entity.WorkOrderVo;
import com.els.base.workflow.common.service.WorkFlowService;
import com.els.base.workflow.common.utils.ExcelFileData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.activiti.engine.RepositoryService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Api(value="\u5de5\u4f5c\u6d41")
@Controller
@RequestMapping(value={"workFlow"})
public class WorkFlowController {
    @ApiOperation(httpMethod="POST", value="\u90e8\u7f72\u6d41\u7a0b\u56fe")
    @RequestMapping(value={"service/deployBpmnZip"})
    @ResponseBody
    public ResponseResult<String> deployBpmnZip(@RequestParam(required=true) MultipartFile file) throws IOException {
        RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getOneBean(RepositoryService.class);
        repositoryService.createDeployment().addZipInputStream(new ZipInputStream(file.getInputStream())).deploy();
        return ResponseResult.success((Object)String.valueOf(repositoryService.createProcessDefinitionQuery().count()));
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u627e\u5f53\u524d\u89d2\u8272\u7684\u5df2\u5b8c\u6210\u7684\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="1"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="title", required=false, value="\u5f85\u529e\u540d\u79f0", paramType="query", dataType="String"), @ApiImplicitParam(name="businessKey", required=false, value="\u4e1a\u52a1\u7f16\u7801", paramType="query", dataType="String")})
    @RequestMapping(value={"service/findDoneTask"})
    @ResponseBody
    public ResponseResult<PageView<WorkOrderVo>> findDoneTask(@RequestParam(defaultValue="1") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String title, @RequestParam(required=false) String businessKey, @RequestParam(required=false) String startUser) {
        List roleList = SpringSecurityUtils.getLoginUserRoleList();
        if (CollectionUtils.isEmpty((Collection)roleList)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        WorkFlowService workFlowService = (WorkFlowService)SpringContextHolder.getOneBean(WorkFlowService.class);
        PageView pageView = new PageView(pageNo, pageSize);
        return ResponseResult.success(workFlowService.findDoneTask((PageView<WorkOrderVo>)pageView, SpringSecurityUtils.getLoginUser(), title, businessKey, startUser));
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u627e\u5f53\u524d\u89d2\u8272\u7684\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="1"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="title", required=false, value="\u5f85\u529e\u540d\u79f0", paramType="query", dataType="String"), @ApiImplicitParam(name="businessKey", required=false, value="\u4e1a\u52a1\u7f16\u7801", paramType="query", dataType="String")})
    @RequestMapping(value={"service/findTodoTask"})
    @ResponseBody
    public ResponseResult<PageView<WorkOrderVo>> findTodoTask(@RequestParam(defaultValue="1") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String title, @RequestParam(required=false) String businessKey, @RequestParam(required=false) String startUser) {
        List roleList = SpringSecurityUtils.getLoginUserRoleList();
        if (CollectionUtils.isEmpty((Collection)roleList)) {
            return ResponseResult.success((Object)new PageView(pageNo, pageSize));
        }
        WorkFlowService workFlowService = (WorkFlowService)SpringContextHolder.getOneBean(WorkFlowService.class);
        PageView pageView = new PageView(pageNo, pageSize);
        return ResponseResult.success(workFlowService.findTodoTask((PageView<WorkOrderVo>)pageView, SpringSecurityUtils.getLoginUser(), title, businessKey, startUser));
    }

    @ApiOperation(value="\u5df2\u529e\u5bfc\u51faExcel", httpMethod="POST")
    @RequestMapping(value={"service/exportForDoneDownload"})
    @ResponseBody
    public ResponseResult<FileData> exportForPurCompanyVerDownload(@RequestBody(required=false) List<String> ids, String businessKey, String title) throws Exception {
        WorkFlowService workFlowService = (WorkFlowService)SpringContextHolder.getOneBean(WorkFlowService.class);
        List<WorkOrderVo> vos = workFlowService.findDoneTaskByExport(SpringSecurityUtils.getLoginUser(), ids, businessKey, title);
        for (WorkOrderVo workOrderVo : vos) {
            Map<String, Object> proinstMap = workOrderVo.getProinstMap();
            String startUser = (String)proinstMap.get("startUser");
            workOrderVo.setStartUser(startUser);
        }
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5df2\u529e\u540d\u79f0", (String)"title"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e1a\u52a1\u7f16\u7801", (String)"businessKey"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5236\u5355\u4eba", (String)"startUser"));
        FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, vos, "\u5df2\u529e\u5ba1\u6279", "\u5df2\u529e\u5ba1\u6279", 0);
        return ResponseResult.success((Object)fileData);
    }

    @ApiOperation(value="\u5f85\u529e\u5bfc\u51faExcel", httpMethod="POST")
    @RequestMapping(value={"service/exportForTodoTDownload"})
    @ResponseBody
    public ResponseResult<FileData> exportForTodoTDownload(@RequestBody(required=false) List<String> ids, String businessKey, String title) throws Exception {
        WorkFlowService workFlowService = (WorkFlowService)SpringContextHolder.getOneBean(WorkFlowService.class);
        List<WorkOrderVo> vos = workFlowService.findTodoTaskByExport(SpringSecurityUtils.getLoginUser(), ids, businessKey, title);
        for (WorkOrderVo workOrderVo : vos) {
            Map<String, Object> proinstMap = workOrderVo.getProinstMap();
            String startUser = (String)proinstMap.get("startUser");
            workOrderVo.setStartUser(startUser);
        }
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f85\u529e\u540d\u79f0", (String)"title"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e1a\u52a1\u7f16\u7801", (String)"businessKey"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5236\u5355\u4eba", (String)"startUser"));
        FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, vos, "\u5df2\u529e\u5ba1\u6279", "\u5df2\u529e\u5ba1\u6279", 0);
        return ResponseResult.success((Object)fileData);
    }

    @ApiOperation(httpMethod="POST", value="\u5ba1\u6279\u6307\u5b9a\u7684\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", required=true, value="\u4efb\u52a1id", paramType="query", dataType="String"), @ApiImplicitParam(name="isPass", required=true, value="\u662f\u5426\u5ba1\u6838\u901a\u8fc7\uff0c\u901a\u8fc7\u8fd4\u56detrue\uff0c\u62d2\u7edd\u8fd4\u56defalse", paramType="query", dataType="String"), @ApiImplicitParam(name="desc", required=true, value="\u5ba1\u6279\u610f\u89c1", paramType="query", dataType="String")})
    @RequestMapping(value={"service/completePersonalTask"})
    @ResponseBody
    public ResponseResult<String> completePersonalTask(@RequestParam(required=true) String taskId, @RequestParam(required=true) String isPass, @RequestParam(required=true) String desc) {
        String userName = SpringSecurityUtils.getLoginUser().getNickName();
        WorkFlowService workFlowService = (WorkFlowService)SpringContextHolder.getOneBean(WorkFlowService.class);
        return ResponseResult.success((Object)workFlowService.completePersonalTask(taskId, SpringSecurityUtils.getLoginUser(), isPass, desc).getDesc());
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5ba1\u6279\u6307\u5b9a\u7684\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="isPass", required=true, value="\u662f\u5426\u5ba1\u6838\u901a\u8fc7\uff0c\u901a\u8fc7\u8fd4\u56detrue\uff0c\u62d2\u7edd\u8fd4\u56defalse", paramType="query", dataType="String"), @ApiImplicitParam(name="desc", required=true, value="\u5ba1\u6279\u610f\u89c1", paramType="query", dataType="String")})
    @RequestMapping(value={"service/completePersonalTasks"})
    @ResponseBody
    public ResponseResult<String> completePersonalTasks(@RequestBody(required=true) List<String> taskIds, @RequestParam(required=true) String isPass, @RequestParam(required=true) String desc) {
        String userName = SpringSecurityUtils.getLoginUser().getNickName();
        WorkFlowService workFlowService = (WorkFlowService)SpringContextHolder.getOneBean(WorkFlowService.class);
        Assert.isNotEmpty(taskIds, (String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (String taskId : taskIds) {
            Assert.isNotBlank((String)taskId, (String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Assert.isNotBlank((String)isPass, (String)"\u662f\u5426\u901a\u8fc7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)desc, (String)"\u5ba1\u6279\u610f\u89c1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (String taskId : taskIds) {
            workFlowService.completePersonalTask(taskId, SpringSecurityUtils.getLoginUser(), isPass, desc).getDesc();
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u6d41\u7a0b\u4e0e\u4e1a\u52a1\u7f16\u7801\uff0c\u67e5\u8be2\u4efb\u52a1\u60c5\u51b5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", required=true, value="\u6d41\u7a0b\u5b9a\u4e49code", paramType="query", dataType="String"), @ApiImplicitParam(name="businessKey", required=true, value="\u4e1a\u52a1\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="approveStatus", required=true, value="\u5ba1\u6279\u72b6\u6001", paramType="query", dataType="String")})
    @RequestMapping(value={"service/findDetailForProcess"})
    @ResponseBody
    public ResponseResult<List<WorkOrderVo>> findTaskListForProcess(@RequestParam(required=true) String processDefinitionKey, @RequestParam(required=true) String businessKey) {
        WorkFlowService workFlowService = (WorkFlowService)SpringContextHolder.getOneBean(WorkFlowService.class);
        return ResponseResult.success(workFlowService.findTaskListForProcess(processDefinitionKey, businessKey));
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u6d41\u7a0b\u4e0e\u4e1a\u52a1\u7f16\u7801\uff0c\u67e5\u8be2\u4efb\u52a1\u60c5\u51b5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", required=true, value="\u6d41\u7a0b\u5b9a\u4e49code", paramType="query", dataType="String"), @ApiImplicitParam(name="businessKey", required=true, value="\u4e1a\u52a1\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="approveStatus", required=true, value="\u5ba1\u6279\u72b6\u6001", paramType="query", dataType="String")})
    @RequestMapping(value={"service/findDetailForProcessById"})
    @ResponseBody
    public ResponseResult<List<WorkOrderVo>> findTaskListForProcess(@RequestParam(required=true) String processInstanceId) {
        WorkFlowService workFlowService = (WorkFlowService)SpringContextHolder.getOneBean(WorkFlowService.class);
        return ResponseResult.success(workFlowService.findTaskListForProcess(processInstanceId));
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", required=true, value="\u6d41\u7a0b\u5b9a\u4e49code", paramType="query", dataType="String"), @ApiImplicitParam(name="businessKey", required=true, value="\u4e1a\u52a1\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="approveStatus", required=true, value="\u5ba1\u6279\u72b6\u6001", paramType="query", dataType="String")})
    @RequestMapping(value={"service/findMyAppliedTask"})
    @ResponseBody
    public ResponseResult<PageView<WorkOrderVo>> findMyAppliedTask(@RequestParam(defaultValue="1") int pageNo, @RequestParam(defaultValue="10") int pageSize) throws Exception {
        WorkFlowService workFlowService = (WorkFlowService)SpringContextHolder.getOneBean(WorkFlowService.class);
        PageView pageView = new PageView(pageNo, pageSize);
        return ResponseResult.success(workFlowService.findMyAppliedTask((PageView<WorkOrderVo>)pageView, SpringSecurityUtils.getLoginUser()));
    }

    @RequestMapping(value={"service/startProcess"})
    @ResponseBody
    public ResponseResult<String> startProcess(@RequestParam(required=true) String processDefinitionKey, @RequestParam(required=true) String businessKey, @RequestParam(required=true) Map<String, Object> processVariable) {
        WorkFlowService workFlowService = (WorkFlowService)SpringContextHolder.getOneBean(WorkFlowService.class);
        workFlowService.startProcess(processDefinitionKey, businessKey, processVariable);
        return ResponseResult.success();
    }

    @RequestMapping(value={"service/stopProcess"})
    @ResponseBody
    public ResponseResult<String> stopProcess(@RequestParam(required=true) String processDefinitionKey, @RequestParam(required=true) String businessKey) {
        WorkFlowService workFlowService = (WorkFlowService)SpringContextHolder.getOneBean(WorkFlowService.class);
        workFlowService.stopProcess(processDefinitionKey, businessKey);
        return ResponseResult.success();
    }

    @RequestMapping(value={"service/printNextTaskDefinition"})
    @ResponseBody
    public ResponseResult<String> printNextTaskDefinition(@RequestParam(required=true) String procInstId) {
        WorkFlowService workFlowService = (WorkFlowService)SpringContextHolder.getOneBean(WorkFlowService.class);
        workFlowService.test(procInstId);
        return ResponseResult.success();
    }
}

