/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.workflow.common.web.controller;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.workflow.common.entity.HistoricProcessInstanceResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5386\u53f2\u6a21\u5757")
@RestController
@RequestMapping(value={"histories"})
public class HistoryController {
    @Resource
    private HistoryService historyService;

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5b9e\u4f8b\u6d41\u7a0b\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="1"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<HistoricProcessInstanceResult>> findByPage(@RequestParam(defaultValue="1") int pageNo, @RequestParam(defaultValue="10") int pageSize) {
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        List hpiList = ((HistoricProcessInstanceQuery)historicProcessInstanceQuery.orderByProcessInstanceStartTime().desc()).listPage(pageSize * (pageNo - 1), pageSize);
        List result = hpiList.stream().map(hpi -> new HistoricProcessInstanceResult((HistoricProcessInstance)hpi)).collect(Collectors.toList());
        PageView pageView = new PageView(pageNo, pageSize);
        pageView.setQueryResult(result);
        long totalSize = historicProcessInstanceQuery.count();
        pageView.setRowCount((int)totalSize);
        return ResponseResult.success((Object)pageView);
    }
}

