/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.workflow.test;

import com.els.base.core.entity.ResponseResult;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletResponse;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentQuery;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"actDeploy"})
public class DeployController {
    @Autowired
    private TaskService taskService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private ProcessEngine processEngine;

    @ApiOperation(httpMethod="POST", value="bpm\u6587\u4ef6")
    @RequestMapping(value={"front/deployBpmn"})
    @ResponseBody
    public ResponseResult<String> deployBpmn(@RequestParam(required=true) MultipartFile file, String resourceName) throws IOException {
        Deployment deployment = this.repositoryService.createDeployment().addInputStream(resourceName, file.getInputStream()).deploy();
        return ResponseResult.success((Object)String.valueOf(this.repositoryService.createProcessDefinitionQuery().count()));
    }

    @ApiOperation(httpMethod="POST", value="zip\u683c\u5f0f")
    @RequestMapping(value={"front/deployBpmnZip"})
    @ResponseBody
    public ResponseResult<String> deployBpmnZip(@RequestParam(required=true) MultipartFile file, String resourceName) throws IOException {
        this.repositoryService.createDeployment().addZipInputStream(new ZipInputStream(file.getInputStream())).deploy();
        return ResponseResult.success((Object)String.valueOf(this.repositoryService.createProcessDefinitionQuery().count()));
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2")
    @RequestMapping(value={"front/queryProcess"})
    @ResponseBody
    public ResponseResult<List<String>> queryProcess() {
        ProcessDefinitionQuery pdq = this.repositoryService.createProcessDefinitionQuery();
        List list = pdq.list();
        ArrayList<String> strList = new ArrayList<String>();
        for (ProcessDefinition pd : list) {
            strList.add(MessageFormat.format("key[{0}], id[{1}], resourceName[{2}], diagramResourceName[{3}]", pd.getKey(), pd.getId(), pd.getResourceName(), pd.getDiagramResourceName()));
        }
        return ResponseResult.success(strList);
    }

    @ApiOperation(httpMethod="POST", value="\u5f00\u59cb\u5ba1\u6279")
    @RequestMapping(value={"front/startProcess"})
    @ResponseBody
    public ResponseResult<String> startProcess(String key) {
        this.runtimeService.startProcessInstanceByKey(key);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d44\u6e90")
    @RequestMapping(value={"front/getResoucesName"})
    @ResponseBody
    public ResponseResult<String> getResoucesName(String deploymentId, String resourceName, HttpServletResponse response) {
        List names = this.repositoryService.getDeploymentResourceNames(deploymentId);
        String imageName = null;
        String nameList = "";
        for (String name : names) {
            if (name.indexOf(".png") >= 0) {
                imageName = name;
            }
            nameList = nameList + name;
        }
        return ResponseResult.success((Object)StringUtils.defaultIfBlank(imageName, (String)nameList));
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d44\u6e90")
    @RequestMapping(value={"front/queryResources"})
    @ResponseBody
    public void queryResources(String deploymentId, String resourceName, HttpServletResponse response) throws IOException {
        InputStream resourceStream = this.repositoryService.getResourceAsStream(deploymentId, resourceName);
        byte[] b = new byte[1024];
        while (resourceStream.read(b, 0, 1024) != -1) {
            response.getOutputStream().write(b, 0, 1024);
        }
    }

    @ApiOperation(httpMethod="POST", value="\u83b7\u53d6\u6d41\u7a0b\u56fe")
    @RequestMapping(value={"front/getProcessImage"})
    public void getProcessImage(String pid, HttpServletResponse response) throws IOException {
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(pid);
        InputStream resourceStream = this.processEngine.getProcessEngineConfiguration().getProcessDiagramGenerator().generatePngDiagram(bpmnModel);
        byte[] b = new byte[1024];
        while (resourceStream.read(b, 0, 1024) != -1) {
            response.getOutputStream().write(b, 0, 1024);
        }
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u6d41\u7a0b")
    @RequestMapping(value={"front/deleteDeployment"})
    @ResponseBody
    public ResponseResult<String> deleteDeployment(String deploymentId) {
        this.repositoryService.deleteDeployment(deploymentId, true);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u6d41\u7a0b")
    @RequestMapping(value={"front/queryDeployment"})
    @ResponseBody
    public ResponseResult<List<String>> queryDeployment() {
        DeploymentQuery dq = this.repositoryService.createDeploymentQuery();
        List list = dq.list();
        ArrayList<String> strList = new ArrayList<String>();
        for (Deployment deployment : list) {
            strList.add(deployment.getId() + " " + deployment.getName() + " " + deployment.getTenantId());
        }
        return ResponseResult.success(strList);
    }
}

