/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.workflow.common.web.controller;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.workflow.common.entity.ModelResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.persistence.entity.ModelEntity;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ModelQuery;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u6a21\u578b\u5217\u8868")
@RestController
@RequestMapping(value={"models"})
public class ModelController {
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private ObjectMapper objectMapper;

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6a21\u578b\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<ModelResult>> findByPage(@RequestParam(defaultValue="1") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) ModelEntity modelEntity) {
        ModelQuery modelQuery = this.repositoryService.createModelQuery();
        if (modelEntity != null && StringUtils.isNotBlank((CharSequence)modelEntity.getName())) {
            modelQuery.modelNameLike("%" + modelEntity.getName() + "%");
        }
        List list = ((ModelQuery)modelQuery.orderByCreateTime().desc()).listPage(pageSize * (pageNo - 1), pageSize);
        long count = modelQuery.count();
        PageView pageView = new PageView(pageNo, pageSize);
        pageView.setRowCount((int)count);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List modelEntityList = list.stream().map(model -> {
                ModelResult modelResult = new ModelResult();
                BeanUtils.copyProperties((Object)model, (Object)modelResult);
                return modelResult;
            }).collect(Collectors.toList());
            pageView.setQueryResult(modelEntityList);
        }
        return ResponseResult.success((Object)pageView);
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u6a21\u578b")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestParam(required=false, defaultValue="cgdd") String key) throws UnsupportedEncodingException {
        Model model = this.repositoryService.newModel();
        String name = "\u672a\u547d\u540d";
        String description = "";
        int revision = 1;
        ObjectNode modelNode = this.objectMapper.createObjectNode();
        modelNode.put("name", name);
        modelNode.put("description", description);
        modelNode.put("revision", revision);
        model.setName(name);
        model.setKey(key);
        model.setMetaInfo(modelNode.toString());
        this.repositoryService.saveModel(model);
        String id = model.getId();
        ObjectNode editorNode = this.objectMapper.createObjectNode();
        editorNode.put("id", "canvas");
        editorNode.put("resourceId", "canvas");
        ObjectNode stencilSetNode = this.objectMapper.createObjectNode();
        stencilSetNode.put("namespace", "http://b3mn.org/stencilset/bpmn2.0#");
        editorNode.set("stencilset", (JsonNode)stencilSetNode);
        this.repositoryService.addModelEditorSource(id, editorNode.toString().getBytes("utf-8"));
        return ResponseResult.success((Object)("/resources/modeler.html?modelId=" + id));
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u6a21\u578b")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.repositoryService.deleteModel(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u5e03\u6a21\u578b")
    @RequestMapping(value={"service/deploymentById"})
    @ResponseBody
    public ResponseResult<String> deploymentById(@RequestParam(required=true) String id) throws IOException {
        Assert.isNotBlank((String)id, (String)"\u53d1\u5e03\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        Model modelData = this.repositoryService.getModel(id);
        byte[] bytes = this.repositoryService.getModelEditorSource(modelData.getId());
        if (bytes == null) {
            throw new CommonException("\u6a21\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u8ba1\u6d41\u7a0b\u5e76\u6210\u529f\u4fdd\u5b58\uff0c\u518d\u8fdb\u884c\u53d1\u5e03\u3002");
        }
        JsonNode modelNode = new ObjectMapper().readTree(bytes);
        BpmnModel model = new BpmnJsonConverter().convertToBpmnModel(modelNode);
        if (model.getProcesses().size() == 0) {
            throw new CommonException("\u6570\u636e\u6a21\u578b\u4e0d\u7b26\u8981\u6c42\uff0c\u8bf7\u81f3\u5c11\u8bbe\u8ba1\u4e00\u6761\u4e3b\u7ebf\u6d41\u7a0b\u3002");
        }
        Process process = model.getMainProcess();
        if (process != null) {
            process.setId(modelData.getKey());
            process.setName(modelData.getName());
        }
        byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(model);
        String processName = modelData.getName() + ".bpmn20.xml";
        Deployment deployment = this.repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmnBytes, "UTF-8")).deploy();
        modelData.setDeploymentId(deployment.getId());
        this.repositoryService.saveModel(modelData);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u83b7\u53d6\u6a21\u578bid")
    @RequestMapping(value={"service/getModelIdByDeploymentId"})
    @ResponseBody
    public ResponseResult<String> getModelIdByDeploymentId(@RequestParam(required=true) String deploymentId) throws IOException {
        Model model = (Model)this.repositoryService.createModelQuery().deploymentId(deploymentId).list().get(0);
        Assert.isNotNull((Object)model, (String)"\u6a21\u578b\u4e0d\u5b58\u5728");
        return ResponseResult.success((Object)model.getId());
    }
}

