/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.workflow.common.web.controller;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.workflow.common.entity.ProcessDefinitionResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d41\u7a0b\u5217\u8868"})
@RestController
@RequestMapping(value={"deployments"})
public class DeploymentController {
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private RuntimeService runtimeService;

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6d41\u7a0b\u7ba1\u7406\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="1"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<ProcessDefinitionResult>> findByPage(@RequestParam(defaultValue="1") int pageNo, @RequestParam(defaultValue="10") int pageSize) {
        PageView pageView = new PageView(pageNo, pageSize);
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
        List processDefinitionList = ((ProcessDefinitionQuery)processDefinitionQuery.orderByDeploymentId().desc()).listPage(pageSize * (pageNo - 1), pageSize);
        if (CollectionUtils.isNotEmpty((Collection)processDefinitionList)) {
            List result = processDefinitionList.stream().map(processDefinition -> new ProcessDefinitionResult((ProcessDefinition)processDefinition)).collect(Collectors.toList());
            pageView.setQueryResult(result);
        }
        long count = this.repositoryService.createDeploymentQuery().count();
        pageView.setRowCount((int)count);
        return ResponseResult.success((Object)pageView);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6d41\u7a0b")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<Deployment> findById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u67e5\u8be2\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(id).singleResult();
        return ResponseResult.success((Object)deployment);
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u6d41\u7a0b")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.repositoryService.deleteDeployment(id);
        return ResponseResult.success();
    }
}

