/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.workflow.deployment.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.workflow.deployment.entity.WfDeployment;
import com.els.base.workflow.deployment.entity.WfDeploymentExample;
import com.els.base.workflow.deployment.service.WfDeploymentService;
import com.els.base.workflow.wfSet.entity.WfSetExample;
import com.els.base.workflow.wfSet.service.WfSetService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(tags={"\u5ba1\u6279\u6d41"})
@Controller
@RequestMapping(value={"wfDeployment"})
public class WfDeploymentController {
    @Resource
    protected WfDeploymentService wfDeploymentService;
    @Resource
    protected WfSetService wfSetService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u5ba1\u6279\u6d41")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@ModelAttribute WfDeployment wfDeployment, MultipartHttpServletRequest request) throws IOException {
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        Set fileKeySet = fileMap.keySet();
        if (fileKeySet.size() > 1) {
            throw new CommonException("\u4e0d\u63a5\u53d7\u591a\u4e2a\u6587\u4ef6\u4e0a\u4f20", "file_upload_not_accepted");
        }
        MultipartFile file = null;
        Iterator keyIterator = fileKeySet.iterator();
        while (keyIterator.hasNext()) {
            file = (MultipartFile)fileMap.get(keyIterator.next());
        }
        wfDeployment.setCreateUser(SpringSecurityUtils.getLoginUserName());
        this.wfDeploymentService.addObj(wfDeployment, file);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5ba1\u6279\u6d41")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@ModelAttribute WfDeployment wfDeployment, MultipartHttpServletRequest request) throws IOException {
        if (StringUtils.isBlank((String)wfDeployment.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        Map fileMap = request.getFileMap();
        wfDeployment.setBusinessCode(null);
        wfDeployment.setName(null);
        wfDeployment.setUpdateUser(SpringSecurityUtils.getLoginUserName());
        this.wfDeploymentService.modifyObj(wfDeployment, fileMap);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5ba1\u6279\u6d41")
    @RequestMapping(value={"service/editSet"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody WfDeployment wfDeployment) throws IOException {
        if (StringUtils.isBlank((String)wfDeployment.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        wfDeployment.setUpdateUser(SpringSecurityUtils.getLoginUserName());
        this.wfDeploymentService.modifyObj(wfDeployment);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u5ba1\u6279\u6d41")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestBody List<String> ids) {
        Assert.isNotNull(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.wfDeploymentService.deleteObjByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u542f\u7528\u6216\u7981\u7528\u5ba1\u6279\u6d41\uff0c\u542f\u7528\u4f201\uff0c\u7981\u7528\u4f200")
    @RequestMapping(value={"service/setIsEnable"})
    @ResponseBody
    public ResponseResult<String> setIsEnable(@RequestBody WfDeployment wf) {
        if (null == wf) {
            throw new CommonException();
        }
        if (StringUtils.isEmpty((String)wf.getId())) {
            throw new CommonException();
        }
        if (null == wf.getIsEnable()) {
            throw new CommonException();
        }
        Integer enable = ((WfDeployment)this.wfDeploymentService.queryObjById(wf.getId())).getIsEnable();
        if (!Constant.NO_INT.equals(wf.getIsEnable()) && !Constant.YES_INT.equals(wf.getIsEnable())) {
            throw new CommonException("\u63d0\u4ea4\u7684\u72b6\u6001\u6709\u8bef!");
        }
        if (wf.getIsEnable().equals(enable)) {
            throw new CommonException("\u72b6\u6001\u672a\u66f4\u6539,\u8bf7\u8f93\u5165\u4fee\u6539\u540e\u7684\u72b6\u6001!");
        }
        this.wfDeploymentService.setIsEnable(wf);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5ba1\u6279\u6d41")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 WfDeployment", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<WfDeployment>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        WfDeploymentExample example = new WfDeploymentExample();
        example.setPageView((PageView<WfDeployment>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        WfDeploymentExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.wfDeploymentService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u8bbe\u7f6e")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<WfDeployment> findById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u67e5\u770b\u8be6\u60c5,id\u4e0d\u80fd\u4e3a\u7a7a");
        WfDeployment wfDeployment = (WfDeployment)this.wfDeploymentService.queryObjById(id);
        if (wfDeployment == null) {
            throw new CommonException("\u8be5\u5355\u636e\u4e3a\u7a7a");
        }
        WfSetExample example = new WfSetExample();
        example.createCriteria().andDeploymentIdEqualTo(id);
        List byExample = this.wfSetService.queryAllObjByExample((IExample)example);
        WfDeployment deployment = new WfDeployment();
        BeanUtils.copyProperties((Object)wfDeployment, (Object)deployment);
        deployment.setWfSetList(byExample);
        return ResponseResult.success((Object)deployment);
    }

    @ApiOperation(httpMethod="POST", value="\u63d0\u4ea4\u6d41\u7a0b\u8282\u70b9\u914d\u7f6e")
    @RequestMapping(value={"service/submitProcessSetting"})
    @ResponseBody
    public ResponseResult<String> submitProcessSetting(@RequestBody WfDeployment wfDeployment) {
        Assert.isNotNull((Object)wfDeployment, (String)"\u63d0\u4ea4\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(wfDeployment.getWfSetList(), (String)"\u6d41\u7a0b\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
        wfDeployment.setCreateUser(SpringSecurityUtils.getLoginUserName());
        this.wfDeploymentService.changeProcess(wfDeployment);
        return ResponseResult.success();
    }
}

