/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.workflow.wfSet.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.workflow.wfSet.dao.WfSetMapper;
import com.els.base.workflow.wfSet.entity.WfSet;
import com.els.base.workflow.wfSet.entity.WfSetExample;
import com.els.base.workflow.wfSet.service.WfSetService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultWfSetService")
public class WfSetServiceImpl
implements WfSetService {
    @Resource
    protected WfSetMapper wfSetMapper;

    @CacheEvict(value={"wfSet"}, allEntries=true)
    public void addObj(WfSet t) {
        this.wfSetMapper.insertSelective(t);
    }

    @CacheEvict(value={"wfSet"}, allEntries=true)
    public void deleteObjById(String id) {
        this.wfSetMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"wfSet"}, allEntries=true)
    public void modifyObj(WfSet t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.wfSetMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"wfSet"}, keyGenerator="redisKeyGenerator")
    public WfSet queryObjById(String id) {
        return this.wfSetMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"wfSet"}, keyGenerator="redisKeyGenerator")
    public List<WfSet> queryAllObjByExample(WfSetExample example) {
        return this.wfSetMapper.selectByExample(example);
    }

    @Cacheable(value={"wfSet"}, keyGenerator="redisKeyGenerator")
    public PageView<WfSet> queryObjByPage(WfSetExample example) {
        PageView<WfSet> pageView = example.getPageView();
        pageView.setQueryResult(this.wfSetMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"wfSet"}, allEntries=true)
    public void deleteByExample(WfSetExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.wfSetMapper.deleteByExample(example);
    }

    @CacheEvict(value={"wfSet"}, allEntries=true)
    @Transactional
    public void addAll(List<WfSet> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.wfSetMapper.insertSelective((WfSet)record));
    }
}

