package com.els.base.workflow.common.entity;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel("流程实体")
public class ProcessDefinitionResult implements Serializable {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty("编号")
	private String id;

	@ApiModelProperty("版本")
	private String category;

	@ApiModelProperty("流程名称")
	private String name;

	@ApiModelProperty("key")
	private String key;

	private String description;

	private int version;

	@ApiModelProperty("资源名称")
	private String resourceName;

	@ApiModelProperty("部署id")
	private String deploymentId;

	@ApiModelProperty("流程图资源")
	private String diagramResourceName;

	private boolean hasStartFormKey;

	private boolean hasGraphicalNotation;

	private boolean isSuspended;

	private String tenantId;

	public ProcessDefinitionResult() {
	}

	public ProcessDefinitionResult(org.activiti.engine.repository.ProcessDefinition p) {
		this.id = p.getId();
		this.category = p.getCategory();
		this.name = p.getName();
		this.key = p.getKey();
		this.description = p.getDescription();
		this.version = p.getVersion();
		this.resourceName = p.getResourceName();
		this.deploymentId = p.getDeploymentId();
		this.diagramResourceName = p.getDiagramResourceName();
		this.hasStartFormKey = p.hasStartFormKey();
		this.hasGraphicalNotation = p.hasGraphicalNotation();
		this.isSuspended = p.isSuspended();
		this.tenantId = p.getTenantId();

	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getCategory() {
		return category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public int getVersion() {
		return version;
	}

	public void setVersion(int version) {
		this.version = version;
	}

	public String getResourceName() {
		return resourceName;
	}

	public void setResourceName(String resourceName) {
		this.resourceName = resourceName;
	}

	public String getDeploymentId() {
		return deploymentId;
	}

	public void setDeploymentId(String deploymentId) {
		this.deploymentId = deploymentId;
	}

	public String getDiagramResourceName() {
		return diagramResourceName;
	}

	public void setDiagramResourceName(String diagramResourceName) {
		this.diagramResourceName = diagramResourceName;
	}

	public boolean isHasStartFormKey() {
		return hasStartFormKey;
	}

	public void setHasStartFormKey(boolean hasStartFormKey) {
		this.hasStartFormKey = hasStartFormKey;
	}

	public boolean isHasGraphicalNotation() {
		return hasGraphicalNotation;
	}

	public void setHasGraphicalNotation(boolean hasGraphicalNotation) {
		this.hasGraphicalNotation = hasGraphicalNotation;
	}

	public boolean isSuspended() {
		return isSuspended;
	}

	public void setSuspended(boolean isSuspended) {
		this.isSuspended = isSuspended;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

}