package com.els.base.workflow.common.entity;

import java.util.Map;

import com.els.base.core.utils.Assert;
import com.els.base.workflow.common.service.ITaskListener;

public class ProcessStartVO {

    String processDefinitionKey;
    String businessKey;
    Map<String, Object> processVariable;
    Class<? extends ITaskListener> listenerClass;
    String displayPage;
    String businessId;// 业务ID
    // String assignee;// 审批人

    /**
     * @return the businessStatus
     */
    /*
     * public String getBusinessStatus() { return businessStatus; }
     * 
     *//**
       * @param businessStatus the businessStatus to set
       * @return
       *//*
         * public ProcessStartVO setBusinessStatus(String businessStatus) { this.businessStatus = businessStatus; return
         * this; }
         */

    public String getBusinessId() {
        return businessId;
    }

    public ProcessStartVO setBusinessId(String businessId) {
        this.businessId = businessId;
        return this;
    }

    public String getProcessDefinitionKey() {
        return processDefinitionKey;
    }

    public String getBusinessKey() {
        return businessKey;
    }

    public Map<String, Object> getProcessVariable() {
        return processVariable;
    }

    public ProcessStartVO setProcessVariable(Map<String, Object> processVariable) {
        this.processVariable = processVariable;
        return this;
    }

    public Class<? extends ITaskListener> getListenerClass() {
        return listenerClass;
    }

    public ProcessStartVO setListenerClass(Class<? extends ITaskListener> listenerClass) {
        this.listenerClass = listenerClass;
        return this;
    }

    public String getDisplayPage() {
        return displayPage;
    }

    public ProcessStartVO setDisplayPage(String displayPage) {
        this.displayPage = displayPage;
        return this;
    }

    private ProcessStartVO() {
        super();
    }

    private ProcessStartVO(String processDefinitionKey, String businessKey) {
        super();
        this.processDefinitionKey = processDefinitionKey;
        this.businessKey = businessKey;
    }

    public static ProcessStartVO newInstance(String processDefinitionKey, String businessKey) {
        // TODO 做一个非空的判断
        Assert.isNotBlank(processDefinitionKey, "流程key不能为空");
        Assert.isNotBlank(businessKey, "业务key不能为空");

        ProcessStartVO vo = new ProcessStartVO(processDefinitionKey, businessKey);
        return vo;
    }

    public static ProcessStartVO newInstance(String processDefinitionKey, String businessKey, String businessId) {

        ProcessStartVO vo = newInstance(processDefinitionKey, businessKey).setBusinessId(businessId);
        return vo;
    }

    public static ProcessStartVO newInstance(String processDefinitionKey, String businessKey, String businessId,
            String displayPage) {

        ProcessStartVO vo =
                newInstance(processDefinitionKey, businessKey).setBusinessId(businessId).setDisplayPage(displayPage);

        return vo;
    }

    public static void main(String[] args) {
        ProcessStartVO vo = ProcessStartVO.newInstance(null, null).setDisplayPage(null).setListenerClass(null)
                .setProcessVariable(null).setBusinessId(null);

        /*
         * WorkFlowService workFlowService=SpringContextHolder.getOneBean(WorkFlowService.class);
         * workFlowService.startProcess(vo);
         */
        // service.startProcess(vo);
    }
}
