package com.els.base.workflow.common.event;

import java.text.MessageFormat;

import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;

import com.els.base.core.entity.user.User;
import com.els.base.core.event.BaseEvent;

/**
 * 任务操作事件
 * 
 * @author hzy
 *
 */
public class TaskOperateEvent extends BaseEvent {

    private static final long serialVersionUID = 1L;

    /***
     * 流程图里面的 id，流程定义key
     */
    private String processDefinitionKey;
    /**
     * 业务编码
     */
    private String businessKey;
    /**
     * 当前审批的流程
     */
    private ProcessInstance currentProcess;
    /**
     * 当前审批的任务
     */
    private Task currentTask;
    /**
     * 审批是否通过
     */
    private boolean isPass;
    /**
     * 审批是否已经结束
     */
    private boolean isFinished;
    /**
     * 业务ID
     */
    private String businessId;
    /**
     * 审批意见
     */
    private String approveDesc;

    /**
     * 审批人
     */
    private String assignee;
    
    /**
     * 审批人信息
     */
    private User assigneeUser;

    /**
     * @return the assignee
     */
    public String getAssignee() {
        return assignee;
    }

    /**
     * @param assignee the assignee to set
     */
    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    /**
     * @return the approveDesc
     */
    public String getApproveDesc() {
        return approveDesc;
    }

    /**
     * @param approveDesc the approveDesc to set
     */
    public void setApproveDesc(String approveDesc) {
        this.approveDesc = approveDesc;
    }

    public String getBusinessId() {
        return businessId;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public String getProcessDefinitionKey() {
        return processDefinitionKey;
    }

    public String getBusinessKey() {
        return businessKey;
    }

    public boolean isPass() {
        return isPass;
    }

    public ProcessInstance getCurrentProcess() {
        return currentProcess;
    }

    public void setCurrentProcess(ProcessInstance currentProcess) {
        this.currentProcess = currentProcess;
    }

    public boolean isFinished() {
        return isFinished;
    }

    public Task getCurrentTask() {
        return currentTask;
    }

    public void setCurrentTask(Task currentTask) {
        this.currentTask = currentTask;
    }
    
    public User getAssigneeUser() {
		return assigneeUser;
	}

	public void setAssigneeUser(User assigneeUser) {
		this.assigneeUser = assigneeUser;
	}

	public TaskOperateEvent(Object source, String processDefinitionKey, String businessKey, boolean isPass,
            boolean isFinished, String businessId, String approveDesc, String assignee) {
        super(MessageFormat.format("流程[{0}],业务key[{1}]", processDefinitionKey, businessKey));
        this.processDefinitionKey = processDefinitionKey;
        this.businessKey = businessKey;
        this.isPass = isPass;
        this.isFinished = isFinished;
        this.businessId = businessId;
        this.approveDesc = approveDesc;
        this.assignee = assignee;
    }

    public TaskOperateEvent(Object source, String processDefinitionKey, String businessKey, boolean isPass,
            boolean isFinished) {
        super(MessageFormat.format("流程[{0}],业务key[{1}]", processDefinitionKey, businessKey));
        this.isPass = isPass;
        this.isFinished = isFinished;

    }

}
