package com.els.base.workflow.common.event;

import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;

import com.els.base.core.event.BaseEvent;

/**
 * 任务开启事件
 * @author hzy
 *
 */
public class TaskStartEvent extends BaseEvent {

	private static final long serialVersionUID = 1L;

	/***
	 * 流程图里面的 id，流程定义key
	 */
	private String processDefinitionKey;
	/**
	 * 业务编码
	 */
	private String businessKey;
	/**
	 * 当前审批的流程
	 */
	private ProcessInstance currentProcess;
	/**
	 * 当前审批的任务
	 */
	private Task currentTask;
	
	public String getProcessDefinitionKey() {
		return processDefinitionKey;
	}

	public void setProcessDefinitionKey(String processDefinitionKey) {
		this.processDefinitionKey = processDefinitionKey;
	}

	public String getBusinessKey() {
		return businessKey;
	}

	public void setBusinessKey(String businessKey) {
		this.businessKey = businessKey;
	}

	public ProcessInstance getCurrentProcess() {
		return currentProcess;
	}

	public void setCurrentProcess(ProcessInstance currentProcess) {
		this.currentProcess = currentProcess;
	}

	public Task getCurrentTask() {
		return currentTask;
	}

	public void setCurrentTask(Task currentTask) {
		this.currentTask = currentTask;
	}

	public TaskStartEvent(Object source) {
		super(source);
	}

}
