package com.els.base.workflow.common.service;

import java.util.List;
import java.util.Map;

import org.activiti.engine.runtime.ProcessInstance;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.entity.WorkOrderVo;
import com.els.base.workflow.common.utils.ApproveStatusEnum;

public interface WorkFlowService {

    /**
     * 开启流程
     * 
     * @param processDefinitionKey
     * @param businessKey
     * @param processVariable 设置在流程里面的参数
     * @return
     */
    public ProcessInstance startProcess(String processDefinitionKey, String businessKey,
            Map<String, Object> processVariable);

    /**
     * 开启流程
     * 
     * @param processStartVo
     * @return
     */
    public ProcessInstance startProcess(ProcessStartVO processStartVO);

    /**
     * 停止流程
     * 
     * @param taskId
     * @param userName
     * @param isPass
     * @param desc
     * @return
     */
    public ProcessInstance stopProcess(String processDefinitionKey, String businessKey);

    /**
     * 审批流程
     * 
     * @param taskId
     * @param userName
     * @param isPass
     * @param desc
     * @return
     */
    public ApproveStatusEnum completePersonalTask(String taskId, User user, String isPass, String desc);

    /**
     * 查询流程下的任务
     * 
     * 
     * @param processDefinitionKey
     * @param processDefinitionKey
     * @param businessKey
     * @param businessKey
     * @return
     * @return
     */

    public List<WorkOrderVo> findTaskListForProcess(String processDefinitionKey, String businessKey);

    /**
     * 查找该角色的任务
     * 
     * @param pageView
     * @param roleList
     * @return
     */
    public PageView<WorkOrderVo> findTodoTask(PageView<WorkOrderVo> pageView, User user, String processDefinitionKey,
            String businessKey,String startUser);

    /**
     * 查找该角色的已完成的任务
     * 
     * @param pageView
     * @param roleList
     * @return
     */
    public PageView<WorkOrderVo> findDoneTask(PageView<WorkOrderVo> pageView, User user, String processDefinitionKey,
            String businessKey,String startUser);

    /**
     * 查询我申请的流程
     * 
     * @param pageView
     * @param user
     * @return
     */
    public PageView<WorkOrderVo> findMyAppliedTask(PageView<WorkOrderVo> pageView, User user);
    
    public void test(String procInstId);

}
