package com.els.base.workflow.common.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.identity.Group;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import com.els.base.auth.service.UserRoleService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.msg.Message;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.SpringContextHolder;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.entity.WorkOrderVo;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.event.TaskStartEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import com.els.base.workflow.common.utils.ApproveStatusEnum;
import com.els.base.workflow.common.utils.ProcessVariableNameEnum;
import com.els.base.workflow.common.utils.TaskVariableNameEnum;
import com.els.base.workflow.wfSet.service.WfSetService;

@Component
public class WorkFlowServiceImpl implements WorkFlowService {
	
	@Resource
	protected TaskService taskService;

	@Resource
	protected RuntimeService runtimeService;

	@Resource
	protected HistoryService historyService;
	@Resource
	protected IdentityService identityService;
	@Resource
	protected RepositoryService repositoryService;

	@Resource
	protected UserService userService;
	
	@Resource
	protected UserRoleService userRoleService;
	
	@Resource 
	protected WfSetService wfSetService;

	@Transactional
	@Override
	public ApproveStatusEnum completePersonalTask(String taskId, User user, String isPass, String desc) {
		// 1、查询任务,并校验任务
		Task task = queryTaskAndVaild(taskId);

		// 2、校验用户是否有权限
		validUser(task, user);

		// 3、当办理人为空时组用户领取任务
		if (StringUtils.isBlank(task.getAssignee())) {
			taskService.claim(taskId, user.getId());
		}
		// 4、获取当前的流程节点
		ProcessInstance currentProcess = runtimeService.createProcessInstanceQuery()
				.processInstanceId(task.getProcessInstanceId()).includeProcessVariables().singleResult();
		if (currentProcess == null || currentProcess.isEnded()) {
			throw new CommonException("该审批流程已经结束");
		}
		ApproveStatusEnum statusEnum = null;
		// 流程禁用的处理
		String processDefinitionKey = (String) currentProcess.getProcessVariables().get("processDefinitionKey");
		String businessKey = currentProcess.getBusinessKey();
		List<ProcessDefinition> processDefinitions = repositoryService.createProcessDefinitionQuery()
				.processDefinitionKey(processDefinitionKey).list();
		if (CollectionUtils.isEmpty(processDefinitions)) {
			throw new CommonException("未找到该模块编码,请检查数据!");
		}
		ProcessDefinition definition = repositoryService.createProcessDefinitionQuery()
				.processDefinitionKey(processDefinitionKey).list().get(processDefinitions.size() - 1);
		if (repositoryService.isProcessDefinitionSuspended(definition.getId())) {
			try {
				if (isPass.equals("true")) {
					callListener(currentProcess, user, task, true, true);
					statusEnum = ApproveStatusEnum.PASS;
				} else if (isPass.equals("false")) {
					callListener(currentProcess, user, task, false, true);
					statusEnum = ApproveStatusEnum.REJECT;
				}
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			ProcessInstance processInstance = runtimeService.createProcessInstanceQuery()
					.processDefinitionKey(processDefinitionKey).processInstanceBusinessKey(businessKey).singleResult();
			runtimeService.deleteProcessInstance(processInstance.getId(), "审批流已停用");
			return statusEnum;
		} else {
			// 5、执行审批流程
			Map<String, Object> taskMap = new HashMap<String, Object>();
			taskMap.put(TaskVariableNameEnum.PASS_STATUS.getVarName(), isPass);
			taskMap.put(TaskVariableNameEnum.APPROVE_DESC.getVarName(), StringUtils.defaultIfBlank(desc, "无"));
			taskMap.put(TaskVariableNameEnum.USER_NAME.getVarName(), user.getNickName());
			taskMap.put(TaskVariableNameEnum.APPROVE_TIME.getVarName(), new Date());

			Map<String, Object> processMap = new HashMap<>();
			processMap.put(ProcessVariableNameEnum.PASS_STATUS.getVarName(), isPass);

			taskService.setVariablesLocal(taskId, taskMap);
			// 添加备注信息
			taskService.addComment(taskId, task.getProcessInstanceId(), desc);
			// 办理任务
			taskService.complete(taskId, processMap);
			// 6、获取审批结果以及触发监听器

			try {
				statusEnum = getApproveResult(currentProcess, user, task, "true".equals(isPass));

			} catch (ClassNotFoundException e) {
				throw new CommonException("审批执行异常", e);
			}
			return statusEnum;
		}
	}

	private ApproveStatusEnum getApproveResult(ProcessInstance currentProcess, User user, Task task, boolean isPass)
			throws ClassNotFoundException {
		// 1、获取下一个流程节点
		ProcessInstance nextProcess = runtimeService.createProcessInstanceQuery()
				.processInstanceId(task.getProcessInstanceId()).includeProcessVariables().singleResult();

		ApproveStatusEnum statusEnum = null;
		boolean isFinish = false;
		if (currentProcess.getActivityId().contains("parallelGateway")) {
			// 2、根据节点判断流程是否已经完结
			if (nextProcess == null || nextProcess.isEnded()) {
				isFinish = true;
				if (isPass) {
					// 表示流程结束，而且是通过
					statusEnum = ApproveStatusEnum.PASS;
					// 3、发布审批事件，触发监听器
					this.callListener(currentProcess, user, task, isPass, isFinish);
				} else {
					// 表示流程结束，而且是不通过
					statusEnum = ApproveStatusEnum.REJECT;
					// 3、发布审批事件，触发监听器
					this.callListener(currentProcess, user, task, isPass, isFinish);
				}
			} else if (isPass) {

				// 表示到下一个流程
				statusEnum = ApproveStatusEnum.APPLY;
				// 3、发布审批事件，触发监听器
				this.callListener(currentProcess, user, task, isPass, isFinish);

				// 发送消息通知下个审批人
				String processInstanceId = task.getProcessInstanceId();
				
				sendNoticeMessage(processInstanceId);
				
			} else {
				// 表示流程结束，而且是不通过
				callListener(currentProcess, user, task, false, true);
				statusEnum = ApproveStatusEnum.REJECT;
			}
		}
		// 2、根据节点判断流程是否已经完结
		else if (nextProcess == null || nextProcess.isEnded()) {
			isFinish = true;
			if (isPass) {
				// 表示流程结束，而且是通过
				statusEnum = ApproveStatusEnum.PASS;
				// 3、发布审批事件，触发监听器
				this.callListener(currentProcess, user, task, isPass, isFinish);

			} else {
				// 表示流程结束，而且是不通过
				statusEnum = ApproveStatusEnum.REJECT;
				// 3、发布审批事件，触发监听器
				this.callListener(currentProcess, user, task, isPass, isFinish);
			}
		} else {
			// 表示到下一个流程
			statusEnum = ApproveStatusEnum.APPLY;
			// 3、发布审批事件，触发监听器
			this.callListener(currentProcess, user, task, isPass, isFinish);

			// 发送消息通知下个审批人
			String processInstanceId = task.getProcessInstanceId();
			
			sendNoticeMessage(processInstanceId);
		}
		/*
		 * HistoricProcessInstance singleResult =
		 * historyService.createHistoricProcessInstanceQuery()
		 * .processInstanceId(task.getProcessInstanceId()).singleResult();
		 * System.out.println(singleResult + "endtime:" +
		 * singleResult.getEndTime());
		 */

		return statusEnum;
	}

	public void test(String processInstanceId) {
		this.sendNoticeMessage(processInstanceId);
	}

//	private void sendNoticeMessage(String processInstanceId) {
//		Map<String, Object> processVariables = this.runtimeService.createProcessInstanceQuery()
//				.processInstanceId(processInstanceId).includeProcessVariables().singleResult().getProcessVariables();
//		
//		String businessTypeCode = "WE_CHAT_AUDIT_NOTICE";
//
//		List<String> receiverIdList = this.getUserIds(processInstanceId);
//		if (CollectionUtils.isEmpty(receiverIdList)) {
//			return ;
//		}
//		Message<Map<String, Object>> message = Message.init(processVariables)
//				.setBusinessTypeCode(businessTypeCode)
//				.setSenderId("1")
//				.setCompanyCode("50000000")
//				.addReceiverIdList(receiverIdList);
//		
//		MessageSendUtils.sendMessage(message);
//	}
	
	/**
	 * 获取审批流的用户id
	 * @param procInstId
	 * @return
	 */
//	private List<String> getUserIds(String procInstId){
//		System.out.println("任务id为:"+procInstId);
//		List<IdentityLink> list = runtimeService.getIdentityLinksForProcessInstance(procInstId);
//		
//		List<String> userIdList = new ArrayList<>();
//		for (IdentityLink item : list) {
//			System.out.println("这一层的UserId为:"+item.getUserId());
//			userIdList.add(item.getUserId());
//		}
//		return userIdList;
//	}
	

	private List<String> getAssigneeList(String procInstId) {
//		List<String> taskDefinitionList = this.getTaskDefinitionList(procInstId);
		
//		System.out.println("=======进入taskDe========");
//		for (String str : taskDefinitionList) {
//			System.out.println(str);
//		}
//		
//		System.out.println("=======进入taskDe========");
//		List<Task> taskList = taskDefinitionList.stream()
//				.map(taskDefinition -> this.taskService.createTaskQuery().processInstanceId(procInstId)
//						.taskDefinitionKey(taskDefinition).singleResult())
//				.collect(Collectors.toList());
		
		List<Task> taskList = this.taskService.createTaskQuery()
				.processInstanceId(procInstId).includeTaskLocalVariables().active().list();

		return taskList.stream()
			.filter(task-> task.getTaskLocalVariables().get(TaskVariableNameEnum.PASS_STATUS.getVarName()) == null)
			.flatMap(task -> {
				return this.getUserIdByTask(task).stream();
			})
			.filter(StringUtils::isNotBlank)
			.distinct()
			.collect(Collectors.toList());

	}
	private List<String> getUserIdByTask(Task task) {
		List<String> userIdList = new ArrayList<>();
		userIdList.add(task.getAssignee());
		
		List<IdentityLink> identityLinks = this.taskService.getIdentityLinksForTask(task.getId());
		
		List<String> candidateUsers = identityLinks.stream()
				.map(IdentityLink::getUserId).collect(Collectors.toList());
		
		userIdList.addAll(candidateUsers);
		
		List<String> userInGroups = identityLinks.stream()
			.map(IdentityLink::getGroupId)
			.filter(StringUtils::isNotBlank)
			.flatMap(groupId->{
				return this.userRoleService.queryUserIdsForRoleId(groupId).stream();
//				UserQuery query = this.identityService.createUserQuery().memberOfGroup(groupId);
//				List<org.activiti.engine.identity.User> userOfGroupList = query.list();
//				return userOfGroupList.stream();
			})
			.collect(Collectors.toList());
		
		userIdList.addAll(userInGroups);
		return userIdList;
	}

//
//	private List<String> getTaskDefinitionList(String procInstId) {
//		List<ProcessInstance> executionEntityList = runtimeService.createProcessInstanceQuery()
//				.processInstanceId(procInstId).list();
//		
//		return executionEntityList.stream().map(executionEntity -> {
//			ExecutionEntity execution = (ExecutionEntity) executionEntity;
//			return execution.getActivityId();
//		}).collect(Collectors.toList());
//
//	}
	
	private void sendNoticeMessage(String processInstanceId) {
		
		
		Map<String, Object> processVariables = this.runtimeService.createProcessInstanceQuery()
				.processInstanceId(processInstanceId).includeProcessVariables().singleResult().getProcessVariables();
		
		String businessTypeCode = "WE_CHAT_AUDIT_NOTICE";
		List<String> receiverIdList = this.getAssigneeList(processInstanceId);
		if(CollectionUtils.isEmpty(receiverIdList)){
			return ;
		}
		Message<Map<String, Object>> message = Message.init(processVariables)
				.setBusinessTypeCode(businessTypeCode)
				.setSenderId("1")
				.setCompanyCode("50000000")
				.addReceiverIdList(receiverIdList);
		
		MessageSendUtils.sendMessage(message);
	}
	
//	private List<String> getAssigneeList(String procInstId) {
//		List<String> taskDefinitionList = this.getTaskDefinitionList(procInstId);
//		List<String> nameList = taskDefinitionList.stream()
//				.map(taskDefinition -> this.taskService.createTaskQuery().processInstanceId(procInstId)
//						.taskDefinitionKey(taskDefinition).singleResult())
//				.map(task -> task.getName()).collect(Collectors.toList());
//		
//		System.out.println("nameList为："+nameList);
//		System.out.println("nameList的第一个为："+nameList.get(0));
//		
//		String name = nameList.get(0);
//		//根据名称查询userId
//		List<String> userIds = null;
//		
//		if(StringUtils.isNotBlank(name)){
//			userIds = new ArrayList<>();
//			String[] names = name.split(",");
//			
//			UserExample example = new UserExample();
//			for (String n : names) {
//				System.out.println("name为:"+n);
//				example.clear();
//				example.createCriteria()
//					   .andNickNameEqualTo(n);
//				List<User> userList = this.userService.queryAllObjByExample(example);
//				if(CollectionUtils.isNotEmpty(userList)){
//					userIds.add(userList.get(0).getId());
//				}
//			}
//		}
//		System.out.println("userIds为："+userIds);
//		
//		return userIds;
//	}
	
//	private List<String> getTaskDefinitionList(String procInstId) {
//		List<ProcessInstance> executionEntityList = runtimeService.createProcessInstanceQuery()
//				.processInstanceId(procInstId).list();
//		return executionEntityList.stream().map(executionEntity -> {
//			ExecutionEntity execution = (ExecutionEntity) executionEntity;
//			return execution.getActivityId();
//		}).collect(Collectors.toList());
//	}

	private void callListener(ProcessInstance currentProcess, User user, Task task, boolean isPass, boolean isFinish)
			throws ClassNotFoundException {
		Map<String, Object> processVariables = currentProcess.getProcessVariables();
		String className = (String) processVariables.get(ProcessVariableNameEnum.LISTENER_CLASS.getVarName());

		if (StringUtils.isBlank(className)) {
			return;
		}

		ITaskListener listener = (ITaskListener) SpringContextHolder.getOneBean(Class.forName(className));

		String businessKey = currentProcess.getBusinessKey();
		String processDefKey = currentProcess.getProcessDefinitionKey();
		String businessId = (String) processVariables.get(ProcessVariableNameEnum.BUSINESS_ID.getVarName());
		List<Comment> comments = taskService.getTaskComments(task.getId());
		java.lang.String approveDesc = null;
		if (CollectionUtils.isEmpty(comments)) {
			approveDesc = null;
		} else {
			approveDesc = comments.get(0).getFullMessage();
		}
		String assignee = user.getNickName();
		TaskOperateEvent event = new TaskOperateEvent(null, processDefKey, businessKey, isPass, isFinish, businessId,
				approveDesc, assignee);
		event.setCurrentProcess(currentProcess);
		event.setCurrentTask(task);
		event.setAssigneeUser(user);
		listener.listen(event);

		SpringContextHolder.getApplicationContext().publishEvent(event);
	}

	private void validUser(Task task, User user) {
		if (StringUtils.isEmpty(task.getAssignee())) {
			ArrayList<String> list = new ArrayList<>();
			for (IdentityLink identityLink : taskService.getIdentityLinksForTask(task.getId())) {
				if (StringUtils.isNotEmpty(identityLink.getUserId())) {
					list.add(identityLink.getUserId());
				}
			}
			if (!CollectionUtils.isEmpty(list)) {
				if (!list.contains(user.getId())) {
					throw new CommonException("没有权限执行该审核任务");
				}
			} else {
				// 角色权限判断
				List<Group> groupList = this.identityService.createGroupQuery().groupMember(user.getId()).list();
				List<String> groupIdList = new ArrayList<>();
				for (Group group : groupList) {
					groupIdList.add(group.getId());
				}
				List<IdentityLink> links = taskService.getIdentityLinksForTask(task.getId());
				List<String> linkGroupIds = new ArrayList<>();
				for (IdentityLink link : links) {
					linkGroupIds.add(link.getGroupId());
				}

				if (!CollectionUtils.containsAny(groupIdList, linkGroupIds)) {
					throw new CommonException("没有权限执行该审核任务");

				}
			}
		} else if (!user.getId().equals(task.getAssignee()))

		{
			throw new CommonException("没有权限执行该审核任务");
		}

	}

	private Task queryTaskAndVaild(String taskId) {
		TaskQuery taskQuery = taskService.createTaskQuery() // 获取查询对象
				.includeTaskLocalVariables().taskId(taskId);

		Task task = taskQuery.singleResult();
		if (task == null) {
			throw new CommonException("该任务id不存在");
		}

		if (task.isSuspended()) {
			throw new CommonException("该审批任务已经暂停");
		}

		return task;
	}

	@Override
	public ProcessInstance stopProcess(java.lang.String processDefinitionKey, java.lang.String businessKey) {
		if (StringUtils.isBlank(processDefinitionKey) || StringUtils.isBlank(businessKey)) {
			throw new CommonException("流程key，业务key，发起人不允许为空");
		}
		// ProcessInstance processInstance =
		// runtimeService.createProcessInstanceQuery()
		// .processDefinitionKey(processDefinitionKey).processInstanceBusinessKey(businessKey).singleResult();
		List<ProcessInstance> processInstances = runtimeService.createProcessInstanceQuery()
				.processDefinitionKey(processDefinitionKey).processInstanceBusinessKey(businessKey).list();
		if (CollectionUtils.isEmpty(processInstances)) {
			throw new CommonException("未找到该模块编码或业务编码,请检查数据!");
		}
		for (ProcessInstance processInstance : processInstances) {
			runtimeService.deleteProcessInstance(processInstance.getId(), "已作废");
			return processInstance;
		}
		return null;
	}

	@Override
	public ProcessInstance startProcess(String processDefinitionKey, String businessKey,
			Map<String, Object> processVariable) {
		if (StringUtils.isBlank(processDefinitionKey) || StringUtils.isBlank(businessKey)) {
			throw new CommonException("流程key，业务key，发起人不允许为空");
		}
		ProcessInstance processInstance = null;
		List<ProcessDefinition> processDefinitions = repositoryService.createProcessDefinitionQuery()
				.processDefinitionKey(processDefinitionKey).list();
		if (CollectionUtils.isEmpty(processDefinitions)) {
			throw new CommonException("未找到该模块编码,请检查数据!");
		}
		ProcessDefinition definition = repositoryService.createProcessDefinitionQuery()
				.processDefinitionKey(processDefinitionKey).list().get(processDefinitions.size() - 1);
		if (repositoryService.isProcessDefinitionSuspended(definition.getId())) {
			complete(processDefinitionKey, businessKey, processVariable);
		} else {
			ProcessInstance currentProcess = runtimeService.createProcessInstanceQuery()
					.processDefinitionKey(processDefinitionKey).processInstanceBusinessKey(businessKey).singleResult();

			if (currentProcess != null) {
				throw new CommonException("业务流程[" + processDefinitionKey + "][" + businessKey + "]，已经启动，无法重复启动");
			}
			processVariable.put(ProcessVariableNameEnum.START_TIME.getVarName(), new Date());
			processVariable.put(ProcessVariableNameEnum.START_USER.getVarName(),
					userService.queryObjById(SpringSecurityUtils.getLoginUserId()).getNickName());
			processInstance = runtimeService.startProcessInstanceByKey(processDefinitionKey, businessKey,
					processVariable);
			List<Task> list = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();

			TaskStartEvent startEvent = new TaskStartEvent("start process");
			startEvent.setBusinessKey(businessKey);
			startEvent.setProcessDefinitionKey(processDefinitionKey);
			startEvent.setCurrentTask(list.get(0));
			startEvent.setCurrentProcess(processInstance);

			SpringContextHolder.getApplicationContext().publishEvent(startEvent);

			// 发送审批消息通知
			String processInstanceId = processInstance.getId();
			sendNoticeMessage(processInstanceId);
		}
		return processInstance;
	}

	// 审批禁用后提交申请直接通过的逻辑
	public void complete(String processDefinitionKey, String businessKey, Map<String, Object> processVariable) {
		String className = (String) processVariable.get(ProcessVariableNameEnum.LISTENER_CLASS.getVarName());
		if (StringUtils.isBlank(className)) {
			return;
		}
		ITaskListener listener = null;
		try {
			listener = (ITaskListener) SpringContextHolder.getOneBean(Class.forName(className));
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			throw new CommonException("审批执行异常", e);
		}
		java.lang.String businessId = (String) processVariable.get(ProcessVariableNameEnum.BUSINESS_ID.getVarName());
		TaskOperateEvent event = new TaskOperateEvent(null, processDefinitionKey, businessKey, true, true, businessId,
				null, null);
		listener.listen(event);
		SpringContextHolder.getApplicationContext().publishEvent(event);
	}

	@Override
	public ProcessInstance startProcess(ProcessStartVO processStartVO) {
		Map<String, Object> processVariable = processStartVO.getProcessVariable();
		if (processVariable == null) {
			processVariable = new HashMap<>();
		}
		if (processStartVO.getListenerClass() != null) {
			processVariable.put(ProcessVariableNameEnum.LISTENER_CLASS.getVarName(),
					processStartVO.getListenerClass().getName());
		}
		String processDefinitionKey = processStartVO.getProcessDefinitionKey();
		String businessId = processStartVO.getBusinessId();
		String displayPage = processStartVO.getDisplayPage();
		String businessKey = processStartVO.getBusinessKey();
		// java.lang.String nickName =
		// userService.queryObjById(SpringSecurityUtils.getLoginUserId()).getNickName();
		//
		// processVariable.put("nickName", nickName);
		processVariable.put("businessKey", businessKey);
		processVariable.put("businessId", businessId);
		processVariable.put("displayPage", displayPage);
		processVariable.put("processDefinitionKey", processDefinitionKey);
		processStartVO.setProcessVariable(processVariable);
		return this.startProcess(processStartVO.getProcessDefinitionKey(), processStartVO.getBusinessKey(),
				processStartVO.getProcessVariable());
	}

	@Transactional
	@Override
	public List<WorkOrderVo> findTaskListForProcess(String processDefinitionKey, String businessKey) {

		List<HistoricProcessInstance> pis = historyService.createHistoricProcessInstanceQuery()
				.processDefinitionKey(processDefinitionKey).processInstanceBusinessKey(businessKey)
				.includeProcessVariables().list();
		if (CollectionUtils.isEmpty(pis)) {
			throw new CommonException("未找到该模块编码,请检查数据!");
		}
		List<WorkOrderVo> workOrderVoList = new ArrayList<>();
		for (HistoricProcessInstance hisProcessInstance : pis) {

			if (hisProcessInstance != null) {
				Map<String, Object> hisProcessMap = hisProcessInstance.getProcessVariables();
				List<HistoricTaskInstance> hisTaskList = this.findHisTaskByProcessId(hisProcessInstance.getId());
				for (int i = 0; CollectionUtils.isNotEmpty(hisTaskList) && i < hisTaskList.size(); i++) {
					Map<String, Object> hisTaskVarMap = hisTaskList.get(i).getTaskLocalVariables();
					WorkOrderVo workOrderVo = new WorkOrderVo(hisTaskList.get(i), hisProcessInstance, hisProcessMap,
							hisTaskVarMap);
					workOrderVoList.add(workOrderVo);
				}
			}
		}
		ProcessInstance currentProcess = runtimeService.createProcessInstanceQuery()
				.processDefinitionKey(processDefinitionKey).processInstanceBusinessKey(businessKey)
				.includeProcessVariables().singleResult();

		if (currentProcess == null) {
			return workOrderVoList;
		}

		Map<String, Object> processMap = currentProcess.getProcessVariables();
		TaskQuery taskQuery = taskService.createTaskQuery().processInstanceBusinessKey(currentProcess.getId())
				.includeTaskLocalVariables().orderByTaskId().asc();

		List<Task> taskList = taskQuery.list();
		for (int i = 0; CollectionUtils.isNotEmpty(taskList) && i < taskList.size(); i++) {
			Map<String, Object> taskMap = taskList.get(i).getTaskLocalVariables();
			WorkOrderVo workOrderVo = new WorkOrderVo(taskList.get(i), currentProcess, processMap, taskMap);
			workOrderVoList.add(workOrderVo);
		}
		return workOrderVoList;

	}

	private List<HistoricTaskInstance> findHisTaskByProcessId(String processInstanceId) {
		HistoricTaskInstanceQuery hisTaskQuery = historyService.createHistoricTaskInstanceQuery()
				.processInstanceId(processInstanceId).includeTaskLocalVariables().orderByTaskCreateTime().asc();
		return hisTaskQuery.list();
	}

	@Transactional
	@Override
	public PageView<WorkOrderVo> findTodoTask(PageView<WorkOrderVo> pageView, User user, String processDefinitionKey,
			String businessKey, String startUser) {
		Assert.isNotNull(pageView, "分页信息为空");

		List<Group> groupList = this.identityService.createGroupQuery().groupMember(user.getId()).list();
		if (CollectionUtils.isEmpty(groupList)) {
			pageView.setPageNo(1);
			return pageView;
		}

		// 查询所有的待办事项
		List<Task> allTask = this.queryAllTodoTask(user, groupList, processDefinitionKey, businessKey, startUser);

		// 进行去重何排序
		allTask = this.distinctAndSort(allTask);

		// 获取当前页的任务
		pageView.setRowCount(allTask.size());
		allTask = allTask.subList(pageView.getStartRowNo(), pageView.getEndRowNo());

		List<WorkOrderVo> workOrderVoList = new ArrayList<>(pageView.getPageSize());
		for (Task task : allTask) {

			ProcessInstance processInstance = runtimeService.createProcessInstanceQuery()
					.processInstanceId(task.getProcessInstanceId()).includeProcessVariables().singleResult();
			Map<String, Object> proinstMap = processInstance.getProcessVariables();

			WorkOrderVo workOrderVo = new WorkOrderVo(task, processInstance, proinstMap, task.getTaskLocalVariables());
			Map<java.lang.String, Object> map = workOrderVo.getProinstMap();
			Date startTime = (Date) map.get("startTime");
			workOrderVo.setStartTime(startTime);
			workOrderVoList.add(workOrderVo);
		}

		pageView.setQueryResult(workOrderVoList);

		return pageView;
	}

	private List<Task> queryAllTodoTask(User user, List<Group> groupList, java.lang.String processDefinitionKey,
			java.lang.String businessKey, java.lang.String startUser) {
		List<String> groupNameList = groupList.stream().map(Group::getId).collect(Collectors.toList());
		// 个人任务列表
		TaskQuery taskQuery = taskService.createTaskQuery().taskAssignee(user.getId());
		// 组任务列表
		TaskQuery query = taskService.createTaskQuery().taskCandidateGroupIn(groupNameList);
		// 候选人任务列表
		TaskQuery tQuery = taskService.createTaskQuery().taskCandidateUser(user.getId());
		if (StringUtils.isNotBlank(businessKey)) {
			taskQuery = taskQuery.processInstanceBusinessKeyLike("%" + businessKey + "%");
			query = query.processInstanceBusinessKeyLike("%" + businessKey + "%");
			tQuery = tQuery.processInstanceBusinessKeyLike("%" + businessKey + "%");
		}
		if (StringUtils.isNotBlank(processDefinitionKey)) {
			taskQuery = taskQuery.processDefinitionKeyLike("%" + processDefinitionKey + "%");
			query = query.processDefinitionKeyLike("%" + processDefinitionKey + "%");
			tQuery = tQuery.processDefinitionKeyLike("%" + processDefinitionKey + "%");
		}
		if (StringUtils.isNotBlank(startUser)) {
			taskQuery = taskQuery.processVariableValueLike("startUser", "%" + startUser + "%");
			query = query.processVariableValueLike("startUser", "%" + startUser + "%");
			tQuery = tQuery.processVariableValueLike("startUser", "%" + startUser + "%");
		}

		taskQuery = taskQuery.includeTaskLocalVariables().active();
		query = query.includeTaskLocalVariables().active();
		tQuery = tQuery.includeTaskLocalVariables().active();
		// 任务拼接
		List<Task> allTask = new ArrayList<>();
		allTask.addAll(taskQuery.list());
		allTask.addAll(query.list());
		allTask.addAll(tQuery.list());
		return allTask;

	}

	private List<Task> distinctAndSort(List<Task> allTask) {
		Set<Task> taskSet = new TreeSet<Task>((t1, t2) -> {
			return t1.getId().compareTo(t2.getId());
		});

		taskSet.addAll(allTask);

		allTask.clear();
		allTask.addAll(taskSet);

		allTask.sort((t1, t2) -> {

			if (t1.getCreateTime() == null) {
				return -1;
			}

			if (t2.getCreateTime() == null) {
				return 1;
			}
			return t2.getCreateTime().compareTo(t1.getCreateTime());
		});
		return allTask;
	}

	@Override
	public PageView<WorkOrderVo> findMyAppliedTask(PageView<WorkOrderVo> pageView, User user) {
		if (pageView == null) {
			throw new CommonException("分页信息为空");
		}

		List<HistoricTaskInstance> allTask = new ArrayList<>();
		HistoricTaskInstanceQuery query = historyService.createHistoricTaskInstanceQuery().taskAssignee(user.getId())
				.includeTaskLocalVariables().orderByTaskCreateTime().desc();
		List<HistoricTaskInstance> list = query.list();

		allTask.addAll(list);

		pageView.setRowCount(allTask.size());
		List<WorkOrderVo> subTaskList = new ArrayList<>(pageView.getPageSize());
		for (HistoricTaskInstance task : allTask.subList(pageView.getStartRowNo(), pageView.getEndRowNo())) {

			HistoricProcessInstance processInstance = historyService.createHistoricProcessInstanceQuery()
					.processInstanceId(task.getProcessInstanceId()).includeProcessVariables().singleResult();
			Map<String, Object> proinstMap = processInstance.getProcessVariables();

			WorkOrderVo workOrderVo = new WorkOrderVo(task, processInstance, proinstMap, task.getTaskLocalVariables());

			subTaskList.add(workOrderVo);
		}

		pageView.setQueryResult(subTaskList);
		return pageView;
	}

	@Transactional
	@Override
	public PageView<WorkOrderVo> findDoneTask(PageView<WorkOrderVo> pageView, User user, String processDefinitionKey,
			String businessKey, String startUser) {
		if (pageView == null) {
			throw new CommonException("分页信息为空");
		}
		List<Group> groupList = this.identityService.createGroupQuery().groupMember(user.getId()).list();

		if (CollectionUtils.isEmpty(groupList)) {
			pageView.setPageNo(1);
			return pageView;
		}

		HistoricTaskInstanceQuery query = historyService.createHistoricTaskInstanceQuery().taskAssignee(user.getId());
		if (StringUtils.isNotBlank(processDefinitionKey)) {
			query = query.processDefinitionKeyLike("%" + processDefinitionKey + "%");
		}
		if (StringUtils.isNotBlank(businessKey)) {
			query = query.processInstanceBusinessKeyLike("%" + businessKey + "%");
		}
		if (StringUtils.isNotBlank(startUser)) {
			query = query.processVariableValueLike("startUser", "%" + startUser + "%");
		}
		List<HistoricTaskInstance> list = query.finished().includeTaskLocalVariables().orderByTaskCreateTime().desc()
				.list();
		List<HistoricTaskInstance> allTask = new ArrayList<>();
		allTask.addAll(list);
		pageView.setRowCount(allTask.size());

		List<WorkOrderVo> subTaskList = new ArrayList<>(pageView.getPageSize());
		for (HistoricTaskInstance task : allTask.subList(pageView.getStartRowNo(), pageView.getEndRowNo())) {

			HistoricProcessInstance processInstance = historyService.createHistoricProcessInstanceQuery()
					.processInstanceId(task.getProcessInstanceId()).includeProcessVariables().singleResult();
			Map<String, Object> proinstMap = processInstance.getProcessVariables();

			WorkOrderVo workOrderVo = new WorkOrderVo(task, processInstance, proinstMap, task.getTaskLocalVariables());
			subTaskList.add(workOrderVo);
		}

		pageView.setQueryResult(subTaskList);

		return pageView;

	}
}
