package com.els.base.workflow.deployment.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import com.els.base.auth.service.UserRoleService;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.utils.SpringContextHolder;
import com.els.base.workflow.deployment.Enum.ApproveConditionEnum;
import com.els.base.workflow.deployment.entity.WfDeployment;
import com.els.base.workflow.wfSet.entity.WfSet;

public class BpmnModelBuilder {
	
    // 生成流程模型
    public BpmnModel build(WfDeployment wfDeployment) {
    	UserService userService = SpringContextHolder.getOneBean(UserService.class);

        // TODO Auto-generated method stub
        BpmnModel model = new BpmnModel();
        Process process = new Process();
        model.addProcess(process);
        // 获取流程id和流程名
        final String PROCESSID = wfDeployment.getBusinessCode();
        final String PROCESSNAME = wfDeployment.getName();
        process.setId(PROCESSID);
        process.setName(PROCESSNAME);
        List<WfSet> wfSetList = wfDeployment.getWfSetList();
        // 获取usertask节点数
        int size = wfSetList.size();
        // 开始节点

        process.addFlowElement(createStartEvent());

        for (int i = 0; i < size; i++) {
            WfSet wfSet = wfSetList.get(i);
            List<String> userList = new ArrayList<>();
            String s = wfSet.getAssigneeId();

            if (StringUtils.isBlank(s) && StringUtils.isBlank(wfSet.getGroupId())) {
                throw new CommonException("办理人或办理组不能同时为空!");
            }
            // 判断是否会签
            if (wfSet.getConditionSetUp().equals(ApproveConditionEnum.EVERYONE.getValue())) {
                // 会签

                // 加入并行网关-分支
                process.addFlowElement(createParallelGateway("parallelGateway-fork" + i, ""));
                // 获取 网关下的办理用户
                // 非组任务情况
                if (StringUtils.isBlank(wfSet.getGroupId())) {
                    // 办理任务人数多个
                    if (s.contains(",")) {
                        List<String> list = Arrays.asList(s.split(","));
                        for (int j = 0; j < list.size(); j++) {
                            userList.add(list.get(j));
                        }
                        for (int u = 0; u < userList.size(); u++) {
                        	String userName = "";
                        	if(StringUtils.isNotBlank(list.get(u))){
                        		UserExample example = new UserExample();
                        		example.createCriteria()
                        			   .andIdEqualTo(list.get(u));
                        		List<User> users = userService.queryAllObjByExample(example);
                        		if(CollectionUtils.isNotEmpty(users)){
                        			userName = users.get(0).getLoginName() + "_" + users.get(0).getNickName();
                        		}
                        	}
                            // 并行网关分支的审核节点
                            process.addFlowElement(
                                    createUserTask("userTask" + i + u, userName, userList.get(u)));
                        }
                        // wfSet.getApproveUsers();
                        // 并行网关-汇聚
                        process.addFlowElement(createParallelGateway("parallelGateway-join" + i, ""));
                    }

                    
                    else if (!s.contains(",")) {
                        throw new CommonException("所有人任务下,办理人必须大于或等于2个!");
                    }
                } else if (StringUtils.isBlank(s)) {
                    // 加入并行网关-分支
                    // process.addFlowElement(createParallelGateway("parallelGateway-fork" + i, "并行网关-分支" + i));
                    // 办理任务是角色,角色下所有人办理
                    UserRoleService userRoleService = SpringContextHolder.getOneBean(UserRoleService.class);
                    List<String> list = userRoleService.queryUserIdsForRoleId(wfSet.getGroupId());
                    if (CollectionUtils.isEmpty(list)) {
                        throw new CommonException("角色下用户为空!");
                    }
                    if (list.size() > 1) {
                        // 办理任务人数多个
                        for (int u = 0; u < list.size(); u++) {
                            // 并行网关分支的审核节点
                        	String userName = "";
                        	if(StringUtils.isNotBlank(list.get(u))){
                        		UserExample example = new UserExample();
                        		example.createCriteria()
                        			   .andIdEqualTo(list.get(u));
                        		List<User> users = userService.queryAllObjByExample(example);
                        		if(CollectionUtils.isNotEmpty(users)){
                        			userName = users.get(0).getLoginName() + "_" +  users.get(0).getNickName();
                        		}
                        	}
                        	
                            process.addFlowElement(
                                    createUserTask("userTask" + i + u, userName, list.get(u)));
                        }

                        // wfSet.getApproveUsers();
                        // 并行网关-汇聚
                        process.addFlowElement(createParallelGateway("parallelGateway-join" + i, ""));

                    } else if (list.size() == 1) {
                        // 办理任务是个人(会签并行网关下不存在此情况)
                        throw new CommonException("所有人办理下,角色下的办理人必须大于或等于2个!");
                    }
                }
            } else {
                // 普通流转
                // 审核节点
                if (StringUtils.isBlank(s)) {
                    // 组任务
                    process.addFlowElement(createGroupTask("task" + i, wfSet.getGroupId(), wfSet.getGroupId()));
                } else if (StringUtils.isBlank(wfSet.getGroupId())) {
                	//用户名
                	String userName = "";
                	
                    // 个人任务,任意一人
                    if (!s.contains(",")) {
                    	//查询昵称
                		UserExample example = new UserExample();
                		example.createCriteria()
                			   .andIdEqualTo(wfSet.getAssigneeId());
                		List<User> users = userService.queryAllObjByExample(example);
                		if(CollectionUtils.isNotEmpty(users)){
                			userName = users.get(0).getLoginName() + "_" +  users.get(0).getNickName();
                		}
                    	
                        process.addFlowElement(
                                createUserTask("task" + i, userName, wfSet.getAssigneeId()));
                    } else if (s.contains(",")) {
                        /*
                         * List<String> list = Arrays.asList(s.split(",")); for (int j = 0; j < list.size(); j++) {
                         * userList.add(list.get(j)); }
                         */
                    	String[] strs = wfSet.getAssigneeId().split(",");
                    	List<String> ids = new ArrayList<>();
                    	for (String str : strs) {
							ids.add(str);
						}
                    	
                    	UserExample example = new UserExample();
                		example.createCriteria()
                			   .andIdIn(ids);
                		List<User> users = userService.queryAllObjByExample(example);
                		if(CollectionUtils.isNotEmpty(users)){
                			for(User user : users){
                				userName = userName +  user.getNickName() + ",";
                			}
                			userName = userName.substring(0,userName.length()-1);
                		}
                		
                        // 候选人
                        process.addFlowElement(
                                createUsersTask("task" + i, userName, wfSet.getAssigneeId()));
                    }
                }
            }
        }
        // 结束节点
        process.addFlowElement(createEndEvent());

        // 连线
        for (int y = 0; y < size; y++) {
            WfSet wfSet = wfSetList.get(y);
            // 是否会签
            if (wfSet.getConditionSetUp().equals(ApproveConditionEnum.EVERYONE.getValue())) {
                // 会签
                // 判断是否第一个节点
                if (y == 0) {
                    // 开始节点和并行网关-分支连线
                    process.addFlowElement(
                            createSequenceFlow("startEvent", "parallelGateway-fork" + y, "" , ""));
                } else {
                    // 审核节点或者并行网关-汇聚到并行网关-分支
                    // 判断上一个节点是否是会签
                    if (wfSetList.get(y - 1).getConditionSetUp().equals(ApproveConditionEnum.EVERYONE.getValue())) {
                        process.addFlowElement(createSequenceFlow("parallelGateway-join" + (y - 1),
                                "parallelGateway-fork" + y, "", ""));
                    } else {
                        process.addFlowElement(createSequenceFlow("task" + (y - 1), "parallelGateway-fork" + y, "",
                                "${passOrNotAll=='true'}"));
                        process.addFlowElement(
                                createSequenceFlow("task" + (y - 1), "endEvent", "", "${passOrNotAll=='false'}"));
                    }
                }
                // 并行网关-分支和会签用户连线，会签用户和并行网关-汇聚连线
                // 获取 网关下的办理用户
                List<String> userList = new ArrayList<>();
                String s = wfSet.getAssigneeId();
                if (StringUtils.isBlank(wfSet.getGroupId())) {
                    if (s.contains(",")) {
                        // 办理任务是个人,且有多个
                        List<String> list = Arrays.asList(s.split(","));
                        for (int j = 0; j < list.size(); j++) {
                            userList.add(list.get(j));
                        }
                        for (int u = 0; u < userList.size(); u++) {
                            process.addFlowElement(createSequenceFlow("parallelGateway-fork" + y, "userTask" + y + u,
                                    "", ""));
                            process.addFlowElement(createSequenceFlow("userTask" + y + u, "parallelGateway-join" + y,
                                    "", "${passOrNotAll=='true'}"));
                            process.addFlowElement(createSequenceFlow("userTask" + y + u, "endEvent", "",
                                    "${passOrNotAll=='false'}"));
                        }
                    } /*
                       * else { // 办理任务是个人,有且只有1个(会签并行网关连线不存在此种情况,上面已做判断) process.addFlowElement(
                       * createSequenceFlow("userTask" + y, "endEvent", "不通过", "${passOrNotAll=='false'}"));
                       * process.addFlowElement( createSequenceFlow("userTask" + y, "endEvent", "通过",
                       * "${passOrNotAll=='true'}")); }
                       */
                } else if (StringUtils.isBlank(s)) {
                    // 办理任务是角色,角色下所有人办理
                    UserRoleService userRoleService = SpringContextHolder.getOneBean(UserRoleService.class);
                    List<String> list = userRoleService.queryUserIdsForRoleId(wfSet.getGroupId());
                    if (CollectionUtils.isEmpty(list)) {
                        throw new CommonException("角色下办理人为空!");
                    }
                    if (list.size() > 1) {
                        // 角色下有多个用户
                        for (int u = 0; u < list.size(); u++) {
                            process.addFlowElement(createSequenceFlow("parallelGateway-fork" + y, "userTask" + y + u,
                                    "", ""));
                            process.addFlowElement(createSequenceFlow("userTask" + y + u, "parallelGateway-join" + y,
                                    "", "${passOrNotAll=='true'}"));
                            process.addFlowElement(createSequenceFlow("userTask" + y + u, "endEvent", "",
                                    "${passOrNotAll=='false'}"));
                        }
                    } /*
                       * else if (list.size() == 1) { 会签并行网关连线不存在此种情况,上面已做判断 }
                       */
                }
                // 最后一个节点 并行网关-汇聚到结束节点
                if (y == (size - 1)) {

                    process.addFlowElement(
                            createSequenceFlow("parallelGateway-join" + y, "endEvent", "", ""));
                    /*
                     * process.addFlowElement(createSequenceFlow("parallelGateway-join" + y, "endEvent", "通过",
                     * "${passOrNotAll=='true'}")); process.addFlowElement(createSequenceFlow("parallelGateway-join" +
                     * y, "endEvent", "未通过", "${passOrNotAll=='false'}"));
                     */
                }
            } else {
                // 普通流转
                // 第一个节点
                if (y == 0) {
                    // 开始节点和审核节点1
                    process.addFlowElement(createSequenceFlow("startEvent", "task" + y, "", ""));
                } else {
                    // 判断上一个节点是否会签
                    if (wfSetList.get(y - 1).getConditionSetUp().equals(ApproveConditionEnum.EVERYONE.getValue())) {
                        // 会签
                        // 并行网关-汇聚到审核节点
                        process.addFlowElement(createSequenceFlow("parallelGateway-join" + (y - 1), "task" + y,
                                "", ""));
                    } else {
                        // 普通
                        process.addFlowElement(
                                createSequenceFlow("task" + (y - 1), "task" + y, "", "${passOrNotAll=='true'}"));
                        process.addFlowElement(
                                createSequenceFlow("task" + (y - 1), "endEvent", "", "${passOrNotAll=='false'}"));
                    }
                }
                // 是否最后一个节点
                if (y == (size - 1)) {
                    // 审核通过
                    process.addFlowElement(createSequenceFlow("task" + y, "endEvent", "", "${passOrNotAll=='true'}"));
                    // 审核拒绝
                    process.addFlowElement(
                            createSequenceFlow("task" + y, "endEvent", "", "${passOrNotAll=='false'}"));
                }
            }
        }
        return model;

    }

    /*
     * private static UserTask creatUserTaskUsers(String id, String name, String candidateUser) { // TODO Auto-generated
     * method stub List<String> candidateUsers = new ArrayList<String>(); candidateUsers.add(candidateUser); UserTask
     * userTask = new UserTask(); userTask.setName(name); userTask.setId(id);
     * userTask.setCandidateUsers(candidateUsers); return userTask; }
     */
    /* 任务节点 */
    protected static UserTask createGroupTask(String id, String name, String candidateGroup) {
        List<String> candidateGroups = new ArrayList<String>();
        candidateGroups.add(candidateGroup);
        UserTask userTask = new UserTask();
        userTask.setName(name);
        userTask.setId(id);
        userTask.setCandidateGroups(candidateGroups);
        return userTask;
    }

    protected static UserTask createUserTask(String id, String name, String assignee) {
        UserTask userTask = new UserTask();
        userTask.setName(name);
        userTask.setAssignee(assignee);
        userTask.setId(id);
        return userTask;
    }

    protected static UserTask createUsersTask(String id, String name, String candidateUser) {
        List<String> candidateUsers = new ArrayList<String>();
        candidateUsers.add(candidateUser);
        UserTask userTask = new UserTask();
        userTask.setName(name);
        userTask.setId(id);
        userTask.setCandidateUsers(candidateUsers);
        return userTask;
    }

    /*
     * protected static UserTask createUserTask(String id, String name, String assignee) { List<String> candidateUsers =
     * new ArrayList<String>(); candidateUsers.add(assignee); UserTask userTask = new UserTask();
     * userTask.setName(name); userTask.setCandidateUsers(candidateUsers); userTask.setId(id); return userTask; }
     */

    /* 连线 */
    protected static SequenceFlow createSequenceFlow(String from, String to, String name, String conditionExpression) {
        SequenceFlow flow = new SequenceFlow();
        flow.setSourceRef(from);
        flow.setTargetRef(to);
        flow.setName(name);
        if (StringUtils.isNotEmpty(conditionExpression)) {
            flow.setConditionExpression(conditionExpression);
        }
        return flow;
    }

    /* 排他网关 */
    protected static ExclusiveGateway createExclusiveGateway(String id, String name) {
        ExclusiveGateway exclusiveGateway = new ExclusiveGateway();
        exclusiveGateway.setId(id);
        exclusiveGateway.setName(name);
        return exclusiveGateway;
    }

    // 并行网关
    protected static ParallelGateway createParallelGateway(String id, String name) {
        ParallelGateway gateway = new ParallelGateway();
        gateway.setId(id);
        gateway.setName(name);
        return gateway;
    }

    /* 开始节点 */
    protected static StartEvent createStartEvent() {
        StartEvent startEvent = new StartEvent();
        startEvent.setId("startEvent");
        return startEvent;
    }

    /* 结束节点 */
    protected static EndEvent createEndEvent() {
        EndEvent endEvent = new EndEvent();
        endEvent.setId("endEvent");
        return endEvent;
    }
    
}
