package com.els.base.workflow.deployment.service;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.springframework.web.multipart.MultipartFile;

import com.els.base.core.service.BaseService;
import com.els.base.workflow.deployment.entity.WfDeployment;
import com.els.base.workflow.deployment.entity.WfDeploymentExample;

public interface WfDeploymentService extends BaseService<WfDeployment, WfDeploymentExample, String> {

    /**
     * 创建审批流
     * 
     * @param wfDeployment
     * @param file
     * @throws IOException
     */
    void addObj(WfDeployment wfDeployment, MultipartFile file) throws IOException;

    /**
     * 启用或禁用审批流
     * 
     * @param id
     * @param isEnable
     */
    void setIsEnable(WfDeployment wf);

    void modifyObj(WfDeployment wfDeployment, Map<String, MultipartFile> fileMap) throws IOException;

    /**
     * 修改流程节点
     * 
     * @param wfDeployment
     */
    void changeProcess(WfDeployment wfDeployment);

    // 删除审批流
    void deleteObjByIds(List<String> ids);

}