package com.els.base.workflow.deployment.service.impl;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipInputStream;

import javax.annotation.Resource;

import org.activiti.bpmn.BpmnAutoLayout;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.workflow.deployment.dao.WfDeploymentMapper;
import com.els.base.workflow.deployment.entity.WfDeployment;
import com.els.base.workflow.deployment.entity.WfDeploymentExample;
import com.els.base.workflow.deployment.model.BpmnModelBuilder;
import com.els.base.workflow.deployment.service.WfDeploymentService;
import com.els.base.workflow.wfSet.entity.WfSet;
import com.els.base.workflow.wfSet.entity.WfSetExample;
import com.els.base.workflow.wfSet.service.WfSetService;

@Service("defaultWfDeploymentService")
public class WfDeploymentServiceImpl implements WfDeploymentService {
    @Resource
    protected WfDeploymentMapper wfDeploymentMapper;
    @Resource
    protected WfSetService wfSetService;
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private RuntimeService runtimeService;

    @CacheEvict(value = { "wfDeployment" }, allEntries = true)
    @Override
    public void addObj(WfDeployment t) {
        t.setIsEnable(Constant.YES_INT);
        t.setCreateTime(new Date());
        this.wfDeploymentMapper.insertSelective(t);
    }

    @Transactional

    @CacheEvict(value = { "wfDeployment" }, allEntries = true)

    @Override
    public void deleteObjById(String id) {
        WfDeployment deployment = new WfDeployment();
        deployment.setId(id);
        deployment.setIsEnable(Constant.NO_INT);
        repositoryService.deleteDeployment(deployment.getId());
        this.wfDeploymentMapper.deleteByPrimaryKey(id);
    }

    @Transactional
    @CacheEvict(value = { "wfDeployment" }, allEntries = true)
    @Override
    public void deleteObjByIds(List<String> ids) {
        for (String id : ids) {
            WfDeployment deployment = new WfDeployment();
            deployment.setId(id);
            deployment.setIsEnable(Constant.NO_INT);
            repositoryService.deleteDeployment(deployment.getId());
            this.wfDeploymentMapper.deleteByPrimaryKey(id);
        }
    }

    /*
     * @CacheEvict(value = { "wfDeployment" }, allEntries = true)
     * 
     * @Override public void modifyObj(WfDeployment t) { if (StringUtils.isBlank(t.getId())) { throw new
     * NullPointerException("id 为空，无法更新"); }
     * 
     * t.setUpdateTime(new Date()); this.wfDeploymentMapper.updateByPrimaryKeySelective(t); }
     */
    @Transactional
    @CacheEvict(value = { "wfDeployment" }, allEntries = true)
    @Override
    public void modifyObj(WfDeployment wfDeployment) {
        if (StringUtils.isBlank(wfDeployment.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }

        // 1.1 生成模板需要的数据
        BpmnModelBuilder builder = new BpmnModelBuilder();
        BpmnModel model = builder.build(wfDeployment);

        // 生成模型
        new BpmnAutoLayout(model).execute();

        // 部署新的流程
        Deployment deployment =
                this.repositoryService.createDeployment().addBpmnModel(wfDeployment.getBusinessCode() + ".bpmn", model)
                        .name(wfDeployment.getBusinessCode() + "_deployment").deploy();
        // 删除旧的wfset
        List<WfSet> wfSetList = wfDeployment.getWfSetList();
        String wid = wfSetList.get(0).getDeploymentId();
        WfSetExample wfSetExample = new WfSetExample();
        wfSetExample.createCriteria().andDeploymentIdEqualTo(wid);
        wfSetService.deleteByExample(wfSetExample);
        // 重新插入wfset
        for (WfSet wfSet : wfSetList) {
            // wfSetService.deleteObjById(wfSet.getId());
            wfSet.setDeploymentId(wfDeployment.getId());
            this.wfSetService.addObj(wfSet);
        }

        wfDeployment.setUpdateTime(new Date());
        this.wfDeploymentMapper.updateByPrimaryKeySelective(wfDeployment);
    }

    @CacheEvict(value = { "wfDeployment" }, allEntries = true)
    @Transactional
    @Override
    public void modifyObj(WfDeployment wfDeployment, Map<String, MultipartFile> fileMap) throws IOException {
        Assert.isNotBlank(wfDeployment.getId(), "id为空,无法更新");

        if (MapUtils.isNotEmpty(fileMap)) {
            Set<String> fileKeySet = fileMap.keySet();
            if (fileKeySet.size() > 1) {
                throw new CommonException("不接受多个文件上传", "file_upload_not_accepted");
            }

            MultipartFile file = null;

            Iterator<String> keyIterator = fileKeySet.iterator();
            while (keyIterator.hasNext()) {
                file = (MultipartFile) fileMap.get(keyIterator.next());
            }
            Deployment deploy = repositoryService.createDeployment() // 创建部署
                    .addZipInputStream(new ZipInputStream(file.getInputStream()))// 添加ZIP输入流
                    .deploy();// 开始部署
        }

        wfDeployment.setUpdateTime(new Date());
        this.wfDeploymentMapper.updateByPrimaryKeySelective(wfDeployment);
    }

    @Cacheable(value = "wfDeployment", keyGenerator = "redisKeyGenerator")
    @Override
    public WfDeployment queryObjById(String id) {
        return this.wfDeploymentMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "wfDeployment", keyGenerator = "redisKeyGenerator")
    @Override
    public List<WfDeployment> queryAllObjByExample(WfDeploymentExample example) {
        return this.wfDeploymentMapper.selectByExample(example);
    }

    @Cacheable(value = "wfDeployment", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<WfDeployment> queryObjByPage(WfDeploymentExample example) {
        PageView<WfDeployment> pageView = example.getPageView();
        List<WfDeployment> selectByExampleByPage = this.wfDeploymentMapper.selectByExampleByPage(example);
        for (int i = 0; CollectionUtils.isNotEmpty(selectByExampleByPage) && i < selectByExampleByPage.size(); i++) {
            WfSetExample wfSetExample = new WfSetExample();
            wfSetExample.createCriteria().andDeploymentIdEqualTo(selectByExampleByPage.get(i).getId());
            List<WfSet> sets = this.wfSetService.queryAllObjByExample(wfSetExample);
            selectByExampleByPage.get(i).setWfSetList(sets);
        }
        pageView.setQueryResult(selectByExampleByPage);
        return pageView;
    }

    @CacheEvict(value = { "wfDeployment" }, allEntries = true)
    @Transactional
    @Override
    public void addObj(WfDeployment wfDeployment, MultipartFile file) throws IOException {
        // 1、部署到activiti,获取deploymentId
        Deployment deploy = repositoryService.createDeployment() // 创建部署
                .addZipInputStream(new ZipInputStream(file.getInputStream()))// 添加ZIP输入流
                .deploy();// 开始部署
        // 2、保存到T_BASE_WF_DEPLOYMENT:deploymentId， processDefindId, processDefindName
        wfDeployment.setId(deploy.getId());
        wfDeployment.setCreateTime(new Date());
        this.wfDeploymentMapper.insertSelective(wfDeployment);
    }

    @CacheEvict(value = { "wfDeployment" }, allEntries = true)
    @Transactional
    @Override
    public void setIsEnable(WfDeployment wf) {
        ProcessDefinition processDefinition =
                repositoryService.createProcessDefinitionQuery().deploymentId(wf.getId()).list().get(0);
        WfDeployment deployment = new WfDeployment();
        deployment.setId(wf.getId());

        if (Constant.NO_INT.equals(wf.getIsEnable())) {
            // 1、到activiti 禁用流程
            deployment.setIsEnable(Constant.NO_INT);
            // 2、修改表的数据
            this.wfDeploymentMapper.updateByPrimaryKeySelective(deployment);
            repositoryService.suspendProcessDefinitionById(processDefinition.getId());
            // runtimeService.suspendProcessInstanceById(processDefinition.getId());
        } else {// 启用
            deployment.setIsEnable(Constant.YES_INT);
            this.wfDeploymentMapper.updateByPrimaryKeySelective(deployment);
            repositoryService.activateProcessDefinitionById(processDefinition.getId());
            // runtimeService.activateProcessInstanceById(processDefinition.getId());
        }

    }

    @CacheEvict(value = { "wfDeployment" }, allEntries = true)
    @Transactional
    @Override
    public void changeProcess(WfDeployment wfDeployment) {
        // String code = wfDeployment.getBusinessCode();

        WfDeploymentExample deploymentExample = new WfDeploymentExample();
        deploymentExample.createCriteria().andBusinessCodeEqualTo(wfDeployment.getBusinessCode());

        if (this.wfDeploymentMapper.countByExample(deploymentExample) > 0) {
            throw new CommonException("该模块编码已存在,请重新输入");
        }
        // 1、根据提交的数据，生成 bpmn文件
        // 1.1 生成模板需要的数据
        BpmnModelBuilder builder = new BpmnModelBuilder();
        BpmnModel model = builder.build(wfDeployment);

        // 生成模型
        new BpmnAutoLayout(model).execute();

        // 部署新的流程
        Deployment deployment =
                this.repositoryService.createDeployment().addBpmnModel(wfDeployment.getBusinessCode() + ".bpmn", model)
                        .name(wfDeployment.getBusinessCode() + "_deployment").deploy();

        // 2、把数据更新到数据库
        // 2.1 删除旧的wfSet 数据
        // wfSet插入数据表，
        List<WfSet> wfSetList = wfDeployment.getWfSetList();
        for (WfSet wfSet : wfSetList) {
            // wfSetService.deleteObjById(wfSet.getId());
            wfSet.setDeploymentId(deployment.getId());
            this.wfSetService.addObj(wfSet);
        }
        // 2.2 重新插入
        wfDeployment.setId(deployment.getId());
        wfDeployment.setIsEnable(Constant.YES_INT);
        wfDeployment.setCreateTime(new Date());
        this.wfDeploymentMapper.insertSelective(wfDeployment);
    }

}