package com.els.base.workflow.test;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipInputStream;

import javax.servlet.http.HttpServletResponse;

import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentQuery;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import com.els.base.core.entity.ResponseResult;

@Controller
@RequestMapping("actDeploy")
public class DeployController {
	
	@Autowired
	private TaskService taskService;

	@Autowired
	private RepositoryService repositoryService;

	@Autowired
	private RuntimeService runtimeService;
	
	@Autowired
	private ProcessEngine processEngine;

	@RequestMapping("front/deployBpmn")
	@ResponseBody
	public ResponseResult<String> deployBpmn(@RequestParam(required = true) MultipartFile file, String resourceName)
			throws IOException {

		Deployment deployment = this.repositoryService.createDeployment()
				.addInputStream(resourceName, file.getInputStream()).deploy();
		return ResponseResult.success(String.valueOf(this.repositoryService.createProcessDefinitionQuery().count()));
	}
	@RequestMapping("front/deployBpmnZip")
	@ResponseBody
	public ResponseResult<String> deployBpmnZip(@RequestParam(required = true) MultipartFile file, String resourceName)
			throws IOException {
		
		this.repositoryService.createDeployment()
				.addZipInputStream(new ZipInputStream(file.getInputStream())).deploy();
		return ResponseResult.success(String.valueOf(this.repositoryService.createProcessDefinitionQuery().count()));
	}

	@RequestMapping("front/queryProcess")
	@ResponseBody
	public ResponseResult<List<String>> queryProcess() {
		ProcessDefinitionQuery pdq = this.repositoryService.createProcessDefinitionQuery();
		List<ProcessDefinition> list = pdq.list();
		List<String> strList = new ArrayList<>();
		for (ProcessDefinition pd : list) {
			strList.add(MessageFormat.format("key[{0}], id[{1}], resourceName[{2}], diagramResourceName[{3}]", pd.getKey() ,pd.getId() , pd.getResourceName(),pd.getDiagramResourceName()));
		}

		return ResponseResult.success(strList);
	}

	@RequestMapping("front/startProcess")
	@ResponseBody
	public ResponseResult<String> startProcess(String key) {
		this.runtimeService.startProcessInstanceByKey(key);

		return ResponseResult.success();
	}

	/*@RequestMapping("front/testCriteria")
	@ResponseBody
	public ResponseResult<AttachmentExample.Criteria> testCriteria() {
		AttachmentExample example = new AttachmentExample();
		AttachmentExample.Criteria criteria = example.createCriteria();
		criteria.andIdEqualTo(1).andFileNameNotEqualTo("3");
		ResponseResult<AttachmentExample.Criteria> result = new ResponseResult<>();
		result.setStatus("00");
		result.setMsg("ok");
		result.setData(criteria);
		return result;
	}*/
	
	@RequestMapping("front/getResoucesName")
	@ResponseBody
	public ResponseResult<String> getResoucesName(String deploymentId, String resourceName, HttpServletResponse response) {
		List<String> names = repositoryService.getDeploymentResourceNames(deploymentId);
		String imageName = null;
		String nameList = "";
		for (String name : names) {
			if (name.indexOf(".png") >= 0) {
				imageName = name;
			}
			nameList = nameList + name;
		}
		
		return ResponseResult.success(StringUtils.defaultIfBlank(imageName, nameList));
	}

	@RequestMapping("front/queryResources")
	@ResponseBody
	public void queryResources(String deploymentId, String resourceName, HttpServletResponse response)
			throws IOException {
		InputStream resourceStream = this.repositoryService.getResourceAsStream(deploymentId, resourceName);
		byte[] b = new byte[1024];
		while (resourceStream.read(b, 0, 1024) != -1) {
			response.getOutputStream().write(b, 0, 1024);
		}
	}
	
	@RequestMapping("front/getProcessImage")
    public void getProcessImage(String pid, HttpServletResponse response) throws IOException{
		
		BpmnModel bpmnModel = this.repositoryService.getBpmnModel(pid);
//		InputStream resourceStream = this.processEngine
//				                      .getProcessEngineConfiguration()
//				                      .getProcessDiagramGenerator()
//				                      .generateDiagram(bpmnModel, "png", null);
		InputStream resourceStream = this.processEngine.getProcessEngineConfiguration().getProcessDiagramGenerator().generatePngDiagram(bpmnModel);
		
		byte[] b = new byte[1024];
		while (resourceStream.read(b, 0, 1024) != -1) {
			response.getOutputStream().write(b, 0, 1024);
		}
	}

	@RequestMapping("front/deleteDeployment")
	@ResponseBody
	public ResponseResult<String> deleteDeployment(String deploymentId) {
		this.repositoryService.deleteDeployment(deploymentId, true);

		return ResponseResult.success();
	}

	@RequestMapping("front/queryDeployment")
	@ResponseBody
	public ResponseResult<List<String>> queryDeployment() {
		DeploymentQuery dq = this.repositoryService.createDeploymentQuery();
		List<Deployment> list = dq.list();
		List<String> strList = new ArrayList<>();
		for (Deployment deployment : list) {
			
			strList.add(deployment.getId() + " " + deployment.getName() + " " + deployment.getTenantId());
		}

		return ResponseResult.success(strList);
	}
	/*@RequestMapping("service/findTodoTask")
	@ResponseBody
	private ResponseResult<PageView<WorkOrderVo>> findTodoTask(@RequestParam(defaultValue="1") int pageNo,@RequestParam(defaultValue="10") int pageSize) {
		List<Role> roleList = SpringSecurityUtils.getLoginUserRoleList();
		
		if (CollectionUtils.isEmpty(roleList)) {
			return ResponseResult.success(new PageView<WorkOrderVo>(pageNo, pageSize));
		}
		
		List<Task> allTask = new ArrayList<>();
		for(Role role: roleList){
			TaskQuery taskQuery = taskService
					.createTaskQuery()	//获取查询对象
					.taskAssignee(role.getRoleCode())//指定查询的名称
					.active()
					.orderByTaskCreateTime().asc();
			List<Task> taskList = taskQuery.list();
			
			if (CollectionUtils.isEmpty(taskList)) {
				continue;
			}
			
			allTask.addAll(taskList);
		}
		
		PageView<WorkOrderVo> pageView = new PageView<>(pageNo, pageSize);
		pageView.setRowCount(allTask.size());

		List<WorkOrderVo> subTaskList = new ArrayList<>(pageSize);
		for(Task task: allTask.subList(pageView.getStartRowNo(), pageView.getEndRowNo())){
			Map<String, Object> proinstMap = runtimeService.createProcessInstanceQuery()
					.processInstanceId(task.getProcessInstanceId()).includeProcessVariables().singleResult().getProcessVariables();
			ProcessDefinition processDefinition = repositoryService.getProcessDefinition(task.getProcessDefinitionId());
			WorkOrderVo workOrderVo = new WorkOrderVo(task, processDefinition, proinstMap);
			subTaskList.add(workOrderVo);
		}
		
		pageView.setQueryResult(subTaskList);
		return ResponseResult.success(pageView);
	}*/
}
