package com.els.base.workflow.user;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.GroupQuery;
import org.activiti.engine.impl.GroupQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.persistence.entity.GroupEntity;
import org.activiti.engine.impl.persistence.entity.GroupEntityManager;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.utils.SpringContextHolder;

@Component
public class CustomGroupEntityManager extends GroupEntityManager {

    @Resource
    private RoleService roleService;

    @Override
    public Group createNewGroup(String groupId) {
        // TODO Auto-generated method stub
        return super.createNewGroup(groupId);
    }

    @Override
    public void insertGroup(Group group) {
        // TODO Auto-generated method stub
        super.insertGroup(group);
    }

    @Override
    public void updateGroup(Group updatedGroup) {
        // TODO Auto-generated method stub
        super.updateGroup(updatedGroup);
    }

    @Override
    public void deleteGroup(String groupId) {
        // TODO Auto-generated method stub
        super.deleteGroup(groupId);
    }

    @Override
    public GroupQuery createNewGroupQuery() {
        // TODO Auto-generated method stub
        return super.createNewGroupQuery();
    }

    @Override
    public List<Group> findGroupByQueryCriteria(GroupQueryImpl query, Page page) {
        // TODO Auto-generated method stub
        // return super.findGroupByQueryCriteria(query, page);
        RoleExample roleExample = new RoleExample();
        RoleExample.Criteria criteria = roleExample.createCriteria();
        RoleService roleService = SpringContextHolder.getOneBean(RoleService.class);
        if (StringUtils.isNotBlank(query.getId())) {
            criteria.andIdEqualTo(query.getId());
        }

        if (StringUtils.isNotBlank(query.getName())) {
            criteria.andRoleNameEqualTo(query.getName());
        }

        if (StringUtils.isNotBlank(query.getNameLike())) {
            criteria.andRoleNameLike(query.getNameLike());
        }

        if (StringUtils.isNotBlank(query.getUserId())) {
            List<Role> roles = roleService.queryUserOwnRoles(query.getUserId());
            // List<Role> roles = this.roleService.queryUserOwnRoles(query.getUserId());
            List<String> roleId = new ArrayList<>();
            for (int i = 0; CollectionUtils.isNotEmpty(roles) && i < roles.size(); i++) {
                roleId.add(roles.get(i).getId());
            }

            if (CollectionUtils.isNotEmpty(roleId)) {

            }
            criteria.andIdIn(roleId);
        }

        List<Role> roles = roleService.queryAllObjByExample(roleExample);
        List<Group> groups = new ArrayList<>();
        GroupEntity groupEntity = null;
        for (Role role : roles) {
            groupEntity = new GroupEntity();
            groupEntity.setRevision(1);
            groupEntity.setType("assignment");
            groupEntity.setId(role.getId());
            groupEntity.setName(role.getRoleCode());
            groups.add(groupEntity);
        }
        return groups;
    }

    @Override
    public long findGroupCountByQueryCriteria(GroupQueryImpl query) {
        // TODO Auto-generated method stub
        return super.findGroupCountByQueryCriteria(query);
    }

    @Override
    public List<Group> findGroupsByUser(String userId) {
        // TODO Auto-generated method stub
        // List<Role> roles = roleService.queryUserOwnRoles(userId);
        List<Role> roles = SpringSecurityUtils.getLoginUserRoleList();
        List<Group> groups = new ArrayList<>();
        GroupEntity groupEntity = null;
        for (Role role : roles) {
            groupEntity = new GroupEntity();
            groupEntity.setRevision(1);
            groupEntity.setType("assignment");
            groupEntity.setId(role.getId());
            groupEntity.setName(role.getRoleCode());
            groups.add(groupEntity);
        }
        return groups;

    }

    @Override
    public List<Group> findGroupsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        // TODO Auto-generated method stub
        return super.findGroupsByNativeQuery(parameterMap, firstResult, maxResults);
    }

    @Override
    public long findGroupCountByNativeQuery(Map<String, Object> parameterMap) {
        // TODO Auto-generated method stub
        return super.findGroupCountByNativeQuery(parameterMap);
    }

    @Override
    public boolean isNewGroup(Group group) {
        // TODO Auto-generated method stub
        return super.isNewGroup(group);
    }

}
