package com.els.base.workflow.user;

import javax.annotation.Resource;

import org.activiti.engine.impl.interceptor.Session;
import org.activiti.engine.impl.interceptor.SessionFactory;
import org.activiti.engine.impl.persistence.entity.GroupIdentityManager;
import org.springframework.stereotype.Service;

/**
 * 自定义用户组的管理器
 * 
 * @author hzy
 *
 */
@Service
public class CustomGroupManagerFactory implements SessionFactory {
    @Resource
    private CustomGroupEntityManager customGroupEntityManager;

    @Override
    public Class<?> getSessionType() {
        return GroupIdentityManager.class;
    }

    @Override
    public Session openSession() {
        return new CustomGroupEntityManager();
    }

    /**
     * @param customGroupEntityManager the customGroupEntityManager to set
     */
    public void setCustomGroupEntityManager(CustomGroupEntityManager customGroupEntityManager) {
        this.customGroupEntityManager = customGroupEntityManager;
    }

}
