/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.workflow.deployment.model;

import com.els.base.auth.entity.Role;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.utils.SpringContextHolder;
import com.els.base.workflow.deployment.Enum.ApproveConditionEnum;
import com.els.base.workflow.deployment.entity.WfDeployment;
import com.els.base.workflow.wfSet.entity.WfSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnModelBuilder {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BpmnModelBuilder.class);

    public BpmnModel build(WfDeployment wfDeployment) {
        Object list;
        UserRoleService userRoleService;
        String groupId;
        List<String> list2;
        String s;
        ArrayList<String> userList;
        WfSet wfSet;
        UserService userService = (UserService)SpringContextHolder.getOneBean(UserService.class);
        BpmnModel model = new BpmnModel();
        Process process = new Process();
        model.addProcess(process);
        String PROCESSID = wfDeployment.getBusinessCode();
        String PROCESSNAME = wfDeployment.getName();
        process.setId(PROCESSID);
        process.setName(PROCESSNAME);
        List<WfSet> wfSetList = wfDeployment.getWfSetList();
        int size = wfSetList.size();
        process.addFlowElement((FlowElement)BpmnModelBuilder.createStartEvent());
        for (int i = 0; i < size; ++i) {
            UserExample example;
            wfSet = wfSetList.get(i);
            userList = new ArrayList<String>();
            s = wfSet.getAssigneeId();
            if (StringUtils.isBlank((String)s) && StringUtils.isBlank((String)wfSet.getGroupId())) {
                throw new CommonException("\u529e\u7406\u4eba\u6216\u529e\u7406\u7ec4\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a!");
            }
            if (wfSet.getConditionSetUp().equals(ApproveConditionEnum.EVERYONE.getValue())) {
                process.addFlowElement((FlowElement)BpmnModelBuilder.createParallelGateway("parallelGateway-fork" + i, ""));
                if (StringUtils.isBlank((String)wfSet.getGroupId())) {
                    if (s.contains(",")) {
                        list2 = Arrays.asList(s.split(","));
                        for (int j = 0; j < list2.size(); ++j) {
                            userList.add(list2.get(j));
                        }
                        for (int u = 0; u < userList.size(); ++u) {
                            String userName = "";
                            if (StringUtils.isNotBlank((String)list2.get(u))) {
                                example = new UserExample();
                                example.createCriteria().andIdEqualTo(list2.get(u));
                                List users = userService.queryAllObjByExample((IExample)example);
                                if (CollectionUtils.isNotEmpty((Collection)users)) {
                                    userName = ((User)users.get(0)).getLoginName() + "_" + ((User)users.get(0)).getNickName();
                                }
                            }
                            process.addFlowElement((FlowElement)BpmnModelBuilder.createUserTask("userTask" + i + u, userName, (String)userList.get(u)));
                        }
                        process.addFlowElement((FlowElement)BpmnModelBuilder.createParallelGateway("parallelGateway-join" + i, ""));
                        continue;
                    }
                    if (s.contains(",")) continue;
                    throw new CommonException("\u6240\u6709\u4eba\u4efb\u52a1\u4e0b,\u529e\u7406\u4eba\u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e2\u4e2a!");
                }
                if (!StringUtils.isBlank((String)s)) continue;
                groupId = wfSet.getGroupId();
                List<Object> groupIdList = new ArrayList<String>();
                if (groupId.contains(",")) {
                    groupIdList = Arrays.asList(groupId.split(","));
                } else {
                    groupIdList.add(groupId);
                }
                LOGGER.debug("\u4efb\u52a1\u4eba\u662f11" + groupIdList.size());
                LOGGER.debug("\u4efb\u52a1\u4eba\u662f11" + groupIdList.toString());
                userRoleService = (UserRoleService)SpringContextHolder.getOneBean(UserRoleService.class);
                list = userRoleService.queryUserIdsForRoleIdList(groupIdList);
                LOGGER.debug("\u4efb\u52a1\u4eba\u662f11" + list.size());
                LOGGER.debug("\u4efb\u52a1\u4eba\u662f11" + list.toString());
                if (CollectionUtils.isEmpty((Collection)list)) {
                    throw new CommonException("\u89d2\u8272\u4e0b\u7528\u6237\u4e3a\u7a7a!");
                }
                if (list.size() > 1) {
                    for (int u = 0; u < list.size(); ++u) {
                        String userName = "";
                        if (StringUtils.isNotBlank((String)((String)list.get(u)))) {
                            UserExample example2 = new UserExample();
                            example2.createCriteria().andIdEqualTo((String)list.get(u));
                            List users = userService.queryAllObjByExample((IExample)example2);
                            if (CollectionUtils.isNotEmpty((Collection)users)) {
                                userName = ((User)users.get(0)).getLoginName() + "_" + ((User)users.get(0)).getNickName();
                            }
                        }
                        process.addFlowElement((FlowElement)BpmnModelBuilder.createUserTask("userTask" + i + u, userName, (String)list.get(u)));
                    }
                    process.addFlowElement((FlowElement)BpmnModelBuilder.createParallelGateway("parallelGateway-join" + i, ""));
                    LOGGER.debug("\u4efb\u52a1\u4eba\u662f11" + process.getFlowElements());
                    continue;
                }
                if (list.size() != 1) continue;
                throw new CommonException("\u6240\u6709\u4eba\u529e\u7406\u4e0b,\u89d2\u8272\u4e0b\u7684\u529e\u7406\u4eba\u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e2\u4e2a!");
            }
            if (StringUtils.isBlank((String)s)) {
                RoleService roleService = (RoleService)SpringContextHolder.getOneBean(RoleService.class);
                Role role = (Role)roleService.queryObjById((Object)wfSet.getGroupId());
                String roleName = "";
                if (role != null) {
                    roleName = role.getRoleName();
                }
                process.addFlowElement((FlowElement)BpmnModelBuilder.createGroupTask("task" + i, roleName, wfSet.getGroupId()));
                continue;
            }
            if (!StringUtils.isBlank((String)wfSet.getGroupId())) continue;
            String userName = "";
            if (!s.contains(",")) {
                UserExample example3 = new UserExample();
                example3.createCriteria().andIdEqualTo(wfSet.getAssigneeId());
                List users = userService.queryAllObjByExample((IExample)example3);
                if (CollectionUtils.isNotEmpty((Collection)users)) {
                    userName = ((User)users.get(0)).getLoginName() + "_" + ((User)users.get(0)).getNickName();
                }
                process.addFlowElement((FlowElement)BpmnModelBuilder.createUserTask("task" + i, userName, wfSet.getAssigneeId()));
                continue;
            }
            if (!s.contains(",")) continue;
            String[] strs = wfSet.getAssigneeId().split(",");
            ArrayList<String> ids = new ArrayList<String>();
            for (String str : strs) {
                ids.add(str);
            }
            example = new UserExample();
            example.createCriteria().andIdIn(ids);
            List users = userService.queryAllObjByExample((IExample)example);
            if (CollectionUtils.isNotEmpty((Collection)users)) {
                for (User user : users) {
                    userName = userName + user.getNickName() + ",";
                }
                userName = userName.substring(0, userName.length() - 1);
            }
            process.addFlowElement((FlowElement)BpmnModelBuilder.createUsersTask("task" + i, userName, wfSet.getAssigneeId()));
        }
        process.addFlowElement((FlowElement)BpmnModelBuilder.createEndEvent());
        for (int y = 0; y < size; ++y) {
            wfSet = wfSetList.get(y);
            if (wfSet.getConditionSetUp().equals(ApproveConditionEnum.EVERYONE.getValue())) {
                if (y == 0) {
                    process.addFlowElement((FlowElement)BpmnModelBuilder.createSequenceFlow("startEvent", "parallelGateway-fork" + y, "", ""));
                } else if (wfSetList.get(y - 1).getConditionSetUp().equals(ApproveConditionEnum.EVERYONE.getValue())) {
                    process.addFlowElement((FlowElement)BpmnModelBuilder.createSequenceFlow("parallelGateway-join" + (y - 1), "parallelGateway-fork" + y, "", ""));
                } else {
                    process.addFlowElement((FlowElement)BpmnModelBuilder.createSequenceFlow("task" + (y - 1), "parallelGateway-fork" + y, "", "${passOrNotAll=='true'}"));
                    process.addFlowElement((FlowElement)BpmnModelBuilder.createSequenceFlow("task" + (y - 1), "endEvent", "", "${passOrNotAll=='false'}"));
                }
                userList = new ArrayList();
                s = wfSet.getAssigneeId();
                if (StringUtils.isBlank((String)wfSet.getGroupId())) {
                    if (s.contains(",")) {
                        list2 = Arrays.asList(s.split(","));
                        for (int j = 0; j < list2.size(); ++j) {
                            userList.add(list2.get(j));
                        }
                        for (int u = 0; u < userList.size(); ++u) {
                            process.addFlowElement((FlowElement)BpmnModelBuilder.createSequenceFlow("parallelGateway-fork" + y, "userTask" + y + u, "", ""));
                            process.addFlowElement((FlowElement)BpmnModelBuilder.createSequenceFlow("userTask" + y + u, "parallelGateway-join" + y, "", "${passOrNotAll=='true'}"));
                            process.addFlowElement((FlowElement)BpmnModelBuilder.createSequenceFlow("userTask" + y + u, "endEvent", "", "${passOrNotAll=='false'}"));
                        }
                    }
                } else if (StringUtils.isBlank((String)s)) {
                    groupId = wfSet.getGroupId();
                    List<String> groupIdList = new ArrayList<String>();
                    if (groupId.contains(",")) {
                        groupIdList = Arrays.asList(groupId.split(","));
                    } else {
                        groupIdList.add(groupId);
                    }
                    userRoleService = (UserRoleService)SpringContextHolder.getOneBean(UserRoleService.class);
                    list = userRoleService.queryUserIdsForRoleIdList(groupIdList);
                    if (CollectionUtils.isEmpty((Collection)list)) {
                        throw new CommonException("\u89d2\u8272\u4e0b\u529e\u7406\u4eba\u4e3a\u7a7a!");
                    }
                    if (list.size() > 1) {
                        for (int u = 0; u < list.size(); ++u) {
                            process.addFlowElement((FlowElement)BpmnModelBuilder.createSequenceFlow("parallelGateway-fork" + y, "userTask" + y + u, "", ""));
                            process.addFlowElement((FlowElement)BpmnModelBuilder.createSequenceFlow("userTask" + y + u, "parallelGateway-join" + y, "", "${passOrNotAll=='true'}"));
                            process.addFlowElement((FlowElement)BpmnModelBuilder.createSequenceFlow("userTask" + y + u, "endEvent", "", "${passOrNotAll=='false'}"));
                        }
                    }
                }
                if (y != size - 1) continue;
                process.addFlowElement((FlowElement)BpmnModelBuilder.createSequenceFlow("parallelGateway-join" + y, "endEvent", "", ""));
                continue;
            }
            if (y == 0) {
                process.addFlowElement((FlowElement)BpmnModelBuilder.createSequenceFlow("startEvent", "task" + y, "", ""));
            } else if (wfSetList.get(y - 1).getConditionSetUp().equals(ApproveConditionEnum.EVERYONE.getValue())) {
                process.addFlowElement((FlowElement)BpmnModelBuilder.createSequenceFlow("parallelGateway-join" + (y - 1), "task" + y, "", ""));
            } else {
                process.addFlowElement((FlowElement)BpmnModelBuilder.createSequenceFlow("task" + (y - 1), "task" + y, "", "${passOrNotAll=='true'}"));
                process.addFlowElement((FlowElement)BpmnModelBuilder.createSequenceFlow("task" + (y - 1), "endEvent", "", "${passOrNotAll=='false'}"));
            }
            if (y != size - 1) continue;
            process.addFlowElement((FlowElement)BpmnModelBuilder.createSequenceFlow("task" + y, "endEvent", "", "${passOrNotAll=='true'}"));
            process.addFlowElement((FlowElement)BpmnModelBuilder.createSequenceFlow("task" + y, "endEvent", "", "${passOrNotAll=='false'}"));
        }
        return model;
    }

    protected static UserTask createGroupTask(String id, String name, String candidateGroup) {
        ArrayList<String> candidateGroups = new ArrayList<String>();
        candidateGroups.add(candidateGroup);
        UserTask userTask = new UserTask();
        userTask.setName(name);
        userTask.setId(id);
        userTask.setCandidateGroups(candidateGroups);
        return userTask;
    }

    protected static UserTask createUserTask(String id, String name, String assignee) {
        UserTask userTask = new UserTask();
        userTask.setName(name);
        userTask.setAssignee(assignee);
        userTask.setId(id);
        return userTask;
    }

    protected static UserTask createUsersTask(String id, String name, String candidateUser) {
        ArrayList<String> candidateUsers = new ArrayList<String>();
        candidateUsers.add(candidateUser);
        UserTask userTask = new UserTask();
        userTask.setName(name);
        userTask.setId(id);
        userTask.setCandidateUsers(candidateUsers);
        return userTask;
    }

    protected static SequenceFlow createSequenceFlow(String from, String to, String name, String conditionExpression) {
        SequenceFlow flow = new SequenceFlow();
        flow.setSourceRef(from);
        flow.setTargetRef(to);
        flow.setName(name);
        if (StringUtils.isNotEmpty((String)conditionExpression)) {
            flow.setConditionExpression(conditionExpression);
        }
        return flow;
    }

    protected static ExclusiveGateway createExclusiveGateway(String id, String name) {
        ExclusiveGateway exclusiveGateway = new ExclusiveGateway();
        exclusiveGateway.setId(id);
        exclusiveGateway.setName(name);
        return exclusiveGateway;
    }

    protected static ParallelGateway createParallelGateway(String id, String name) {
        ParallelGateway gateway = new ParallelGateway();
        gateway.setId(id);
        gateway.setName(name);
        return gateway;
    }

    protected static StartEvent createStartEvent() {
        StartEvent startEvent = new StartEvent();
        startEvent.setId("startEvent");
        return startEvent;
    }

    protected static EndEvent createEndEvent() {
        EndEvent endEvent = new EndEvent();
        endEvent.setId("endEvent");
        return endEvent;
    }
}

