/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.workflow.common.service.impl;

import com.els.base.auth.service.UserRoleService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.msg.Message;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.SpringContextHolder;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.entity.WorkOrderVo;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.event.TaskStartEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import com.els.base.workflow.common.utils.ApproveStatusEnum;
import com.els.base.workflow.common.utils.ProcessVariableNameEnum;
import com.els.base.workflow.common.utils.TaskVariableNameEnum;
import com.els.base.workflow.wfSet.service.WfSetService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.identity.Group;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WorkFlowServiceImpl
implements WorkFlowService {
    @Resource
    protected TaskService taskService;
    @Resource
    protected RuntimeService runtimeService;
    @Resource
    protected HistoryService historyService;
    @Resource
    protected IdentityService identityService;
    @Resource
    protected RepositoryService repositoryService;
    @Resource
    protected UserService userService;
    @Resource
    protected UserRoleService userRoleService;
    @Resource
    protected WfSetService wfSetService;

    @Override
    @Transactional
    public ApproveStatusEnum completePersonalTask(String taskId, User user, String isPass, String desc) {
        ProcessInstance currentProcess;
        Task task = this.queryTaskAndVaild(taskId);
        this.validUser(task, user);
        if (StringUtils.isBlank((String)task.getAssignee())) {
            this.taskService.claim(taskId, user.getId());
        }
        if ((currentProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).includeProcessVariables().singleResult()) == null || currentProcess.isEnded()) {
            throw new CommonException("\u8be5\u5ba1\u6279\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f");
        }
        ApproveStatusEnum statusEnum = null;
        String processDefinitionKey = (String)currentProcess.getProcessVariables().get("processDefinitionKey");
        String businessKey = currentProcess.getBusinessKey();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).list();
        if (CollectionUtils.isEmpty((Collection)processDefinitions)) {
            throw new CommonException("\u672a\u627e\u5230\u8be5\u6a21\u5757\u7f16\u7801,\u8bf7\u68c0\u67e5\u6570\u636e!");
        }
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).list().get(processDefinitions.size() - 1);
        if (this.repositoryService.isProcessDefinitionSuspended(definition.getId())) {
            try {
                if (isPass.equals("true")) {
                    this.callListener(currentProcess, user, task, true, true);
                    statusEnum = ApproveStatusEnum.PASS;
                } else if (isPass.equals("false")) {
                    this.callListener(currentProcess, user, task, false, true);
                    statusEnum = ApproveStatusEnum.REJECT;
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(processDefinitionKey).processInstanceBusinessKey(businessKey).singleResult();
            this.runtimeService.deleteProcessInstance(processInstance.getId(), "\u5ba1\u6279\u6d41\u5df2\u505c\u7528");
            return statusEnum;
        }
        HashMap<String, Object> taskMap = new HashMap<String, Object>();
        taskMap.put(TaskVariableNameEnum.PASS_STATUS.getVarName(), isPass);
        taskMap.put(TaskVariableNameEnum.APPROVE_DESC.getVarName(), StringUtils.defaultIfBlank((String)desc, (String)"\u65e0"));
        taskMap.put(TaskVariableNameEnum.USER_NAME.getVarName(), user.getNickName());
        taskMap.put(TaskVariableNameEnum.APPROVE_TIME.getVarName(), new Date());
        HashMap<String, String> processMap = new HashMap<String, String>();
        processMap.put(ProcessVariableNameEnum.PASS_STATUS.getVarName(), isPass);
        this.taskService.setVariablesLocal(taskId, taskMap);
        this.taskService.addComment(taskId, task.getProcessInstanceId(), desc);
        this.taskService.complete(taskId, processMap);
        try {
            statusEnum = this.getApproveResult(currentProcess, user, task, "true".equals(isPass));
        }
        catch (ClassNotFoundException e) {
            throw new CommonException("\u5ba1\u6279\u6267\u884c\u5f02\u5e38", (Throwable)e);
        }
        return statusEnum;
    }

    private ApproveStatusEnum getApproveResult(ProcessInstance currentProcess, User user, Task task, boolean isPass) throws ClassNotFoundException {
        ProcessInstance nextProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).includeProcessVariables().singleResult();
        ApproveStatusEnum statusEnum = null;
        boolean isFinish = false;
        if (currentProcess.getActivityId().contains("parallelGateway")) {
            if (nextProcess == null || nextProcess.isEnded()) {
                isFinish = true;
                if (isPass) {
                    statusEnum = ApproveStatusEnum.PASS;
                    this.callListener(currentProcess, user, task, isPass, isFinish);
                } else {
                    statusEnum = ApproveStatusEnum.REJECT;
                    this.callListener(currentProcess, user, task, isPass, isFinish);
                }
            } else if (isPass) {
                statusEnum = ApproveStatusEnum.APPLY;
                this.callListener(currentProcess, user, task, isPass, isFinish);
                String processInstanceId = task.getProcessInstanceId();
                this.sendNoticeMessage(processInstanceId);
            } else {
                this.callListener(currentProcess, user, task, false, true);
                statusEnum = ApproveStatusEnum.REJECT;
            }
        } else if (nextProcess == null || nextProcess.isEnded()) {
            isFinish = true;
            if (isPass) {
                statusEnum = ApproveStatusEnum.PASS;
                this.callListener(currentProcess, user, task, isPass, isFinish);
            } else {
                statusEnum = ApproveStatusEnum.REJECT;
                this.callListener(currentProcess, user, task, isPass, isFinish);
            }
        } else {
            statusEnum = ApproveStatusEnum.APPLY;
            this.callListener(currentProcess, user, task, isPass, isFinish);
            String processInstanceId = task.getProcessInstanceId();
            this.sendNoticeMessage(processInstanceId);
        }
        return statusEnum;
    }

    @Override
    public void test(String processInstanceId) {
        this.sendNoticeMessage(processInstanceId);
    }

    private List<String> getAssigneeList(String procInstId) {
        List taskList = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(procInstId)).includeTaskLocalVariables()).active().list();
        return taskList.stream().filter(task -> task.getTaskLocalVariables().get(TaskVariableNameEnum.PASS_STATUS.getVarName()) == null).flatMap(task -> this.getUserIdByTask((Task)task).stream()).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
    }

    private List<String> getUserIdByTask(Task task) {
        ArrayList<String> userIdList = new ArrayList<String>();
        userIdList.add(task.getAssignee());
        List identityLinks = this.taskService.getIdentityLinksForTask(task.getId());
        List candidateUsers = identityLinks.stream().map(IdentityLink::getUserId).collect(Collectors.toList());
        userIdList.addAll(candidateUsers);
        List userInGroups = identityLinks.stream().map(IdentityLink::getGroupId).filter(StringUtils::isNotBlank).flatMap(groupId -> this.userRoleService.queryUserIdsForRoleId(groupId).stream()).collect(Collectors.toList());
        userIdList.addAll(userInGroups);
        return userIdList;
    }

    private void sendNoticeMessage(String processInstanceId) {
        Map processVariables = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).includeProcessVariables().singleResult()).getProcessVariables();
        String businessTypeCode = "WE_CHAT_AUDIT_NOTICE";
        List<String> receiverIdList = this.getAssigneeList(processInstanceId);
        if (CollectionUtils.isEmpty(receiverIdList)) {
            return;
        }
        Message message = Message.init((Object)processVariables).setBusinessTypeCode(businessTypeCode).setSenderId("1").setCompanyCode("50000000").addReceiverIdList(receiverIdList);
        MessageSendUtils.sendMessage((Message)message);
    }

    private void callListener(ProcessInstance currentProcess, User user, Task task, boolean isPass, boolean isFinish) throws ClassNotFoundException {
        Map processVariables = currentProcess.getProcessVariables();
        String className = (String)processVariables.get(ProcessVariableNameEnum.LISTENER_CLASS.getVarName());
        if (StringUtils.isBlank((String)className)) {
            return;
        }
        ITaskListener listener = (ITaskListener)SpringContextHolder.getOneBean(Class.forName(className));
        String businessKey = currentProcess.getBusinessKey();
        String processDefKey = currentProcess.getProcessDefinitionKey();
        String businessId = (String)processVariables.get(ProcessVariableNameEnum.BUSINESS_ID.getVarName());
        List comments = this.taskService.getTaskComments(task.getId());
        String approveDesc = null;
        approveDesc = CollectionUtils.isEmpty((Collection)comments) ? null : ((Comment)comments.get(0)).getFullMessage();
        String assignee = user.getNickName();
        TaskOperateEvent event = new TaskOperateEvent(null, processDefKey, businessKey, isPass, isFinish, businessId, approveDesc, assignee);
        event.setCurrentProcess(currentProcess);
        event.setCurrentTask(task);
        event.setAssigneeUser(user);
        listener.listen(event);
        SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)event);
    }

    private void validUser(Task task, User user) {
        if (StringUtils.isEmpty((String)task.getAssignee())) {
            ArrayList<String> list = new ArrayList<String>();
            for (IdentityLink identityLink : this.taskService.getIdentityLinksForTask(task.getId())) {
                if (!StringUtils.isNotEmpty((String)identityLink.getUserId())) continue;
                list.add(identityLink.getUserId());
            }
            if (!CollectionUtils.isEmpty(list)) {
                if (!list.contains(user.getId())) {
                    throw new CommonException("\u6ca1\u6709\u6743\u9650\u6267\u884c\u8be5\u5ba1\u6838\u4efb\u52a1");
                }
            } else {
                List groupList = this.identityService.createGroupQuery().groupMember(user.getId()).list();
                ArrayList<String> groupIdList = new ArrayList<String>();
                for (Group group : groupList) {
                    groupIdList.add(group.getId());
                }
                List links = this.taskService.getIdentityLinksForTask(task.getId());
                ArrayList<String> linkGroupIds = new ArrayList<String>();
                for (IdentityLink link : links) {
                    linkGroupIds.add(link.getGroupId());
                }
                if (!CollectionUtils.containsAny(groupIdList, linkGroupIds)) {
                    throw new CommonException("\u6ca1\u6709\u6743\u9650\u6267\u884c\u8be5\u5ba1\u6838\u4efb\u52a1");
                }
            }
        } else if (!user.getId().equals(task.getAssignee())) {
            throw new CommonException("\u6ca1\u6709\u6743\u9650\u6267\u884c\u8be5\u5ba1\u6838\u4efb\u52a1");
        }
    }

    private Task queryTaskAndVaild(String taskId) {
        TaskQuery taskQuery = (TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).taskId(taskId);
        Task task = (Task)taskQuery.singleResult();
        if (task == null) {
            throw new CommonException("\u8be5\u4efb\u52a1id\u4e0d\u5b58\u5728");
        }
        if (task.isSuspended()) {
            throw new CommonException("\u8be5\u5ba1\u6279\u4efb\u52a1\u5df2\u7ecf\u6682\u505c");
        }
        return task;
    }

    @Override
    public ProcessInstance stopProcess(String processDefinitionKey, String businessKey) {
        if (StringUtils.isBlank((String)processDefinitionKey) || StringUtils.isBlank((String)businessKey)) {
            throw new CommonException("\u6d41\u7a0bkey\uff0c\u4e1a\u52a1key\uff0c\u53d1\u8d77\u4eba\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        List processInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey(processDefinitionKey).processInstanceBusinessKey(businessKey).list();
        if (CollectionUtils.isEmpty((Collection)processInstances)) {
            throw new CommonException("\u672a\u627e\u5230\u8be5\u6a21\u5757\u7f16\u7801\u6216\u4e1a\u52a1\u7f16\u7801,\u8bf7\u68c0\u67e5\u6570\u636e!");
        }
        Iterator iterator = processInstances.iterator();
        if (iterator.hasNext()) {
            ProcessInstance processInstance = (ProcessInstance)iterator.next();
            this.runtimeService.deleteProcessInstance(processInstance.getId(), "\u5df2\u4f5c\u5e9f");
            return processInstance;
        }
        return null;
    }

    @Override
    public ProcessInstance startProcess(String processDefinitionKey, String businessKey, Map<String, Object> processVariable) {
        if (StringUtils.isBlank((String)processDefinitionKey) || StringUtils.isBlank((String)businessKey)) {
            throw new CommonException("\u6d41\u7a0bkey\uff0c\u4e1a\u52a1key\uff0c\u53d1\u8d77\u4eba\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        ProcessInstance processInstance = null;
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).list();
        if (CollectionUtils.isEmpty((Collection)processDefinitions)) {
            throw new CommonException("\u672a\u627e\u5230\u8be5\u6a21\u5757\u7f16\u7801,\u8bf7\u68c0\u67e5\u6570\u636e!");
        }
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).list().get(processDefinitions.size() - 1);
        if (this.repositoryService.isProcessDefinitionSuspended(definition.getId())) {
            this.complete(processDefinitionKey, businessKey, processVariable);
        } else {
            ProcessInstance currentProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(processDefinitionKey).processInstanceBusinessKey(businessKey).singleResult();
            if (currentProcess != null) {
                throw new CommonException("\u4e1a\u52a1\u6d41\u7a0b[" + processDefinitionKey + "][" + businessKey + "]\uff0c\u5df2\u7ecf\u542f\u52a8\uff0c\u65e0\u6cd5\u91cd\u590d\u542f\u52a8");
            }
            processVariable.put(ProcessVariableNameEnum.START_TIME.getVarName(), new Date());
            processVariable.put(ProcessVariableNameEnum.START_USER.getVarName(), ((User)this.userService.queryObjById((Object)SpringSecurityUtils.getLoginUserId())).getNickName());
            processInstance = this.runtimeService.startProcessInstanceByKey(processDefinitionKey, businessKey, processVariable);
            List list = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getId())).list();
            TaskStartEvent startEvent = new TaskStartEvent("start process");
            startEvent.setBusinessKey(businessKey);
            startEvent.setProcessDefinitionKey(processDefinitionKey);
            startEvent.setCurrentTask((Task)list.get(0));
            startEvent.setCurrentProcess(processInstance);
            SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)startEvent);
            String processInstanceId = processInstance.getId();
            this.sendNoticeMessage(processInstanceId);
        }
        return processInstance;
    }

    public void complete(String processDefinitionKey, String businessKey, Map<String, Object> processVariable) {
        String className = (String)processVariable.get(ProcessVariableNameEnum.LISTENER_CLASS.getVarName());
        if (StringUtils.isBlank((String)className)) {
            return;
        }
        ITaskListener listener = null;
        try {
            listener = (ITaskListener)SpringContextHolder.getOneBean(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new CommonException("\u5ba1\u6279\u6267\u884c\u5f02\u5e38", (Throwable)e);
        }
        String businessId = (String)processVariable.get(ProcessVariableNameEnum.BUSINESS_ID.getVarName());
        TaskOperateEvent event = new TaskOperateEvent(null, processDefinitionKey, businessKey, true, true, businessId, null, null);
        listener.listen(event);
        SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)event);
    }

    @Override
    public ProcessInstance startProcess(ProcessStartVO processStartVO) {
        Map<String, Object> processVariable = processStartVO.getProcessVariable();
        if (processVariable == null) {
            processVariable = new HashMap<String, Object>();
        }
        if (processStartVO.getListenerClass() != null) {
            processVariable.put(ProcessVariableNameEnum.LISTENER_CLASS.getVarName(), processStartVO.getListenerClass().getName());
        }
        String processDefinitionKey = processStartVO.getProcessDefinitionKey();
        String businessId = processStartVO.getBusinessId();
        String displayPage = processStartVO.getDisplayPage();
        String businessKey = processStartVO.getBusinessKey();
        processVariable.put("businessKey", businessKey);
        processVariable.put("businessId", businessId);
        processVariable.put("displayPage", displayPage);
        processVariable.put("processDefinitionKey", processDefinitionKey);
        processStartVO.setProcessVariable(processVariable);
        return this.startProcess(processStartVO.getProcessDefinitionKey(), processStartVO.getBusinessKey(), processStartVO.getProcessVariable());
    }

    @Override
    @Transactional
    public List<WorkOrderVo> findTaskListForProcess(String processDefinitionKey, String businessKey) {
        WorkOrderVo workOrderVo;
        int i;
        List pis = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(processDefinitionKey).processInstanceBusinessKey(businessKey).includeProcessVariables().list();
        if (CollectionUtils.isEmpty((Collection)pis)) {
            throw new CommonException("\u672a\u627e\u5230\u8be5\u6a21\u5757\u7f16\u7801,\u8bf7\u68c0\u67e5\u6570\u636e!");
        }
        ArrayList<WorkOrderVo> workOrderVoList = new ArrayList<WorkOrderVo>();
        for (HistoricProcessInstance hisProcessInstance : pis) {
            if (hisProcessInstance == null) continue;
            Map hisProcessMap = hisProcessInstance.getProcessVariables();
            List<HistoricTaskInstance> hisTaskList = this.findHisTaskByProcessId(hisProcessInstance.getId());
            for (i = 0; CollectionUtils.isNotEmpty(hisTaskList) && i < hisTaskList.size(); ++i) {
                Map hisTaskVarMap = hisTaskList.get(i).getTaskLocalVariables();
                workOrderVo = new WorkOrderVo(hisTaskList.get(i), hisProcessInstance, (Map<String, Object>)hisProcessMap, (Map<String, Object>)hisTaskVarMap);
                workOrderVoList.add(workOrderVo);
            }
        }
        ProcessInstance currentProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(processDefinitionKey).processInstanceBusinessKey(businessKey).includeProcessVariables().singleResult();
        if (currentProcess == null) {
            return workOrderVoList;
        }
        Map processMap = currentProcess.getProcessVariables();
        TaskQuery taskQuery = (TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(currentProcess.getId())).includeTaskLocalVariables()).orderByTaskId()).asc();
        List taskList = taskQuery.list();
        for (i = 0; CollectionUtils.isNotEmpty((Collection)taskList) && i < taskList.size(); ++i) {
            Map taskMap = ((Task)taskList.get(i)).getTaskLocalVariables();
            workOrderVo = new WorkOrderVo((Task)taskList.get(i), currentProcess, (Map<String, Object>)processMap, (Map<String, Object>)taskMap);
            workOrderVoList.add(workOrderVo);
        }
        return workOrderVoList;
    }

    private List<HistoricTaskInstance> findHisTaskByProcessId(String processInstanceId) {
        HistoricTaskInstanceQuery hisTaskQuery = (HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).includeTaskLocalVariables()).orderByTaskCreateTime()).asc();
        return hisTaskQuery.list();
    }

    @Override
    public PageView<WorkOrderVo> findTodoTask(PageView<WorkOrderVo> pageView, User user, String title, String businessKey, String startUser) {
        Assert.isNotNull(pageView, (String)"\u5206\u9875\u4fe1\u606f\u4e3a\u7a7a");
        List groupList = this.identityService.createGroupQuery().groupMember(user.getId()).list();
        if (CollectionUtils.isEmpty((Collection)groupList)) {
            pageView.setPageNo(1);
            return pageView;
        }
        List<Task> allTask = this.queryAllTodoTask(user, groupList, title, businessKey, startUser);
        if (CollectionUtils.isEmpty(allTask)) {
            return pageView;
        }
        List<WorkOrderVo> workOrderVoList = this.completeVo(allTask = this.distinctAndSort(allTask));
        if (CollectionUtils.isEmpty(workOrderVoList)) {
            return pageView;
        }
        pageView.setRowCount(workOrderVoList.size());
        workOrderVoList = workOrderVoList.subList(pageView.getStartRowNo(), pageView.getEndRowNo());
        pageView.setQueryResult(workOrderVoList);
        return pageView;
    }

    @Override
    public List<WorkOrderVo> findAllTodoTask(User user, String title, String businessKey, String startUser) {
        List groupList = this.identityService.createGroupQuery().groupMember(user.getId()).list();
        if (CollectionUtils.isEmpty((Collection)groupList)) {
            return null;
        }
        List<Task> allTask = this.queryAllTodoTask(user, groupList, title, businessKey, startUser);
        if (CollectionUtils.isEmpty(allTask)) {
            return null;
        }
        allTask = this.distinctAndSort(allTask);
        List<WorkOrderVo> workOrderVoList = this.completeVo(allTask);
        return workOrderVoList;
    }

    private List<WorkOrderVo> completeVo(List<Task> allTask) {
        if (CollectionUtils.isEmpty(allTask)) {
            return null;
        }
        Set processInstanceIdList = allTask.stream().map(TaskInfo::getProcessInstanceId).collect(Collectors.toSet());
        List processInstanceList = this.runtimeService.createProcessInstanceQuery().processInstanceIds(processInstanceIdList).includeProcessVariables().list();
        return allTask.stream().map(task -> {
            WorkOrderVo workOrderVo;
            Map<String, Object> map;
            ProcessInstance processInstance = processInstanceList.stream().filter(tmp -> tmp.getId().equals(task.getProcessInstanceId())).findAny().orElse(null);
            Map proinstMap = null;
            if (processInstance != null) {
                proinstMap = processInstance.getProcessVariables();
            }
            if ((map = (workOrderVo = new WorkOrderVo((Task)task, processInstance, (Map<String, Object>)proinstMap, (Map<String, Object>)task.getTaskLocalVariables())).getProinstMap()) != null) {
                Date startTime = (Date)map.get("startTime");
                workOrderVo.setStartTime(startTime);
            }
            return workOrderVo;
        }).collect(Collectors.toList());
    }

    private List<Task> queryAllTodoTask(User user, List<Group> groupList, String title, String businessKey, String startUser) {
        List groupNameList = groupList.stream().map(Group::getId).collect(Collectors.toList());
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().taskAssignee(user.getId());
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().taskCandidateGroupIn(groupNameList);
        TaskQuery tQuery = (TaskQuery)this.taskService.createTaskQuery().taskCandidateUser(user.getId());
        if (StringUtils.isNotBlank((String)businessKey)) {
            taskQuery = (TaskQuery)taskQuery.processInstanceBusinessKeyLike("%" + businessKey + "%");
            query = (TaskQuery)query.processInstanceBusinessKeyLike("%" + businessKey + "%");
            tQuery = (TaskQuery)tQuery.processInstanceBusinessKeyLike("%" + businessKey + "%");
        }
        if (StringUtils.isNotBlank((String)title)) {
            taskQuery = (TaskQuery)taskQuery.processDefinitionNameLike("%" + title + "%");
            query = (TaskQuery)query.processDefinitionNameLike("%" + title + "%");
            tQuery = (TaskQuery)tQuery.processDefinitionNameLike("%" + title + "%");
        }
        if (StringUtils.isNotBlank((String)startUser)) {
            taskQuery = (TaskQuery)taskQuery.processVariableValueLike("startUser", "%" + startUser + "%");
            query = (TaskQuery)query.processVariableValueLike("startUser", "%" + startUser + "%");
            tQuery = (TaskQuery)tQuery.processVariableValueLike("startUser", "%" + startUser + "%");
        }
        taskQuery = ((TaskQuery)taskQuery.includeTaskLocalVariables()).active();
        query = ((TaskQuery)query.includeTaskLocalVariables()).active();
        tQuery = ((TaskQuery)tQuery.includeTaskLocalVariables()).active();
        ArrayList<Task> allTask = new ArrayList<Task>();
        allTask.addAll(taskQuery.list());
        allTask.addAll(query.list());
        allTask.addAll(tQuery.list());
        return allTask;
    }

    private List<Task> distinctAndSort(List<Task> allTask) {
        TreeSet<Task> taskSet = new TreeSet<Task>((t1, t2) -> t1.getId().compareTo(t2.getId()));
        taskSet.addAll(allTask);
        allTask.clear();
        allTask.addAll(taskSet);
        allTask.sort((t1, t2) -> {
            if (t1.getCreateTime() == null) {
                return -1;
            }
            if (t2.getCreateTime() == null) {
                return 1;
            }
            return t2.getCreateTime().compareTo(t1.getCreateTime());
        });
        return allTask;
    }

    @Override
    public PageView<WorkOrderVo> findMyAppliedTask(PageView<WorkOrderVo> pageView, User user) {
        if (pageView == null) {
            throw new CommonException("\u5206\u9875\u4fe1\u606f\u4e3a\u7a7a");
        }
        ArrayList allTask = new ArrayList();
        HistoricTaskInstanceQuery query = (HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(user.getId())).includeTaskLocalVariables()).orderByTaskCreateTime()).desc();
        List list = query.list();
        allTask.addAll(list);
        pageView.setRowCount(allTask.size());
        ArrayList<WorkOrderVo> subTaskList = new ArrayList<WorkOrderVo>(pageView.getPageSize());
        for (HistoricTaskInstance task : allTask.subList(pageView.getStartRowNo(), pageView.getEndRowNo())) {
            HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).includeProcessVariables().singleResult();
            Map proinstMap = processInstance.getProcessVariables();
            WorkOrderVo workOrderVo = new WorkOrderVo(task, processInstance, (Map<String, Object>)proinstMap, (Map<String, Object>)task.getTaskLocalVariables());
            subTaskList.add(workOrderVo);
        }
        pageView.setQueryResult(subTaskList);
        return pageView;
    }

    @Override
    @Transactional
    public PageView<WorkOrderVo> findDoneTask(PageView<WorkOrderVo> pageView, User user, String title, String businessKey, String startUser) {
        if (pageView == null) {
            throw new CommonException("\u5206\u9875\u4fe1\u606f\u4e3a\u7a7a");
        }
        List groupList = this.identityService.createGroupQuery().groupMember(user.getId()).list();
        if (CollectionUtils.isEmpty((Collection)groupList)) {
            pageView.setPageNo(1);
            return pageView;
        }
        HistoricTaskInstanceQuery query = (HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(user.getId());
        if (StringUtils.isNotBlank((String)businessKey)) {
            query = (HistoricTaskInstanceQuery)query.processInstanceBusinessKeyLike("%" + businessKey + "%");
        }
        if (StringUtils.isNotBlank((String)startUser)) {
            query = (HistoricTaskInstanceQuery)query.processVariableValueLike("startUser", "%" + startUser + "%");
        }
        List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)query.finished().includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).list();
        ArrayList allTask = new ArrayList();
        allTask.addAll(list);
        pageView.setRowCount(allTask.size());
        List<WorkOrderVo> subTaskList = new ArrayList<WorkOrderVo>(pageView.getPageSize());
        if (StringUtils.isNotBlank((String)title)) {
            for (Object task : allTask) {
                subTaskList = this.completeTask((HistoricTaskInstance)task, subTaskList);
            }
            subTaskList = subTaskList.stream().filter(i -> i.getTitle().contains(title)).collect(Collectors.toList());
            pageView.setRowCount(subTaskList.size());
            ArrayList<WorkOrderVo> sTaskList = new ArrayList<WorkOrderVo>(pageView.getPageSize());
            for (WorkOrderVo task : subTaskList.subList(pageView.getStartRowNo(), pageView.getEndRowNo())) {
                sTaskList.add(task);
            }
            pageView.setQueryResult(sTaskList);
        } else {
            for (HistoricTaskInstance task : allTask.subList(pageView.getStartRowNo(), pageView.getEndRowNo())) {
                subTaskList = this.completeTask(task, subTaskList);
            }
            pageView.setQueryResult(subTaskList);
        }
        return pageView;
    }

    @Override
    @Transactional
    public List<WorkOrderVo> findAllDoneTask(User user, String title, String businessKey, String startUser) {
        List groupList = this.identityService.createGroupQuery().groupMember(user.getId()).list();
        if (CollectionUtils.isEmpty((Collection)groupList)) {
            return null;
        }
        HistoricTaskInstanceQuery query = (HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(user.getId());
        if (StringUtils.isNotBlank((String)businessKey)) {
            query = (HistoricTaskInstanceQuery)query.processInstanceBusinessKeyLike("%" + businessKey + "%");
        }
        if (StringUtils.isNotBlank((String)startUser)) {
            query = (HistoricTaskInstanceQuery)query.processVariableValueLike("startUser", "%" + startUser + "%");
        }
        List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)query.finished().includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).list();
        ArrayList allTask = new ArrayList();
        allTask.addAll(list);
        List<WorkOrderVo> subTaskList = new ArrayList<WorkOrderVo>();
        if (StringUtils.isNotBlank((String)title)) {
            for (HistoricTaskInstance task : allTask) {
                subTaskList = this.completeTask(task, subTaskList);
            }
            subTaskList = subTaskList.stream().filter(i -> i.getTitle().contains(title)).collect(Collectors.toList());
        } else {
            for (HistoricTaskInstance task : allTask) {
                subTaskList = this.completeTask(task, subTaskList);
            }
        }
        return subTaskList;
    }

    private List<WorkOrderVo> completeTask(HistoricTaskInstance task, List<WorkOrderVo> subTaskList) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).includeProcessVariables().singleResult();
        Map proinstMap = processInstance.getProcessVariables();
        WorkOrderVo workOrderVo = new WorkOrderVo(task, processInstance, (Map<String, Object>)proinstMap, (Map<String, Object>)task.getTaskLocalVariables());
        subTaskList.add(workOrderVo);
        return subTaskList;
    }

    @Override
    @Transactional
    public List<WorkOrderVo> findDoneTaskByExport(User user, List<String> ids, String businessKey, String title) {
        List groupList = this.identityService.createGroupQuery().groupMember(user.getId()).list();
        if (CollectionUtils.isEmpty((Collection)groupList)) {
            throw new CommonException("\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        HistoricTaskInstanceQuery query = (HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(user.getId());
        if (StringUtils.isNotBlank((String)businessKey)) {
            query = (HistoricTaskInstanceQuery)query.processInstanceBusinessKeyLike("%" + businessKey + "%");
        }
        List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)query.finished().includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).list();
        ArrayList allTask = new ArrayList();
        allTask.addAll(list);
        List<WorkOrderVo> subTaskList = new ArrayList<WorkOrderVo>();
        for (HistoricTaskInstance task : allTask) {
            HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).includeProcessVariables().singleResult();
            Map proinstMap = processInstance.getProcessVariables();
            WorkOrderVo workOrderVo = new WorkOrderVo(task, processInstance, (Map<String, Object>)proinstMap, (Map<String, Object>)task.getTaskLocalVariables());
            subTaskList.add(workOrderVo);
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            subTaskList = subTaskList.stream().filter(i -> ids.contains(i.getTaskId())).collect(Collectors.toList());
        }
        if (StringUtils.isNotEmpty((String)title)) {
            subTaskList = subTaskList.stream().filter(i -> i.getTitle().contains(title)).collect(Collectors.toList());
        }
        return subTaskList;
    }

    @Override
    @Transactional
    public List<WorkOrderVo> findTodoTaskByExport(User user, List<String> ids, String businessKey, String title) {
        List groupList = this.identityService.createGroupQuery().groupMember(user.getId()).list();
        if (CollectionUtils.isEmpty((Collection)groupList)) {
            throw new CommonException("\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        List groupNameList = groupList.stream().map(Group::getId).collect(Collectors.toList());
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().taskAssignee(user.getId());
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().taskCandidateGroupIn(groupNameList);
        TaskQuery tQuery = (TaskQuery)this.taskService.createTaskQuery().taskCandidateUser(user.getId());
        if (StringUtils.isNotBlank((String)businessKey)) {
            taskQuery = (TaskQuery)taskQuery.processInstanceBusinessKeyLike("%" + businessKey + "%");
            query = (TaskQuery)query.processInstanceBusinessKeyLike("%" + businessKey + "%");
            tQuery = (TaskQuery)tQuery.processInstanceBusinessKeyLike("%" + businessKey + "%");
        }
        if (StringUtils.isNotBlank((String)title)) {
            taskQuery = (TaskQuery)taskQuery.processDefinitionKeyLike("%" + title + "%");
            query = (TaskQuery)query.processDefinitionKeyLike("%" + title + "%");
            tQuery = (TaskQuery)tQuery.processDefinitionKeyLike("%" + title + "%");
        }
        taskQuery = ((TaskQuery)taskQuery.includeTaskLocalVariables()).active();
        query = ((TaskQuery)query.includeTaskLocalVariables()).active();
        tQuery = ((TaskQuery)tQuery.includeTaskLocalVariables()).active();
        List<Task> allTask = new ArrayList<Task>();
        allTask.addAll(taskQuery.list());
        allTask.addAll(query.list());
        allTask.addAll(tQuery.list());
        allTask = this.distinctAndSort(allTask);
        List<WorkOrderVo> subTaskList = new ArrayList<WorkOrderVo>();
        for (Task task : allTask) {
            ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).includeProcessVariables().singleResult();
            Map proinstMap = processInstance.getProcessVariables();
            WorkOrderVo workOrderVo = new WorkOrderVo(task, processInstance, (Map<String, Object>)proinstMap, (Map<String, Object>)task.getTaskLocalVariables());
            Map<String, Object> map = workOrderVo.getProinstMap();
            Date startTime = (Date)map.get("startTime");
            workOrderVo.setStartTime(startTime);
            subTaskList.add(workOrderVo);
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            subTaskList = subTaskList.stream().filter(i -> ids.contains(i.getTaskId())).collect(Collectors.toList());
        }
        return subTaskList;
    }

    @Override
    public List<WorkOrderVo> findTaskListForProcess(String processInstanceId) {
        WorkOrderVo workOrderVo;
        int i;
        List pis = this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).includeProcessVariables().list();
        if (CollectionUtils.isEmpty((Collection)pis)) {
            throw new CommonException("\u672a\u627e\u5230\u8be5\u6a21\u5757\u7f16\u7801,\u8bf7\u68c0\u67e5\u6570\u636e!");
        }
        ArrayList<WorkOrderVo> workOrderVoList = new ArrayList<WorkOrderVo>();
        for (HistoricProcessInstance hisProcessInstance : pis) {
            if (hisProcessInstance == null) continue;
            Map hisProcessMap = hisProcessInstance.getProcessVariables();
            List<HistoricTaskInstance> hisTaskList = this.findHisTaskByProcessId(hisProcessInstance.getId());
            for (i = 0; CollectionUtils.isNotEmpty(hisTaskList) && i < hisTaskList.size(); ++i) {
                Map hisTaskVarMap = hisTaskList.get(i).getTaskLocalVariables();
                workOrderVo = new WorkOrderVo(hisTaskList.get(i), hisProcessInstance, (Map<String, Object>)hisProcessMap, (Map<String, Object>)hisTaskVarMap);
                workOrderVoList.add(workOrderVo);
            }
        }
        ProcessInstance currentProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).includeProcessVariables().singleResult();
        if (currentProcess == null) {
            return workOrderVoList;
        }
        Map processMap = currentProcess.getProcessVariables();
        TaskQuery taskQuery = (TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(currentProcess.getId())).includeTaskLocalVariables()).orderByTaskId()).asc();
        List taskList = taskQuery.list();
        for (i = 0; CollectionUtils.isNotEmpty((Collection)taskList) && i < taskList.size(); ++i) {
            Map taskMap = ((Task)taskList.get(i)).getTaskLocalVariables();
            workOrderVo = new WorkOrderVo((Task)taskList.get(i), currentProcess, (Map<String, Object>)processMap, (Map<String, Object>)taskMap);
            workOrderVoList.add(workOrderVo);
        }
        return workOrderVoList;
    }
}

