/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingContent;
import com.els.base.bidding.entity.BiddingContentMatter;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingMatter;
import com.els.base.bidding.entity.BiddingMatterExample;
import com.els.base.bidding.entity.BiddingPower;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingMatterService;
import com.els.base.certification.contacts.entity.Contacts;
import com.els.base.certification.contacts.service.ContactsService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.BankAccount;
import com.els.base.company.entity.BankAccountExample;
import com.els.base.company.entity.Company;
import com.els.base.company.service.BankAccountService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.utils.ObjectHolder;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.ggsync.service.SyncEconomicIssuesSetService;
import com.els.base.material.entity.Material;
import com.els.base.material.service.MaterialService;
import com.els.base.purchase.dao.PurchaseRequisitionHeadMapper;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseRequisitionHead;
import com.els.base.purchase.entity.PurchaseRequisitionHeadExample;
import com.els.base.purchase.entity.PurchaseRequisitionItem;
import com.els.base.purchase.entity.PurchaseRequisitionItemExample;
import com.els.base.purchase.enumerate.PurchaseRequisitionStatusEnum;
import com.els.base.purchase.exception.BudgetNotPassException;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.service.PurchaseRequisitionHeadService;
import com.els.base.purchase.service.PurchaseRequisitionItemService;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import com.els.sinolifesdk.service.SinoLifeApiService;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurchaseRequisitionHeadService")
public class PurchaseRequisitionHeadServiceImpl
implements PurchaseRequisitionHeadService,
ITaskListener {
    @Resource
    protected PurchaseRequisitionHeadMapper purchaseRequisitionHeadMapper;
    @Resource
    protected PurchaseRequisitionItemService purchaseRequisitionItemService;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private PurchaseOrderService purchaseOrderService;
    @Resource
    private CompanyService companyService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private ContactsService contactsService;
    @Resource
    private MaterialService materialService;
    @Resource
    private BiddingHeaderService biddingHeaderService;
    @Resource
    private BiddingMatterService biddingMatterService;
    @Resource
    private SinoLifeApiService sinolifeApiService;
    @Resource
    private SyncEconomicIssuesSetService syncEconomicIssuesSetService;
    @Resource
    private BankAccountService bankAccountService;

    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    @Transactional
    public void addObj(PurchaseRequisitionHead t) {
        User currentUser = SpringSecurityUtils.getLoginUser();
        t.setProjectId(ProjectUtils.getProjectId());
        t.setCompanyId(CompanyUtils.currentCompanyId());
        t.setApplyNo(this.generateCodeService.getNextCode("PURCHASE_REQUISITION"));
        t.setApplyStatusCode(PurchaseRequisitionStatusEnum.NEW.code());
        t.setApplyStatusDesc(PurchaseRequisitionStatusEnum.NEW.desc());
        t.setCreateUserId(currentUser.getId());
        t.setCreateUserName(currentUser.getNickName());
        t.setCreateTime(new Date());
        this.purchaseRequisitionHeadMapper.insertSelective(t);
        ObjectHolder oh = ObjectHolder.of((Object)1);
        t.getPurchaseRequisitionItemList().forEach(item -> {
            item.setHeadId(t.getId());
            Integer n = (Integer)oh.value;
            oh.value = (Integer)oh.value + 1;
            Integer n2 = oh.value;
            item.setItemNo(n);
        });
        this.purchaseRequisitionItemService.addAll(t.getPurchaseRequisitionItemList());
    }

    @Transactional
    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    public void addAll(List<PurchaseRequisitionHead> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseRequisitionHeadMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseRequisitionHeadMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    @Transactional
    public void deleteByExample(PurchaseRequisitionHeadExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseRequisitionHeadMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    @Transactional
    public void modifyObj(PurchaseRequisitionHead t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        User currentUser = SpringSecurityUtils.getLoginUser();
        t.setApplyStatusCode(PurchaseRequisitionStatusEnum.NEW.code());
        t.setApplyStatusDesc(PurchaseRequisitionStatusEnum.NEW.desc());
        t.setUpdateUserId(currentUser.getId());
        t.setUpdateUserName(currentUser.getNickName());
        t.setUpdateTime(new Date());
        this.purchaseRequisitionHeadMapper.updateByPrimaryKeySelective(t);
        PurchaseRequisitionItemExample example = new PurchaseRequisitionItemExample();
        example.createCriteria().andHeadIdEqualTo(t.getId());
        this.purchaseRequisitionItemService.deleteByExample((IExample)example);
        ObjectHolder oh = ObjectHolder.of((Object)1);
        t.getPurchaseRequisitionItemList().forEach(item -> {
            item.setHeadId(t.getId());
            Integer n = (Integer)oh.value;
            oh.value = (Integer)oh.value + 1;
            Integer n2 = oh.value;
            item.setItemNo(n);
        });
        this.purchaseRequisitionItemService.addAll(t.getPurchaseRequisitionItemList());
    }

    @Cacheable(value={"purchaseRequisitionHead"}, keyGenerator="redisKeyGenerator")
    public PurchaseRequisitionHead queryObjById(String id) {
        return this.purchaseRequisitionHeadMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseRequisitionHead"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseRequisitionHead> queryAllObjByExample(PurchaseRequisitionHeadExample example) {
        return this.purchaseRequisitionHeadMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseRequisitionHead"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseRequisitionHead> queryObjByPage(PurchaseRequisitionHeadExample example) {
        PageView<PurchaseRequisitionHead> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseRequisitionHeadMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    @Transactional
    public void deleteByIds(List<String> ids) {
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.createCriteria().andIdIn((List)ids);
        this.purchaseRequisitionHeadMapper.deleteByExample(example);
        PurchaseRequisitionItemExample example2 = new PurchaseRequisitionItemExample();
        example2.createCriteria().andHeadIdIn((List)ids);
        this.purchaseRequisitionItemService.deleteByExample((IExample)example2);
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    @Transactional
    public List<PurchaseRequisitionHead> budgetCheck(List<PurchaseRequisitionHead> purchaseRequisitionList) {
        purchaseRequisitionList.forEach(purchaseRequisition -> {
            boolean pass = this.doCheck((PurchaseRequisitionHead)purchaseRequisition);
            PurchaseRequisitionStatusEnum status = pass ? PurchaseRequisitionStatusEnum.BUDGET_PASS : PurchaseRequisitionStatusEnum.BUDGET_NOT_PASS;
            PurchaseRequisitionHead updateVO = new PurchaseRequisitionHead();
            updateVO.setId(purchaseRequisition.getId());
            updateVO.setApplyStatusCode(status.code());
            updateVO.setApplyStatusDesc(status.desc());
            updateVO.setUpdateTime(new Date());
            this.purchaseRequisitionHeadMapper.updateByPrimaryKeySelective(updateVO);
        });
        return purchaseRequisitionList;
    }

    private boolean doCheck(PurchaseRequisitionHead requisition) {
        List list = requisition.getPurchaseRequisitionItemList().parallelStream().map(item -> {
            String bs = this.syncEconomicIssuesSetService.getBudgetSubjectsByEconomicIssuesNo(item.getEconomicIssuesNo());
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            tmp.put("p_query_date", new Date());
            tmp.put("p_business_book", requisition.getManagerBusinessBook());
            tmp.put("p_fin_branch_code", item.getBranchId());
            tmp.put("p_budget_center", item.getBudgetCenterCode());
            tmp.put("p_budget_subjects", bs);
            tmp.put("p_amount", item.getAmountWithTax());
            return tmp;
        }).collect(Collectors.toList());
        return this.sinolifeApiService.bepBudgetCheck(list);
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true, beforeInvocation=true)
    @Transactional(noRollbackFor={BudgetNotPassException.class})
    public List<PurchaseRequisitionHead> approve(List<PurchaseRequisitionHead> purchaseRequisitionList) {
        purchaseRequisitionList.forEach(purchaseRequisition -> {
            boolean pass = this.doCheck((PurchaseRequisitionHead)purchaseRequisition);
            if (!pass) {
                PurchaseRequisitionHead updateVO = new PurchaseRequisitionHead();
                updateVO.setId(purchaseRequisition.getId());
                updateVO.setApplyStatusCode(PurchaseRequisitionStatusEnum.BUDGET_NOT_PASS.code());
                updateVO.setApplyStatusDesc(PurchaseRequisitionStatusEnum.BUDGET_NOT_PASS.desc());
                updateVO.setUpdateTime(new Date());
                this.purchaseRequisitionHeadMapper.updateByPrimaryKeySelective(updateVO);
                throw new BudgetNotPassException("\u5355\u636e%s\u7684\u9884\u7b97\u672a\u901a\u8fc7\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279!", purchaseRequisition.getApplyNo());
            }
        });
        purchaseRequisitionList.forEach(purchaseRequisition -> {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("seq", purchaseRequisition.getId());
            paramMap.put("applySource", 3);
            paramMap.put("businessBook", purchaseRequisition.getManagerBusinessBook());
            paramMap.put("applyUseEmpId", purchaseRequisition.getInitiatorEmpId());
            paramMap.put("applyFinBranchCode", purchaseRequisition.getInitiatorCompanyCode());
            paramMap.put("applyDeptNo", purchaseRequisition.getInitiatorDeptCode());
            paramMap.put("applyUserPhone", purchaseRequisition.getInitiatorPhone());
            paramMap.put("responsibleUseEmpId", purchaseRequisition.getManagerEmpId());
            paramMap.put("responsibleFinBranchCode", purchaseRequisition.getManagerCompanyCode());
            paramMap.put("responsibleDeptNo", purchaseRequisition.getManagerDeptCode());
            paramMap.put("responsibleUserPhone", purchaseRequisition.getManagerPhone());
            paramMap.put("applyDate", purchaseRequisition.getApplyTime());
            paramMap.put("applyReason", purchaseRequisition.getApplyReason());
            paramMap.put("issuesDescription", purchaseRequisition.getRemark());
            paramMap.put("budgetCenter", purchaseRequisition.getBudgetCenterCode());
            paramMap.put("isScan", Integer.valueOf(1).equals(purchaseRequisition.getScan()) ? "Y" : "N");
            paramMap.put("projectCode", purchaseRequisition.getProjectCode());
            paramMap.put("amount", purchaseRequisition.getTotalMoney());
            paramMap.put("currency", purchaseRequisition.getCurrencyCode());
            ArrayList applyList = new ArrayList(purchaseRequisition.getPurchaseRequisitionItemList().size());
            LinkedList prepayList = new LinkedList();
            BigDecimal prepayTotalAmount = new BigDecimal(0, new MathContext(2));
            purchaseRequisition.getPurchaseRequisitionItemList().forEach(item -> {
                HashMap<String, Object> applyItem = new HashMap<String, Object>();
                applyItem.put("applySeq", item.getItemNo());
                applyItem.put("branchId", item.getBranchId());
                applyItem.put("budgetCenter", item.getBudgetCenterCode());
                applyItem.put("economicIssuesNo", item.getEconomicIssuesNo());
                applyItem.put("isDonation", Integer.valueOf(1).equals(item.getDonate()) ? "Y" : "N");
                applyItem.put("donationType", item.getDonationType());
                applyItem.put("applyAmount", item.getAmountWithTax());
                applyItem.put("summary", item.getApplyRemark());
                applyList.add(applyItem);
                if (Integer.valueOf(1).equals(item.getPrepay())) {
                    HashMap<String, Object> prepayItem = new HashMap<String, Object>();
                    prepayItem.put("lendSeq", item.getItemNo());
                    prepayItem.put("payeeNo", item.getSupCompanyCode());
                    prepayItem.put("economicIssuesNo", item.getEconomicIssuesNo());
                    prepayItem.put("applyAmount", item.getPrepayAmount());
                    prepayItem.put("paymentType", item.getPrepayType());
                    prepayItem.put("summary", item.getPrepayRemark());
                    BankAccountExample example = new BankAccountExample();
                    example.createCriteria().andCompanyIdEqualTo(item.getSupCompanyId()).andInvalidFlagEqualTo("N");
                    List bankAccountList = this.bankAccountService.queryAllObjByExample((IExample)example);
                    if (CollectionUtils.isNotEmpty((Collection)bankAccountList)) {
                        BankAccount bankAccount = (BankAccount)bankAccountList.get(0);
                        prepayItem.put("accountName", bankAccount.getAccountName());
                        prepayItem.put("accountNo", bankAccount.getAccountNo());
                        prepayItem.put("accountBank", bankAccount.getAccountBank());
                        prepayItem.put("accountBankNet", bankAccount.getBankNet());
                    }
                    prepayList.add(prepayItem);
                    prepayTotalAmount.add(item.getPrepayAmount());
                }
            });
            paramMap.put("isLendInExpenses", prepayList.isEmpty() ? "N" : "Y");
            paramMap.put("expensesDetailList", applyList);
            paramMap.put("lendApplyAmount", prepayTotalAmount);
            paramMap.put("lendApplyDetailList", prepayList);
            paramMap.put("applyNo", purchaseRequisition.getApplyNo());
            paramMap.put("listenerClass", this.getClass());
            Map result = this.sinolifeApiService.CreateExpensesApply(paramMap);
            if (!"Y".equals(result.get("flag"))) {
                throw new CommonException((String)result.get("message"));
            }
            PurchaseRequisitionHead updateVO = new PurchaseRequisitionHead();
            updateVO.setId(purchaseRequisition.getId());
            updateVO.setBepApplyNo((String)result.get("applyBepVoucherNo"));
            updateVO.setBepApplySn((String)result.get("expensesApplyNo"));
            updateVO.setBepApplyType((String)result.get("applyType"));
            updateVO.setBepPrepayNo((String)result.get("lendBepVoucherNo"));
            updateVO.setBepPrepaySn((String)result.get("lendApplyNo"));
            updateVO.setBepPrepayType((String)result.get("lendType"));
            updateVO.setApplyStatusCode(PurchaseRequisitionStatusEnum.AUDITING.code());
            updateVO.setApplyStatusDesc(PurchaseRequisitionStatusEnum.AUDITING.desc());
            updateVO.setUpdateTime(new Date());
            this.purchaseRequisitionHeadMapper.updateByPrimaryKeySelective(updateVO);
        });
        return purchaseRequisitionList;
    }

    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    @Transactional
    public void listen(TaskOperateEvent event) {
        if (event.isFinished()) {
            String purchaseRequisitionId = event.getBusinessId();
            Assert.isNotBlank((String)purchaseRequisitionId, (String)"\u91c7\u8d2d\u7533\u8bf7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            PurchaseRequisitionHead purchaseRequisition = this.queryObjById(purchaseRequisitionId);
            Assert.isNotNull((Object)purchaseRequisition, (String)"\u6839\u636e\u91c7\u8d2d\u7533\u8bf7ID\u67e5\u8be2\u51fa\u7684\u91c7\u8d2d\u7533\u8bf7\u4fe1\u606f\u4e3a\u7a7a");
            PurchaseRequisitionStatusEnum status = event.isPass() ? PurchaseRequisitionStatusEnum.APPROVED : PurchaseRequisitionStatusEnum.REJECTED;
            PurchaseRequisitionHead updateVO = new PurchaseRequisitionHead();
            updateVO.setId(purchaseRequisition.getId());
            updateVO.setApplyStatusCode(status.code());
            updateVO.setApplyStatusDesc(status.desc());
            updateVO.setUpdateTime(new Date());
            this.purchaseRequisitionHeadMapper.updateByPrimaryKeySelective(updateVO);
        }
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    @Transactional
    public List<PurchaseRequisitionHead> toOrder(List<PurchaseRequisitionHead> purchaseRequisitionList) {
        String projectId = ProjectUtils.getProjectId();
        Company currentCompnay = CompanyUtils.currentCompany();
        User loginUser = SpringSecurityUtils.getLoginUser();
        purchaseRequisitionList.forEach(purchaseRequisition -> {
            PurchaseOrder order = new PurchaseOrder();
            order.setProjectId(projectId);
            order.setPurchaseApplyNo(purchaseRequisition.getApplyNo());
            Company supCompany = (Company)this.companyService.queryObjById((Object)purchaseRequisition.getSupCompanyId());
            order.setSupCompanyId(supCompany.getId());
            order.setSupCompanyName(supCompany.getCompanyFullName());
            order.setSupCompanyShortName(supCompany.getCompanyName());
            order.setSupCompanySrmCode(supCompany.getCompanyCode());
            User supUser = this.companyUserRefService.queryMainUserOfCompany(supCompany.getId());
            order.setSupUserId(supUser.getId());
            order.setSupUserName(supUser.getNickName());
            List contacts = this.contactsService.queryAllContacts(supCompany.getId());
            if (CollectionUtils.isNotEmpty((Collection)contacts)) {
                order.setSupplierPerson(((Contacts)contacts.get(0)).getName());
                order.setSupplierTel(((Contacts)contacts.get(0)).getMobilePhone());
                order.setSupplierFax(((Contacts)contacts.get(0)).getFax());
            }
            order.setPurPlanerId(purchaseRequisition.getManagerId());
            order.setPurPlanerName(purchaseRequisition.getManagerName());
            order.setAccountCode(purchaseRequisition.getManagerBusinessBook());
            order.setAccountSetId(purchaseRequisition.getManagerAccountSetId());
            order.setAccountSetName(purchaseRequisition.getManagerAccountSetName());
            order.setInstitutionsId(purchaseRequisition.getManagerCompanyCode());
            order.setInstitutionsName(purchaseRequisition.getManagerCompanyName());
            order.setInTheOrganizationId(purchaseRequisition.getManagerOrganizationId());
            order.setInTheOrganizationName(purchaseRequisition.getManagerOrganizationName());
            order.setDepartId(purchaseRequisition.getManagerDeptCode());
            order.setDepartName(purchaseRequisition.getManagerDeptName());
            order.setCurrency(purchaseRequisition.getCurrencyCode());
            order.setContractNumber(purchaseRequisition.getContractNo());
            List<PurchaseRequisitionItem> priList = purchaseRequisition.getPurchaseRequisitionItemList();
            ArrayList<PurchaseOrderItem> poiList = new ArrayList<PurchaseOrderItem>(priList.size());
            for (PurchaseRequisitionItem pri : priList) {
                PurchaseOrderItem poi = new PurchaseOrderItem();
                poi.setProjectId(projectId);
                poi.setSupCompanyId(pri.getSupCompanyId());
                poi.setSupCompanySrmCode(pri.getSupCompanyCode());
                poi.setSupCompanyName(pri.getSupCompanyName());
                poi.setSupUserId(supUser.getId());
                poi.setSupUserName(supUser.getNickName());
                Material material = this.materialService.queryObjByCode(pri.getMaterialCode());
                poi.setMaterialCategoryId(material.getCategoryId());
                poi.setMaterialCategoryName(material.getMaterialCategoryDesc());
                poi.setMaterialId(material.getId());
                poi.setMaterialCode(material.getMaterialCode());
                poi.setMaterialName(material.getDescription());
                poi.setQuantity(new BigDecimal(pri.getDemandAmount()));
                poi.setPriceUnit(null);
                poi.setOrderUnit(material.getBasicUnit());
                poi.setWarehouseCode(pri.getStoreId());
                poi.setWarehouseName(pri.getStoreName());
                poi.setCurrency(purchaseRequisition.getCurrencyCode());
                poi.setOrderStatus(Integer.valueOf(1));
                poi.setPurReqNo(purchaseRequisition.getApplyNo());
                poi.setPurReqItemNo(String.valueOf(pri.getItemNo()));
                poi.setOrderItemNo(String.valueOf(pri.getItemNo()));
                BigDecimal up = pri.getUnitPrice();
                BigDecimal total = up.multiply(new BigDecimal(pri.getDemandAmount()), new MathContext(2));
                poi.setTaxUnitPrice(up);
                poi.setTaxTotalPrice(total);
                poi.setTotalPrice(total);
                poi.setBudgetCore(pri.getBudgetCenterCode());
                poi.setBudgetCoreDesc(pri.getBudgetCenterName());
                poi.setEconomicMatters(pri.getEconomicIssuesNo());
                poi.setEconomicMattersDesc(pri.getEconomicIssuesDesc());
                poi.setUses(Integer.toString(pri.getDonate()));
                poiList.add(poi);
            }
            order.setItems(poiList);
            String orderNo = this.purchaseOrderService.createPurOrder(order, currentCompnay, loginUser);
            purchaseRequisition.setTransformedNo(orderNo);
            purchaseRequisition.setApplyStatusCode(PurchaseRequisitionStatusEnum.ORDER_TRANSFORMED.code());
            purchaseRequisition.setApplyStatusDesc(PurchaseRequisitionStatusEnum.ORDER_TRANSFORMED.desc());
            this.purchaseRequisitionHeadMapper.updateByPrimaryKey((PurchaseRequisitionHead)purchaseRequisition);
        });
        return purchaseRequisitionList;
    }

    @Override
    public List<PurchaseRequisitionHead> toQuotation(List<PurchaseRequisitionHead> purchaseRequisitionList) {
        return null;
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    @Transactional
    public List<PurchaseRequisitionHead> toBidding(List<PurchaseRequisitionHead> purchaseRequisitionList) {
        String projectId = ProjectUtils.getProjectId();
        Company currentCompnay = CompanyUtils.currentCompany();
        User currentUser = SpringSecurityUtils.getLoginUser();
        purchaseRequisitionList.forEach(purchaseRequisition -> {
            BiddingBaseVo bidding = new BiddingBaseVo();
            BiddingHeader biddingHeader = new BiddingHeader();
            biddingHeader.setPurCompanyId(currentCompnay.getId());
            biddingHeader.setPurCompanyCode(currentCompnay.getCompanyCode());
            biddingHeader.setPurCompanyName(currentCompnay.getCompanyFullName());
            biddingHeader.setPurUserId(purchaseRequisition.getManagerId());
            biddingHeader.setPurUserName(purchaseRequisition.getManagerName());
            biddingHeader.setBiddingName("\u91c7\u8d2d\u9700\u6c42\u8f6c\u62db\u6295\u6807(" + purchaseRequisition.getApplyNo() + ")");
            biddingHeader.setBiddingType(purchaseRequisition.getBargainType() == 2 ? "0" : "1");
            biddingHeader.setBiddingAmount(purchaseRequisition.getTotalMoney().toString());
            biddingHeader.setBiddingCurrency(purchaseRequisition.getCurrencyCode());
            biddingHeader.setBiddingSendBidder("0");
            biddingHeader.setPurUserId(purchaseRequisition.getManagerId());
            biddingHeader.setPurUserName(purchaseRequisition.getManagerName());
            biddingHeader.setAccountCode(purchaseRequisition.getManagerBusinessBook());
            biddingHeader.setAccountSetId(purchaseRequisition.getManagerAccountSetId());
            biddingHeader.setAccountSetName(purchaseRequisition.getManagerAccountSetName());
            biddingHeader.setInstitutionsId(purchaseRequisition.getManagerCompanyCode());
            biddingHeader.setInstitutionsName(purchaseRequisition.getManagerCompanyName());
            biddingHeader.setInTheOrganizationId(purchaseRequisition.getManagerOrganizationId());
            biddingHeader.setInTheOrganizationName(purchaseRequisition.getManagerOrganizationName());
            biddingHeader.setDepartId(purchaseRequisition.getManagerDeptCode());
            biddingHeader.setDepartName(purchaseRequisition.getManagerDeptName());
            BiddingPower biddingPower = new BiddingPower();
            biddingPower.setBiddingTendererPower("0");
            biddingHeader.setBiddingPower(biddingPower);
            BiddingMatterExample example = new BiddingMatterExample();
            example.setPageView(new PageView(1, 1));
            PageView biddingMatterPage = this.biddingMatterService.queryObjByPage((IExample)example);
            if (biddingMatterPage != null && CollectionUtils.isNotEmpty((Collection)biddingMatterPage.getQueryResult())) {
                BiddingMatter biddingMatter = (BiddingMatter)biddingMatterPage.getQueryResult().get(0);
                biddingHeader.setBiddingMatterId(biddingMatter.getId());
                biddingHeader.setBiddingMatterName(biddingMatter.getBiddingMatterName());
            }
            BiddingContent biddingContent = new BiddingContent();
            biddingContent.setProjectId(projectId);
            biddingContent.setPurCompanyId(currentCompnay.getId());
            biddingContent.setPurCompanySrmCode(currentCompnay.getCompanyCode());
            biddingContent.setPurCompanyName(currentCompnay.getCompanyFullName());
            biddingContent.setPurUserId(purchaseRequisition.getManagerId());
            biddingContent.setPurUserName(purchaseRequisition.getManagerName());
            List<PurchaseRequisitionItem> itemList = purchaseRequisition.getPurchaseRequisitionItemList();
            ArrayList<BiddingContentMatter> matterList = new ArrayList<BiddingContentMatter>(itemList.size());
            for (PurchaseRequisitionItem item : itemList) {
                BiddingContentMatter matter = new BiddingContentMatter();
                matter.setProjectId(projectId);
                matter.setProjectId(projectId);
                matter.setPurCompanyId(currentCompnay.getId());
                matter.setPurCompanySrmCode(currentCompnay.getCompanyCode());
                matter.setPurCompanyName(currentCompnay.getCompanyFullName());
                matter.setPurUserId(purchaseRequisition.getManagerId());
                matter.setPurUserName(purchaseRequisition.getManagerName());
                matter.setCreateTime(new Date());
                Material material = this.materialService.queryObjByCode(item.getMaterialCode());
                matter.setMaterialNo(material.getMaterialCode());
                matter.setMaterialDesc(material.getDescription());
                matter.setMaterialName(material.getMaterialName());
                matter.setMaterialSpec(material.getMaterialSpecification());
                matter.setMaterialFeatures(material.getBrandName());
                matter.setUnit(material.getBasicUnit());
                matter.setDosage(Long.valueOf(item.getDemandAmount().intValue()));
                matter.setCurrency(purchaseRequisition.getCurrencyCode());
                matter.setQuotationMethod("1");
                matterList.add(matter);
            }
            biddingContent.setBiddingContentMatterList(matterList);
            bidding.setCompany(CompanyUtils.currentCompany());
            bidding.setUser(currentUser);
            bidding.setBiddingHeader(biddingHeader);
            bidding.setBiddingContent(biddingContent);
            this.biddingHeaderService.biddingFromPurchaseRequisition(bidding);
            purchaseRequisition.setTransformedNo(biddingHeader.getBiddingNo());
            purchaseRequisition.setApplyStatusCode(PurchaseRequisitionStatusEnum.BIDDING_TRANSFORMED.code());
            purchaseRequisition.setApplyStatusDesc(PurchaseRequisitionStatusEnum.BIDDING_TRANSFORMED.desc());
            this.purchaseRequisitionHeadMapper.updateByPrimaryKey((PurchaseRequisitionHead)purchaseRequisition);
        });
        return purchaseRequisitionList;
    }
}

