/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.web.controller;

import com.alibaba.druid.util.lang.Consumer;
import com.els.base.company.utils.RoleCheckUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.purchase.entity.PurchaseRequisitionHead;
import com.els.base.purchase.entity.PurchaseRequisitionHeadExample;
import com.els.base.purchase.entity.PurchaseRequisitionItem;
import com.els.base.purchase.entity.PurchaseRequisitionItemExample;
import com.els.base.purchase.enumerate.PurchaseBarginTypeEnum;
import com.els.base.purchase.enumerate.PurchaseRequisitionStatusEnum;
import com.els.base.purchase.service.PurchaseRequisitionHeadService;
import com.els.base.purchase.service.PurchaseRequisitionItemService;
import com.els.base.purchase.util.PurchaseBargainTypeCheckUtils;
import com.els.base.purchase.util.PurchaseRequisitionStatusCheckUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u91c7\u8d2d\u7533\u8bf7\u5934")
@Controller
@RequestMapping(value={"purchaseRequisition"})
public class PurchaseRequisitionHeadController {
    @Resource
    protected PurchaseRequisitionHeadService purchaseRequisitionHeadService;
    @Resource
    protected PurchaseRequisitionItemService purchaseRequisitionItemService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u91c7\u8d2d\u7533\u8bf7\u5934")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody PurchaseRequisitionHead purchaseRequisitionHead) {
        RoleCheckUtils.requireRole((String)"CGJBR");
        this.validate(purchaseRequisitionHead, false, null);
        this.purchaseRequisitionHeadService.addObj(purchaseRequisitionHead);
        return ResponseResult.success((Object)purchaseRequisitionHead.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u91c7\u8d2d\u7533\u8bf7\u5934")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody PurchaseRequisitionHead purchaseRequisitionHead) {
        RoleCheckUtils.requireRole((String)"CGJBR");
        Consumer statusChecker = pr -> PurchaseRequisitionStatusCheckUtils.requireAny(pr.getApplyStatusCode(), "\u4fee\u6539", PurchaseRequisitionStatusEnum.NEW, PurchaseRequisitionStatusEnum.BUDGET_PASS, PurchaseRequisitionStatusEnum.BUDGET_NOT_PASS, PurchaseRequisitionStatusEnum.REJECTED);
        this.validate(purchaseRequisitionHead, true, (Consumer<PurchaseRequisitionHead>)statusChecker);
        this.purchaseRequisitionHeadService.modifyObj(purchaseRequisitionHead);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u91c7\u8d2d\u7533\u8bf7\u5934")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        RoleCheckUtils.requireRole((String)"CGJBR");
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.createCriteria().andIdIn((List)ids);
        List prList = this.purchaseRequisitionHeadService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)prList)) {
            throw new CommonException("\u8981\u5220\u9664\u7684\u5355\u636e\u4e0d\u5b58\u5728");
        }
        prList.forEach(pr -> PurchaseRequisitionStatusCheckUtils.require(pr.getApplyStatusCode(), PurchaseRequisitionStatusEnum.NEW, "\u5220\u9664"));
        this.purchaseRequisitionHeadService.deleteByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u5934")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseRequisitionHead", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseRequisitionHead>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.setPageView((PageView<PurchaseRequisitionHead>)new PageView(pageNo, pageSize));
        example.setOrderByClause("COALESCE(UPDATE_TIME, CREATE_TIME) DESC");
        example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purchaseRequisitionHeadService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u6839\u636eid\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u5355")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<PurchaseRequisitionHead> findById(@RequestParam(required=false) String id) {
        Assert.isNotNull((Object)id, (String)"\u7533\u8bf7ID\u4e0d\u80fd\u4e3a\u7a7a!");
        PurchaseRequisitionHead head = (PurchaseRequisitionHead)this.purchaseRequisitionHeadService.queryObjById(id);
        Assert.isNotNull((Object)head, (String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u4e0d\u5b58\u5728!");
        PurchaseRequisitionItemExample example = new PurchaseRequisitionItemExample();
        example.createCriteria().andHeadIdEqualTo(id);
        List itemList = this.purchaseRequisitionItemService.queryAllObjByExample((IExample)example);
        head.setPurchaseRequisitionItemList(itemList);
        return ResponseResult.success((Object)head);
    }

    @ApiOperation(httpMethod="POST", value="\u9884\u7b97\u6821\u9a8c")
    @RequestMapping(value={"service/budgetCheck"})
    @ResponseBody
    public ResponseResult<PurchaseRequisitionHead> budgetCheck(String id) {
        Assert.isNotBlank((String)id, (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a!");
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHead purchaseRequisition = (PurchaseRequisitionHead)this.purchaseRequisitionHeadService.queryObjById(id);
        PurchaseRequisitionStatusCheckUtils.require(purchaseRequisition.getApplyStatusCode(), PurchaseRequisitionStatusEnum.NEW, "\u9884\u7b97\u6821\u9a8c");
        this.checkOutLine(purchaseRequisition);
        this.checkMaterial(purchaseRequisition);
        ArrayList<PurchaseRequisitionHead> purchaseRequisitionList = new ArrayList<PurchaseRequisitionHead>(1);
        purchaseRequisitionList.add(purchaseRequisition);
        this.purchaseRequisitionHeadService.budgetCheck(purchaseRequisitionList);
        return ResponseResult.success((Object)purchaseRequisition);
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u9884\u7b97\u6821\u9a8c")
    @RequestMapping(value={"service/batchBudgetCheck"})
    @ResponseBody
    public ResponseResult<List<PurchaseRequisitionHead>> batchBudgetCheck(@RequestBody(required=false) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5355\u636eID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.createCriteria().andIdIn((List)ids);
        List prList = this.purchaseRequisitionHeadService.queryAllObjByExample((IExample)example);
        prList.forEach(purchaseRequisition -> PurchaseRequisitionStatusCheckUtils.require(purchaseRequisition.getApplyStatusCode(), PurchaseRequisitionStatusEnum.NEW, "\u9884\u7b97\u6821\u9a8c"));
        prList.forEach(pr -> {
            this.checkOutLine((PurchaseRequisitionHead)pr);
            this.checkMaterial((PurchaseRequisitionHead)pr);
        });
        this.purchaseRequisitionHeadService.budgetCheck(prList);
        return ResponseResult.success((Object)prList);
    }

    private void checkMaterial(PurchaseRequisitionHead purchaseRequisition) {
        purchaseRequisition.getPurchaseRequisitionItemList().forEach(item -> {
            if (!Integer.valueOf(1).equals(item.getMaterialExist())) {
                throw new CommonException("\u6709\u7269\u6599\u4e0d\u5b58\u5728,\u8bf7\u5148\u7ef4\u62a4\u7269\u6599\u4e3b\u6570\u636e");
            }
            Assert.isNotNull((Object)item.getDemandAmount(), (String)"\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u4fee\u6539\u9700\u6c42\u6570\u91cf");
            Assert.isNotNull((Object)item.getUnitPrice(), (String)"\u91c7\u8d2d\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u4fee\u6539\u91c7\u8d2d\u5355\u4ef7");
            Assert.isNotNull((Object)item.getStoreId(), (String)"\u5e93\u5b58\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u4fee\u6539\u5e93\u5b58\u5730\u70b9");
        });
    }

    @ApiOperation(httpMethod="POST", value="\u63d0\u4ea4\u5ba1\u6279")
    @RequestMapping(value={"service/approve"})
    @ResponseBody
    public ResponseResult<PurchaseRequisitionHead> approve(String id) {
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHead purchaseRequisition = (PurchaseRequisitionHead)this.purchaseRequisitionHeadService.queryObjById(id);
        PurchaseRequisitionStatusCheckUtils.require(purchaseRequisition.getApplyStatusCode(), PurchaseRequisitionStatusEnum.BUDGET_PASS, "\u63d0\u4ea4\u5ba1\u6279");
        this.checkOutLine(purchaseRequisition);
        ArrayList<PurchaseRequisitionHead> purchaseRequisitionList = new ArrayList<PurchaseRequisitionHead>(1);
        purchaseRequisitionList.add(purchaseRequisition);
        this.purchaseRequisitionHeadService.approve(purchaseRequisitionList);
        return ResponseResult.success((Object)purchaseRequisition);
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u63d0\u4ea4\u5ba1\u6279")
    @RequestMapping(value={"service/batchApprove"})
    @ResponseBody
    public ResponseResult<List<PurchaseRequisitionHead>> batchApprove(@RequestBody(required=false) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5355\u636eID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.createCriteria().andIdIn((List)ids);
        List prList = this.purchaseRequisitionHeadService.queryAllObjByExample((IExample)example);
        prList.forEach(purchaseRequisition -> PurchaseRequisitionStatusCheckUtils.require(purchaseRequisition.getApplyStatusCode(), PurchaseRequisitionStatusEnum.BUDGET_PASS, "\u63d0\u4ea4\u5ba1\u6279"));
        prList.forEach(this::checkOutLine);
        this.purchaseRequisitionHeadService.approve(prList);
        return ResponseResult.success((Object)prList);
    }

    @ApiOperation(httpMethod="POST", value="\u8f6c\u8ba2\u5355")
    @RequestMapping(value={"service/toOrder"})
    @ResponseBody
    public ResponseResult<PurchaseRequisitionHead> toOrder(String id) {
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHead purchaseRequisition = (PurchaseRequisitionHead)this.purchaseRequisitionHeadService.queryObjById(id);
        PurchaseRequisitionStatusCheckUtils.require(purchaseRequisition.getApplyStatusCode(), PurchaseRequisitionStatusEnum.APPROVED, "\u8f6c\u8ba2\u5355");
        PurchaseBargainTypeCheckUtils.require(purchaseRequisition.getBargainType(), PurchaseBarginTypeEnum.NULL, "\u8f6c\u8ba2\u5355");
        this.checkOutLine(purchaseRequisition);
        ArrayList<PurchaseRequisitionHead> purchaseRequisitionList = new ArrayList<PurchaseRequisitionHead>(1);
        purchaseRequisitionList.add(purchaseRequisition);
        this.purchaseRequisitionHeadService.toOrder(purchaseRequisitionList);
        return ResponseResult.success((Object)purchaseRequisition);
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u8f6c\u8ba2\u5355")
    @RequestMapping(value={"service/batchToOrder"})
    @ResponseBody
    public ResponseResult<List<PurchaseRequisitionHead>> batchToOrder(@RequestBody(required=false) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5355\u636eID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.createCriteria().andIdIn((List)ids);
        List prList = this.purchaseRequisitionHeadService.queryAllObjByExample((IExample)example);
        prList.forEach(purchaseRequisition -> {
            PurchaseRequisitionStatusCheckUtils.require(purchaseRequisition.getApplyStatusCode(), PurchaseRequisitionStatusEnum.APPROVED, "\u8f6c\u8ba2\u5355");
            PurchaseBargainTypeCheckUtils.require(purchaseRequisition.getBargainType(), PurchaseBarginTypeEnum.NULL, "\u8f6c\u8ba2\u5355");
        });
        prList.forEach(this::checkOutLine);
        this.purchaseRequisitionHeadService.toOrder(prList);
        return ResponseResult.success((Object)prList);
    }

    @ApiOperation(httpMethod="POST", value="\u8f6c\u8be2\u4ef7\u5355")
    @RequestMapping(value={"service/toQuotation"})
    @ResponseBody
    public ResponseResult<PurchaseRequisitionHead> toQuotation(String id) {
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHead purchaseRequisition = (PurchaseRequisitionHead)this.purchaseRequisitionHeadService.queryObjById(id);
        PurchaseRequisitionStatusCheckUtils.require(purchaseRequisition.getApplyStatusCode(), PurchaseRequisitionStatusEnum.APPROVED, "\u8f6c\u8be2\u4ef7\u5355");
        PurchaseBargainTypeCheckUtils.require(purchaseRequisition.getBargainType(), PurchaseBarginTypeEnum.QUOTATION, "\u8f6c\u8be2\u4ef7\u5355");
        this.checkOutLine(purchaseRequisition);
        ArrayList<PurchaseRequisitionHead> purchaseRequisitionList = new ArrayList<PurchaseRequisitionHead>(1);
        purchaseRequisitionList.add(purchaseRequisition);
        this.purchaseRequisitionHeadService.toQuotation(purchaseRequisitionList);
        return ResponseResult.success((Object)purchaseRequisition);
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u8f6c\u8be2\u4ef7\u5355")
    @RequestMapping(value={"service/batchToQuotation"})
    @ResponseBody
    public ResponseResult<List<PurchaseRequisitionHead>> batchToQuotation(@RequestBody(required=false) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5355\u636eID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.createCriteria().andIdIn((List)ids);
        List prList = this.purchaseRequisitionHeadService.queryAllObjByExample((IExample)example);
        prList.forEach(purchaseRequisition -> {
            PurchaseRequisitionStatusCheckUtils.require(purchaseRequisition.getApplyStatusCode(), PurchaseRequisitionStatusEnum.APPROVED, "\u8f6c\u8be2\u4ef7\u5355");
            PurchaseBargainTypeCheckUtils.require(purchaseRequisition.getBargainType(), PurchaseBarginTypeEnum.QUOTATION, "\u8f6c\u8be2\u4ef7\u5355");
        });
        prList.forEach(this::checkOutLine);
        this.purchaseRequisitionHeadService.toQuotation(prList);
        return ResponseResult.success((Object)prList);
    }

    @ApiOperation(httpMethod="POST", value="\u8f6c\u62db\u6807\u5355")
    @RequestMapping(value={"service/toBidding"})
    @ResponseBody
    public ResponseResult<PurchaseRequisitionHead> toBidding(String id) {
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHead purchaseRequisition = (PurchaseRequisitionHead)this.purchaseRequisitionHeadService.queryObjById(id);
        PurchaseRequisitionStatusCheckUtils.require(purchaseRequisition.getApplyStatusCode(), PurchaseRequisitionStatusEnum.APPROVED, "\u8f6c\u62db\u6807\u5355");
        PurchaseBargainTypeCheckUtils.requireAny(purchaseRequisition.getBargainType(), "\u8f6c\u62db\u6807\u5355", PurchaseBarginTypeEnum.INVITE_BIDDING, PurchaseBarginTypeEnum.PUBLIC_BIDDING);
        this.checkOutLine(purchaseRequisition);
        ArrayList<PurchaseRequisitionHead> purchaseRequisitionList = new ArrayList<PurchaseRequisitionHead>(1);
        purchaseRequisitionList.add(purchaseRequisition);
        this.purchaseRequisitionHeadService.toBidding(purchaseRequisitionList);
        return ResponseResult.success((Object)purchaseRequisition);
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u8f6c\u62db\u6807\u5355")
    @RequestMapping(value={"service/batchToBidding"})
    @ResponseBody
    public ResponseResult<List<PurchaseRequisitionHead>> batchToBidding(@RequestBody(required=false) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5355\u636eID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.createCriteria().andIdIn((List)ids);
        List prList = this.purchaseRequisitionHeadService.queryAllObjByExample((IExample)example);
        prList.forEach(purchaseRequisition -> {
            PurchaseRequisitionStatusCheckUtils.require(purchaseRequisition.getApplyStatusCode(), PurchaseRequisitionStatusEnum.APPROVED, "\u8f6c\u62db\u6807\u5355");
            PurchaseBargainTypeCheckUtils.requireAny(purchaseRequisition.getBargainType(), "\u8f6c\u62db\u6807\u5355", PurchaseBarginTypeEnum.INVITE_BIDDING, PurchaseBarginTypeEnum.PUBLIC_BIDDING);
        });
        prList.forEach(this::checkOutLine);
        this.purchaseRequisitionHeadService.toBidding(prList);
        return ResponseResult.success((Object)prList);
    }

    private void checkOutLine(PurchaseRequisitionHead purchaseRequisition) {
        PurchaseRequisitionItemExample example = new PurchaseRequisitionItemExample();
        example.createCriteria().andHeadIdEqualTo(purchaseRequisition.getId());
        List itemList = this.purchaseRequisitionItemService.queryAllObjByExample((IExample)example);
        purchaseRequisition.setPurchaseRequisitionItemList(itemList);
    }

    private void validate(PurchaseRequisitionHead purchaseRequisition, boolean checkId, Consumer<PurchaseRequisitionHead> statusChecker) {
        Assert.isNotNull((Object)purchaseRequisition, (String)"\u91c7\u8d2d\u7533\u8bf7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(purchaseRequisition.getPurchaseRequisitionItemList(), (String)"\u91c7\u8d2d\u7533\u8bf7\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        if (checkId) {
            Assert.isNotBlank((String)purchaseRequisition.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        if (statusChecker != null) {
            PurchaseRequisitionHead pr = (PurchaseRequisitionHead)this.purchaseRequisitionHeadService.queryObjById(purchaseRequisition.getId());
            statusChecker.accept((Object)pr);
        }
        Assert.isNotBlank((String)purchaseRequisition.getInitiatorId(), (String)"\u53d1\u8d77\u4eba\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseRequisition.getInitiatorPhone(), (String)"\u53d1\u8d77\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseRequisition.getInitiatorDeptCode(), (String)"\u53d1\u8d77\u4eba\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseRequisition.getInitiatorCompanyCode(), (String)"\u53d1\u8d77\u4eba\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseRequisition.getManagerId(), (String)"\u8d23\u4efb\u4eba\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseRequisition.getManagerPhone(), (String)"\u8d23\u4efb\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseRequisition.getManagerDeptCode(), (String)"\u8d23\u4efb\u4eba\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseRequisition.getManagerCompanyCode(), (String)"\u8d23\u4efb\u4eba\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseRequisition.getSupCompanyCode(), (String)"\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseRequisition.getBudgetCenterCode(), (String)"\u9884\u7b97\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseRequisition.getIssuesCategoryCode(), (String)"\u652f\u51fa\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseRequisition.getIssuesClassCode(), (String)"\u652f\u51fa\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseRequisition.getCurrencyCode(), (String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a");
        for (PurchaseRequisitionItem item : purchaseRequisition.getPurchaseRequisitionItemList()) {
            Assert.isNotBlank((String)item.getBranchId(), (String)"\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getBudgetCenterCode(), (String)"\u9884\u7b97\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getEconomicIssuesNo(), (String)"\u7ecf\u6d4e\u4e8b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

