/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.dao.PurchaseRequisitionItemMapper;
import com.els.base.purchase.entity.PurchaseRequisitionItem;
import com.els.base.purchase.entity.PurchaseRequisitionItemExample;
import com.els.base.purchase.service.PurchaseRequisitionItemService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurchaseRequisitionItemService")
public class PurchaseRequisitionItemServiceImpl
implements PurchaseRequisitionItemService {
    @Resource
    protected PurchaseRequisitionItemMapper purchaseRequisitionItemMapper;

    @CacheEvict(value={"purchaseRequisitionItem"}, allEntries=true)
    public void addObj(PurchaseRequisitionItem t) {
        this.purchaseRequisitionItemMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purchaseRequisitionItem"}, allEntries=true)
    public void addAll(List<PurchaseRequisitionItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseRequisitionItemMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseRequisitionItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseRequisitionItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseRequisitionItem"}, allEntries=true)
    public void deleteByExample(PurchaseRequisitionItemExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseRequisitionItemMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseRequisitionItem"}, allEntries=true)
    public void modifyObj(PurchaseRequisitionItem t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purchaseRequisitionItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseRequisitionItem"}, keyGenerator="redisKeyGenerator")
    public PurchaseRequisitionItem queryObjById(String id) {
        return this.purchaseRequisitionItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseRequisitionItem"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseRequisitionItem> queryAllObjByExample(PurchaseRequisitionItemExample example) {
        return this.purchaseRequisitionItemMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseRequisitionItem"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseRequisitionItem> queryObjByPage(PurchaseRequisitionItemExample example) {
        PageView<PurchaseRequisitionItem> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseRequisitionItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public int updateByPrimaryKeySelective(PurchaseRequisitionItem item) {
        return this.purchaseRequisitionItemMapper.updateByPrimaryKeySelective(item);
    }
}

