/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command;

import cn.hutool.json.JSONUtil;
import com.els.base.certification.contacts.entity.Contacts;
import com.els.base.certification.contacts.service.ContactsService;
import com.els.base.company.entity.Company;
import com.els.base.company.functional.BigDecimalFunction;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.ObjectHolder;
import com.els.base.company.utils.Objects;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.Material;
import com.els.base.material.service.MaterialService;
import com.els.base.product.entity.PurchaseProduct;
import com.els.base.product.entity.PurchaseProductExample;
import com.els.base.product.entity.PurchaseUserOrderItemExt;
import com.els.base.product.entity.PurchaseUserOrderItemExtExample;
import com.els.base.product.service.PurchaseProductService;
import com.els.base.product.service.PurchaseUserOrderItemExtService;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseRequisitionHead;
import com.els.base.purchase.entity.PurchaseRequisitionItem;
import com.els.base.purchase.entity.SubmitJd;
import com.els.base.purchase.enumerate.PurchaseRequisitionStatusEnum;
import com.els.base.purchase.service.OrderBudgetHandleService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.service.PurchaseRequisitionHeadService;
import com.els.base.purchase.service.PurchaseRequisitionItemService;
import com.els.base.purchase.vo.PurchaseRequisitionEventVO;
import com.els.base.utils.SpringContextHolder;
import com.els.jd.entity.JingdongGoodsEntityInfo;
import com.els.jd.entity.JingdongGoodsEntityInfoExample;
import com.els.jd.service.JdApiService;
import com.els.jd.service.JingdongGoodsEntityInfoService;
import com.els.jd.vo.JdGoodsEntityResultVO;
import com.els.jd.vo.JdSellPriceResultVO;
import com.els.jd.vo.SubmintOrderResultVO;
import com.els.jd.vo.order.request.SubmitOrderRequest;
import com.els.sinolifesdk.service.SinoLifeApiService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

public class JdOrderCommand
extends BaseCommand<String> {
    private static final long serialVersionUID = 1L;
    private MaterialService materialService = (MaterialService)SpringContextHolder.getOneBean(MaterialService.class);
    private PurchaseProductService purchaseProductService = (PurchaseProductService)SpringContextHolder.getOneBean(PurchaseProductService.class);
    private CompanyService companyService = (CompanyService)SpringContextHolder.getOneBean(CompanyService.class);
    private CompanyUserRefService companyUserRefService = (CompanyUserRefService)SpringContextHolder.getOneBean(CompanyUserRefService.class);
    private ContactsService contactsService = (ContactsService)SpringContextHolder.getOneBean(ContactsService.class);
    private JingdongGoodsEntityInfoService jingdongGoodsEntityInfoService = (JingdongGoodsEntityInfoService)SpringContextHolder.getOneBean(JingdongGoodsEntityInfoService.class);
    private JdApiService jdApiService = (JdApiService)SpringContextHolder.getOneBean(JdApiService.class);
    private PurchaseOrderService purchaseOrderService = (PurchaseOrderService)SpringContextHolder.getOneBean(PurchaseOrderService.class);
    private PurchaseRequisitionItemService purchaseRequisitionItemService = (PurchaseRequisitionItemService)SpringContextHolder.getOneBean(PurchaseRequisitionItemService.class);
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private SinoLifeApiService sinolifeApiService = (SinoLifeApiService)SpringContextHolder.getOneBean(SinoLifeApiService.class);
    private PurchaseUserOrderItemExtService purchaseUserOrderItemExtService = (PurchaseUserOrderItemExtService)SpringContextHolder.getOneBean(PurchaseUserOrderItemExtService.class);
    private OrderBudgetHandleService orderBudgetHandleService = (OrderBudgetHandleService)SpringContextHolder.getOneBean(OrderBudgetHandleService.class);
    private PurchaseRequisitionHeadService purchaseRequisitionHeadService = (PurchaseRequisitionHeadService)SpringContextHolder.getOneBean(PurchaseRequisitionHeadService.class);
    private PurchaseRequisitionEventVO purchaseRequisitionEventVO;

    public JdOrderCommand() {
    }

    public JdOrderCommand(PurchaseRequisitionEventVO purchaseRequisitionEventVO) {
        this.purchaseRequisitionEventVO = purchaseRequisitionEventVO;
    }

    @Transactional
    public String execute(ICommandInvoker iCommandInvoker) {
        this.logger.debug("\u8fdb\u5165JdOrderCommand\u7c7bexecute\u65b9\u6cd5");
        this.logger.info("\u83b7\u53d6\u91c7\u8d2d\u7533\u8bf7\u4fe1\u606f");
        PurchaseRequisitionHead purchaseRequisitionHead = this.purchaseRequisitionEventVO.getPurchaseRequisitionHead();
        this.logger.info("\u68c0\u67e5\u91c7\u8d2d\u7533\u8bf7\u5934\u662f\u5426\u4e3a\u7a7a");
        this.check(purchaseRequisitionHead);
        this.logger.info("\u68c0\u67e5\u91c7\u8d2d\u7533\u8bf7\u884c\u662f\u5426\u4e3a\u7a7a");
        this.checkPurchaseRequisitionItem(purchaseRequisitionHead);
        this.logger.info("\u4eac\u4e1c\u4e0b\u5355");
        this.toProcessOrder(purchaseRequisitionHead);
        return null;
    }

    private void toProcessOrder(PurchaseRequisitionHead purchaseRequisition) {
        List<PurchaseRequisitionItem> prItemList = purchaseRequisition.getPurchaseRequisitionItemList();
        Map<String, List<PurchaseRequisitionItem>> prItemGroupMap = this.purchaseRequisitionItemService.groupingByConsigneeInfo(prItemList);
        if (MapUtils.isEmpty(prItemGroupMap)) {
            this.logger.info("\u6839\u636e\u6536\u8d27\u4eba\u4fe1\u606f\u5206\u7ec4\u540e\u7684map\u4e3a\u7a7a");
            return;
        }
        ObjectHolder satisfied = ObjectHolder.of((Object)true);
        prItemGroupMap.forEach((key, itemList) -> {
            if (CollectionUtils.isNotEmpty((Collection)itemList)) {
                itemList.stream().forEach(item -> {
                    JdSellPriceResultVO resultVO = this.jdApiService.getProductSellPrice(item.getProductCodeWx());
                    boolean priceSatisfied = this.priceCheck((PurchaseRequisitionItem)item, resultVO);
                    JdGoodsEntityResultVO jdGoodsEntity = this.jdApiService.getJDGoodsEntity(item.getProductCodeWx());
                    boolean stateSatisfied = this.checkSkuState((PurchaseRequisitionItem)item, jdGoodsEntity);
                    satisfied.value = priceSatisfied && stateSatisfied;
                });
            }
        });
        if (!((Boolean)satisfied.value).booleanValue()) {
            this.purchaseRequisitionItemService.calcFreight(prItemList);
            prItemList.stream().forEach(this.purchaseRequisitionItemService::updateByPrimaryKeySelective);
            BigDecimal totalMoney = this.purchaseRequisitionHeadService.calcTotalMoney(purchaseRequisition);
            ObjectHolder marketTotalPrice = ObjectHolder.of((Object)BigDecimal.ZERO);
            prItemList.stream().forEach(item -> {
                if (item.getMarketPrice() != null) {
                    marketTotalPrice.value = ((BigDecimal)marketTotalPrice.value).add(item.getMarketPrice());
                }
                if (item.getFreight() != null) {
                    marketTotalPrice.value = ((BigDecimal)marketTotalPrice.value).add(item.getFreight());
                }
            });
            this.logger.info("\u4fee\u6539\u7533\u8bf7\u603b\u91d1\u989d\u3001\u5e02\u4ef7\u603b\u91d1\u989d\u548c\u72b6\u6001");
            this.purchaseRequisitionHeadService.updateApplyStatus(purchaseRequisition, PurchaseRequisitionStatusEnum.ADJUSTMENT_REQUIRED, pr -> {
                pr.setTotalMoney(totalMoney);
                pr.setMarketTotalPrice((BigDecimal)marketTotalPrice.value);
            });
            this.logger.info("\u4fee\u6539\u7533\u8bf7\u603b\u91d1\u989d\u3001\u5e02\u4ef7\u603b\u91d1\u989d\u548c\u72b6\u6001\u7ed3\u675f");
            return;
        }
        this.logger.info("\u4ef7\u683c\u6ca1\u95ee\u9898\u5c31\u4e0b\u5355");
        ArrayList orderResults = new ArrayList();
        PurchaseOrder order = this.initSubmitOrderHead(purchaseRequisition);
        prItemGroupMap.forEach((key, itemList) -> {
            String orderResult = this.fillSubmitOrderItem((List<PurchaseRequisitionItem>)itemList, order, purchaseRequisition);
            orderResults.add(orderResult);
        });
        PurchaseRequisitionStatusEnum applyStatus = orderResults.contains("0") ? PurchaseRequisitionStatusEnum.ADJUSTMENT_REQUIRED : PurchaseRequisitionStatusEnum.ORDER_TRANSFORMED;
        this.logger.info("\u66f4\u65b0\u91c7\u8d2d\u7533\u8bf7\u5355\u72b6\u6001\u4e3a{}", (Object)applyStatus.desc());
        this.purchaseRequisitionHeadService.updateApplyStatus(purchaseRequisition, applyStatus, pr -> {
            if (!orderResults.contains("0")) {
                pr.setTransformedType("O");
            }
        });
        try {
            this.orderBudgetHandleService.ordering(purchaseRequisition);
            if (!orderResults.contains("0") && orderResults.size() > 0) {
                this.purchaseRequisitionHeadService.prepay(purchaseRequisition);
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528bep\u9884\u7b97\u5904\u7406/\u9884\u4ed8\u63a5\u53e3\u5931\u8d25", (Throwable)e);
            try {
                this.purchaseRequisitionHeadService.updateApplyStatus(purchaseRequisition, PurchaseRequisitionStatusEnum.PREPAY_FAILED, pr -> pr.setPrepayStatus(3));
            }
            catch (Exception e2) {
                this.logger.error("\u66f4\u65b0\u91c7\u8d2d\u7533\u8bf7\u9884\u4ed8\u5931\u8d25\u72b6\u6001\u5931\u8d25", (Throwable)e2);
            }
        }
    }

    private boolean checkSkuState(PurchaseRequisitionItem item, JdGoodsEntityResultVO jdGoodsEntity) {
        boolean result = true;
        if ("N".equals(jdGoodsEntity.getState()) || Constant.NO_INT.equals(jdGoodsEntity.getSkuState())) {
            result = false;
            String orderErrorReason = StringUtils.isNotBlank((String)item.getOrderEorrReason()) ? String.format("%s,%s", item.getOrderEorrReason(), "\u5546\u54c1\u5df2\u4e0b\u67b6\u6216\u65e0\u6548") : "\u5546\u54c1\u5df2\u4e0b\u67b6\u6216\u65e0\u6548";
            this.purchaseRequisitionItemService.update(item, it -> it.setOrderEorrReason(orderErrorReason));
            PurchaseProductExample example = new PurchaseProductExample();
            example.createCriteria().andProductCodeWxEqualTo(item.getProductCodeWx());
            PurchaseProduct purchaseProduct = new PurchaseProduct();
            purchaseProduct.setPutwayStatus(Constant.NO_INT);
            this.purchaseProductService.updateByExampleSelective(purchaseProduct, example);
            JingdongGoodsEntityInfoExample infpExample = new JingdongGoodsEntityInfoExample();
            infpExample.createCriteria().andSkuEqualTo(item.getProductCodeWx());
            JingdongGoodsEntityInfo temp = new JingdongGoodsEntityInfo();
            temp.setState(jdGoodsEntity.getState());
            temp.setSkuState(jdGoodsEntity.getSkuState());
            this.jingdongGoodsEntityInfoService.updateByExampleSelective(temp, infpExample);
        }
        return result;
    }

    private boolean priceCheck(PurchaseRequisitionItem item, JdSellPriceResultVO resultVO) {
        boolean result = true;
        BigDecimal price = resultVO.getPrice();
        if (price.compareTo(item.getUnitPrice()) != 0) {
            result = false;
            BigDecimal demandAmount = new BigDecimal(item.getDemandAmount());
            BigDecimal amountWithTax = (BigDecimal)BigDecimalFunction.MULTIPLY.apply(price, demandAmount);
            BigDecimal preUnitPrice = item.getUnitPrice();
            this.purchaseRequisitionItemService.update(item, it -> {
                it.setPreUnitPrice(preUnitPrice);
                it.setUnitPrice(price);
                it.setAmountWithTax(amountWithTax);
                it.setOrderEorrReason("\u4ef7\u683c\u4e0d\u4e00\u81f4");
            });
        }
        return result;
    }

    private String fillSubmitOrderItem(List<PurchaseRequisitionItem> purchaseRequisitionItemList, PurchaseOrder order, PurchaseRequisitionHead head) {
        ArrayList<SubmitJd> submitJdList = new ArrayList<SubmitJd>();
        ArrayList<PurchaseOrderItem> orderItemList = new ArrayList<PurchaseOrderItem>();
        String orderStatus = null;
        BigDecimal orderMoney = BigDecimal.ZERO;
        for (PurchaseRequisitionItem item2 : purchaseRequisitionItemList) {
            SubmitJd submitJd = new SubmitJd();
            submitJd.setSkuId(Long.parseLong(item2.getProductCodeWx()));
            submitJd.setPrice(item2.getUnitPrice());
            submitJd.setNum(new BigDecimal(item2.getDemandAmount()));
            submitJd.setbNeedGift(false);
            submitJdList.add(submitJd);
            PurchaseOrderItem orderItem = new PurchaseOrderItem();
            orderItem.setProjectId(head.getProjectId());
            orderItem.setSupCompanyId(item2.getSupCompanyId());
            orderItem.setSupCompanySrmCode(item2.getSupCompanyCode());
            orderItem.setSupCompanyName(item2.getSupCompanyName());
            orderItem.setSupUserId(order.getSupUserId());
            orderItem.setSupUserName(order.getSupUserName());
            orderItem.setProductCode(item2.getProductCode());
            orderItem.setProductCodeWx(item2.getProductCodeWx());
            Material material = this.materialService.queryObjByCode(item2.getMaterialCode());
            orderItem.setMaterialCategoryName(material.getMaterialSpecification());
            orderItem.setMaterialId(material.getId());
            orderItem.setMaterialCode(material.getMaterialCode());
            orderItem.setMaterialName(material.getDescription());
            orderItem.setQuantity(new BigDecimal(item2.getDemandAmount()));
            orderItem.setPriceUnit(null);
            orderItem.setOrderUnit(material.getBasicUnit());
            orderItem.setWarehouseCode(item2.getStoreId());
            orderItem.setWarehouseName(item2.getStoreName());
            orderItem.setCurrency(head.getCurrencyCode());
            orderItem.setDeliveryLocation(item2.getDeliveryAddress());
            orderItem.setConsignee(item2.getConsignee());
            orderItem.setConsigneeId(item2.getConsigneeId());
            orderItem.setPurchasePhone(item2.getPurchasePhone());
            orderItem.setFreight(item2.getFreight());
            orderItem.setOrderStatus(Integer.valueOf(1));
            orderItem.setPurReqNo(head.getApplyNo());
            orderItem.setPurReqItemNo(String.valueOf(item2.getItemNo()));
            orderItem.setOrderItemNo(String.valueOf(item2.getItemNo()));
            BigDecimal up = item2.getUnitPrice();
            BigDecimal total = up.multiply(new BigDecimal(item2.getDemandAmount())).setScale(2, 4);
            orderMoney = Optional.ofNullable(item2.getFreight()).orElse(BigDecimal.ZERO).add(total).add(orderMoney);
            orderItem.setTaxUnitPrice(up);
            orderItem.setTaxTotalPrice(total);
            orderItem.setTotalPrice(total);
            orderItem.setBudgetCore(item2.getBudgetCenterCode());
            orderItem.setBudgetCoreDesc(item2.getBudgetCenterName());
            orderItem.setEconomicMatters(item2.getEconomicIssuesNo());
            orderItem.setEconomicMattersDesc(item2.getEconomicIssuesDesc());
            if (item2.getDonate() != null) {
                orderItem.setUses(Integer.toString(item2.getDonate()));
            }
            orderStatus = item2.getOrderStatus();
            orderItemList.add(orderItem);
        }
        order.setTaxTotalPrice(orderMoney);
        order.setOrderTotal(orderMoney);
        order.setItems(orderItemList);
        Company currentCompnay = this.purchaseRequisitionEventVO.getCompany();
        User loginUser = new User();
        loginUser.setId(head.getInitiatorId());
        loginUser.setNickName(head.getInitiatorName());
        if (!"1".equals(orderStatus)) {
            try {
                SubmintOrderResultVO submintOrderResultVO = this.submitToJD(purchaseRequisitionItemList, submitJdList);
                if (submintOrderResultVO.getSuccess().booleanValue()) {
                    this.logger.info("\u8c03\u7528\u786e\u8ba4\u9884\u5360\u5e93\u5b58\u63a5\u53e3");
                    this.jdApiService.getConfirmOrder(submintOrderResultVO.getJdOrderId().toString());
                    order.setId(null);
                    order.setShopOrderNo(submintOrderResultVO.getJdOrderId().toString());
                    this.logger.info("\u521b\u5efa\u91c7\u8d2d\u8ba2\u5355\u6570\u636e: {}", (Object)order);
                    String orderNo = this.purchaseOrderService.createPurOrder(order, currentCompnay, loginUser);
                    this.logger.info("\u91c7\u8d2d\u8ba2\u5355\u521b\u5efa\u6210\u529f,\u5355\u53f7 {}", (Object)orderNo);
                    purchaseRequisitionItemList.stream().forEach(item -> this.purchaseRequisitionItemService.update((PurchaseRequisitionItem)item, it -> {
                        it.setOrderStatus("1");
                        it.setOrderNoWx(Objects.toString((Object)submintOrderResultVO.getJdOrderId(), (String)"---"));
                        it.setPurOrderNo(order.getOrderNo());
                        it.setPurOrderingDate(new Date());
                    }));
                    return "1";
                }
                throw new CommonException(submintOrderResultVO.getEorrlogger());
            }
            catch (Exception e) {
                purchaseRequisitionItemList.stream().forEach(item -> this.purchaseRequisitionItemService.update((PurchaseRequisitionItem)item, it -> {
                    it.setOrderEorrReason(e.getMessage());
                    it.setOrderStatus("0");
                }));
                return "0";
            }
        }
        return "1";
    }

    private PurchaseOrder initSubmitOrderHead(PurchaseRequisitionHead head) {
        PurchaseOrder order = new PurchaseOrder();
        String projectId = this.purchaseRequisitionEventVO.getProjectId();
        User loginUser = new User();
        loginUser.setId(head.getInitiatorId());
        loginUser.setNickName(head.getInitiatorName());
        order.setProjectId(projectId);
        order.setPurchaseApplyNo(head.getApplyNo());
        order.setBepVoucherNo(head.getBepApplyNo());
        order.setExpensesApplyNo(head.getBepApplySn());
        Company supCompany = (Company)this.companyService.queryObjById((Object)head.getSupCompanyId());
        order.setSupCompanyId(supCompany.getId());
        order.setSupCompanyName(supCompany.getCompanyFullName());
        order.setSupCompanyShortName(supCompany.getCompanyName());
        order.setSupCompanySrmCode(supCompany.getCompanyCode());
        User supUser = this.companyUserRefService.queryMainUserOfCompany(supCompany.getId());
        order.setSupUserId(supUser.getId());
        order.setSupUserName(supUser.getNickName());
        List contacts = this.contactsService.queryAllContacts(supCompany.getId());
        if (CollectionUtils.isNotEmpty((Collection)contacts)) {
            order.setSupplierPerson(((Contacts)contacts.get(0)).getName());
            order.setSupplierTel(((Contacts)contacts.get(0)).getMobilePhone());
            order.setSupplierFax(((Contacts)contacts.get(0)).getFax());
        }
        order.setPurPlanerId(loginUser.getId());
        order.setPurPlanerName(loginUser.getNickName());
        order.setAccountCode(head.getInitiatorBusinessBook());
        order.setAccountSetId(head.getInitiatorAccountSetId());
        order.setAccountSetName(head.getInitiatorAccountSetName());
        order.setInstitutionsId(head.getInitiatorCompanyCode());
        order.setInstitutionsName(head.getInitiatorCompanyName());
        order.setInTheOrganizationId(head.getInitiatorOrganizationId());
        order.setInTheOrganizationName(head.getInitiatorOrganizationName());
        order.setDepartId(head.getInitiatorDeptCode());
        order.setDepartName(head.getInitiatorDeptName());
        order.setCurrency(head.getCurrencyCode());
        order.setContractNumber(head.getContractNo());
        order.setDataSource(head.getDataSource());
        return order;
    }

    private void check(PurchaseRequisitionHead purchaseRequisitionHead) {
        if (ObjectUtils.isEmpty((Object)purchaseRequisitionHead)) {
            throw new CommonException("\u91c7\u8d2d\u7533\u8bf7\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)purchaseRequisitionHead.getId())) {
            throw new CommonException("\u91c7\u8d2d\u7533\u8bf7\u5934ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void checkPurchaseRequisitionItem(PurchaseRequisitionHead purchaseRequisitionHead) {
        if (CollectionUtils.isEmpty(purchaseRequisitionHead.getPurchaseRequisitionItemList())) {
            throw new CommonException("\u91c7\u8d2d\u7533\u8bf7\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    private SubmintOrderResultVO submitToJD(List<PurchaseRequisitionItem> priList, List<SubmitJd> jds) {
        SubmitOrderRequest jdOrderSubmitVO = new SubmitOrderRequest();
        jdOrderSubmitVO.setThirdOrder(priList.get(0).getId() + "_" + priList.size());
        jdOrderSubmitVO.setSku(StringEscapeUtils.unescapeJavaScript((String)JSONUtil.toJsonStr(jds)));
        jdOrderSubmitVO.setName(priList.get(0).getConsignee());
        PurchaseUserOrderItemExtExample extExample = new PurchaseUserOrderItemExtExample();
        extExample.createCriteria().andOrderNoEqualTo(priList.get(0).getProductCode());
        List extList = this.purchaseUserOrderItemExtService.queryAllObjByExample((IExample)extExample);
        PurchaseUserOrderItemExt itemExt = (PurchaseUserOrderItemExt)extList.get(0);
        jdOrderSubmitVO.setProvince(Integer.valueOf(Integer.parseInt(priList.get(0).getProvinceId())));
        jdOrderSubmitVO.setCity(Integer.valueOf(Integer.parseInt(priList.get(0).getCityId())));
        jdOrderSubmitVO.setCounty(Integer.valueOf(Integer.parseInt(priList.get(0).getCountyId())));
        jdOrderSubmitVO.setTown(Integer.valueOf(priList.get(0).getTownId() != null ? Integer.parseInt(priList.get(0).getTownId()) : 0));
        jdOrderSubmitVO.setAddress(priList.get(0).getDeliveryAddress());
        jdOrderSubmitVO.setMobile(priList.get(0).getPurchasePhone());
        jdOrderSubmitVO.setEmail(itemExt.getEmail());
        jdOrderSubmitVO.setInvoiceState(Integer.valueOf(2));
        jdOrderSubmitVO.setInvoiceType(Integer.valueOf(2));
        jdOrderSubmitVO.setSelectedInvoiceTitle(Integer.valueOf(5));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("branchCode", priList.get(0).getBranchId());
        this.logger.info("\u8c03\u7528VMS\u4ea4\u4e92\u53d1\u7968\u4fe1\u606f:" + ((Object)map).toString());
        Map vmsMap = this.sinolifeApiService.queryTaxpayerInfo(map);
        this.logger.info("\u8c03\u7528VMS\u8fd4\u56de\u7ed3\u679c:" + vmsMap.toString());
        jdOrderSubmitVO.setCompanyName((String)vmsMap.get("taxpayerName"));
        jdOrderSubmitVO.setInvoiceContent(Integer.valueOf(1));
        jdOrderSubmitVO.setPaymentType(Integer.valueOf(5));
        jdOrderSubmitVO.setIsUseBalance(Integer.valueOf(0));
        jdOrderSubmitVO.setSubmitState(Integer.valueOf(0));
        jdOrderSubmitVO.setInvoicePhone(itemExt.getRecMobile());
        jdOrderSubmitVO.setInvoiceProvice(Integer.valueOf(Integer.parseInt(itemExt.getProvinceId())));
        jdOrderSubmitVO.setInvoiceCity(Integer.valueOf(Integer.parseInt(itemExt.getCityId())));
        jdOrderSubmitVO.setInvoiceCounty(Integer.valueOf(Integer.parseInt(itemExt.getCountyId())));
        jdOrderSubmitVO.setInvoiceAddress(priList.get(0).getDeliveryAddress());
        jdOrderSubmitVO.setRegCompanyName((String)vmsMap.get("taxpayerName"));
        jdOrderSubmitVO.setRegCode((String)vmsMap.get("taxPayerCode"));
        jdOrderSubmitVO.setRegAddr((String)vmsMap.get("registeredAddress"));
        jdOrderSubmitVO.setRegPhone("075523833526");
        jdOrderSubmitVO.setRegBank((String)vmsMap.get("bankName"));
        jdOrderSubmitVO.setRegBankAccount((String)vmsMap.get("bankAccount"));
        SubmintOrderResultVO submitOrder = this.jdApiService.submitOrder(jdOrderSubmitVO);
        return submitOrder;
    }
}

