/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.company.functional.BigDecimalFunction;
import com.els.base.company.utils.ObjectHolder;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.dao.PurchaseRequisitionItemMapper;
import com.els.base.purchase.entity.PurchaseRequisitionItem;
import com.els.base.purchase.entity.PurchaseRequisitionItemExample;
import com.els.base.purchase.service.PurchaseRequisitionItemService;
import com.els.base.purchase.vo.SkuNumberVO;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.jd.service.JdApiService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurchaseRequisitionItemService")
public class PurchaseRequisitionItemServiceImpl
implements PurchaseRequisitionItemService {
    @Resource
    protected PurchaseRequisitionItemMapper purchaseRequisitionItemMapper;
    @Resource
    private JdApiService jdApiService;

    @CacheEvict(value={"purchaseRequisitionItem"}, allEntries=true)
    public void addObj(PurchaseRequisitionItem t) {
        this.purchaseRequisitionItemMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purchaseRequisitionItem"}, allEntries=true)
    public void addAll(List<PurchaseRequisitionItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseRequisitionItemMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseRequisitionItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseRequisitionItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseRequisitionItem"}, allEntries=true)
    public void deleteByExample(PurchaseRequisitionItemExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseRequisitionItemMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseRequisitionItem"}, allEntries=true)
    public void modifyObj(PurchaseRequisitionItem t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purchaseRequisitionItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseRequisitionItem"}, keyGenerator="redisKeyGenerator")
    public PurchaseRequisitionItem queryObjById(String id) {
        return this.purchaseRequisitionItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseRequisitionItem"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseRequisitionItem> queryAllObjByExample(PurchaseRequisitionItemExample example) {
        return this.purchaseRequisitionItemMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseRequisitionItem"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseRequisitionItem> queryObjByPage(PurchaseRequisitionItemExample example) {
        PageView<PurchaseRequisitionItem> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseRequisitionItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionItem"}, allEntries=true)
    public int updateByPrimaryKeySelective(PurchaseRequisitionItem item) {
        return this.purchaseRequisitionItemMapper.updateByPrimaryKeySelective(item);
    }

    @Override
    public List<PurchaseRequisitionItem> calcFreight(List<PurchaseRequisitionItem> itemList) {
        BinaryOperator adder = BigDecimalFunction.ADD;
        BinaryOperator multiplyer = BigDecimalFunction.MULTIPLY;
        BinaryOperator subtracter = BigDecimalFunction.SUBTRACT;
        itemList.stream().forEach(item -> item.setFreight(BigDecimal.ZERO));
        List<PurchaseRequisitionItem> calculableItemList = itemList.stream().filter(this::calculable).collect(Collectors.toList());
        Map<String, List<PurchaseRequisitionItem>> tmpMap = this.groupingByConsigneeInfo(calculableItemList);
        tmpMap.forEach((key, list) -> {
            PurchaseRequisitionItem last = (PurchaseRequisitionItem)list.get(list.size() - 1);
            ArrayList skuNumberList = new ArrayList();
            list.stream().collect(Collectors.groupingBy(item -> item.getProductCodeWx())).forEach((skuId, tmpList) -> {
                Integer num = tmpList.stream().map(item -> item.getDemandAmount()).reduce((a, b) -> a + b).orElse(0);
                skuNumberList.add(SkuNumberVO.of(skuId, num));
            });
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("sku", "[" + StringUtils.join(skuNumberList, (char)',') + "]");
            paramMap.put("province", last.getProvinceId());
            paramMap.put("city", last.getCityId());
            paramMap.put("county", last.getCountyId());
            paramMap.put("town", last.getTownId());
            paramMap.put("paymentType", "5");
            BigDecimal freight = this.jdApiService.queryOrderFreight(paramMap);
            if (freight != null && freight.intValue() > 0) {
                if (list.size() == 1) {
                    last.setFreight(freight);
                } else {
                    list.stream().map(PurchaseRequisitionItem::getAmountWithTax).reduce(adder).ifPresent(total -> {
                        ObjectHolder accumulatorHolder = ObjectHolder.of((Object)BigDecimal.ZERO);
                        BigDecimal percent = freight.divide((BigDecimal)total, 10, RoundingMode.HALF_UP);
                        list.stream().forEach(item -> {
                            if (item != last) {
                                BigDecimal tmpFreight = (BigDecimal)multiplyer.apply(percent, item.getAmountWithTax());
                                item.setFreight(tmpFreight);
                                accumulatorHolder.value = adder.apply(accumulatorHolder.value, tmpFreight);
                            } else {
                                item.setFreight((BigDecimal)subtracter.apply(freight, accumulatorHolder.value));
                            }
                        });
                    });
                }
            }
        });
        return itemList;
    }

    private boolean calculable(PurchaseRequisitionItem item) {
        return StringUtils.isNotBlank((String)item.getMaterialCode()) && StringUtils.isNotBlank((String)item.getProductCodeWx()) && item.getDemandAmount() != null && item.getDemandAmount() > 0 && item.getUnitPrice() != null && item.getUnitPrice().doubleValue() > 0.0 && item.getAmountWithTax() != null && StringUtils.isNotBlank((String)item.getProvinceId()) && StringUtils.isNotBlank((String)item.getCityId()) && StringUtils.isNotBlank((String)item.getCountyId());
    }

    @Override
    @Transactional
    @CacheEvict(value={"purchaseRequisitionItem"}, allEntries=true)
    public int modifyByExample(PurchaseRequisitionItem purchaseRequisitionItem, PurchaseRequisitionItemExample exampleDel) {
        return this.purchaseRequisitionItemMapper.updateByExampleSelective(purchaseRequisitionItem, exampleDel);
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionItem"}, allEntries=true)
    public PurchaseRequisitionItem update(PurchaseRequisitionItem item, Consumer<PurchaseRequisitionItem> setter) {
        if (item == null || setter == null) {
            return null;
        }
        PurchaseRequisitionItem updateVO = new PurchaseRequisitionItem();
        updateVO.setId(item.getId());
        setter.accept(updateVO);
        setter.accept(item);
        this.updateByPrimaryKeySelective(updateVO);
        return item;
    }

    @Override
    public Map<String, List<PurchaseRequisitionItem>> groupingByConsigneeInfo(List<PurchaseRequisitionItem> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return Collections.emptyMap();
        }
        return itemList.stream().collect(Collectors.groupingBy(this::groupingBy));
    }

    private String groupingBy(PurchaseRequisitionItem item) {
        String townId = StringUtils.isBlank((String)item.getTownId()) ? "0" : item.getTownId();
        return String.format("%s-%s-%s-%s-%s-%s-%s-%s", item.getBranchId(), item.getProvinceId(), item.getCityId(), item.getCountyId(), townId, item.getDeliveryAddress(), item.getConsigneeId(), item.getPurchasePhone());
    }
}

