/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.product.vo.ProductOriginEnum;
import com.els.base.purchase.entity.PurchaseRequisitionHead;
import com.els.base.purchase.entity.PurchaseRequisitionHeadExample;
import com.els.base.purchase.enumerate.PurchaseRequisitionStatusEnum;
import com.els.base.purchase.event.JdOrderPassEvent;
import com.els.base.purchase.service.PurchaseRequisitionHeadService;
import com.els.base.purchase.vo.PurchaseRequisitionEventVO;
import com.els.sinolifesdk.service.ResultProcessService;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;

@Service
public class PurchaseRequisitionPrepayCallBackServiceImpl
implements ResultProcessService {
    private static final Logger logger = LoggerFactory.getLogger(PurchaseRequisitionPrepayCallBackServiceImpl.class);
    @Resource
    private PurchaseRequisitionHeadService service;
    @Resource
    private ApplicationContext applicationContext;

    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    public Map<String, Object> processResult(Map<String, Object> objectMap) throws Exception {
        String bepVoucherNo = (String)objectMap.get("bepVoucherNo");
        String transferResult = (String)objectMap.get("transferResult");
        String transferResultDesc = (String)objectMap.get("transferResultDesc");
        Date transferDate = (Date)objectMap.get("transferDate");
        Assert.isNotBlank((String)bepVoucherNo, (String)"bepVoucherNo\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)transferResult, (String)"transferResult\u4e0d\u80fd\u4e3a\u7a7a");
        if (!"1".equals(transferResult) && !"2".equals(transferResult)) {
            throw new CommonException("\u672a\u77e5\u7684\u9884\u4ed8\u7ed3\u679c:  " + transferResult + ", \u9884\u671f: 1-\u4ea4\u6613\u6210\u529f\uff0c2-\u4ea4\u6613\u5931\u8d25");
        }
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.or().andBepPrepayNoEqualTo(bepVoucherNo);
        List tmpList = this.service.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)tmpList)) {
            throw new CommonException("\u4e0d\u5b58\u5728bepVoucherNo(\u501f\u6b3e\u5355\u7f16\u53f7)=" + bepVoucherNo + "\u7684\u91c7\u8d2d\u7533\u8bf7\u5355");
        }
        PurchaseRequisitionHead requisition = (PurchaseRequisitionHead)tmpList.get(0);
        boolean succeeded = "1".equals(transferResult);
        PurchaseRequisitionStatusEnum status = succeeded ? PurchaseRequisitionStatusEnum.ORDER_TRANSFORMED : PurchaseRequisitionStatusEnum.PREPAY_FAILED;
        this.service.updateApplyStatus(requisition, status, pr -> {
            pr.setBepPrepayTransferDate(transferDate);
            pr.setBepPrepayTransferDesc(transferResultDesc);
            pr.setPrepayStatus(succeeded ? 2 : 3);
        });
        if (succeeded && ProductOriginEnum.isJD((String)requisition.getDataSource())) {
            try {
                this.service.checkOutDetailLine(requisition);
                PurchaseRequisitionEventVO eventVO = new PurchaseRequisitionEventVO();
                eventVO.setPurchaseRequisitionHead(requisition);
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.putAll(objectMap);
                eventVO.setResultMap(resultMap);
                JdOrderPassEvent event = new JdOrderPassEvent(eventVO);
                this.applicationContext.publishEvent((ApplicationEvent)event);
            }
            catch (Exception e) {
                logger.error("\u9884\u4ed8\u6210\u529f\u540e\u53d1\u9001\u90ae\u4ef6\u7ed9\u4eac\u4e1c\u51fa\u9519", (Throwable)e);
            }
        }
        return null;
    }
}

