/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.entity.PurchaseRequisitionHead;
import com.els.base.purchase.entity.PurchaseRequisitionHeadExample;
import com.els.base.purchase.entity.PurchaseRequisitionItemExample;
import com.els.base.purchase.service.PurchaseRequisitionHeadService;
import com.els.base.purchase.service.PurchaseRequisitionItemService;
import com.els.sinolifesdk.service.ResultProcessService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Service;

@Service
public class PurchaseRequisitionQueryServiceImpl
implements ResultProcessService {
    @Resource
    private PurchaseRequisitionHeadService purchaseRequisitionHeadService;
    @Resource
    protected PurchaseRequisitionItemService purchaseRequisitionItemService;

    public Map<String, Object> processResult(Map<String, Object> objectMap) throws Exception {
        String bepApplyNo = (String)objectMap.get("expensesBepVoucher");
        Assert.isNotBlank((String)bepApplyNo, (String)"expensesBepVoucher\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap<String, Object> result = new HashMap<String, Object>();
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.createCriteria().andBepApplyNoEqualTo(bepApplyNo);
        List tmpList = this.purchaseRequisitionHeadService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)tmpList)) {
            throw new CommonException("\u4e0d\u5b58\u5728expensesBepVoucher=" + bepApplyNo + "\u7684\u91c7\u8d2d\u7533\u8bf7\u5355");
        }
        PurchaseRequisitionHead purchaseRequisition = (PurchaseRequisitionHead)tmpList.get(0);
        PurchaseRequisitionItemExample itemExample = new PurchaseRequisitionItemExample();
        itemExample.createCriteria().andHeadIdEqualTo(purchaseRequisition.getId());
        Optional.ofNullable(this.purchaseRequisitionItemService.queryAllObjByExample((IExample)itemExample)).ifPresent(itemList -> {
            List purchaseDetailMapList = itemList.stream().map(item -> {
                HashMap<String, Object> purchaseDetailMap = new HashMap<String, Object>();
                purchaseDetailMap.put("materialCode", item.getMaterialCode());
                purchaseDetailMap.put("materialName", item.getMaterialDesc());
                purchaseDetailMap.put("materialUnit", item.getUnit());
                purchaseDetailMap.put("quantity", item.getDemandAmount());
                purchaseDetailMap.put("price", item.getUnitPrice());
                purchaseDetailMap.put("freight", item.getFreight());
                purchaseDetailMap.put("amount", item.getAmountWithTax());
                purchaseDetailMap.put("payeeNo", item.getSupCompanyCode());
                purchaseDetailMap.put("payeeName", item.getSupCompanyName());
                return purchaseDetailMap;
            }).collect(Collectors.toList());
            result.put("purchaseDetailMapList", purchaseDetailMapList);
        });
        if (MapUtils.isEmpty(result)) {
            throw new CommonException("expensesBepVoucher=" + bepApplyNo + "\u7684\u91c7\u8d2d\u7533\u8bf7\u6ca1\u6709\u5bf9\u5e94\u7684\u884c\u9879\u76ee");
        }
        return result;
    }
}

