/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.web.controller;

import com.alibaba.druid.util.lang.Consumer;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.functional.BigDecimalFunction;
import com.els.base.company.service.DepartmentService;
import com.els.base.company.utils.ObjectHolder;
import com.els.base.company.utils.RoleCheckUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.product.vo.ProductOriginEnum;
import com.els.base.purchase.entity.PurchaseBargainConfig;
import com.els.base.purchase.entity.PurchaseRequisitionHead;
import com.els.base.purchase.entity.PurchaseRequisitionHeadExample;
import com.els.base.purchase.entity.PurchaseRequisitionItem;
import com.els.base.purchase.enumerate.PurchaseBarginTypeEnum;
import com.els.base.purchase.enumerate.PurchaseRequisitionStatusEnum;
import com.els.base.purchase.service.PurchaseBargainConfigService;
import com.els.base.purchase.service.PurchaseRequisitionFileService;
import com.els.base.purchase.service.PurchaseRequisitionHeadService;
import com.els.base.purchase.service.PurchaseRequisitionItemService;
import com.els.base.purchase.util.PurchaseBargainTypeCheckUtils;
import com.els.base.purchase.util.PurchaseRequisitionStatusCheckUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u91c7\u8d2d\u7533\u8bf7\u5934"})
@Controller
@RequestMapping(value={"purchaseRequisition"})
public class PurchaseRequisitionHeadController {
    @Resource
    protected PurchaseRequisitionHeadService purchaseRequisitionHeadService;
    @Resource
    protected PurchaseRequisitionItemService purchaseRequisitionItemService;
    @Resource
    protected PurchaseRequisitionFileService purchaseRequisitionFileService;
    @Resource
    protected PurchaseBargainConfigService purchaseBargainConfigService;
    @Resource
    protected DepartmentService departmentService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u91c7\u8d2d\u7533\u8bf7\u5934")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody PurchaseRequisitionHead purchaseRequisition) {
        RoleCheckUtils.requireRole((String)"CGJBR");
        this.validate(purchaseRequisition, false, null);
        this.calculate(purchaseRequisition);
        purchaseRequisition.setDataSource("0");
        this.purchaseRequisitionHeadService.addObj(purchaseRequisition);
        return ResponseResult.success((Object)purchaseRequisition.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u91c7\u8d2d\u7533\u8bf7\u5934")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody PurchaseRequisitionHead purchaseRequisition) {
        RoleCheckUtils.requireRole((String)"CGJBR");
        Consumer statusChecker = pr -> PurchaseRequisitionStatusCheckUtils.requireAny(pr.getApplyStatusCode(), "\u4fee\u6539", PurchaseRequisitionStatusEnum.NEW, PurchaseRequisitionStatusEnum.BUDGET_PASS, PurchaseRequisitionStatusEnum.BUDGET_NOT_PASS, PurchaseRequisitionStatusEnum.REJECTED);
        this.validate(purchaseRequisition, true, (Consumer<PurchaseRequisitionHead>)statusChecker);
        this.calculate(purchaseRequisition);
        this.purchaseRequisitionHeadService.modifyObj(purchaseRequisition);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u91c7\u8d2d\u7533\u8bf7\u5934")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        RoleCheckUtils.requireRole((String)"CGJBR");
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.createCriteria().andIdIn((List)ids);
        List prList = this.purchaseRequisitionHeadService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)prList)) {
            throw new CommonException("\u8981\u5220\u9664\u7684\u5355\u636e\u4e0d\u5b58\u5728");
        }
        prList.forEach(pr -> PurchaseRequisitionStatusCheckUtils.require(pr.getApplyStatusCode(), PurchaseRequisitionStatusEnum.NEW, "\u5220\u9664"));
        this.purchaseRequisitionHeadService.deleteByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u5934")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseRequisitionHead", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseRequisitionHead>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        String currentUserId = SpringSecurityUtils.getLoginUserId();
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.setPageView((PageView<PurchaseRequisitionHead>)new PageView(pageNo, pageSize));
        example.setOrderByClause("COALESCE(UPDATE_TIME, CREATE_TIME) DESC");
        example.or().andInitiatorIdEqualTo(currentUserId);
        example.or().andManagerIdEqualTo(currentUserId);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purchaseRequisitionHeadService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u6839\u636eid\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u5355")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<PurchaseRequisitionHead> findById(@RequestParam(required=false) String id) {
        Assert.isNotNull((Object)id, (String)"\u7533\u8bf7ID\u4e0d\u80fd\u4e3a\u7a7a!");
        PurchaseRequisitionHead purchaseRequisition = (PurchaseRequisitionHead)this.purchaseRequisitionHeadService.queryObjById(id);
        Assert.isNotNull((Object)purchaseRequisition, (String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u4e0d\u5b58\u5728!");
        this.checkOutLine(purchaseRequisition);
        if (ProductOriginEnum.JD.getValue().equals(purchaseRequisition.getDataSource())) {
            this.purchaseRequisitionHeadService.updateMarketPriceIfNecessary(purchaseRequisition, true);
        }
        return ResponseResult.success((Object)purchaseRequisition);
    }

    @ApiOperation(httpMethod="POST", value="\u9884\u7b97\u6821\u9a8c")
    @RequestMapping(value={"service/budgetCheck"})
    @ResponseBody
    public ResponseResult<PurchaseRequisitionHead> budgetCheck(@RequestParam(required=false) String id) {
        Assert.isNotBlank((String)id, (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a!");
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHead purchaseRequisition = (PurchaseRequisitionHead)this.purchaseRequisitionHeadService.queryObjById(id);
        PurchaseRequisitionStatusCheckUtils.requireAny(purchaseRequisition.getApplyStatusCode(), "\u9884\u7b97\u6821\u9a8c", PurchaseRequisitionStatusEnum.NEW, PurchaseRequisitionStatusEnum.BUDGET_NOT_PASS, PurchaseRequisitionStatusEnum.QUOTATION_FINISHED, PurchaseRequisitionStatusEnum.BIDDING_FINISHED);
        this.checkOutLine(purchaseRequisition);
        this.checkMaterial(purchaseRequisition);
        ArrayList<PurchaseRequisitionHead> purchaseRequisitionList = new ArrayList<PurchaseRequisitionHead>(1);
        purchaseRequisitionList.add(purchaseRequisition);
        this.purchaseRequisitionHeadService.budgetCheck(purchaseRequisitionList);
        return ResponseResult.success((Object)purchaseRequisition);
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u9884\u7b97\u6821\u9a8c")
    @RequestMapping(value={"service/batchBudgetCheck"})
    @ResponseBody
    public ResponseResult<List<PurchaseRequisitionHead>> batchBudgetCheck(@RequestBody(required=false) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5355\u636eID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.createCriteria().andIdIn((List)ids);
        List prList = this.purchaseRequisitionHeadService.queryAllObjByExample((IExample)example);
        prList.forEach(purchaseRequisition -> PurchaseRequisitionStatusCheckUtils.requireAny(purchaseRequisition.getApplyStatusCode(), "\u9884\u7b97\u6821\u9a8c", PurchaseRequisitionStatusEnum.NEW, PurchaseRequisitionStatusEnum.BUDGET_NOT_PASS, PurchaseRequisitionStatusEnum.QUOTATION_FINISHED, PurchaseRequisitionStatusEnum.BIDDING_FINISHED));
        prList.forEach(pr -> {
            this.checkOutLine((PurchaseRequisitionHead)pr);
            this.checkMaterial((PurchaseRequisitionHead)pr);
        });
        this.purchaseRequisitionHeadService.budgetCheck(prList);
        return ResponseResult.success((Object)prList);
    }

    private void checkMaterial(PurchaseRequisitionHead purchaseRequisition) {
        purchaseRequisition.getPurchaseRequisitionItemList().forEach(item -> {
            if (!Integer.valueOf(1).equals(item.getMaterialExist())) {
                throw new CommonException("\u6709\u7269\u6599\u4e0d\u5b58\u5728,\u8bf7\u5148\u7ef4\u62a4\u7269\u6599\u4e3b\u6570\u636e");
            }
            Assert.isNotNull((Object)item.getDemandAmount(), (String)"\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u4fee\u6539\u9700\u6c42\u6570\u91cf");
            Assert.isNotNull((Object)item.getUnitPrice(), (String)"\u91c7\u8d2d\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u4fee\u6539\u91c7\u8d2d\u5355\u4ef7");
        });
    }

    @ApiOperation(httpMethod="POST", value="\u63d0\u4ea4\u5ba1\u6279")
    @RequestMapping(value={"service/approve"})
    @ResponseBody
    public ResponseResult<PurchaseRequisitionHead> approve(@RequestParam(required=false) String id) {
        Assert.isNotBlank((String)id, (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a!");
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHead purchaseRequisition = (PurchaseRequisitionHead)this.purchaseRequisitionHeadService.queryObjById(id);
        PurchaseRequisitionStatusCheckUtils.require(purchaseRequisition.getApplyStatusCode(), PurchaseRequisitionStatusEnum.BUDGET_PASS, "\u63d0\u4ea4\u5ba1\u6279");
        if (Objects.equals(purchaseRequisition.getBargainType(), PurchaseBarginTypeEnum.QUOTATION.code()) && !"Q".equals(purchaseRequisition.getTransformedType())) {
            throw new CommonException("\u8bae\u4ef7\u65b9\u5f0f\u4e3a\u8be2\u62a5\u4ef7\u7684\u5355\u636e\u9700\u5b8c\u6210\u8be2\u62a5\u4ef7\u540e\u624d\u80fd\u63d0\u4ea4\u5ba1\u6279");
        }
        if ((Objects.equals(purchaseRequisition.getBargainType(), PurchaseBarginTypeEnum.INVITE_BIDDING.code()) || Objects.equals(purchaseRequisition.getBargainType(), PurchaseBarginTypeEnum.PUBLIC_BIDDING.code())) && !"B".equals(purchaseRequisition.getTransformedType())) {
            throw new CommonException("\u8bae\u4ef7\u65b9\u5f0f\u4e3a\u9080\u8bf7/\u516c\u5f00\u62db\u6807\u7684\u5355\u636e\u9700\u5b8c\u6210\u62db\u6295\u6807\u540e\u624d\u80fd\u63d0\u4ea4\u5ba1\u6279");
        }
        Assert.isNotNull((Object)purchaseRequisition.getSupCompanyId(), (String)"\u4f9b\u5e94\u5546\u4fe1\u606f\u4e3a\u7a7a,\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279");
        this.checkOutLine(purchaseRequisition);
        this.validate(purchaseRequisition, true, null);
        ArrayList<PurchaseRequisitionHead> purchaseRequisitionList = new ArrayList<PurchaseRequisitionHead>(1);
        purchaseRequisitionList.add(purchaseRequisition);
        this.purchaseRequisitionHeadService.approve(purchaseRequisitionList);
        return ResponseResult.success((Object)purchaseRequisition);
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u63d0\u4ea4\u5ba1\u6279")
    @RequestMapping(value={"service/batchApprove"})
    @ResponseBody
    public ResponseResult<List<PurchaseRequisitionHead>> batchApprove(@RequestBody(required=false) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5355\u636eID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.createCriteria().andIdIn((List)ids);
        List prList = this.purchaseRequisitionHeadService.queryAllObjByExample((IExample)example);
        prList.forEach(purchaseRequisition -> {
            PurchaseRequisitionStatusCheckUtils.require(purchaseRequisition.getApplyStatusCode(), PurchaseRequisitionStatusEnum.BUDGET_PASS, "\u63d0\u4ea4\u5ba1\u6279");
            if (Objects.equals(purchaseRequisition.getBargainType(), PurchaseBarginTypeEnum.QUOTATION.code()) && !"Q".equals(purchaseRequisition.getTransformedType())) {
                throw new CommonException("\u8bae\u4ef7\u65b9\u5f0f\u4e3a\u8be2\u62a5\u4ef7\u7684\u5355\u636e\u9700\u5b8c\u6210\u8be2\u62a5\u4ef7\u540e\u624d\u80fd\u63d0\u4ea4\u5ba1\u6279");
            }
            if ((Objects.equals(purchaseRequisition.getBargainType(), PurchaseBarginTypeEnum.INVITE_BIDDING.code()) || Objects.equals(purchaseRequisition.getBargainType(), PurchaseBarginTypeEnum.PUBLIC_BIDDING.code())) && !"B".equals(purchaseRequisition.getTransformedType())) {
                throw new CommonException("\u8bae\u4ef7\u65b9\u5f0f\u4e3a\u9080\u8bf7/\u516c\u5f00\u62db\u6807\u7684\u5355\u636e\u9700\u5b8c\u6210\u62db\u6295\u6807\u540e\u624d\u80fd\u63d0\u4ea4\u5ba1\u6279");
            }
        });
        prList.forEach(purchaseRequisition -> {
            this.checkOutLine((PurchaseRequisitionHead)purchaseRequisition);
            this.validate((PurchaseRequisitionHead)purchaseRequisition, true, null);
        });
        this.purchaseRequisitionHeadService.approve(prList);
        return ResponseResult.success((Object)prList);
    }

    @ApiOperation(httpMethod="POST", value="\u8f6c\u8ba2\u5355")
    @RequestMapping(value={"service/toOrder"})
    @ResponseBody
    public ResponseResult<PurchaseRequisitionHead> toOrder(@RequestParam(required=false) String id) {
        Assert.isNotBlank((String)id, (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a!");
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHead purchaseRequisition = (PurchaseRequisitionHead)this.purchaseRequisitionHeadService.queryObjById(id);
        PurchaseRequisitionStatusCheckUtils.require(purchaseRequisition.getApplyStatusCode(), PurchaseRequisitionStatusEnum.APPROVED, "\u8f6c\u8ba2\u5355");
        this.checkOutLine(purchaseRequisition);
        ArrayList<PurchaseRequisitionHead> purchaseRequisitionList = new ArrayList<PurchaseRequisitionHead>(1);
        purchaseRequisitionList.add(purchaseRequisition);
        this.purchaseRequisitionHeadService.toOrder(purchaseRequisitionList);
        return ResponseResult.success((Object)purchaseRequisition);
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u8f6c\u8ba2\u5355")
    @RequestMapping(value={"service/batchToOrder"})
    @ResponseBody
    public ResponseResult<List<PurchaseRequisitionHead>> batchToOrder(@RequestBody(required=false) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5355\u636eID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.createCriteria().andIdIn((List)ids);
        List prList = this.purchaseRequisitionHeadService.queryAllObjByExample((IExample)example);
        prList.forEach(purchaseRequisition -> PurchaseRequisitionStatusCheckUtils.require(purchaseRequisition.getApplyStatusCode(), PurchaseRequisitionStatusEnum.APPROVED, "\u8f6c\u8ba2\u5355"));
        prList.forEach(this::checkOutLine);
        this.purchaseRequisitionHeadService.toOrder(prList);
        return ResponseResult.success((Object)prList);
    }

    @ApiOperation(httpMethod="POST", value="\u8f6c\u8be2\u4ef7\u5355")
    @RequestMapping(value={"service/toQuotation"})
    @ResponseBody
    public ResponseResult<PurchaseRequisitionHead> toQuotation(@RequestParam(required=false) String id, @RequestParam(required=false) String templateId) {
        Assert.isNotBlank((String)id, (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)templateId, (String)"\u6a21\u7248ID\u4e0d\u80fd\u4e3a\u7a7a!");
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHead purchaseRequisition = (PurchaseRequisitionHead)this.purchaseRequisitionHeadService.queryObjById(id);
        PurchaseBargainTypeCheckUtils.require(purchaseRequisition.getBargainType(), PurchaseBarginTypeEnum.QUOTATION, "\u8f6c\u8be2\u4ef7\u5355");
        PurchaseRequisitionStatusCheckUtils.requireAny(purchaseRequisition.getApplyStatusCode(), "\u8f6c\u8be2\u4ef7\u5355", PurchaseRequisitionStatusEnum.NEW, PurchaseRequisitionStatusEnum.BUDGET_NOT_PASS, PurchaseRequisitionStatusEnum.BUDGET_PASS, PurchaseRequisitionStatusEnum.REJECTED);
        this.checkOutLine(purchaseRequisition);
        ArrayList<PurchaseRequisitionHead> purchaseRequisitionList = new ArrayList<PurchaseRequisitionHead>(1);
        purchaseRequisitionList.add(purchaseRequisition);
        this.purchaseRequisitionHeadService.toQuotation(purchaseRequisitionList, templateId);
        return ResponseResult.success((Object)purchaseRequisition);
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u8f6c\u8be2\u4ef7\u5355")
    @RequestMapping(value={"service/batchToQuotation"})
    @ResponseBody
    public ResponseResult<List<PurchaseRequisitionHead>> batchToQuotation(@RequestBody(required=false) List<String> ids, @RequestParam(required=false) String templateId) {
        Assert.isNotEmpty(ids, (String)"\u5355\u636eID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)templateId, (String)"\u6a21\u7248ID\u4e0d\u80fd\u4e3a\u7a7a!");
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.createCriteria().andIdIn((List)ids);
        List prList = this.purchaseRequisitionHeadService.queryAllObjByExample((IExample)example);
        prList.forEach(purchaseRequisition -> {
            PurchaseBargainTypeCheckUtils.require(purchaseRequisition.getBargainType(), PurchaseBarginTypeEnum.QUOTATION, "\u8f6c\u8be2\u4ef7\u5355");
            PurchaseRequisitionStatusCheckUtils.requireAny(purchaseRequisition.getApplyStatusCode(), "\u8f6c\u8be2\u4ef7\u5355", PurchaseRequisitionStatusEnum.NEW, PurchaseRequisitionStatusEnum.BUDGET_NOT_PASS, PurchaseRequisitionStatusEnum.BUDGET_PASS, PurchaseRequisitionStatusEnum.REJECTED);
        });
        prList.forEach(this::checkOutLine);
        this.purchaseRequisitionHeadService.toQuotation(prList, templateId);
        return ResponseResult.success((Object)prList);
    }

    @ApiOperation(httpMethod="POST", value="\u8f6c\u62db\u6807\u5355")
    @RequestMapping(value={"service/toBidding"})
    @ResponseBody
    public ResponseResult<PurchaseRequisitionHead> toBidding(@RequestParam(required=false) String id) {
        Assert.isNotBlank((String)id, (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a!");
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHead purchaseRequisition = (PurchaseRequisitionHead)this.purchaseRequisitionHeadService.queryObjById(id);
        PurchaseBargainTypeCheckUtils.requireAny(purchaseRequisition.getBargainType(), "\u8f6c\u62db\u6807\u5355", PurchaseBarginTypeEnum.INVITE_BIDDING, PurchaseBarginTypeEnum.PUBLIC_BIDDING);
        PurchaseRequisitionStatusCheckUtils.requireAny(purchaseRequisition.getApplyStatusCode(), "\u8f6c\u62db\u6807\u5355", PurchaseRequisitionStatusEnum.NEW, PurchaseRequisitionStatusEnum.BUDGET_NOT_PASS, PurchaseRequisitionStatusEnum.BUDGET_PASS, PurchaseRequisitionStatusEnum.REJECTED);
        this.checkOutLine(purchaseRequisition);
        ArrayList<PurchaseRequisitionHead> purchaseRequisitionList = new ArrayList<PurchaseRequisitionHead>(1);
        purchaseRequisitionList.add(purchaseRequisition);
        this.purchaseRequisitionHeadService.toBidding(purchaseRequisitionList);
        return ResponseResult.success((Object)purchaseRequisition);
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u8f6c\u62db\u6807\u5355")
    @RequestMapping(value={"service/batchToBidding"})
    @ResponseBody
    public ResponseResult<List<PurchaseRequisitionHead>> batchToBidding(@RequestBody(required=false) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5355\u636eID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.createCriteria().andIdIn((List)ids);
        List prList = this.purchaseRequisitionHeadService.queryAllObjByExample((IExample)example);
        prList.forEach(purchaseRequisition -> {
            PurchaseBargainTypeCheckUtils.requireAny(purchaseRequisition.getBargainType(), "\u8f6c\u62db\u6807\u5355", PurchaseBarginTypeEnum.INVITE_BIDDING, PurchaseBarginTypeEnum.PUBLIC_BIDDING);
            PurchaseRequisitionStatusCheckUtils.requireAny(purchaseRequisition.getApplyStatusCode(), "\u8f6c\u62db\u6807\u5355", PurchaseRequisitionStatusEnum.NEW, PurchaseRequisitionStatusEnum.BUDGET_NOT_PASS, PurchaseRequisitionStatusEnum.BUDGET_PASS, PurchaseRequisitionStatusEnum.REJECTED);
        });
        prList.forEach(this::checkOutLine);
        this.purchaseRequisitionHeadService.toBidding(prList);
        return ResponseResult.success((Object)prList);
    }

    @ApiOperation(httpMethod="POST", value="\u8ba1\u7b97\u8fd0\u8d39")
    @RequestMapping(value={"service/calcFreight"})
    @ResponseBody
    public ResponseResult<List<PurchaseRequisitionItem>> calcFreight(@RequestBody(required=false) List<PurchaseRequisitionItem> itemList) {
        Assert.isNotEmpty(itemList, (String)"itemList\u4e0d\u80fd\u4e3a\u7a7a");
        return ResponseResult.success(this.purchaseRequisitionItemService.calcFreight(itemList));
    }

    @ApiOperation(httpMethod="POST", value="\u8c03\u6574\u91c7\u8d2d\u9700\u6c42")
    @RequestMapping(value={"service/confirmAdjust"})
    @ResponseBody
    public ResponseResult<String> confirmAdjust(@RequestBody PurchaseRequisitionHead purchaseRequisition) {
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionStatusCheckUtils.require(purchaseRequisition.getApplyStatusCode(), PurchaseRequisitionStatusEnum.ADJUSTMENT_REQUIRED, "\u91c7\u8d2d\u8c03\u6574");
        Assert.isNotEmpty(purchaseRequisition.getPurchaseRequisitionItemList(), (String)"\u91c7\u8d2d\u7533\u8bf7\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        this.purchaseRequisitionHeadService.adjustRequisition(purchaseRequisition);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5173\u95ed\u91c7\u8d2d\u7533\u8bf7")
    @RequestMapping(value={"service/close"})
    @ResponseBody
    public ResponseResult<PurchaseRequisitionHead> close(@RequestParam(required=false) String id) {
        Assert.isNotBlank((String)id, (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a!");
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHead purchaseRequisition = (PurchaseRequisitionHead)this.purchaseRequisitionHeadService.queryObjById(id);
        Integer sc = purchaseRequisition.getApplyStatusCode();
        int approved = PurchaseRequisitionStatusEnum.APPROVED.code();
        int adjustment = PurchaseRequisitionStatusEnum.ADJUSTMENT_REQUIRED.code();
        int transformed = PurchaseRequisitionStatusEnum.ORDER_TRANSFORMED.code();
        if (!Objects.equals(sc, approved) && !Objects.equals(sc, adjustment) && !Objects.equals(sc, transformed) || Objects.equals(sc, transformed) && Objects.equals(purchaseRequisition.getPrepayStatus(), 2)) {
            throw new CommonException("\u53ea\u6709\u5ba1\u6279\u901a\u8fc7\u3001\u91c7\u8d2d\u8c03\u6574\u3001\u5df2\u8f6c\u8ba2\u5355(\u672a\u652f\u4ed8)\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u5173\u95ed\u64cd\u4f5c");
        }
        this.checkOutLine(purchaseRequisition);
        ArrayList<PurchaseRequisitionHead> purchaseRequisitionList = new ArrayList<PurchaseRequisitionHead>(1);
        purchaseRequisitionList.add(purchaseRequisition);
        this.purchaseRequisitionHeadService.close(purchaseRequisitionList);
        return ResponseResult.success((Object)purchaseRequisition);
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5173\u95ed\u91c7\u8d2d\u7533\u8bf7")
    @RequestMapping(value={"service/batchClose"})
    @ResponseBody
    public ResponseResult<List<PurchaseRequisitionHead>> batchClose(@RequestBody(required=false) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5355\u636eID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        RoleCheckUtils.requireRole((String)"CGJBR");
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.createCriteria().andIdIn((List)ids);
        List prList = this.purchaseRequisitionHeadService.queryAllObjByExample((IExample)example);
        prList.forEach(purchaseRequisition -> {
            Integer sc = purchaseRequisition.getApplyStatusCode();
            int approved = PurchaseRequisitionStatusEnum.APPROVED.code();
            int transformed = PurchaseRequisitionStatusEnum.ORDER_TRANSFORMED.code();
            if (!Objects.equals(sc, approved) && !Objects.equals(sc, transformed) || Objects.equals(sc, transformed) && Objects.equals(purchaseRequisition.getPrepayStatus(), 2)) {
                throw new CommonException("\u53ea\u6709\u5ba1\u6279\u901a\u8fc7\u3001\u5df2\u8f6c\u8ba2\u5355(\u672a\u652f\u4ed8)\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u5173\u95ed\u64cd\u4f5c");
            }
        });
        prList.forEach(this::checkOutLine);
        this.purchaseRequisitionHeadService.close(prList);
        return ResponseResult.success((Object)prList);
    }

    private void checkOutLine(PurchaseRequisitionHead purchaseRequisition) {
        this.purchaseRequisitionHeadService.checkOutLine(purchaseRequisition, true, true);
    }

    private void validate(PurchaseRequisitionHead purchaseRequisition, boolean checkId, Consumer<PurchaseRequisitionHead> statusChecker) {
        Assert.isNotNull((Object)purchaseRequisition, (String)"\u91c7\u8d2d\u7533\u8bf7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(purchaseRequisition.getPurchaseRequisitionItemList(), (String)"\u91c7\u8d2d\u7533\u8bf7\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        if (checkId) {
            Assert.isNotBlank((String)purchaseRequisition.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        if (statusChecker != null) {
            PurchaseRequisitionHead pr = (PurchaseRequisitionHead)this.purchaseRequisitionHeadService.queryObjById(purchaseRequisition.getId());
            statusChecker.accept((Object)pr);
        }
        Assert.isNotBlank((String)purchaseRequisition.getInitiatorId(), (String)"\u53d1\u8d77\u4eba\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseRequisition.getInitiatorPhone(), (String)"\u53d1\u8d77\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseRequisition.getInitiatorDeptCode(), (String)"\u53d1\u8d77\u4eba\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseRequisition.getInitiatorCompanyCode(), (String)"\u53d1\u8d77\u4eba\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseRequisition.getManagerId(), (String)"\u8d23\u4efb\u4eba\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseRequisition.getManagerPhone(), (String)"\u8d23\u4efb\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseRequisition.getManagerDeptCode(), (String)"\u8d23\u4efb\u4eba\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseRequisition.getManagerCompanyCode(), (String)"\u8d23\u4efb\u4eba\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseRequisition.getBudgetCenterCode(), (String)"\u9884\u7b97\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseRequisition.getIssuesCategoryCode(), (String)"\u652f\u51fa\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseRequisition.getIssuesClassCode(), (String)"\u652f\u51fa\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseRequisition.getCurrencyCode(), (String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a");
        if (purchaseRequisition.getTotalMoney() == null || purchaseRequisition.getTotalMoney().doubleValue() <= 0.0) {
            throw new CommonException("\u7533\u8bf7\u91d1\u989d\u9700\u5927\u4e8e0,\u8bf7\u4fee\u6539");
        }
        HashSet<String> supCompanyCodeSet = new HashSet<String>();
        supCompanyCodeSet.add(purchaseRequisition.getSupCompanyCode());
        purchaseRequisition.getPurchaseRequisitionItemList().stream().forEach(item -> {
            Assert.isNotBlank((String)item.getBranchId(), (String)"\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getBudgetCenterCode(), (String)"\u9884\u7b97\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getEconomicIssuesNo(), (String)"\u7ecf\u6d4e\u4e8b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getDeliveryAddress(), (String)"\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getConsignee(), (String)"\u6536\u8d27\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getPurchasePhone(), (String)"\u6536\u8d27\u4eba\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getConsigneeId(), (String)"\u6536\u8d27\u4eba\u7684ID\u4e0d\u80fd\u4e3a\u7a7a");
            if (Objects.equals(item.getInventoryFlag(), 1) && item.getStoreId() == null) {
                throw new CommonException("\u7eb3\u5165\u5e93\u5b58\u7684\u7269\u6599\u5e93\u5b58\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (item.getDemandAmount() == null || item.getDemandAmount() <= 0) {
                throw new CommonException("\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u6216\u7b49\u4e8e0");
            }
            if (item.getUnitPrice() == null || item.getUnitPrice().doubleValue() <= 0.0) {
                throw new CommonException("\u91c7\u8d2d\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u6216\u7b49\u4e8e0");
            }
            if (Objects.equals(item.getPrepay(), 1)) {
                Assert.isNotBlank((String)item.getPayway(), (String)"\u7533\u8bf7\u884c\u4e3a\u9884\u4ed8\u6b3e\u65f6\u9884\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isNotBlank((String)item.getPrepayType(), (String)"\u7533\u8bf7\u884c\u4e3a\u9884\u4ed8\u6b3e\u65f6\u9884\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                if (item.getPrepayAmount() == null || item.getPrepayAmount().doubleValue() <= 0.0) {
                    throw new CommonException("\u7533\u8bf7\u884c\u4e3a\u9884\u4ed8\u6b3e\u65f6\u9884\u4ed8\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u6216\u7b49\u4e8e0");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)item.getSupCompanyCode())) {
                supCompanyCodeSet.add(item.getSupCompanyCode());
            }
        });
        if (supCompanyCodeSet.size() > 1) {
            throw new CommonException("\u4fdd\u5b58\u5931\u8d25,\u4e00\u4e2a\u5355\u636e\u53ea\u80fd\u5bf9\u5e94\u4e00\u4e2a\u4f9b\u5e94\u5546!");
        }
    }

    private void calculate(PurchaseRequisitionHead purchaseRequisition) {
        ObjectHolder totalMoney = ObjectHolder.of((Object)BigDecimal.ZERO);
        purchaseRequisition.getPurchaseRequisitionItemList().stream().forEach(item -> {
            if (item.getDemandAmount() != null && item.getDemandAmount() > 0 && item.getUnitPrice() != null && item.getUnitPrice().doubleValue() > 0.0) {
                BigDecimal amountWithTax = (BigDecimal)BigDecimalFunction.MULTIPLY.apply(new BigDecimal(item.getDemandAmount()), item.getUnitPrice());
                item.setAmountWithTax(amountWithTax);
                totalMoney.value = BigDecimalFunction.ADD.apply(totalMoney.value, amountWithTax);
            }
        });
        if ("0".equals(purchaseRequisition.getDataSource())) {
            PurchaseBargainConfig bargainType = this.purchaseBargainConfigService.determineBargainType(purchaseRequisition.getInitiatorOrganizationId(), (BigDecimal)totalMoney.value);
            purchaseRequisition.setBargainType(bargainType == null ? 0 : bargainType.getBargainType());
        } else {
            purchaseRequisition.setBargainType(0);
        }
        if (ProductOriginEnum.JD.getValue().equals(purchaseRequisition.getDataSource())) {
            this.purchaseRequisitionItemService.calcFreight(purchaseRequisition.getPurchaseRequisitionItemList()).stream().map(PurchaseRequisitionItem::getFreight).filter(Objects::nonNull).reduce((a, b) -> a.add((BigDecimal)b)).ifPresent(freight -> {
                totalMoney.value = BigDecimalFunction.ADD.apply(totalMoney.value, freight);
                BigDecimal cfr_ignored_0 = (BigDecimal)totalMoney.value;
            });
        }
        purchaseRequisition.setTotalMoney((BigDecimal)totalMoney.value);
    }
}

