/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.dao.PurchaseRequisitionFileMapper;
import com.els.base.purchase.entity.PurchaseRequisitionFile;
import com.els.base.purchase.entity.PurchaseRequisitionFileExample;
import com.els.base.purchase.service.PurchaseRequisitionFileService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurchaseRequisitionFileService")
public class PurchaseRequisitionFileServiceImpl
implements PurchaseRequisitionFileService {
    @Resource
    protected PurchaseRequisitionFileMapper purchaseRequisitionFileMapper;

    @CacheEvict(value={"purchaseRequisitionFile"}, allEntries=true)
    public void addObj(PurchaseRequisitionFile t) {
        this.purchaseRequisitionFileMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purchaseRequisitionFile"}, allEntries=true)
    public void addAll(List<PurchaseRequisitionFile> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseRequisitionFileMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseRequisitionFile"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseRequisitionFileMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseRequisitionFile"}, allEntries=true)
    public void deleteByExample(PurchaseRequisitionFileExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseRequisitionFileMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseRequisitionFile"}, allEntries=true)
    public void modifyObj(PurchaseRequisitionFile t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purchaseRequisitionFileMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseRequisitionFile"}, keyGenerator="redisKeyGenerator")
    public PurchaseRequisitionFile queryObjById(String id) {
        return this.purchaseRequisitionFileMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseRequisitionFile"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseRequisitionFile> queryAllObjByExample(PurchaseRequisitionFileExample example) {
        return this.purchaseRequisitionFileMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseRequisitionFile"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseRequisitionFile> queryObjByPage(PurchaseRequisitionFileExample example) {
        PageView<PurchaseRequisitionFile> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseRequisitionFileMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public int updateByExampleSelective(PurchaseRequisitionFile file, PurchaseRequisitionFileExample fileExample) {
        return this.purchaseRequisitionFileMapper.updateByExampleSelective(file, fileExample);
    }
}

