/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.alibaba.fastjson.JSON;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.bidding.entity.BiddingContent;
import com.els.base.bidding.entity.BiddingContentMatter;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingMatter;
import com.els.base.bidding.entity.BiddingMatterExample;
import com.els.base.bidding.entity.BiddingOffer;
import com.els.base.bidding.entity.BiddingOfferExample;
import com.els.base.bidding.entity.BiddingPower;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.enums.ApprovalStatusEnum;
import com.els.base.bidding.enums.TenderStatusEumn;
import com.els.base.bidding.service.BiddingHeaderService;
import com.els.base.bidding.service.BiddingMatterService;
import com.els.base.bidding.service.BiddingOfferService;
import com.els.base.certification.contacts.entity.Contacts;
import com.els.base.certification.contacts.service.ContactsService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.functional.BigDecimalFunction;
import com.els.base.company.service.BankAccountService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.utils.FilterUtils;
import com.els.base.company.utils.ObjectHolder;
import com.els.base.company.utils.ObjectUtils;
import com.els.base.company.utils.Objects;
import com.els.base.company.utils.SupplierStatusEnum;
import com.els.base.company.vo.JQAccountVO;
import com.els.base.contract.ledger.entity.ContractFileExample;
import com.els.base.contract.ledger.service.ContractFileService;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.file.entity.FileData;
import com.els.base.ggsync.service.SyncEconomicIssuesSetService;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.pur.CreateCommand;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryPurFile;
import com.els.base.inquiry.entity.InquirySupplier;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TargetM001;
import com.els.base.material.entity.Material;
import com.els.base.material.service.MaterialService;
import com.els.base.product.entity.PurchaseProductInventory;
import com.els.base.product.entity.PurchaseProductInventoryExample;
import com.els.base.product.entity.PurchaseUserOrderItem;
import com.els.base.product.entity.PurchaseUserOrderItemExample;
import com.els.base.product.service.PurchaseProductInventoryService;
import com.els.base.product.service.PurchaseProductService;
import com.els.base.product.service.PurchaseUserOrderItemExtService;
import com.els.base.product.service.PurchaseUserOrderItemService;
import com.els.base.product.vo.ProductOriginEnum;
import com.els.base.purchase.command.JdOrderCommand;
import com.els.base.purchase.command.QixinOrderCommand2;
import com.els.base.purchase.command.SupOrderCommand;
import com.els.base.purchase.dao.PurchaseRequisitionHeadMapper;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseRequisitionFile;
import com.els.base.purchase.entity.PurchaseRequisitionFileExample;
import com.els.base.purchase.entity.PurchaseRequisitionHead;
import com.els.base.purchase.entity.PurchaseRequisitionHeadExample;
import com.els.base.purchase.entity.PurchaseRequisitionItem;
import com.els.base.purchase.entity.PurchaseRequisitionItemExample;
import com.els.base.purchase.enumerate.PurchaseRequisitionStatusEnum;
import com.els.base.purchase.exception.BudgetNotPassException;
import com.els.base.purchase.service.OrderBudgetHandleService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.service.PurchaseRequisitionFileService;
import com.els.base.purchase.service.PurchaseRequisitionHeadService;
import com.els.base.purchase.service.PurchaseRequisitionItemService;
import com.els.base.purchase.vo.BiddingFollowableHistoryVO;
import com.els.base.purchase.vo.PurchaseRequisitionEventVO;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import com.els.comix.service.ComixApiService;
import com.els.comix.service.QixinBaseGoodsInfoService;
import com.els.jd.service.JdApiService;
import com.els.jd.service.JingdongGoodsEntityInfoService;
import com.els.sinolifesdk.service.SinoLifeApiService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurchaseRequisitionHeadService")
public class PurchaseRequisitionHeadServiceImpl
implements PurchaseRequisitionHeadService,
ITaskListener {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private PurchaseRequisitionHeadMapper purchaseRequisitionHeadMapper;
    @Resource
    private PurchaseRequisitionItemService purchaseRequisitionItemService;
    @Resource
    private PurchaseRequisitionFileService purchaseRequisitionFileService;
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private PurchaseOrderService purchaseOrderService;
    @Resource
    private CompanyService companyService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private ContactsService contactsService;
    @Resource
    private MaterialService materialService;
    @Resource
    private BiddingHeaderService biddingHeaderService;
    @Resource
    private BiddingMatterService biddingMatterService;
    @Resource
    private BiddingOfferService biddingOfferService;
    @Resource
    private SinoLifeApiService sinolifeApiService;
    @Resource
    private SyncEconomicIssuesSetService syncEconomicIssuesSetService;
    @Resource
    private BankAccountService bankAccountService;
    @Resource
    private PurchaseUserOrderItemExtService purchaseUserOrderItemExtService;
    @Resource
    private InquiryCommandInvoker inquiryCommandInvoker;
    @Resource
    private PurchaseRequisitionHeadService purchaseRequisitionHeadService;
    @Resource
    private QixinBaseGoodsInfoService qixinBaseGoodsInfoService;
    @Resource
    private ComixApiService comixApiService;
    @Resource
    private JdApiService jdApiService;
    @Resource
    private JingdongGoodsEntityInfoService jingdongGoodsEntityInfoService;
    @Resource
    private PurchaseProductService purchaseProductService;
    @Resource
    private PurchaseUserOrderItemService purchaseUserOrderItemService;
    @Resource
    private OrderBudgetHandleService orderBudgetHandleService;
    @Resource
    private ContractFileService contractFileService;
    @Resource
    private DicGroupItemService dicGroupItemService;
    @Resource
    private ICommandInvoker invoker;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;
    @Resource
    private PurchaseProductInventoryService purchaseProductInventoryService;
    @Value(value="${sinolife.esb.api.enable:false}")
    private boolean esbApiEnabled;

    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    @Transactional
    public void addObj(PurchaseRequisitionHead t) {
        User currentUser = SpringSecurityUtils.getLoginUser();
        t.setProjectId(ProjectUtils.getProjectId());
        t.setCompanyId(CompanyUtils.currentCompanyId());
        t.setApplyNo(this.generateCodeService.getNextCode("PURCHASE_REQUISITION"));
        t.setApplyStatusCode(PurchaseRequisitionStatusEnum.NEW.code());
        t.setApplyStatusDesc(PurchaseRequisitionStatusEnum.NEW.desc());
        t.setCreateUserId(currentUser.getId());
        t.setCreateUserName(currentUser.getNickName());
        t.setCreateTime(new Date());
        this.purchaseRequisitionHeadMapper.insertSelective(t);
        ObjectHolder oh = ObjectHolder.of((Object)1);
        t.getPurchaseRequisitionItemList().forEach(item -> {
            item.setHeadId(t.getId());
            Integer n = (Integer)oh.value;
            oh.value = (Integer)oh.value + 1;
            Integer n2 = oh.value;
            item.setItemNo(n);
        });
        this.purchaseRequisitionItemService.addAll(t.getPurchaseRequisitionItemList());
        Optional.ofNullable(t.getPurchaseRequisitionFileList()).ifPresent(fileList -> {
            fileList.forEach(file -> {
                file.setHeadId(t.getId());
                file.setCreateTime(new Date());
                file.setIsEnable(Constant.YES_INT);
            });
            this.purchaseRequisitionFileService.addAll((List)fileList);
        });
    }

    @Transactional
    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    public void addAll(List<PurchaseRequisitionHead> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseRequisitionHeadMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseRequisitionHeadMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    @Transactional
    public void deleteByExample(PurchaseRequisitionHeadExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseRequisitionHeadMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    @Transactional
    public void modifyObj(PurchaseRequisitionHead t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        User currentUser = SpringSecurityUtils.getLoginUser();
        Date now = new Date();
        t.setApplyStatusCode(PurchaseRequisitionStatusEnum.NEW.code());
        t.setApplyStatusDesc(PurchaseRequisitionStatusEnum.NEW.desc());
        t.setUpdateUserId(currentUser.getId());
        t.setUpdateUserName(currentUser.getNickName());
        t.setUpdateTime(now);
        this.purchaseRequisitionHeadMapper.updateByPrimaryKeySelective(t);
        if (!"0".equals(t.getDataSource())) {
            List tmp;
            List shopOrderNoList = t.getPurchaseRequisitionItemList().stream().map(PurchaseRequisitionItem::getProductCode).filter(Objects::nonNull).collect(Collectors.toList());
            PurchaseRequisitionItemExample prItemExample = new PurchaseRequisitionItemExample();
            PurchaseRequisitionItemExample.Criteria criteria = prItemExample.or().andHeadIdEqualTo(t.getId());
            if (CollectionUtils.isNotEmpty(shopOrderNoList)) {
                criteria.andProductCodeNotIn(shopOrderNoList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(tmp = this.purchaseRequisitionItemService.queryAllObjByExample((IExample)prItemExample)))) {
                List deletedList = tmp.stream().map(PurchaseRequisitionItem::getProductCode).collect(Collectors.toList());
                PurchaseUserOrderItem puoItem = new PurchaseUserOrderItem();
                puoItem.setStatus("0");
                PurchaseUserOrderItemExample puoiExample = new PurchaseUserOrderItemExample();
                puoiExample.or().andOrderNoIn(deletedList);
                this.purchaseUserOrderItemService.updateByExampleSelective(puoItem, puoiExample);
            }
        }
        PurchaseRequisitionItemExample itemExample = new PurchaseRequisitionItemExample();
        itemExample.createCriteria().andHeadIdEqualTo(t.getId());
        this.purchaseRequisitionItemService.deleteByExample((IExample)itemExample);
        Integer currentNo = t.getPurchaseRequisitionItemList().stream().map(PurchaseRequisitionItem::getItemNo).filter(Objects::nonNull).max(Integer::compare).orElse(0);
        currentNo = currentNo + 1;
        ObjectHolder oh = ObjectHolder.of((Object)currentNo);
        t.getPurchaseRequisitionItemList().forEach(item -> {
            item.setHeadId(t.getId());
            if (item.getItemNo() == null) {
                Integer n = (Integer)oh.value;
                oh.value = (Integer)oh.value + 1;
                Integer n2 = oh.value;
                item.setItemNo(n);
            }
        });
        this.purchaseRequisitionItemService.addAll(t.getPurchaseRequisitionItemList());
        PurchaseRequisitionFileExample fileExample = new PurchaseRequisitionFileExample();
        fileExample.createCriteria().andHeadIdEqualTo(t.getId()).andIsEnableEqualTo(Constant.YES_INT);
        PurchaseRequisitionFile tmp = new PurchaseRequisitionFile();
        tmp.setIsEnable(Constant.NO_INT);
        this.purchaseRequisitionFileService.updateByExampleSelective(tmp, fileExample);
        Optional.ofNullable(t.getPurchaseRequisitionFileList()).ifPresent(fileList -> {
            fileList.forEach(file -> {
                file.setHeadId(t.getId());
                file.setUpdateTime(now);
                file.setIsEnable(Constant.YES_INT);
            });
            this.purchaseRequisitionFileService.addAll((List)fileList);
        });
    }

    @Cacheable(value={"purchaseRequisitionHead"}, keyGenerator="redisKeyGenerator")
    public PurchaseRequisitionHead queryObjById(String id) {
        return this.purchaseRequisitionHeadMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseRequisitionHead"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseRequisitionHead> queryAllObjByExample(PurchaseRequisitionHeadExample example) {
        return this.purchaseRequisitionHeadMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseRequisitionHead"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseRequisitionHead> queryObjByPage(PurchaseRequisitionHeadExample example) {
        PageView<PurchaseRequisitionHead> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseRequisitionHeadMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    @Transactional
    public void deleteByIds(List<String> ids) {
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.createCriteria().andIdIn((List)ids);
        List<PurchaseRequisitionHead> prList = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(prList)) {
            return;
        }
        ArrayList shopOrderNoList = new ArrayList();
        prList.stream().filter(pr -> !"0".equals(pr.getDataSource())).forEach(pr -> {
            this.checkOutLine((PurchaseRequisitionHead)pr);
            List tmpList = pr.getPurchaseRequisitionItemList().stream().map(item -> item.getProductCode()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(tmpList)) {
                shopOrderNoList.addAll(tmpList);
            }
        });
        if (!shopOrderNoList.isEmpty()) {
            PurchaseUserOrderItem puoItem = new PurchaseUserOrderItem();
            puoItem.setStatus("0");
            PurchaseUserOrderItemExample puoiExample = new PurchaseUserOrderItemExample();
            puoiExample.or().andOrderNoIn(shopOrderNoList);
            this.purchaseUserOrderItemService.updateByExampleSelective(puoItem, puoiExample);
        }
        this.purchaseRequisitionHeadMapper.deleteByExample(example);
        PurchaseRequisitionItemExample example2 = new PurchaseRequisitionItemExample();
        example2.createCriteria().andHeadIdIn((List)ids);
        this.purchaseRequisitionItemService.deleteByExample((IExample)example2);
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    @Transactional
    public List<PurchaseRequisitionHead> budgetCheck(List<PurchaseRequisitionHead> purchaseRequisitionList) {
        purchaseRequisitionList.forEach(purchaseRequisition -> {
            boolean pass = this.doCheck((PurchaseRequisitionHead)purchaseRequisition);
            PurchaseRequisitionStatusEnum status = pass ? PurchaseRequisitionStatusEnum.BUDGET_PASS : PurchaseRequisitionStatusEnum.BUDGET_NOT_PASS;
            this.updateApplyStatus((PurchaseRequisitionHead)purchaseRequisition, status);
        });
        return purchaseRequisitionList;
    }

    private boolean doCheck(PurchaseRequisitionHead requisition) {
        List list = requisition.getPurchaseRequisitionItemList().parallelStream().map(item -> {
            String bs = this.syncEconomicIssuesSetService.getBudgetSubjectsByEconomicIssuesNo(item.getEconomicIssuesNo());
            String businessBook = "group_mining".equals(requisition.getPurchaseCatalogType()) ? item.getCtBusinessBook() : requisition.getInitiatorBusinessBook();
            String budgetBook = this.getBudgetBook(businessBook);
            Assert.isNotBlank((String)budgetBook, (String)"\u4e0d\u652f\u6301\u7684\u8d26\u5957!");
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            tmp.put("p_query_date", DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM"));
            tmp.put("p_business_book", budgetBook);
            tmp.put("p_fin_branch_code", item.getBranchId());
            tmp.put("p_budget_center", item.getBudgetCenterCode());
            tmp.put("p_budget_subjects", bs);
            tmp.put("p_project_code", Objects.toString((Object)requisition.getProjectCode(), () -> this.getDefaultProjectCode(businessBook)));
            tmp.put("p_amount", item.getAmountWithTax());
            return tmp;
        }).collect(Collectors.toList());
        return this.sinolifeApiService.bepBudgetCheck(list);
    }

    private String getBudgetBook(String businessBook) {
        switch (businessBook) {
            case "SINO_LEDGER": {
                return "1";
            }
            case "SINO_CRI_LEDGER": {
                return "2";
            }
            case "SINO_AMC_LEDGER": {
                return "3";
            }
            case "SINO_FS_LEDGER": {
                return "4";
            }
            case "SINO_FDIH_LEDGER": {
                return "5";
            }
        }
        return null;
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true, beforeInvocation=true)
    @Transactional(noRollbackFor={BudgetNotPassException.class})
    public List<PurchaseRequisitionHead> approve(List<PurchaseRequisitionHead> purchaseRequisitionList) {
        purchaseRequisitionList.forEach(purchaseRequisition -> {
            boolean pass = this.doCheck((PurchaseRequisitionHead)purchaseRequisition);
            if (!pass) {
                this.updateApplyStatus((PurchaseRequisitionHead)purchaseRequisition, PurchaseRequisitionStatusEnum.BUDGET_NOT_PASS);
                throw new BudgetNotPassException("\u5355\u636e%s\u7684\u9884\u7b97\u672a\u901a\u8fc7\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279!", purchaseRequisition.getApplyNo());
            }
        });
        purchaseRequisitionList.forEach(purchaseRequisition -> {
            Map result;
            String hBusinessBook = "group_mining".equals(purchaseRequisition.getPurchaseCatalogType()) ? purchaseRequisition.getPurchaseRequisitionItemList().get(0).getCtBusinessBook() : purchaseRequisition.getInitiatorBusinessBook();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("seq", purchaseRequisition.getApplyNo());
            paramMap.put("applySource", "3");
            if ("group_mining".equals(purchaseRequisition.getPurchaseCatalogType())) {
                paramMap.put("groupMiningFlag", "Y");
            }
            paramMap.put("businessBook", purchaseRequisition.getManagerBusinessBook());
            paramMap.put("applyUseEmpId", purchaseRequisition.getInitiatorEmpId());
            paramMap.put("applyFinBranchCode", purchaseRequisition.getInitiatorOrganizationId());
            paramMap.put("applyDeptNo", purchaseRequisition.getInitiatorDeptCode());
            paramMap.put("applyUserPhone", purchaseRequisition.getInitiatorPhone());
            paramMap.put("responsibleUseEmpId", purchaseRequisition.getManagerEmpId());
            paramMap.put("responsibleFinBranchCode", purchaseRequisition.getManagerOrganizationId());
            paramMap.put("responsibleDeptNo", purchaseRequisition.getManagerDeptCode());
            paramMap.put("responsibleUserPhone", purchaseRequisition.getManagerPhone());
            paramMap.put("applyDate", purchaseRequisition.getApplyTime());
            paramMap.put("applyReason", purchaseRequisition.getApplyReason());
            paramMap.put("issuesDescription", purchaseRequisition.getRemark());
            paramMap.put("budgetCenter", purchaseRequisition.getBudgetCenterCode());
            paramMap.put("isScan", Integer.valueOf(1).equals(purchaseRequisition.getScan()) ? "Y" : "N");
            paramMap.put("projectCode", Objects.toString((Object)purchaseRequisition.getProjectCode(), () -> this.getDefaultProjectCode(hBusinessBook)));
            paramMap.put("currency", purchaseRequisition.getCurrencyCode());
            if (CompanyUtils.isJingDongCompanyCode((String)purchaseRequisition.getSupCompanyCode())) {
                paramMap.put("amount", purchaseRequisition.getMarketTotalPrice());
            } else {
                paramMap.put("amount", purchaseRequisition.getTotalMoney());
            }
            ArrayList applyList = new ArrayList(purchaseRequisition.getPurchaseRequisitionItemList().size());
            LinkedList prepayList = new LinkedList();
            ObjectHolder prepayTotalAmount = ObjectHolder.of((Object)BigDecimal.ZERO);
            purchaseRequisition.getPurchaseRequisitionItemList().forEach(item -> {
                HashMap<String, Object> applyItem = new HashMap<String, Object>();
                applyList.add(applyItem);
                applyItem.put("applySeq", item.getItemNo());
                applyItem.put("branchId", item.getBranchId());
                applyItem.put("budgetCenter", item.getBudgetCenterCode());
                applyItem.put("economicIssuesNo", item.getEconomicIssuesNo());
                applyItem.put("isDonation", Integer.valueOf(1).equals(item.getDonate()) ? "Y" : "N");
                applyItem.put("donationType", item.getDonationType());
                applyItem.put("summary", item.getApplyRemark());
                if (CompanyUtils.isJingDongCompanyCode((String)item.getSupCompanyCode())) {
                    applyItem.put("applyAmount", item.getPrepayAmount());
                } else {
                    applyItem.put("applyAmount", item.getAmountWithTax());
                }
                if (Integer.valueOf(1).equals(item.getPrepay())) {
                    HashMap<String, Object> prepayItem = new HashMap<String, Object>();
                    prepayItem.put("lendSeq", item.getItemNo());
                    prepayItem.put("economicIssuesNo", item.getPrepayType());
                    prepayItem.put("applyAmount", item.getPrepayAmount());
                    prepayItem.put("budgetCenter", item.getBudgetCenterCode());
                    prepayItem.put("paymentType", item.getPayway());
                    prepayItem.put("summary", item.getPrepayRemark());
                    if (CompanyUtils.isJingDongOrQiXinCompanyCode((String)item.getSupCompanyCode())) {
                        String businessBook = StringUtils.isBlank((String)item.getCtBusinessBook()) ? purchaseRequisition.getInitiatorBusinessBook() : item.getCtBusinessBook();
                        JQAccountVO account = this.companyService.getJingDongOrQiXinAccountInfo(businessBook, CompanyUtils.isJingDongCompanyCode((String)item.getSupCompanyCode()) ? 1 : 2);
                        prepayItem.put("payeeNo", account.getPayeeNo());
                        prepayItem.put("accountName", account.getAccountName());
                        prepayItem.put("accountNo", account.getAccountNo());
                        prepayItem.put("accountBank", account.getAccountBank());
                        prepayItem.put("accountBankNet", account.getAccountBankNet());
                    } else {
                        prepayItem.put("payeeNo", item.getSupCompanyCode());
                        this.bankAccountService.getDefaultAccount(item.getSupCompanyId()).ifPresent(bankAccount -> {
                            prepayItem.put("accountName", bankAccount.getAccountName());
                            prepayItem.put("accountNo", bankAccount.getAccountNo());
                            prepayItem.put("accountBank", bankAccount.getAccountBank());
                            prepayItem.put("accountBankNet", bankAccount.getBankNet());
                        });
                    }
                    prepayList.add(prepayItem);
                    prepayTotalAmount.value = BigDecimalFunction.ADD.apply(prepayTotalAmount.value, item.getPrepayAmount());
                }
            });
            LinkedList fileList = new LinkedList();
            Optional.ofNullable(purchaseRequisition.getPurchaseRequisitionFileList()).ifPresent(list -> list.stream().filter(file -> StringUtils.isNotBlank((String)file.getAttachment())).forEach(file -> JSON.parseArray((String)file.getAttachment(), FileData.class).forEach(fileData -> {
                HashMap<String, String> fileInfo = new HashMap<String, String>();
                if (StringUtils.isNotBlank((String)fileData.getInternetPath())) {
                    fileInfo.put("fileurl", fileData.getInternetPath());
                } else {
                    fileInfo.put("fileurl", fileData.getFileUrl());
                }
                fileInfo.put("fileName", fileData.getFileName());
                fileInfo.put("fileSize", Objects.toString((Object)fileData.getFileSize(), (String)""));
                fileList.add(fileInfo);
            })));
            if (Objects.equals((Object)1, (Object)purchaseRequisition.getAttachToContract()) && StringUtils.isNotBlank((String)purchaseRequisition.getContractNo())) {
                ContractFileExample example = new ContractFileExample();
                example.or().andContractNumEqualTo(purchaseRequisition.getContractNo());
                List contractFileList = this.contractFileService.queryAllObjByExample((IExample)example);
                if (CollectionUtils.isNotEmpty((Collection)contractFileList)) {
                    contractFileList.stream().forEach(fileData -> {
                        HashMap<String, String> fileInfo = new HashMap<String, String>();
                        if (StringUtils.isNotBlank((String)fileData.getInternetPath())) {
                            fileInfo.put("fileurl", fileData.getInternetPath());
                        } else {
                            fileInfo.put("fileurl", fileData.getUrl());
                        }
                        fileInfo.put("fileName", fileData.getName());
                        fileInfo.put("fileSize", Objects.toString((Object)fileData.getFileSize(), (String)""));
                        fileList.add(fileInfo);
                    });
                }
            }
            paramMap.put("isLendInExpenses", prepayList.isEmpty() ? "N" : "Y");
            paramMap.put("expensesDetailList", applyList);
            paramMap.put("lendApplyAmount", prepayTotalAmount.value);
            paramMap.put("lendApplyDetailList", prepayList);
            paramMap.put("fileList", fileList);
            if (!this.esbApiEnabled) {
                paramMap.put("applyId", purchaseRequisition.getId());
                paramMap.put("applyNo", purchaseRequisition.getApplyNo());
                paramMap.put("listenerClass", this.getClass());
            }
            if (!"Y".equals((result = this.sinolifeApiService.CreateExpensesApply(paramMap)).get("flag"))) {
                throw new CommonException((String)result.get("message"));
            }
            this.updateApplyStatus((PurchaseRequisitionHead)purchaseRequisition, PurchaseRequisitionStatusEnum.AUDITING, pr -> {
                pr.setBepApplyNo((String)result.get("applyBepVoucherNo"));
                pr.setBepApplySn((String)result.get("expensesApplyNo"));
                pr.setBepApplyType((String)result.get("applyType"));
                pr.setBepPrepayNo((String)result.get("lendBepVoucherNo"));
                pr.setBepPrepaySn((String)result.get("lendApplyNo"));
                pr.setBepPrepayType((String)result.get("lendType"));
            });
        });
        return purchaseRequisitionList;
    }

    private String getDefaultProjectCode(String businessBook) {
        DicGroupItem dicGroupItem = this.dicGroupItemService.queryItems("default_project_code", businessBook);
        if (dicGroupItem == null || StringUtils.isBlank((String)dicGroupItem.getValue())) {
            throw new CommonException(businessBook + " \u672a\u914d\u7f6e\u9ed8\u8ba4\u9879\u76ee\u4ee3\u7801");
        }
        return dicGroupItem.getValue();
    }

    @CacheEvict(value={"purchaseRequisitionHead", "purchaseRequisitionItem"}, allEntries=true)
    @Transactional
    public void listen(TaskOperateEvent event) {
        if (!event.isFinished()) {
            return;
        }
        String purchaseRequisitionId = event.getBusinessId();
        Assert.isNotBlank((String)purchaseRequisitionId, (String)"\u91c7\u8d2d\u7533\u8bf7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        PurchaseRequisitionHead purchaseRequisition = this.queryObjById(purchaseRequisitionId);
        Assert.isNotNull((Object)purchaseRequisition, (String)"\u6839\u636e\u91c7\u8d2d\u7533\u8bf7ID\u67e5\u8be2\u51fa\u7684\u91c7\u8d2d\u7533\u8bf7\u4fe1\u606f\u4e3a\u7a7a");
        PurchaseRequisitionStatusEnum status = event.isPass() ? PurchaseRequisitionStatusEnum.APPROVED : PurchaseRequisitionStatusEnum.REJECTED;
        this.updateApplyStatus(purchaseRequisition, status);
        if (event.isPass() && ProductOriginEnum.isJQ((String)purchaseRequisition.getDataSource())) {
            this.checkOutDetailLine(purchaseRequisition);
            this.toShopOrder(purchaseRequisition);
        }
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    @Transactional
    public List<PurchaseRequisitionHead> toOrder(List<PurchaseRequisitionHead> purchaseRequisitionList) {
        purchaseRequisitionList.forEach(purchaseRequisition -> {
            if (!ProductOriginEnum.isNormal((String)purchaseRequisition.getDataSource())) {
                this.toShopOrder((PurchaseRequisitionHead)purchaseRequisition);
            } else {
                this.toNormalOrder((PurchaseRequisitionHead)purchaseRequisition);
            }
        });
        return purchaseRequisitionList;
    }

    private void toShopOrder(PurchaseRequisitionHead purchaseRequisition) {
        Company company = CompanyUtils.currentCompanyAudit((String)purchaseRequisition.getInitiatorId());
        ArrayList<PurchaseRequisitionHead> prList = new ArrayList<PurchaseRequisitionHead>(1);
        prList.add(purchaseRequisition);
        PurchaseRequisitionEventVO purchaseRequisitionEventVO = new PurchaseRequisitionEventVO();
        purchaseRequisitionEventVO.setProjectId(ProjectUtils.getProjectId());
        purchaseRequisitionEventVO.setCompany(company);
        purchaseRequisitionEventVO.setPurchaseRequisitionHead(purchaseRequisition);
        purchaseRequisitionEventVO.setPurchaseRequisitionHeadList(prList);
        if (ProductOriginEnum.isJD((String)purchaseRequisition.getDataSource())) {
            this.logger.debug("\u6267\u884c\u4eac\u4e1c\u4e0b\u5355\u547d\u4ee4\u5f00\u59cb");
            this.invoker.invoke((BaseCommand)new JdOrderCommand(purchaseRequisitionEventVO));
            this.logger.debug("\u6267\u884c\u4eac\u4e1c\u4e0b\u5355\u547d\u4ee4\u5b8c\u6bd5");
        } else if (ProductOriginEnum.isQX((String)purchaseRequisition.getDataSource())) {
            this.logger.debug("\u6267\u884c\u9f50\u5fc3\u4e0b\u5355\u547d\u4ee4\u5f00\u59cb");
            this.invoker.invoke((BaseCommand)new QixinOrderCommand2(purchaseRequisitionEventVO));
            this.logger.debug("\u6267\u884c\u9f50\u5fc3\u4e0b\u5355\u547d\u4ee4\u7ed3\u675f");
        } else if (ProductOriginEnum.isSUP((String)purchaseRequisition.getDataSource())) {
            this.logger.debug("\u6267\u884c\u5185\u90e8\u5546\u57ce\u4e0b\u5355\u547d\u4ee4\u5f00\u59cb");
            this.invoker.invoke((BaseCommand)new SupOrderCommand(purchaseRequisitionEventVO));
            this.logger.debug("\u6267\u884c\u5185\u90e8\u5546\u57ce\u4e0b\u5355\u547d\u4ee4\u7ed3\u675f");
        }
    }

    private void toNormalOrder(PurchaseRequisitionHead purchaseRequisition) {
        String projectId = ProjectUtils.getProjectId();
        Company currentCompnay = CompanyUtils.currentCompany();
        User loginUser = SpringSecurityUtils.getLoginUser();
        PurchaseOrder order = new PurchaseOrder();
        order.setProjectId(projectId);
        order.setPurchaseApplyNo(purchaseRequisition.getApplyNo());
        order.setBepVoucherNo(purchaseRequisition.getBepApplyNo());
        order.setExpensesApplyNo(purchaseRequisition.getBepApplySn());
        Company supCompany = (Company)this.companyService.queryObjById((Object)purchaseRequisition.getSupCompanyId());
        order.setSupCompanyId(supCompany.getId());
        order.setSupCompanyName(supCompany.getCompanyFullName());
        order.setSupCompanyShortName(supCompany.getCompanyName());
        order.setSupCompanySrmCode(supCompany.getCompanyCode());
        User supUser = this.companyUserRefService.queryMainUserOfCompany(supCompany.getId());
        order.setSupUserId(supUser.getId());
        order.setSupUserName(supUser.getNickName());
        List contacts = this.contactsService.queryAllContacts(supCompany.getId());
        if (CollectionUtils.isNotEmpty((Collection)contacts)) {
            order.setSupplierPerson(((Contacts)contacts.get(0)).getName());
            order.setSupplierTel(((Contacts)contacts.get(0)).getMobilePhone());
            order.setSupplierFax(((Contacts)contacts.get(0)).getFax());
        }
        order.setPurPlanerId(loginUser.getId());
        order.setPurPlanerName(loginUser.getNickName());
        order.setAccountCode(purchaseRequisition.getInitiatorBusinessBook());
        order.setAccountSetId(purchaseRequisition.getInitiatorAccountSetId());
        order.setAccountSetName(purchaseRequisition.getInitiatorAccountSetName());
        order.setInstitutionsId(purchaseRequisition.getInitiatorCompanyCode());
        order.setInstitutionsName(purchaseRequisition.getInitiatorCompanyName());
        order.setInTheOrganizationId(purchaseRequisition.getInitiatorOrganizationId());
        order.setInTheOrganizationName(purchaseRequisition.getInitiatorOrganizationName());
        order.setDepartId(purchaseRequisition.getInitiatorDeptCode());
        order.setDepartName(purchaseRequisition.getInitiatorDeptName());
        order.setCurrency(purchaseRequisition.getCurrencyCode());
        order.setContractNumber(purchaseRequisition.getContractNo());
        order.setDataSource(purchaseRequisition.getDataSource());
        order.setTaxTotalPrice(purchaseRequisition.getTotalMoney());
        order.setOrderTotal(purchaseRequisition.getTotalMoney());
        List<PurchaseRequisitionItem> priList = purchaseRequisition.getPurchaseRequisitionItemList();
        ArrayList<PurchaseOrderItem> poiList = new ArrayList<PurchaseOrderItem>(priList.size());
        for (PurchaseRequisitionItem pri : priList) {
            PurchaseOrderItem poi = new PurchaseOrderItem();
            poi.setProjectId(projectId);
            poi.setSupCompanyId(pri.getSupCompanyId());
            poi.setSupCompanySrmCode(pri.getSupCompanyCode());
            poi.setSupCompanyName(pri.getSupCompanyName());
            poi.setSupUserId(supUser.getId());
            poi.setSupUserName(supUser.getNickName());
            Material material = this.materialService.queryObjByCode(pri.getMaterialCode());
            poi.setMaterialCategoryName(material.getMaterialSpecification());
            poi.setMaterialId(material.getId());
            poi.setMaterialCode(material.getMaterialCode());
            poi.setMaterialName(material.getDescription());
            poi.setQuantity(new BigDecimal(pri.getDemandAmount()));
            poi.setPriceUnit(null);
            poi.setOrderUnit(material.getBasicUnit());
            poi.setWarehouseCode(pri.getStoreId());
            poi.setWarehouseName(pri.getStoreName());
            poi.setCurrency(purchaseRequisition.getCurrencyCode());
            poi.setDeliveryLocation(pri.getDeliveryAddress());
            poi.setConsignee(pri.getConsignee());
            poi.setConsigneeId(pri.getConsigneeId());
            poi.setPurchasePhone(pri.getPurchasePhone());
            poi.setOrderStatus(Integer.valueOf(1));
            poi.setPurReqNo(purchaseRequisition.getApplyNo());
            poi.setPurReqItemNo(String.valueOf(pri.getItemNo()));
            poi.setOrderItemNo(String.valueOf(pri.getItemNo()));
            BigDecimal up = pri.getUnitPrice();
            BigDecimal total = up.multiply(new BigDecimal(pri.getDemandAmount())).setScale(2, 4);
            poi.setTaxUnitPrice(up);
            poi.setTaxTotalPrice(total);
            poi.setTotalPrice(total);
            poi.setBudgetCore(pri.getBudgetCenterCode());
            poi.setBudgetCoreDesc(pri.getBudgetCenterName());
            poi.setEconomicMatters(pri.getEconomicIssuesNo());
            poi.setEconomicMattersDesc(pri.getEconomicIssuesDesc());
            poi.setUses(Integer.toString(pri.getDonate()));
            poi.setProductCode(pri.getProductCode());
            poi.setProductCodeWx(pri.getProductCodeWx());
            poiList.add(poi);
        }
        order.setItems(poiList);
        String orderNo = this.purchaseOrderService.createPurOrder(order, currentCompnay, loginUser);
        this.updateApplyStatus(purchaseRequisition, PurchaseRequisitionStatusEnum.ORDER_TRANSFORMED, pr -> {
            pr.setTransformedType("O");
            pr.setTransformedNo(orderNo);
        });
        Date now = new Date();
        purchaseRequisition.getPurchaseRequisitionItemList().stream().forEach(item -> this.purchaseRequisitionItemService.update((PurchaseRequisitionItem)item, it -> {
            it.setOrderNoWx(orderNo);
            it.setPurOrderNo(orderNo);
            it.setPurOrderingDate(now);
        }));
        this.orderBudgetHandleService.ordering(purchaseRequisition);
        if (purchaseRequisition.getPurchaseRequisitionItemList().stream().filter(item -> Objects.equals((Object)item.getPrepay(), (Object)1)).count() > 0L) {
            this.prepay(purchaseRequisition);
        }
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    @Transactional
    public List<PurchaseRequisitionHead> toQuotation(List<PurchaseRequisitionHead> purchaseRequisitionList, String templateId) {
        purchaseRequisitionList.forEach(purchaseRequisition -> {
            PurOrder purOrder = new PurOrder();
            purOrder.setOrderNo(this.generateCodeService.getNextCode("INQUIRY_ORDER_CODE"));
            purOrder.setPurOrderNo(purchaseRequisition.getApplyNo());
            purOrder.setTemplateId(templateId);
            List targetList = purchaseRequisition.getPurchaseRequisitionItemList().stream().filter(FilterUtils.distinctBy(PurchaseRequisitionItem::getMaterialCode)).map(item -> {
                Material material = Optional.ofNullable(this.materialService.queryObjByCode(item.getMaterialCode())).orElseThrow(() -> new CommonException("\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a" + item.getMaterialCode() + "\u7684\u7269\u6599"));
                TargetM001 target = new TargetM001();
                target.buildFromMaterial(templateId, material);
                target.setQuoteType(Integer.valueOf(1));
                target.setPropertyValueList(new ArrayList());
                target.setPurchasingNum(new BigDecimal(item.getDemandAmount()));
                return target;
            }).collect(Collectors.toList());
            purOrder.setTargetList(targetList);
            ArrayList<InquirySupplier> supplierList = new ArrayList<InquirySupplier>(1);
            InquirySupplier supplier = new InquirySupplier();
            supplier.setSupCompanyId(purchaseRequisition.getSupCompanyId());
            supplier.setSupCompanyName(purchaseRequisition.getSupCompanyName());
            supplier.setSupCompanySrmCode(purchaseRequisition.getSupCompanyCode());
            supplierList.add(supplier);
            purOrder.setInquirySuppliers(supplierList);
            ArrayList<InquiryBusiCondition> conditionList = new ArrayList<InquiryBusiCondition>(1);
            InquiryBusiCondition condition = new InquiryBusiCondition();
            condition.setSupCompanyId(purchaseRequisition.getSupCompanyId());
            condition.setSupCompanyName(purchaseRequisition.getSupCompanyName());
            condition.setSupCompanySrmCode(purchaseRequisition.getSupCompanyCode());
            conditionList.add(condition);
            purOrder.setBusiConditions(conditionList);
            Optional.ofNullable(purchaseRequisition.getPurchaseRequisitionFileList()).ifPresent(fileList -> {
                List purFileList = fileList.stream().map(file -> {
                    InquiryPurFile purFile = new InquiryPurFile();
                    purFile.setType(Integer.valueOf(1));
                    purFile.setSources(Integer.valueOf(2));
                    purFile.setPurOrderItemNo("-10");
                    purFile.setAttachments(file.getAttachment());
                    return purFile;
                }).collect(Collectors.toList());
                purOrder.setPurFileList(purFileList);
            });
            CreateCommand cmd = new CreateCommand(purOrder);
            cmd.setPurUser(SpringSecurityUtils.getLoginUser());
            cmd.setPurCompany(CompanyUtils.currentCompany());
            this.inquiryCommandInvoker.invoke((AbstractInquiryCommand)cmd);
            this.updateApplyStatus((PurchaseRequisitionHead)purchaseRequisition, PurchaseRequisitionStatusEnum.QUOTATION_TRANSFORMED, pr -> {
                pr.setTransformedType("Q");
                pr.setTransformedNo(purOrder.getOrderNo());
            });
        });
        return purchaseRequisitionList;
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    @Transactional
    public List<PurchaseRequisitionHead> toBidding(List<PurchaseRequisitionHead> purchaseRequisitionList) {
        String projectId = ProjectUtils.getProjectId();
        Company currentCompnay = CompanyUtils.currentCompany();
        User currentUser = SpringSecurityUtils.getLoginUser();
        purchaseRequisitionList.forEach(purchaseRequisition -> {
            BiddingBaseVo bidding = new BiddingBaseVo();
            BiddingHeader biddingHeader = new BiddingHeader();
            biddingHeader.setPurCompanyId(currentCompnay.getId());
            biddingHeader.setPurCompanyCode(currentCompnay.getCompanyCode());
            biddingHeader.setPurCompanyName(currentCompnay.getCompanyFullName());
            biddingHeader.setPurUserId(purchaseRequisition.getManagerId());
            biddingHeader.setPurUserName(purchaseRequisition.getManagerName());
            biddingHeader.setBiddingName("\u91c7\u8d2d\u9700\u6c42\u8f6c\u62db\u6295\u6807(" + purchaseRequisition.getApplyNo() + ")");
            biddingHeader.setBiddingType("0");
            biddingHeader.setBiddingAmount(purchaseRequisition.getTotalMoney().toString());
            biddingHeader.setBiddingCurrency(purchaseRequisition.getCurrencyCode());
            biddingHeader.setBiddingSendBidder("0");
            biddingHeader.setPurUserId(purchaseRequisition.getInitiatorId());
            biddingHeader.setPurUserName(purchaseRequisition.getInitiatorName());
            biddingHeader.setAccountCode(purchaseRequisition.getInitiatorBusinessBook());
            biddingHeader.setAccountSetId(purchaseRequisition.getInitiatorAccountSetId());
            biddingHeader.setAccountSetName(purchaseRequisition.getInitiatorAccountSetName());
            biddingHeader.setInstitutionsId(purchaseRequisition.getInitiatorCompanyCode());
            biddingHeader.setInstitutionsName(purchaseRequisition.getInitiatorCompanyName());
            biddingHeader.setInTheOrganizationId(purchaseRequisition.getInitiatorOrganizationId());
            biddingHeader.setInTheOrganizationName(purchaseRequisition.getInitiatorOrganizationName());
            biddingHeader.setDepartId(purchaseRequisition.getInitiatorDeptCode());
            biddingHeader.setDepartName(purchaseRequisition.getInitiatorDeptName());
            BiddingPower biddingPower = new BiddingPower();
            biddingPower.setBiddingTendererPower("0");
            biddingHeader.setBiddingPower(biddingPower);
            BiddingMatterExample example = new BiddingMatterExample();
            example.setPageView(new PageView(1, 1));
            PageView biddingMatterPage = this.biddingMatterService.queryObjByPage((IExample)example);
            if (biddingMatterPage != null && CollectionUtils.isNotEmpty((Collection)biddingMatterPage.getQueryResult())) {
                BiddingMatter biddingMatter = (BiddingMatter)biddingMatterPage.getQueryResult().get(0);
                biddingHeader.setBiddingMatterId(biddingMatter.getId());
                biddingHeader.setBiddingMatterName(biddingMatter.getBiddingMatterName());
            }
            BiddingContent biddingContent = new BiddingContent();
            biddingContent.setProjectId(projectId);
            biddingContent.setPurCompanyId(currentCompnay.getId());
            biddingContent.setPurCompanySrmCode(currentCompnay.getCompanyCode());
            biddingContent.setPurCompanyName(currentCompnay.getCompanyFullName());
            biddingContent.setPurUserId(purchaseRequisition.getInitiatorId());
            biddingContent.setPurUserName(purchaseRequisition.getInitiatorName());
            List<PurchaseRequisitionItem> itemList = purchaseRequisition.getPurchaseRequisitionItemList();
            ArrayList<BiddingContentMatter> matterList = new ArrayList<BiddingContentMatter>(itemList.size());
            for (PurchaseRequisitionItem item : itemList) {
                BiddingContentMatter matter = new BiddingContentMatter();
                matter.setProjectId(projectId);
                matter.setPurCompanyId(currentCompnay.getId());
                matter.setPurCompanySrmCode(currentCompnay.getCompanyCode());
                matter.setPurCompanyName(currentCompnay.getCompanyFullName());
                matter.setPurUserId(purchaseRequisition.getInitiatorId());
                matter.setPurUserName(purchaseRequisition.getInitiatorName());
                matter.setCreateTime(new Date());
                Material material = this.materialService.queryObjByCode(item.getMaterialCode());
                matter.setMaterialNo(material.getMaterialCode());
                matter.setMaterialDesc(material.getDescription());
                matter.setMaterialName(material.getMaterialName());
                matter.setMaterialSpec(material.getMaterialSpecification());
                matter.setMaterialFeatures(material.getBrandName());
                matter.setUnit(material.getBasicUnit());
                matter.setDosage(Long.valueOf(item.getDemandAmount().intValue()));
                matter.setUnitPrice(item.getUnitPrice());
                matter.setSetThePrice(item.getAmountWithTax());
                matter.setCurrency(purchaseRequisition.getCurrencyCode());
                matter.setQuotationMethod("1");
                matterList.add(matter);
            }
            biddingContent.setBiddingContentMatterList(matterList);
            Optional.ofNullable(purchaseRequisition.getSupCompanyId()).ifPresent(t -> {
                ArrayList<BiddingSupplier> biddingSupplierList = new ArrayList<BiddingSupplier>(1);
                BiddingSupplier biddingSupplier = new BiddingSupplier();
                biddingSupplier.setBankAttachment("[]");
                biddingSupplier.setIsPayMoney("0");
                biddingSupplier.setPartnerRoleCode(SupplierStatusEnum.QUALIFIED.code());
                biddingSupplier.setSupCompanyId(purchaseRequisition.getSupCompanyId());
                biddingSupplier.setSupCompanySrmCode(purchaseRequisition.getSupCompanyCode());
                biddingSupplier.setSupCompanyName(purchaseRequisition.getSupCompanyName());
                biddingSupplier.setSupplierTemporaryCode(this.generateCodeService.getNextCode("SUPPLIER_TEMPORARY_CODE"));
                biddingSupplierList.add(biddingSupplier);
                bidding.setBiddingSupplierList(biddingSupplierList);
            });
            bidding.setCompany(CompanyUtils.currentCompany());
            bidding.setUser(currentUser);
            bidding.setBiddingHeader(biddingHeader);
            bidding.setBiddingContent(biddingContent);
            this.biddingHeaderService.biddingFromPurchaseRequisition(bidding);
            this.updateApplyStatus((PurchaseRequisitionHead)purchaseRequisition, PurchaseRequisitionStatusEnum.BIDDING_TRANSFORMED, pr -> {
                pr.setTransformedType("B");
                pr.setTransformedNo(biddingHeader.getBiddingNo());
            });
        });
        return purchaseRequisitionList;
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    @Transactional(noRollbackFor={CommonException.class})
    public List<PurchaseRequisitionHead> close(List<PurchaseRequisitionHead> purchaseRequisitionList) {
        purchaseRequisitionList.stream().forEach(purchaseRequisition -> {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("expensesApplyNo", purchaseRequisition.getBepApplySn());
            paramMap.put("expensesApplyType", purchaseRequisition.getBepApplyType());
            Map resultMap = this.sinolifeApiService.expensesApplyClose(paramMap);
            if (!"Y".equals(resultMap.get("flag"))) {
                throw new CommonException(String.format("\u7533\u8bf7\u5355 %s \u5173\u95ed\u5931\u8d25: %s", purchaseRequisition.getApplyNo(), resultMap.get("message")));
            }
            this.updateApplyStatus((PurchaseRequisitionHead)purchaseRequisition, PurchaseRequisitionStatusEnum.CLOSED);
        });
        return purchaseRequisitionList;
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionHead", "purchaseRequisitionItem"}, allEntries=true)
    public void updateSupplierInfo(PurchaseRequisitionHead purchaseRequisition) {
        this.updateByPrimaryKeySelective(purchaseRequisition);
    }

    @Override
    @Transactional
    @CacheEvict(value={"purchaseRequisitionHead", "purchaseRequisitionItem"}, allEntries=true)
    public void updateByPrimaryKeySelective(PurchaseRequisitionHead purchaseRequisition) {
        this.purchaseRequisitionHeadMapper.updateByPrimaryKeySelective(purchaseRequisition);
        if (CollectionUtils.isNotEmpty(purchaseRequisition.getPurchaseRequisitionItemList())) {
            purchaseRequisition.getPurchaseRequisitionItemList().stream().forEach(this.purchaseRequisitionItemService::updateByPrimaryKeySelective);
        }
    }

    @Override
    public PurchaseRequisitionHead checkOutLine(PurchaseRequisitionHead purchaseRequisition) {
        return this.checkOutAttachmentLine(this.checkOutDetailLine(purchaseRequisition));
    }

    @Override
    public PurchaseRequisitionHead checkOutLine(PurchaseRequisitionHead purchaseRequisition, boolean forceCheckOutDetailLine, boolean forceCheckoutAttachmentLine) {
        return this.checkOutAttachmentLine(this.checkOutDetailLine(purchaseRequisition, forceCheckOutDetailLine), forceCheckoutAttachmentLine);
    }

    @Override
    public PurchaseRequisitionHead checkOutDetailLine(PurchaseRequisitionHead purchaseRequisition) {
        return this.checkOutDetailLine(purchaseRequisition, false);
    }

    @Override
    public PurchaseRequisitionHead checkOutDetailLine(PurchaseRequisitionHead purchaseRequisition, boolean force) {
        if (force || CollectionUtils.isEmpty(purchaseRequisition.getPurchaseRequisitionItemList())) {
            PurchaseRequisitionItemExample itemExample = new PurchaseRequisitionItemExample();
            itemExample.or().andHeadIdEqualTo(purchaseRequisition.getId());
            List itemList = this.purchaseRequisitionItemService.queryAllObjByExample((IExample)itemExample);
            purchaseRequisition.setPurchaseRequisitionItemList(itemList);
        }
        return purchaseRequisition;
    }

    @Override
    public PurchaseRequisitionHead checkOutAttachmentLine(PurchaseRequisitionHead purchaseRequisition) {
        return this.checkOutAttachmentLine(purchaseRequisition, false);
    }

    @Override
    public PurchaseRequisitionHead checkOutAttachmentLine(PurchaseRequisitionHead purchaseRequisition, boolean force) {
        if (force || purchaseRequisition.getPurchaseRequisitionFileList() == null) {
            PurchaseRequisitionFileExample fileExample = new PurchaseRequisitionFileExample();
            fileExample.or().andHeadIdEqualTo(purchaseRequisition.getId()).andIsEnableEqualTo(Constant.YES_INT);
            List fileList = this.purchaseRequisitionFileService.queryAllObjByExample((IExample)fileExample);
            purchaseRequisition.setPurchaseRequisitionFileList(fileList);
        }
        return purchaseRequisition;
    }

    @Override
    @Transactional
    @CacheEvict(value={"purchaseRequisitionHead", "purchaseRequisitionItem"})
    public void updateMarketPriceIfNecessary(PurchaseRequisitionHead purchaseRequisition, boolean save) {
        if (ObjectUtils.equalsOne((Object)purchaseRequisition.getApplyStatusCode(), (Object[])new Object[]{PurchaseRequisitionStatusEnum.APPROVED.code(), PurchaseRequisitionStatusEnum.ADJUSTMENT_REQUIRED.code(), PurchaseRequisitionStatusEnum.ORDER_TRANSFORMED.code()})) {
            return;
        }
        if (ProductOriginEnum.JD.getValue().equals(purchaseRequisition.getDataSource())) {
            ObjectHolder updateRequired = ObjectHolder.of((Object)false);
            purchaseRequisition.getPurchaseRequisitionItemList().stream().filter(item -> StringUtils.isNotBlank((String)item.getProductCodeWx())).forEach(item -> {
                PurchaseProductInventoryExample example = new PurchaseProductInventoryExample();
                example.createCriteria().andProductCodeWxEqualTo(item.getProductCodeWx()).andIsEnableEqualTo(Constant.YES_INT);
                Optional.ofNullable(this.purchaseProductInventoryService.queryAllObjByExample((IExample)example)).filter(CollectionUtils::isNotEmpty).ifPresent(list -> {
                    BigDecimal marketPrice = ((PurchaseProductInventory)list.get(0)).getProductPrice();
                    if (!Objects.equals((Object)item.getMarketUnitPrice(), (Object)marketPrice)) {
                        updateRequired.value = true;
                        item.setMarketUnitPrice(marketPrice);
                        if (item.getDemandAmount() != null) {
                            BigDecimal demandAmount = new BigDecimal(item.getDemandAmount());
                            item.setMarketPrice((BigDecimal)BigDecimalFunction.MULTIPLY.apply(marketPrice, demandAmount));
                            item.setPrepayAmount((BigDecimal)BigDecimalFunction.ADD.apply(item.getMarketPrice(), item.getFreight()));
                        }
                    }
                });
            });
            if (((Boolean)updateRequired.value).booleanValue()) {
                purchaseRequisition.getPurchaseRequisitionItemList().stream().filter(item -> item.getMarketPrice() != null && item.getFreight() != null).map(item -> (BigDecimal)BigDecimalFunction.ADD.apply(item.getMarketPrice(), item.getFreight())).reduce(BigDecimalFunction.ADD).ifPresent(purchaseRequisition::setMarketTotalPrice);
                if (save) {
                    this.purchaseRequisitionHeadMapper.updateByPrimaryKey(purchaseRequisition);
                    purchaseRequisition.getPurchaseRequisitionItemList().stream().forEach(this.purchaseRequisitionItemService::updateByPrimaryKeySelective);
                }
            }
        }
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionHead", "purchaseRequisitionItem"}, allEntries=true)
    public void prepay(PurchaseRequisitionHead purchaseRequisition) {
        Assert.isNotNull((Object)purchaseRequisition, (String)"\u91c7\u8d2d\u7533\u8bf7\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(purchaseRequisition.getPurchaseRequisitionItemList(), (String)"\u91c7\u8d2d\u7533\u8bf7\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        boolean isJdPurchaseRequisition = ProductOriginEnum.isJD((String)purchaseRequisition.getDataSource());
        LinkedList toBeUpdatedList = new LinkedList();
        Map paramMap = Optional.ofNullable(purchaseRequisition).map(head -> {
            ObjectHolder isAdjust = ObjectHolder.of((Object)"N");
            HashMap<String, Object> pm = new HashMap<String, Object>();
            pm.put("expensesApplyNo", head.getBepApplySn());
            pm.put("applySource", "3");
            List lendApplyDetailList = head.getPurchaseRequisitionItemList().stream().filter(item -> Objects.equals((Object)item.getPrepay(), (Object)1)).map(item -> {
                if (isJdPurchaseRequisition) {
                    BigDecimal freight = item.getFreight() != null ? item.getFreight() : BigDecimal.ZERO;
                    BigDecimal prepayAmount = freight.add(item.getAmountWithTax());
                    isAdjust.value = "Y";
                    item.setPrepayAmount(prepayAmount);
                    toBeUpdatedList.add(item);
                }
                HashMap<String, Number> lendApplyDetail = new HashMap<String, Number>();
                lendApplyDetail.put("lendSeq", item.getItemNo());
                lendApplyDetail.put("applyAmount", item.getPrepayAmount());
                return lendApplyDetail;
            }).collect(Collectors.toList());
            pm.put("isAdjust", isAdjust.value);
            pm.put("lendApplyDetailList", lendApplyDetailList);
            return pm;
        }).orElse(Collections.emptyMap());
        Map resultMap = this.sinolifeApiService.transactionInitiation(paramMap);
        if (!"Y".equals(resultMap.get("flag"))) {
            throw new CommonException("\u53d1\u8d77\u9884\u4ed8\u5931\u8d25,\u539f\u56e0: " + resultMap.get("message"));
        }
        this.updateApplyStatus(purchaseRequisition, PurchaseRequisitionStatusEnum.PREPAYING, pr -> pr.setPrepayStatus(1));
        toBeUpdatedList.stream().forEach(item -> this.purchaseRequisitionItemService.update((PurchaseRequisitionItem)item, it -> it.setPrepayAmount(item.getPrepayAmount())));
    }

    private void removeDeletedLine(PurchaseRequisitionHead purchaseRequisition) {
        List itemIdList = purchaseRequisition.getPurchaseRequisitionItemList().stream().map(PurchaseRequisitionItem::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(itemIdList)) {
            PurchaseRequisitionItemExample itemExample = new PurchaseRequisitionItemExample();
            itemExample.createCriteria().andHeadIdEqualTo(purchaseRequisition.getId()).andIdNotIn(itemIdList);
            this.purchaseRequisitionItemService.deleteByExample((IExample)itemExample);
        }
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionHead", "purchaseRequisitionItem"}, allEntries=true)
    @Transactional
    public PurchaseRequisitionHead adjustRequisition(PurchaseRequisitionHead purchaseRequisition) {
        PurchaseRequisitionHead old = this.queryObjById(purchaseRequisition.getId());
        this.checkOutLine(old);
        Map<String, PurchaseRequisitionItem> oldItemMap = old.getPurchaseRequisitionItemList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        this.purchaseRequisitionItemService.calcFreight(purchaseRequisition.getPurchaseRequisitionItemList());
        purchaseRequisition.getPurchaseRequisitionItemList().stream().forEach(item -> {
            BigDecimal freight;
            PurchaseRequisitionItem oldItem = (PurchaseRequisitionItem)oldItemMap.get(item.getId());
            BigDecimal bigDecimal = freight = item.getFreight() != null ? item.getFreight() : BigDecimal.ZERO;
            if (oldItem.getPrepayAmount().compareTo(item.getAmountWithTax().add(freight)) == -1) {
                throw new CommonException("\u6bcf\u884c\u7684\u542b\u7a0e\u91d1\u989d\u4e0e\u8fd0\u8d39\u4e4b\u548c\u4e0d\u80fd\u5927\u4e8e\u8be5\u884c\u7684\u9884\u4ed8\u91d1\u989d!");
            }
        });
        this.updateByPrimaryKeySelective(purchaseRequisition);
        ArrayList<PurchaseRequisitionHead> purchaseRequisitionList = new ArrayList<PurchaseRequisitionHead>(1);
        purchaseRequisitionList.add(purchaseRequisition);
        this.toOrder(purchaseRequisitionList);
        this.removeDeletedLine(purchaseRequisition);
        return purchaseRequisition;
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    public PurchaseRequisitionHead updateApplyStatus(PurchaseRequisitionHead purchaseRequisition, PurchaseRequisitionStatusEnum status) {
        return this.updateApplyStatus(purchaseRequisition, status, null);
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    public PurchaseRequisitionHead updateApplyStatus(PurchaseRequisitionHead purchaseRequisition, PurchaseRequisitionStatusEnum status, Consumer<PurchaseRequisitionHead> extraSetter) {
        Date now = new Date();
        purchaseRequisition.setApplyStatusCode(status.code());
        purchaseRequisition.setApplyStatusDesc(status.desc());
        purchaseRequisition.setUpdateTime(now);
        PurchaseRequisitionHead updateVO = new PurchaseRequisitionHead();
        updateVO.setId(purchaseRequisition.getId());
        updateVO.setApplyStatusCode(status.code());
        updateVO.setApplyStatusDesc(status.desc());
        updateVO.setUpdateTime(now);
        if (extraSetter != null) {
            extraSetter.accept(updateVO);
            extraSetter.accept(purchaseRequisition);
        }
        this.purchaseRequisitionHeadMapper.updateByPrimaryKeySelective(updateVO);
        return purchaseRequisition;
    }

    @Override
    @Transactional
    @CacheEvict(value={"purchaseRequisitionHead"}, allEntries=true)
    public void updateByPrimaryKey(PurchaseRequisitionHead purchaseRequisition) {
        this.purchaseRequisitionHeadMapper.updateByPrimaryKey(purchaseRequisition);
    }

    @Override
    public BigDecimal calcTotalMoney(PurchaseRequisitionHead purchaseRequisition) {
        this.checkOutDetailLine(purchaseRequisition);
        ObjectHolder totalMoney = ObjectHolder.of((Object)BigDecimal.ZERO);
        purchaseRequisition.getPurchaseRequisitionItemList().stream().filter(item -> item.getAmountWithTax() != null).forEach(item -> {
            BigDecimal freight = item.getFreight() != null ? item.getFreight() : BigDecimal.ZERO;
            totalMoney.value = ((BigDecimal)totalMoney.value).add(item.getAmountWithTax()).add(freight);
        });
        purchaseRequisition.setTotalMoney((BigDecimal)totalMoney.value);
        return (BigDecimal)totalMoney.value;
    }

    @Override
    public List<BiddingFollowableHistoryVO> findFollowableBiddingHistory(PurchaseRequisitionHead purchaseRequisition) {
        List<PurchaseRequisitionItem> itemList = purchaseRequisition.getPurchaseRequisitionItemList();
        List materialCodeList = itemList.stream().map(PurchaseRequisitionItem::getMaterialCode).collect(Collectors.toList());
        BiddingHeaderExample biddingHeaderExample = new BiddingHeaderExample();
        biddingHeaderExample.or().andInTheOrganizationIdEqualTo(purchaseRequisition.getManagerOrganizationId()).andBiddingAuditstatusEqualTo(ApprovalStatusEnum.ADOPT_APPROVAL.getValue()).andBiddingStatusEqualTo(TenderStatusEumn.ISFINISH.getValue());
        List biddingHeaderList = this.biddingHeaderService.queryAllObjByExample((IExample)biddingHeaderExample);
        if (CollectionUtils.isEmpty((Collection)biddingHeaderList)) {
            return Collections.emptyList();
        }
        LinkedList<BiddingFollowableHistoryVO> result = new LinkedList<BiddingFollowableHistoryVO>();
        biddingHeaderList.stream().forEach(biddingHeader -> {
            BiddingOfferExample biddingOfferExample = new BiddingOfferExample();
            biddingOfferExample.or().andBiddingNoEqualTo(biddingHeader.getBiddingNo()).andRequirementTypeCodeEqualTo("material").andIsBiddingEqualTo(Constant.YES_INT.toString()).andBiddingRoundsNumberEqualTo(biddingHeader.getBiddingCurrentRound());
            List biddingOfferList = this.biddingOfferService.queryAllObjByExample((IExample)biddingOfferExample);
            if (CollectionUtils.isNotEmpty((Collection)biddingOfferList)) {
                Set biddingMaterialCodeList = biddingOfferList.stream().map(BiddingOffer::getProjectNo).collect(Collectors.toSet());
                biddingMaterialCodeList.addAll(materialCodeList);
                if (biddingOfferList.size() == biddingMaterialCodeList.size()) {
                    BiddingFollowableHistoryVO history = new BiddingFollowableHistoryVO();
                    history.setBiddingId(biddingHeader.getId());
                    history.setBiddingNo(biddingHeader.getBiddingNo());
                    history.setSupCompanyCode(((BiddingOffer)biddingOfferList.get(0)).getSupCompanySrmCode());
                    history.setSupCompanyName(((BiddingOffer)biddingOfferList.get(0)).getSupCompanyName());
                    history.setTotalMoney(this.calcTotalMoneyForBidding(itemList, biddingOfferList));
                    result.add(history);
                }
            }
        });
        result.sort((a, b) -> a.getTotalMoney().compareTo(b.getTotalMoney()));
        return result;
    }

    @Override
    @Transactional
    @CacheEvict(value={"purchaseRequisitionHead", "purchaseRequisitionItem"}, allEntries=true)
    public void followBiddingHistory(PurchaseRequisitionHead purchaseRequisition, BiddingFollowableHistoryVO history) {
        List<BiddingOffer> biddingOfferList = this.checkBiddingHistoryFollowable(purchaseRequisition, history);
        Map<String, List<BiddingOffer>> materialOfferMap = biddingOfferList.stream().collect(Collectors.groupingBy(BiddingOffer::getProjectNo));
        ObjectHolder totalMoney = ObjectHolder.of((Object)BigDecimal.ZERO);
        purchaseRequisition.getPurchaseRequisitionItemList().stream().forEach(item -> {
            BiddingOffer biddingOffer = (BiddingOffer)((List)materialOfferMap.get(item.getMaterialCode())).get(0);
            BigDecimal unitPrice = new BigDecimal(biddingOffer.getOfferUnitPrice());
            BigDecimal amount = new BigDecimal(item.getDemandAmount());
            BigDecimal amountWithTax = (BigDecimal)BigDecimalFunction.MULTIPLY.apply(unitPrice, amount);
            totalMoney.value = BigDecimalFunction.ADD.apply(totalMoney.value, amountWithTax);
            this.purchaseRequisitionItemService.update((PurchaseRequisitionItem)item, it -> {
                it.setSupCompanyId(biddingOffer.getSupCompanyId());
                it.setSupCompanyCode(biddingOffer.getSupCompanySrmCode());
                it.setSupCompanyName(biddingOffer.getSupCompanyName());
                it.setUnitPrice(unitPrice);
                it.setAmountWithTax(amountWithTax);
            });
        });
        this.updateApplyStatus(purchaseRequisition, PurchaseRequisitionStatusEnum.BIDDING_FINISHED, pr -> {
            BiddingOffer biddingOffer = (BiddingOffer)biddingOfferList.get(0);
            pr.setSupCompanyId(biddingOffer.getSupCompanyId());
            pr.setSupCompanyCode(biddingOffer.getSupCompanySrmCode());
            pr.setSupCompanyName(biddingOffer.getSupCompanyName());
            pr.setTransformedType("B");
            pr.setTransformedNo(history.getBiddingNo());
            pr.setFollowedBiddingNo(history.getBiddingNo());
            pr.setTotalMoney((BigDecimal)totalMoney.value);
        });
    }

    @Override
    public PurchaseRequisitionHead findByApplyNo(String applyNo) {
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.createCriteria().andApplyNoEqualTo(applyNo);
        List<PurchaseRequisitionHead> list = this.queryAllObjByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    private BigDecimal calcTotalMoneyForBidding(List<PurchaseRequisitionItem> itemList, List<BiddingOffer> offerList) {
        Map<String, List<BiddingOffer>> materialOfferMap = offerList.stream().collect(Collectors.groupingBy(BiddingOffer::getProjectNo));
        ObjectHolder totalMoney = ObjectHolder.of((Object)BigDecimal.ZERO);
        itemList.stream().forEach(purchaseRequisitionItem -> {
            String materialCode = purchaseRequisitionItem.getMaterialCode();
            List list = (List)materialOfferMap.get(materialCode);
            BigDecimal unitPrice = new BigDecimal(((BiddingOffer)list.get(0)).getOfferUnitPrice());
            BigDecimal amount = new BigDecimal(purchaseRequisitionItem.getDemandAmount());
            BigDecimal amountWithTax = (BigDecimal)BigDecimalFunction.MULTIPLY.apply(unitPrice, amount);
            totalMoney.value = BigDecimalFunction.ADD.apply(totalMoney.value, amountWithTax);
        });
        return (BigDecimal)totalMoney.value;
    }

    private List<BiddingOffer> checkBiddingHistoryFollowable(PurchaseRequisitionHead purchaseRequisition, BiddingFollowableHistoryVO history) {
        BiddingHeader biddingHeader = (BiddingHeader)this.biddingHeaderService.queryObjById((Object)history.getBiddingId());
        Assert.isNotNull((Object)biddingHeader, (String)("\u4e0d\u5b58\u5728ID\u4e3a" + history.getBiddingId() + "\u7684\u62db\u6807\u5355"));
        if (!Objects.equals((Object)purchaseRequisition.getManagerOrganizationId(), (Object)biddingHeader.getInTheOrganizationId())) {
            throw new CommonException("\u4e0d\u80fd\u6cbf\u7528\u5176\u5b83\u673a\u6784\u7684\u62db\u6807\u5355");
        }
        if (!ApprovalStatusEnum.ADOPT_APPROVAL.getValue().equals(biddingHeader.getBiddingAuditstatus())) {
            throw new CommonException("\u4e0d\u80fd\u6cbf\u7528\u5b9a\u6807\u672a\u5ba1\u6279\u901a\u8fc7\u7684\u62db\u6807\u5355");
        }
        if (!TenderStatusEumn.ISFINISH.getValue().equals(biddingHeader.getBiddingStatus())) {
            throw new CommonException("\u4e0d\u80fd\u6cbf\u7528\u672a\u7ed3\u6848\u7684\u62db\u6807\u5355");
        }
        BiddingOfferExample biddingOfferExample = new BiddingOfferExample();
        biddingOfferExample.or().andBiddingNoEqualTo(biddingHeader.getBiddingNo()).andRequirementTypeCodeEqualTo("material").andIsBiddingEqualTo(Constant.YES_INT.toString()).andBiddingRoundsNumberEqualTo(biddingHeader.getBiddingCurrentRound());
        List biddingOfferList = this.biddingOfferService.queryAllObjByExample((IExample)biddingOfferExample);
        if (CollectionUtils.isEmpty((Collection)biddingOfferList)) {
            throw new CommonException("\u8be5\u62db\u6807\u5355\u6ca1\u6709\u4e2d\u6807\u4f9b\u5e94\u5546,\u4e0d\u80fd\u6cbf\u7528");
        }
        List materialCodeList = purchaseRequisition.getPurchaseRequisitionItemList().stream().map(PurchaseRequisitionItem::getMaterialCode).collect(Collectors.toList());
        Set biddingMaterialCodeList = biddingOfferList.stream().map(BiddingOffer::getProjectNo).collect(Collectors.toSet());
        biddingMaterialCodeList.addAll(materialCodeList);
        if (biddingOfferList.size() != biddingMaterialCodeList.size()) {
            throw new CommonException("\u91c7\u8d2d\u7533\u8bf7\u4e2d\u5305\u542b\u4e86\u8be5\u62db\u6807\u5355\u4e2d\u4e0d\u5305\u542b\u7684\u7269\u6599,\u4e0d\u80fd\u6cbf\u7528");
        }
        return biddingOfferList;
    }
}

