/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.utils.SectionUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.purchase.entity.PurchaseBargainConfig;
import com.els.base.purchase.entity.PurchaseBargainConfigExample;
import com.els.base.purchase.enumerate.PurchaseBarginTypeEnum;
import com.els.base.purchase.service.PurchaseBargainConfigService;
import com.els.base.purchase.vo.PurchaseBargainConfigVO;
import com.els.base.purchase.vo.PurchaseBargainConfigVOExample;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u91c7\u8d2d\u7533\u8bf7\u8bae\u4ef7\u65b9\u5f0f\u914d\u7f6e"})
@Controller
@RequestMapping(value={"purchaseBargainConfig"})
public class PurchaseBargainConfigController {
    @Resource
    protected PurchaseBargainConfigService purchaseBargainConfigService;

    @ApiOperation(httpMethod="POST", value="\u914d\u7f6e\u91c7\u8d2d\u7533\u8bf7\u8bae\u4ef7\u65b9\u5f0f")
    @RequestMapping(value={"service/config"})
    @ResponseBody
    public ResponseResult<String> config(@RequestBody List<PurchaseBargainConfig> configList) {
        Assert.isNotEmpty(configList, (String)"\u914d\u7f6e\u5931\u8d25,\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        User currentUser = SpringSecurityUtils.getLoginUser();
        String projectId = ProjectUtils.getProjectId();
        String companyId = CompanyUtils.currentCompanyId();
        Date now = new Date();
        SectionUtils.clear();
        HashSet branchIdSet = new HashSet();
        configList.forEach(config -> {
            Assert.isNotNull((Object)config.getBranchId(), (String)"\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
            branchIdSet.add(config.getBranchId());
            if (branchIdSet.size() > 1) {
                throw new CommonException("\u4e0d\u80fd\u540c\u65f6\u914d\u7f6e\u591a\u4e2a\u673a\u6784");
            }
            PurchaseBarginTypeEnum.check(config.getBargainType());
            try {
                SectionUtils.add((SectionUtils.Section)SectionUtils.Section.of((BigDecimal)config.getFromPrice(), (BigDecimal)config.getToPrice()));
            }
            catch (IllegalArgumentException e) {
                throw new CommonException("\u5f00\u59cb\u91d1\u989d\u8ddf\u7ed3\u675f\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            catch (SectionUtils.SectionStartGreatThanEndException e) {
                throw new CommonException("\u91d1\u989d\u5230\u4e0d\u80fd\u5c0f\u4e8e\u91d1\u989d\u4ece:[" + e.getFrom() + ", " + e.getTo() + ")");
            }
            catch (SectionUtils.SectionIntersectException e) {
                throw new CommonException("\u533a\u95f4\u91d1\u989d" + e.getSection1() + "\u4e0e\u533a\u95f4\u91d1\u989d" + e.getSection2() + "\u76f8\u4ea4");
            }
            config.setProjectId(projectId);
            config.setCompanyId(companyId);
            config.setCreateUserId(currentUser.getId());
            config.setCreateUserName(currentUser.getNickName());
            config.setCreateTime(now);
        });
        this.purchaseBargainConfigService.config(configList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636eID\u5220\u9664\u91c7\u8d2d\u7533\u8bf7\u8bae\u4ef7\u65b9\u5f0f")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        PurchaseBargainConfigExample example = new PurchaseBargainConfigExample();
        example.createCriteria().andIdIn((List)ids);
        this.purchaseBargainConfigService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u673a\u6784ID\u5220\u9664\u91c7\u8d2d\u7533\u8bf7\u8bae\u4ef7\u65b9\u5f0f")
    @RequestMapping(value={"service/deleteByBranchIds"})
    @ResponseBody
    public ResponseResult<String> deleteByBranchIds(@RequestBody(required=true) List<String> branchIds) {
        Assert.isNotEmpty(branchIds, (String)"\u5220\u9664\u5931\u8d25,branchId\u4e0d\u80fd\u4e3a\u7a7a");
        PurchaseBargainConfigExample example = new PurchaseBargainConfigExample();
        example.createCriteria().andBranchIdIn((List)branchIds);
        this.purchaseBargainConfigService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u8bae\u4ef7\u65b9\u5f0f\u914d\u7f6e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseBargainConfig", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseBargainConfig>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseBargainConfigExample example = new PurchaseBargainConfigExample();
        example.setPageView((PageView<PurchaseBargainConfig>)new PageView(pageNo, pageSize));
        example.setOrderByClause("BRANCH_ID ASC, FROM_PRICE ASC");
        example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purchaseBargainConfigService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u8bae\u4ef7\u65b9\u5f0f\u914d\u7f6e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseBargainConfig", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findTreeByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseBargainConfigVO>> findTreeByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseBargainConfigVOExample example = new PurchaseBargainConfigVOExample();
        example.setPageView((PageView<PurchaseBargainConfigVO>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView<PurchaseBargainConfigVO> pageData = this.purchaseBargainConfigService.findTreeByPage(example);
        Optional.ofNullable(pageData.getQueryResult()).ifPresent(list -> list.forEach(vo -> {
            PurchaseBargainConfigExample example2 = new PurchaseBargainConfigExample();
            example2.createCriteria().andBranchIdEqualTo(vo.getBranchId());
            example2.setOrderByClause("FROM_PRICE ASC");
            List configList = this.purchaseBargainConfigService.queryAllObjByExample((IExample)example2);
            vo.setConfigList(configList);
        }));
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u6307\u5b9a\u673a\u6784\u7684\u91c7\u8d2d\u7533\u8bf7\u8bae\u4ef7\u65b9\u5f0f\u914d\u7f6e")
    @GetMapping(value={"service/findByBranchId"})
    @ResponseBody
    public ResponseResult<List<PurchaseBargainConfig>> findByBranchId(@RequestParam(required=false) String branchId) {
        Assert.isNotBlank((String)branchId, (String)"\u8981\u67e5\u8be2\u7684\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        PurchaseBargainConfigExample example = new PurchaseBargainConfigExample();
        example.createCriteria().andBranchIdEqualTo(branchId);
        example.setOrderByClause("FROM_PRICE ASC");
        List configList = this.purchaseBargainConfigService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)configList);
    }

    @ApiOperation(httpMethod="GET", value="\u901a\u8fc7\u673a\u6784ID\u548c\u7533\u8bf7\u603b\u91d1\u989d\u83b7\u53d6\u8bae\u4ef7\u65b9\u5f0f,\u8fd4\u56denull\u4ee3\u8868\u65e0")
    @GetMapping(value={"service/determine"})
    @ResponseBody
    public ResponseResult<PurchaseBargainConfig> determineBargainType(String branchId, BigDecimal amount) {
        Assert.isNotBlank((String)branchId, (String)"\u8981\u67e5\u8be2\u7684\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)amount, (String)"\u7533\u8bf7\u603b\u91d1\u989d(amount)\u4e0d\u80fd\u4e3a\u7a7a");
        List ids = CompanyUtils.findCompanyByInstitutionId(Arrays.asList(branchId));
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return ResponseResult.success(null);
        }
        PurchaseBargainConfig bargainConfig = this.purchaseBargainConfigService.determineBargainType(branchId, amount);
        return ResponseResult.success((Object)bargainConfig);
    }
}

