/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command;

import cn.hutool.core.bean.BeanUtil;
import com.els.base.certification.contacts.entity.Contacts;
import com.els.base.certification.contacts.service.ContactsService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.ObjectUtils;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.material.entity.Material;
import com.els.base.material.service.MaterialService;
import com.els.base.product.entity.PurchaseUserOrderItemExtExample;
import com.els.base.product.service.PurchaseProductService;
import com.els.base.product.service.PurchaseUserOrderItemExtService;
import com.els.base.purchase.dao.PurchaseRequisitionHeadMapper;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseRequisitionHead;
import com.els.base.purchase.entity.PurchaseRequisitionItem;
import com.els.base.purchase.entity.PurchaseRequisitionItemExample;
import com.els.base.purchase.enumerate.PurchaseRequisitionStatusEnum;
import com.els.base.purchase.event.QixinOrderPassEvent;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.service.PurchaseRequisitionHeadService;
import com.els.base.purchase.service.PurchaseRequisitionItemService;
import com.els.base.purchase.vo.PurchaseRequisitionEventVO;
import com.els.base.utils.SpringContextHolder;
import com.els.comix.entity.QixinBaseGoodsInfo;
import com.els.comix.entity.QixinBaseGoodsInfoExample;
import com.els.comix.service.ComixApiService;
import com.els.comix.service.QixinBaseGoodsInfoService;
import com.els.comix.vo.MsgHeader;
import com.els.comix.vo.baseGoodsInfo.BasicGoodsInfos;
import com.els.comix.vo.submitOrder.DeliveryInfo;
import com.els.comix.vo.submitOrder.InvoiceInfo;
import com.els.comix.vo.submitOrder.RecipientsInfo;
import com.els.comix.vo.submitOrder.SubmitOrderHeader;
import com.els.comix.vo.submitOrder.SubmitOrderItem;
import com.els.comix.vo.submitOrder.SubmitOrderResult;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.scheduling.annotation.Async;
import org.springframework.transaction.annotation.Transactional;

public class QixinOrderCommand
extends BaseCommand<String> {
    private GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
    private MaterialService materialService = (MaterialService)SpringContextHolder.getOneBean(MaterialService.class);
    private PurchaseProductService purchaseProductService = (PurchaseProductService)SpringContextHolder.getOneBean(PurchaseProductService.class);
    private CompanyService companyService = (CompanyService)SpringContextHolder.getOneBean(CompanyService.class);
    private CompanyUserRefService companyUserRefService = (CompanyUserRefService)SpringContextHolder.getOneBean(CompanyUserRefService.class);
    private ContactsService contactsService = (ContactsService)SpringContextHolder.getOneBean(ContactsService.class);
    private PurchaseRequisitionItemService purchaseRequisitionItemService = (PurchaseRequisitionItemService)SpringContextHolder.getOneBean(PurchaseRequisitionItemService.class);
    private QixinBaseGoodsInfoService qixinBaseGoodsInfoService = (QixinBaseGoodsInfoService)SpringContextHolder.getOneBean(QixinBaseGoodsInfoService.class);
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private PurchaseOrderService purchaseOrderService = (PurchaseOrderService)SpringContextHolder.getOneBean(PurchaseOrderService.class);
    private PurchaseRequisitionHeadMapper purchaseRequisitionHeadMapper = (PurchaseRequisitionHeadMapper)SpringContextHolder.getOneBean(PurchaseRequisitionHeadMapper.class);
    private ComixApiService comixApiService = (ComixApiService)SpringContextHolder.getOneBean(ComixApiService.class);
    private PurchaseUserOrderItemExtService purchaseUserOrderItemExtService = (PurchaseUserOrderItemExtService)SpringContextHolder.getOneBean(PurchaseUserOrderItemExtService.class);
    private PurchaseRequisitionHeadService purchaseRequisitionHeadService = (PurchaseRequisitionHeadService)SpringContextHolder.getOneBean(PurchaseRequisitionHeadService.class);
    private PurchaseRequisitionEventVO purchaseRequisitionEventVO;

    public QixinOrderCommand() {
    }

    public QixinOrderCommand(PurchaseRequisitionEventVO purchaseRequisitionEventVO) {
        this.purchaseRequisitionEventVO = purchaseRequisitionEventVO;
    }

    @Async
    @Transactional
    public String execute(ICommandInvoker iCommandInvoker) {
        this.logger.debug("\u8fdb\u5165QixinOrderCommand\u7c7bexecute\u65b9\u6cd5");
        this.place(this.purchaseRequisitionEventVO);
        SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)new QixinOrderPassEvent(this.purchaseRequisitionEventVO));
        return null;
    }

    private void place(PurchaseRequisitionEventVO purchaseRequisitionEventVO) {
        String projectId = purchaseRequisitionEventVO.getProjectId();
        PurchaseRequisitionHead purchaseRequisitionHead = purchaseRequisitionEventVO.getPurchaseRequisitionHead();
        Company currentCompnay = purchaseRequisitionEventVO.getCompany();
        User loginUser = new User();
        List<PurchaseRequisitionHead> purchaseRequisitionList = purchaseRequisitionEventVO.getPurchaseRequisitionHeadList();
        loginUser.setId(purchaseRequisitionList.get(0).getInitiatorId());
        loginUser.setNickName(purchaseRequisitionList.get(0).getInitiatorName());
        purchaseRequisitionList.forEach(purchaseRequisition -> {
            PurchaseOrder order = new PurchaseOrder();
            order.setProjectId(projectId);
            order.setPurchaseApplyNo(purchaseRequisition.getApplyNo());
            order.setBepVoucherNo(purchaseRequisition.getBepApplyNo());
            order.setExpensesApplyNo(purchaseRequisition.getBepApplySn());
            Company supCompany = (Company)this.companyService.queryObjById((Object)purchaseRequisition.getSupCompanyId());
            order.setSupCompanyId(supCompany.getId());
            order.setSupCompanyName(supCompany.getCompanyFullName());
            order.setSupCompanyShortName(supCompany.getCompanyName());
            order.setSupCompanySrmCode(supCompany.getCompanyCode());
            User supUser = this.companyUserRefService.queryMainUserOfCompany(supCompany.getId());
            order.setSupUserId(supUser.getId());
            order.setSupUserName(supUser.getNickName());
            List contacts = this.contactsService.queryAllContacts(supCompany.getId());
            if (CollectionUtils.isNotEmpty((Collection)contacts)) {
                order.setSupplierPerson(((Contacts)contacts.get(0)).getName());
                order.setSupplierTel(((Contacts)contacts.get(0)).getMobilePhone());
                order.setSupplierFax(((Contacts)contacts.get(0)).getFax());
            }
            order.setPurPlanerId(loginUser.getId());
            order.setPurPlanerName(loginUser.getNickName());
            order.setAccountCode(purchaseRequisition.getInitiatorBusinessBook());
            order.setAccountSetId(purchaseRequisition.getInitiatorAccountSetId());
            order.setAccountSetName(purchaseRequisition.getInitiatorAccountSetName());
            order.setInstitutionsId(purchaseRequisition.getInitiatorCompanyCode());
            order.setInstitutionsName(purchaseRequisition.getInitiatorCompanyName());
            order.setInTheOrganizationId(purchaseRequisition.getInitiatorOrganizationId());
            order.setInTheOrganizationName(purchaseRequisition.getInitiatorOrganizationName());
            order.setDepartId(purchaseRequisition.getInitiatorDeptCode());
            order.setDepartName(purchaseRequisition.getInitiatorDeptName());
            order.setCurrency(purchaseRequisition.getCurrencyCode());
            order.setContractNumber(purchaseRequisition.getContractNo());
            order.setDataSource(purchaseRequisition.getDataSource());
            order.setTaxTotalPrice(purchaseRequisition.getTotalMoney());
            order.setOrderTotal(purchaseRequisition.getTotalMoney());
            Map<Object, List<PurchaseRequisitionItem>> detailmapQiXin = purchaseRequisition.getPurchaseRequisitionItemList().stream().collect(Collectors.groupingBy(d -> this.fetchGroupKey((PurchaseRequisitionItem)d)));
            boolean qixin = true;
            qixin = this.checkQixinPrice(detailmapQiXin, qixin);
            if (qixin) {
                for (Object key : detailmapQiXin.keySet()) {
                    ArrayList<SubmitOrderItem> orderProducts = new ArrayList<SubmitOrderItem>();
                    ArrayList<String> qiXinProductList = new ArrayList<String>();
                    List<PurchaseRequisitionItem> purchaseRequisitionItemValue = detailmapQiXin.get(key);
                    ArrayList<PurchaseOrderItem> orderList = new ArrayList<PurchaseOrderItem>();
                    for (PurchaseRequisitionItem item : purchaseRequisitionItemValue) {
                        SubmitOrderItem orderItem = new SubmitOrderItem();
                        qiXinProductList.add(item.getProductCodeWx());
                        orderItem.setProductNo(item.getProductCodeWx());
                        QixinBaseGoodsInfoExample goodsInfoExample = new QixinBaseGoodsInfoExample();
                        goodsInfoExample.createCriteria().andProductNoEqualTo(item.getProductCodeWx());
                        List list = this.qixinBaseGoodsInfoService.queryAllObjByExample((IExample)goodsInfoExample);
                        orderItem.setProductNum(item.getDemandAmount() + "");
                        orderItem.setPriceType("1");
                        orderItem.setUnitPrice(item.getUnitPrice() + "");
                        orderItem.setPxPrice(list.size() == 0 ? "0" : ((QixinBaseGoodsInfo)list.get(0)).getPxPrice() + "");
                        orderItem.setTaxPrice(list.size() == 0 ? "0" : ((QixinBaseGoodsInfo)list.get(0)).getTaxPrice() + "");
                        orderItem.setNakedPrice(item.getUnitPrice() + "");
                        orderItem.setTaxRate(list.size() == 0 ? "0" : ((QixinBaseGoodsInfo)list.get(0)).getTaxRate() + "");
                        orderItem.setTotalPrice(item.getUnitPrice() + "");
                        orderItem.setTotalTaxPrice("0");
                        orderItem.setTotalNakedPrice(item.getUnitPrice() + "");
                        orderItem.setMaterialNo(item.getMaterialCode());
                        PurchaseOrderItem purchaseOrder = new PurchaseOrderItem();
                        purchaseOrder.setProjectId(projectId);
                        purchaseOrder.setSupCompanyId(item.getSupCompanyId());
                        purchaseOrder.setSupCompanySrmCode(item.getSupCompanyCode());
                        purchaseOrder.setSupCompanyName(item.getSupCompanyName());
                        purchaseOrder.setSupUserId(supUser.getId());
                        purchaseOrder.setSupUserName(supUser.getNickName());
                        purchaseOrder.setProductCode(item.getProductCode());
                        purchaseOrder.setProductCodeWx(item.getProductCodeWx());
                        Material material = this.materialService.queryObjByCode(item.getMaterialCode());
                        purchaseOrder.setMaterialCategoryName(material.getMaterialSpecification());
                        purchaseOrder.setMaterialId(material.getId());
                        purchaseOrder.setMaterialCode(material.getMaterialCode());
                        purchaseOrder.setMaterialName(material.getDescription());
                        purchaseOrder.setQuantity(new BigDecimal(item.getDemandAmount()));
                        purchaseOrder.setPriceUnit(null);
                        purchaseOrder.setOrderUnit(material.getBasicUnit());
                        purchaseOrder.setWarehouseCode(item.getStoreId());
                        purchaseOrder.setWarehouseName(item.getStoreName());
                        purchaseOrder.setCurrency(purchaseRequisition.getCurrencyCode());
                        purchaseOrder.setDeliveryLocation(item.getDeliveryAddress());
                        purchaseOrder.setConsignee(item.getConsignee());
                        purchaseOrder.setConsigneeId(item.getConsigneeId());
                        purchaseOrder.setPurchasePhone(item.getPurchasePhone());
                        purchaseOrder.setOrderStatus(Integer.valueOf(1));
                        purchaseOrder.setPurReqNo(purchaseRequisition.getApplyNo());
                        purchaseOrder.setPurReqItemNo(String.valueOf(item.getItemNo()));
                        purchaseOrder.setOrderItemNo(String.valueOf(item.getItemNo()));
                        BigDecimal up = item.getUnitPrice();
                        BigDecimal total = up.multiply(new BigDecimal(item.getDemandAmount())).setScale(2, 4);
                        purchaseOrder.setTaxUnitPrice(up);
                        purchaseOrder.setTaxTotalPrice(total);
                        purchaseOrder.setTotalPrice(total);
                        purchaseOrder.setBudgetCore(item.getBudgetCenterCode());
                        purchaseOrder.setBudgetCoreDesc(item.getBudgetCenterName());
                        purchaseOrder.setEconomicMatters(item.getEconomicIssuesNo());
                        purchaseOrder.setEconomicMattersDesc(item.getEconomicIssuesDesc());
                        if (item.getDonate() != null) {
                            purchaseOrder.setUses(Integer.toString(item.getDonate()));
                        }
                        orderList.add(purchaseOrder);
                        orderProducts.add(orderItem);
                    }
                    order.setItems(orderList);
                    String orderNo = this.purchaseOrderService.createPurOrder(order, currentCompnay, loginUser);
                    this.logger.info("\u9f50\u5fc3\u9001\u8d27\u5355\u53f7\uff1a{}" + orderNo);
                    this.submitToQiXin(orderNo, orderProducts, qiXinProductList, ((Contacts)contacts.get(0)).getName());
                    this.logger.info("\u8fdb\u5165\u66f4\u65b0\u91c7\u8d2d\u7533\u8bf7\u5934\u5f00\u59cb");
                    purchaseRequisition.setApplyStatusCode(PurchaseRequisitionStatusEnum.ORDER_TRANSFORMED.code());
                    purchaseRequisition.setApplyStatusDesc(PurchaseRequisitionStatusEnum.ORDER_TRANSFORMED.desc());
                    this.purchaseRequisitionHeadService.updateByPrimaryKey((PurchaseRequisitionHead)purchaseRequisition);
                    this.logger.info("\u8fdb\u5165\u66f4\u65b0\u91c7\u8d2d\u7533\u8bf7\u5934\u7ed3\u675f");
                }
            } else {
                purchaseRequisition.setApplyStatusCode(PurchaseRequisitionStatusEnum.ADJUSTMENT_REQUIRED.code());
                purchaseRequisition.setApplyStatusDesc(PurchaseRequisitionStatusEnum.ADJUSTMENT_REQUIRED.desc());
                this.purchaseRequisitionHeadService.updateByPrimaryKey((PurchaseRequisitionHead)purchaseRequisition);
            }
        });
    }

    private boolean checkQixinPrice(Map<Object, List<PurchaseRequisitionItem>> detailmapQiXin, boolean qixin) {
        for (Object key : detailmapQiXin.keySet()) {
            List<PurchaseRequisitionItem> purchaseRequisitionItemValue = detailmapQiXin.get(key);
            for (PurchaseRequisitionItem item : purchaseRequisitionItemValue) {
                BasicGoodsInfos basicGoodsInfos = this.qixinBaseGoodsInfoService.syncGoodsInfo(item.getProductCodeWx());
                PurchaseRequisitionItem purchaseRequisitionItem = new PurchaseRequisitionItem();
                if (item.getUnitPrice().compareTo(BigDecimal.valueOf(basicGoodsInfos.getPxPrice())) == 1) {
                    qixin = false;
                    purchaseRequisitionItem.setPreUnitPrice(item.getUnitPrice());
                    purchaseRequisitionItem.setUnitPrice(BigDecimal.valueOf(basicGoodsInfos.getPxPrice()));
                    purchaseRequisitionItem.setOrderEorrReason("\u4ef7\u683c\u4e0d\u4e00\u81f4");
                }
                if (basicGoodsInfos.getStore() < (double)item.getDemandAmount().intValue()) {
                    qixin = false;
                    purchaseRequisitionItem.setJdStockAmount((int)basicGoodsInfos.getStore());
                    purchaseRequisitionItem.setOrderEorrReason(purchaseRequisitionItem.getOrderEorrReason() + ",\u5e93\u5b58\u4e0d\u6ee1\u8db3");
                }
                if (qixin) continue;
                PurchaseRequisitionItemExample exampleDel = new PurchaseRequisitionItemExample();
                exampleDel.createCriteria().andIdEqualTo(item.getId());
                this.purchaseRequisitionItemService.modifyByExample(purchaseRequisitionItem, exampleDel);
            }
        }
        return qixin;
    }

    private String fetchGroupKey(PurchaseRequisitionItem detail) {
        return detail.getDeliveryAddress() + "_" + detail.getBranchName() + "_" + detail.getConsignee() + "_" + detail.getPurchasePhone() + "_" + detail.getCtAccountDeptName();
    }

    private void submitToQiXin(String orderNo, List<SubmitOrderItem> orderProducts, List<String> productCodeList, String name) {
        SubmitOrderHeader submitOrderHeader = new SubmitOrderHeader();
        submitOrderHeader.setPxOrderId(orderNo);
        submitOrderHeader.setOrderProducts(orderProducts);
        for (String productCode : productCodeList) {
            PurchaseUserOrderItemExtExample extExample = new PurchaseUserOrderItemExtExample();
            extExample.createCriteria().andOrderNoEqualTo(productCode);
            List itemExts = this.purchaseUserOrderItemExtService.queryAllObjByExample((IExample)extExample);
            Assert.isNotEmpty((Collection)itemExts, (String)"\u5bf9\u5e94\u7684\u5546\u54c1\u6269\u5c55\u4fe1\u606f\u4e3a\u7a7a");
            DeliveryInfo deliveryInfo = new DeliveryInfo();
            BeanUtil.copyProperties(itemExts.get(0), (Object)deliveryInfo);
            submitOrderHeader.setDeliveryInfo(deliveryInfo);
            RecipientsInfo recipientsInfo = new RecipientsInfo();
            BeanUtil.copyProperties(itemExts.get(0), (Object)recipientsInfo);
            submitOrderHeader.setRecipientsInfo(recipientsInfo);
            submitOrderHeader.setCustomerName(name);
            InvoiceInfo invoiceInfo = new InvoiceInfo();
            BeanUtil.copyProperties(itemExts.get(0), (Object)invoiceInfo);
            submitOrderHeader.setInvoiceInfo(invoiceInfo);
        }
        submitOrderHeader.setCreatedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        submitOrderHeader.setIsEmergency("0");
        submitOrderHeader.setPayWay("0");
        submitOrderHeader.setSignData("110120110");
        SubmitOrderResult submitOrderResult = this.comixApiService.submitOrderToQiXin(submitOrderHeader);
        this.checkSubmitOrder(submitOrderHeader, submitOrderResult);
    }

    private void checkSubmitOrder(SubmitOrderHeader submitOrderHeader, SubmitOrderResult submitOrderResult) {
        MsgHeader msgHeader = submitOrderResult.getMsgHeader();
        if (ObjectUtils.isEmpty((Object)msgHeader)) {
            throw new CommonException("\u63d0\u4ea4\u91c7\u8d2d\u8ba2\u5355\u5230\u9f50\u5fc3," + msgHeader.getRetMessage());
        }
        String retCode = msgHeader.getRetCode();
        if (ObjectUtils.isEmpty((Object)retCode)) {
            throw new CommonException("\u63d0\u4ea4\u91c7\u8d2d\u8ba2\u5355\u5230\u9f50\u5fc3," + msgHeader.getRetMessage());
        }
        SubmitOrderResult confirmResult = this.comixApiService.orderConfirm(submitOrderHeader);
        MsgHeader msgConfirmHeader = confirmResult.getMsgHeader();
        if (ObjectUtils.isEmpty((Object)msgConfirmHeader)) {
            throw new CommonException("\u9884\u8ba2\u5355\u786e\u8ba4," + msgConfirmHeader.getRetMessage());
        }
        String retConfirmCode = msgConfirmHeader.getRetCode();
        if (ObjectUtils.isEmpty((Object)retConfirmCode)) {
            throw new CommonException("\u9884\u8ba2\u5355\u786e\u8ba4," + msgConfirmHeader.getRetMessage());
        }
    }
}

