/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command;

import com.els.base.certification.contacts.entity.Contacts;
import com.els.base.certification.contacts.service.ContactsService;
import com.els.base.common.ContextUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.functional.BigDecimalFunction;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.ObjectHolder;
import com.els.base.company.utils.Objects;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.material.entity.Material;
import com.els.base.material.service.MaterialService;
import com.els.base.product.entity.PurchaseUserOrderItemExt;
import com.els.base.product.entity.PurchaseUserOrderItemExtExample;
import com.els.base.product.service.PurchaseUserOrderItemExtService;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseRequisitionHead;
import com.els.base.purchase.entity.PurchaseRequisitionItem;
import com.els.base.purchase.enumerate.PurchaseRequisitionStatusEnum;
import com.els.base.purchase.service.OrderBudgetHandleService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.service.PurchaseRequisitionHeadService;
import com.els.base.purchase.service.PurchaseRequisitionItemService;
import com.els.base.purchase.vo.PurchaseRequisitionEventVO;
import com.els.base.utils.SpringContextHolder;
import com.els.comix.service.ComixApiService;
import com.els.comix.service.QixinBaseGoodsInfoService;
import com.els.comix.vo.baseGoodsInfo.BasicGoodsInfos;
import com.els.comix.vo.submitOrder.DeliveryInfo;
import com.els.comix.vo.submitOrder.InvoiceInfo;
import com.els.comix.vo.submitOrder.RecipientsInfo;
import com.els.comix.vo.submitOrder.SubmitOrderHeader;
import com.els.comix.vo.submitOrder.SubmitOrderItem;
import com.els.comix.vo.submitOrder.SubmitOrderResult;
import com.els.sinolifesdk.service.SinoLifeApiService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class QixinOrderCommand2
extends BaseCommand<String> {
    private static final long serialVersionUID = 1L;
    private MaterialService materialService = (MaterialService)SpringContextHolder.getOneBean(MaterialService.class);
    private CompanyService companyService = (CompanyService)SpringContextHolder.getOneBean(CompanyService.class);
    private CompanyUserRefService companyUserRefService = (CompanyUserRefService)SpringContextHolder.getOneBean(CompanyUserRefService.class);
    private ContactsService contactsService = (ContactsService)SpringContextHolder.getOneBean(ContactsService.class);
    private PurchaseRequisitionItemService purchaseRequisitionItemService = (PurchaseRequisitionItemService)SpringContextHolder.getOneBean(PurchaseRequisitionItemService.class);
    private QixinBaseGoodsInfoService qixinBaseGoodsInfoService = (QixinBaseGoodsInfoService)SpringContextHolder.getOneBean(QixinBaseGoodsInfoService.class);
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private PurchaseOrderService purchaseOrderService = (PurchaseOrderService)SpringContextHolder.getOneBean(PurchaseOrderService.class);
    private ComixApiService comixApiService = (ComixApiService)SpringContextHolder.getOneBean(ComixApiService.class);
    private PurchaseUserOrderItemExtService purchaseUserOrderItemExtService = (PurchaseUserOrderItemExtService)SpringContextHolder.getOneBean(PurchaseUserOrderItemExtService.class);
    private PurchaseRequisitionHeadService purchaseRequisitionHeadService = (PurchaseRequisitionHeadService)SpringContextHolder.getOneBean(PurchaseRequisitionHeadService.class);
    private SinoLifeApiService sinolifeApiService = (SinoLifeApiService)SpringContextHolder.getOneBean(SinoLifeApiService.class);
    private OrderBudgetHandleService orderBudgetHandleService = (OrderBudgetHandleService)SpringContextHolder.getOneBean(OrderBudgetHandleService.class);
    private PurchaseRequisitionEventVO purchaseRequisitionEventVO;

    public QixinOrderCommand2() {
    }

    public QixinOrderCommand2(PurchaseRequisitionEventVO purchaseRequisitionEventVO) {
        this.purchaseRequisitionEventVO = purchaseRequisitionEventVO;
    }

    @Transactional
    public String execute(ICommandInvoker iCommandInvoker) {
        this.logger.debug("QixinOrderCommand2\u7c7bexecute\u65b9\u6cd5start");
        this.logger.info("\u83b7\u53d6\u91c7\u8d2d\u7533\u8bf7\u4fe1\u606f");
        PurchaseRequisitionHead purchaseRequisition = this.purchaseRequisitionEventVO.getPurchaseRequisitionHead();
        this.logger.info("\u68c0\u67e5\u91c7\u8d2d\u7533\u8bf7\u5934\u662f\u5426\u4e3a\u7a7a");
        this.check(purchaseRequisition);
        this.logger.info("\u521d\u59cb\u5316\u4fe1\u606f,\u6bd4\u5982\u8bf4\u91c7\u8d2d\u7533\u8bf7\u884c\u4ee5\u53ca\u91c7\u8d2d\u7533\u8bf7\u9644\u4ef6");
        this.checkPurchaseRequisitionItem(purchaseRequisition);
        this.logger.info("\u9f50\u5fc3\u4e0b\u5355");
        this.toProcessOrder(purchaseRequisition);
        this.logger.debug("QixinOrderCommand2\u7c7bexecute\u65b9\u6cd5end");
        return null;
    }

    private void check(PurchaseRequisitionHead purchaseRequisition) {
        if (ObjectUtils.isEmpty((Object)purchaseRequisition)) {
            throw new CommonException("\u91c7\u8d2d\u7533\u8bf7\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)purchaseRequisition.getId())) {
            throw new CommonException("\u91c7\u8d2d\u7533\u8bf7\u5934ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void checkPurchaseRequisitionItem(PurchaseRequisitionHead purchaseRequisition) {
        if (CollectionUtils.isEmpty(purchaseRequisition.getPurchaseRequisitionItemList())) {
            throw new CommonException("\u91c7\u8d2d\u7533\u8bf7\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    private void toProcessOrder(PurchaseRequisitionHead purchaseRequisition) {
        List<PurchaseRequisitionItem> prItemList = purchaseRequisition.getPurchaseRequisitionItemList();
        Map<String, List<PurchaseRequisitionItem>> prItemGroupMap = this.purchaseRequisitionItemService.groupingByConsigneeInfo(prItemList);
        if (MapUtils.isEmpty(prItemGroupMap)) {
            this.logger.info("\u6839\u636e\u6536\u8d27\u4eba\u4fe1\u606f\u5206\u7ec4\u540e\u7684map\u4e3a\u7a7a");
            return;
        }
        ArrayList orderResults = new ArrayList();
        prItemGroupMap.forEach((key, itemList) -> {
            if (CollectionUtils.isNotEmpty((Collection)itemList)) {
                SubmitOrderHeader submitOrderHeader = this.initSubmitOrderHeader(purchaseRequisition, (List<PurchaseRequisitionItem>)itemList);
                PurchaseOrder purchaseOrder = this.initPurchaseOrder(purchaseRequisition);
                this.fillOrderItem(submitOrderHeader, purchaseOrder, purchaseRequisition, (List<PurchaseRequisitionItem>)itemList);
                String result = this.submitOrderToQiXin(submitOrderHeader, purchaseOrder, purchaseRequisition, (List<PurchaseRequisitionItem>)itemList);
                orderResults.add(result);
            }
        });
        PurchaseRequisitionStatusEnum status = orderResults.contains("0") ? PurchaseRequisitionStatusEnum.ADJUSTMENT_REQUIRED : PurchaseRequisitionStatusEnum.ORDER_TRANSFORMED;
        this.logger.info("\u66f4\u65b0\u91c7\u8d2d\u7533\u8bf7\u5355\u4e3a{}", (Object)status.desc());
        this.purchaseRequisitionHeadService.updateApplyStatus(purchaseRequisition, status, pr -> {
            if (!orderResults.contains("0")) {
                pr.setTransformedType("O");
            }
        });
        try {
            this.orderBudgetHandleService.ordering(purchaseRequisition);
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528bep\u9884\u7b97\u5904\u7406/\u9884\u4ed8\u63a5\u53e3\u5931\u8d25", (Throwable)e);
            try {
                this.purchaseRequisitionHeadService.updateApplyStatus(purchaseRequisition, PurchaseRequisitionStatusEnum.PREPAY_FAILED, pr -> pr.setPrepayStatus(3));
            }
            catch (Exception e2) {
                this.logger.error("\u66f4\u65b0\u91c7\u8d2d\u7533\u8bf7\u9884\u4ed8\u5931\u8d25\u72b6\u6001\u5931\u8d25", (Throwable)e2);
            }
        }
    }

    private String submitOrderToQiXin(SubmitOrderHeader submitOrderHeader, PurchaseOrder purchaseOrder, PurchaseRequisitionHead purchaseRequisition, List<PurchaseRequisitionItem> purchaseRequisitionItemList) {
        try {
            SubmitOrderResult submitOrderResult1 = this.comixApiService.submitOrderToQiXin(submitOrderHeader);
            if (submitOrderResult1 == null || submitOrderResult1.getMsgHeader() == null || !"Y".equalsIgnoreCase(submitOrderResult1.getMsgHeader().getRetCode())) {
                String retMessage = null;
                retMessage = submitOrderResult1 == null ? "\u8c03\u7528\u9f50\u5fc3\u63d0\u4ea4\u8ba2\u5355\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3anull" : (submitOrderResult1.getMsgHeader() == null ? "\u8c03\u7528\u9f50\u5fc3\u63d0\u4ea4\u8ba2\u5355\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u7684msgHeader\u4e3anull" : submitOrderResult1.getMsgHeader().getRetMessage());
                throw new CommonException(retMessage);
            }
            SubmitOrderResult submitOrderResult2 = this.comixApiService.orderConfirm(submitOrderHeader.getPxOrderId());
            if (submitOrderResult2 == null || submitOrderResult2.getMsgHeader() == null || !"Y".equalsIgnoreCase(submitOrderResult2.getMsgHeader().getRetCode())) {
                String retMessage = null;
                retMessage = submitOrderResult2 == null ? "\u8c03\u7528\u9f50\u5fc3\u786e\u8ba4\u8ba2\u5355\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3anull" : (submitOrderResult2.getMsgHeader() == null ? "\u8c03\u7528\u9f50\u5fc3\u786e\u8ba4\u8ba2\u5355\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u7684msgHeader\u4e3anull" : submitOrderResult2.getMsgHeader().getRetMessage());
                throw new CommonException(retMessage);
            }
            Company currentCompnay = this.purchaseRequisitionEventVO.getCompany();
            User loginUser = new User();
            loginUser.setId(purchaseRequisition.getInitiatorId());
            loginUser.setNickName(purchaseRequisition.getInitiatorName());
            purchaseOrder.setQixinOrderNo(submitOrderHeader.getPxOrderId());
            this.purchaseOrderService.createPurOrderQixin(purchaseOrder, currentCompnay, loginUser);
            purchaseRequisitionItemList.stream().forEach(item -> this.purchaseRequisitionItemService.update((PurchaseRequisitionItem)item, it -> {
                it.setOrderStatus("1");
                it.setOrderEorrReason("");
                it.setOrderNoWx(purchaseOrder.getQixinOrderNo());
                it.setPurOrderNo(purchaseOrder.getOrderNo());
                it.setPurOrderingDate(new Date());
            }));
            return "1";
        }
        catch (Exception e) {
            this.logger.info("\u4e0b\u5355\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a\uff1a{}", (Object)e.getMessage());
            this.logger.debug("\u66f4\u65b0\u91c7\u8d2d\u7533\u8bf7\u884c\u8ba2\u5355\u72b6\u6001\u5f00\u59cb");
            purchaseRequisitionItemList.stream().forEach(item -> this.purchaseRequisitionItemService.update((PurchaseRequisitionItem)item, it -> {
                it.setOrderStatus("0");
                it.setOrderEorrReason(e.getMessage());
            }));
            this.logger.debug("\u66f4\u65b0\u91c7\u8d2d\u7533\u8bf7\u884c\u8ba2\u5355\u72b6\u6001\u7ed3\u675f");
            return "0";
        }
    }

    private void fillOrderItem(SubmitOrderHeader submitOrderHeader, PurchaseOrder purchaseOrder, PurchaseRequisitionHead purchaseRequisition, List<PurchaseRequisitionItem> purchaseRequisitionItemList) {
        ArrayList submitOrderItemList = new ArrayList();
        ArrayList purchaseOrderItemList = new ArrayList();
        ObjectHolder orderMoney = ObjectHolder.of((Object)BigDecimal.ZERO);
        purchaseRequisitionItemList.stream().forEach(item -> {
            BasicGoodsInfos basicGoodsInfos = this.qixinBaseGoodsInfoService.syncGoodsInfo(item.getProductCodeWx());
            Assert.isNotNull((Object)basicGoodsInfos, (String)"\u9f50\u5fc3\u8fd4\u56de\u7684\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            BigDecimal unitPrice = item.getUnitPrice() != null ? item.getUnitPrice() : BigDecimal.ZERO;
            Integer demandAmount = item.getDemandAmount() != null ? item.getDemandAmount() : 0;
            BigDecimal amountWithTax = item.getAmountWithTax() != null ? item.getAmountWithTax() : BigDecimal.ZERO;
            String unitPriceStr = unitPrice.toString();
            String totalPriceStr = amountWithTax.toString();
            SubmitOrderItem submitOrderItem = new SubmitOrderItem();
            submitOrderItem.setMaterialNo(item.getMaterialCode());
            submitOrderItem.setProductNo(item.getProductCodeWx());
            submitOrderItem.setProductNum(demandAmount.toString());
            submitOrderItem.setPriceType("1");
            submitOrderItem.setUnitPrice(unitPriceStr);
            submitOrderItem.setNakedPrice(unitPriceStr);
            submitOrderItem.setTotalPrice(totalPriceStr);
            submitOrderItem.setTotalNakedPrice(totalPriceStr);
            submitOrderItem.setTotalTaxPrice("0");
            submitOrderItem.setPxPrice(Objects.toString((Object)basicGoodsInfos.getPxPrice(), (String)""));
            submitOrderItem.setTaxPrice(Objects.toString((Object)basicGoodsInfos.getTaxPrice(), (String)""));
            submitOrderItem.setTaxRate(Objects.toString((Object)basicGoodsInfos.getTaxRate(), (String)""));
            submitOrderItemList.add(submitOrderItem);
            PurchaseOrderItem purchaseOrderItem = new PurchaseOrderItem();
            purchaseOrderItem.setProjectId(this.purchaseRequisitionEventVO.getProjectId());
            purchaseOrderItem.setSupCompanyId(item.getSupCompanyId());
            purchaseOrderItem.setSupCompanySrmCode(item.getSupCompanyCode());
            purchaseOrderItem.setSupCompanyName(item.getSupCompanyName());
            purchaseOrderItem.setSupUserId(purchaseOrder.getSupUserId());
            purchaseOrderItem.setSupUserName(purchaseOrder.getSupUserName());
            purchaseOrderItem.setProductCode(item.getProductCode());
            purchaseOrderItem.setProductCodeWx(item.getProductCodeWx());
            Material material = this.materialService.queryObjByCode(item.getMaterialCode());
            purchaseOrderItem.setMaterialCategoryName(material.getMaterialSpecification());
            purchaseOrderItem.setMaterialId(material.getId());
            purchaseOrderItem.setMaterialCode(material.getMaterialCode());
            purchaseOrderItem.setMaterialName(material.getDescription());
            purchaseOrderItem.setQuantity(new BigDecimal(item.getDemandAmount()));
            purchaseOrderItem.setPriceUnit(null);
            purchaseOrderItem.setOrderUnit(material.getBasicUnit());
            purchaseOrderItem.setWarehouseCode(item.getStoreId());
            purchaseOrderItem.setWarehouseName(item.getStoreName());
            purchaseOrderItem.setCurrency(purchaseRequisition.getCurrencyCode());
            purchaseOrderItem.setDeliveryLocation(item.getDeliveryAddress());
            purchaseOrderItem.setConsignee(item.getConsignee());
            purchaseOrderItem.setConsigneeId(item.getConsigneeId());
            purchaseOrderItem.setPurchasePhone(item.getPurchasePhone());
            purchaseOrderItem.setOrderStatus(Integer.valueOf(1));
            purchaseOrderItem.setPurReqNo(purchaseRequisition.getApplyNo());
            purchaseOrderItem.setPurReqItemNo(String.valueOf(item.getItemNo()));
            purchaseOrderItem.setOrderItemNo(String.valueOf(item.getItemNo()));
            BigDecimal up = item.getUnitPrice();
            BigDecimal total = up.multiply(new BigDecimal(item.getDemandAmount())).setScale(2, 4);
            purchaseOrderItem.setTaxUnitPrice(up);
            purchaseOrderItem.setTaxTotalPrice(total);
            purchaseOrderItem.setTotalPrice(total);
            orderMoney.value = BigDecimalFunction.ADD.apply(orderMoney.value, total);
            purchaseOrderItem.setBudgetCore(item.getBudgetCenterCode());
            purchaseOrderItem.setBudgetCoreDesc(item.getBudgetCenterName());
            purchaseOrderItem.setEconomicMatters(item.getEconomicIssuesNo());
            purchaseOrderItem.setEconomicMattersDesc(item.getEconomicIssuesDesc());
            purchaseOrderItem.setUses(Objects.toString((Object)item.getDonate(), (String)""));
            purchaseOrderItemList.add(purchaseOrderItem);
        });
        submitOrderHeader.setOrderProducts(submitOrderItemList);
        purchaseOrder.setItems(purchaseOrderItemList);
        purchaseOrder.setTaxTotalPrice((BigDecimal)orderMoney.value);
        purchaseOrder.setOrderTotal((BigDecimal)orderMoney.value);
        PurchaseRequisitionItem first = purchaseRequisitionItemList.get(0);
        purchaseOrder.setAccountCode(first.getCtBusinessBook());
        purchaseOrder.setAccountSetId(first.getCtAccountSetId());
        purchaseOrder.setAccountSetName(first.getCtAccountSetName());
        purchaseOrder.setInTheOrganizationId(first.getBranchId());
        purchaseOrder.setInTheOrganizationName(first.getBranchName());
        purchaseOrder.setDepartId(first.getCtAccountDeptCode());
        purchaseOrder.setDepartName(first.getCtAccountDeptName());
    }

    private PurchaseOrder initPurchaseOrder(PurchaseRequisitionHead purchaseRequisition) {
        PurchaseOrder purchaseOrder = new PurchaseOrder();
        purchaseOrder.setProjectId(ProjectUtils.getProjectId());
        purchaseOrder.setPurchaseApplyNo(purchaseRequisition.getApplyNo());
        purchaseOrder.setBepVoucherNo(purchaseRequisition.getBepApplyNo());
        purchaseOrder.setExpensesApplyNo(purchaseRequisition.getBepApplySn());
        Company supCompany = (Company)this.companyService.queryObjById((Object)purchaseRequisition.getSupCompanyId());
        purchaseOrder.setSupCompanyId(supCompany.getId());
        purchaseOrder.setSupCompanyName(supCompany.getCompanyFullName());
        purchaseOrder.setSupCompanyShortName(supCompany.getCompanyName());
        purchaseOrder.setSupCompanySrmCode(supCompany.getCompanyCode());
        User supUser = this.companyUserRefService.queryMainUserOfCompany(supCompany.getId());
        purchaseOrder.setSupUserId(supUser.getId());
        purchaseOrder.setSupUserName(supUser.getNickName());
        List contacts = this.contactsService.queryAllContacts(supCompany.getId());
        if (CollectionUtils.isNotEmpty((Collection)contacts)) {
            purchaseOrder.setSupplierPerson(((Contacts)contacts.get(0)).getName());
            purchaseOrder.setSupplierTel(((Contacts)contacts.get(0)).getMobilePhone());
            purchaseOrder.setSupplierFax(((Contacts)contacts.get(0)).getFax());
        }
        purchaseOrder.setPurPlanerId(purchaseRequisition.getInitiatorId());
        purchaseOrder.setPurPlanerName(purchaseRequisition.getInitiatorName());
        purchaseOrder.setCurrency(purchaseRequisition.getCurrencyCode());
        purchaseOrder.setContractNumber(purchaseRequisition.getContractNo());
        purchaseOrder.setDataSource(purchaseRequisition.getDataSource());
        return purchaseOrder;
    }

    private SubmitOrderHeader initSubmitOrderHeader(PurchaseRequisitionHead purchaseRequisition, List<PurchaseRequisitionItem> itemList) {
        PurchaseRequisitionItem purchaseRequisitionItem = itemList.get(0);
        SubmitOrderHeader submitOrderHeader = new SubmitOrderHeader();
        String deliveryOrderNo = ContextUtils.getGenerateCodeService().getNextCode("DELIVERY_NO_GENERATOR");
        submitOrderHeader.setPxOrderId(deliveryOrderNo);
        DeliveryInfo deliveryInfo = new DeliveryInfo();
        deliveryInfo.setDeliveryName(purchaseRequisitionItem.getConsignee());
        deliveryInfo.setCompany(purchaseRequisitionItem.getBranchName());
        deliveryInfo.setProvince(purchaseRequisitionItem.getProvinceId());
        deliveryInfo.setCity(purchaseRequisitionItem.getCityId());
        deliveryInfo.setCounty(purchaseRequisitionItem.getCountyId());
        deliveryInfo.setAddress(purchaseRequisitionItem.getDeliveryAddress());
        deliveryInfo.setZip(purchaseRequisitionItem.getZip());
        deliveryInfo.setMobile(purchaseRequisitionItem.getPurchasePhone());
        deliveryInfo.setEmail(purchaseRequisitionItem.getConsigneeEmail());
        deliveryInfo.setRemark(purchaseRequisitionItem.getConsigneeRemark());
        submitOrderHeader.setDeliveryInfo(deliveryInfo);
        submitOrderHeader.setCustomerName(purchaseRequisitionItem.getBranchName());
        RecipientsInfo recipientsInfo = new RecipientsInfo();
        recipientsInfo.setCreatorCompany(purchaseRequisition.getInitiatorOrganizationName());
        recipientsInfo.setCreatorName(purchaseRequisition.getInitiatorName());
        recipientsInfo.setCreatorPhone(purchaseRequisition.getInitiatorPhone());
        recipientsInfo.setCreatorMobile(purchaseRequisition.getInitiatorPhone());
        submitOrderHeader.setRecipientsInfo(recipientsInfo);
        PurchaseUserOrderItemExt itemExt = this.getOrderItemExt(purchaseRequisitionItem.getProductCode());
        InvoiceInfo invoiceInfo = new InvoiceInfo();
        invoiceInfo.setInvoiceType("ZZ");
        invoiceInfo.setInvoiceTitle(this.getInvoiceTitle(purchaseRequisitionItem.getBranchId()));
        invoiceInfo.setInvoiceContent("01");
        invoiceInfo.setReceiver(itemExt.getReceiver());
        invoiceInfo.setRecMobile(itemExt.getRecMobile());
        invoiceInfo.setRecAddr(itemExt.getRecAddr());
        submitOrderHeader.setInvoiceInfo(invoiceInfo);
        submitOrderHeader.setCreatedTime(DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        submitOrderHeader.setIsEmergency("0");
        submitOrderHeader.setPayWay("0");
        submitOrderHeader.setSignData("110120110");
        return submitOrderHeader;
    }

    private PurchaseUserOrderItemExt getOrderItemExt(String productCode) {
        PurchaseUserOrderItemExtExample extExample = new PurchaseUserOrderItemExtExample();
        extExample.createCriteria().andOrderNoEqualTo(productCode);
        List itemExts = this.purchaseUserOrderItemExtService.queryAllObjByExample((IExample)extExample);
        Assert.isNotEmpty((Collection)itemExts, (String)"\u5bf9\u5e94\u7684\u5546\u54c1\u6269\u5c55\u4fe1\u606f\u4e3a\u7a7a");
        return (PurchaseUserOrderItemExt)itemExts.get(0);
    }

    private String getInvoiceTitle(String branchCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("branchCode", branchCode);
        this.logger.info("\u8c03\u7528VMS\u4ea4\u4e92\u53d1\u7968\u4fe1\u606f: {}" + map);
        Map vmsMap = this.sinolifeApiService.queryTaxpayerInfo(map);
        this.logger.info("\u8c03\u7528VMS\u8fd4\u56de\u7ed3\u679c: {}" + vmsMap);
        return (String)vmsMap.get("taxpayerName");
    }
}

