/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.contacts.entity.Contacts;
import com.els.base.certification.contacts.service.ContactsService;
import com.els.base.company.entity.Company;
import com.els.base.company.functional.BigDecimalFunction;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.utils.ObjectHolder;
import com.els.base.company.utils.Objects;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.material.entity.Material;
import com.els.base.material.service.MaterialService;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseRequisitionHead;
import com.els.base.purchase.entity.PurchaseRequisitionItem;
import com.els.base.purchase.enumerate.PurchaseRequisitionStatusEnum;
import com.els.base.purchase.service.OrderBudgetHandleService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.service.PurchaseRequisitionHeadService;
import com.els.base.purchase.service.PurchaseRequisitionItemService;
import com.els.base.purchase.vo.PurchaseRequisitionEventVO;
import com.els.base.utils.SpringContextHolder;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.ObjectUtils;

public class SupOrderCommand
extends BaseCommand<String> {
    private static final long serialVersionUID = 1L;
    private CompanyService companyService = (CompanyService)SpringContextHolder.getOneBean(CompanyService.class);
    private ContactsService contactsService = (ContactsService)SpringContextHolder.getOneBean(ContactsService.class);
    private MaterialService materialService = (MaterialService)SpringContextHolder.getOneBean(MaterialService.class);
    private PurchaseOrderService purchaseOrderService = (PurchaseOrderService)SpringContextHolder.getOneBean(PurchaseOrderService.class);
    private CompanyUserRefService companyUserRefService = (CompanyUserRefService)SpringContextHolder.getOneBean(CompanyUserRefService.class);
    private OrderBudgetHandleService orderBudgetHandleService = (OrderBudgetHandleService)SpringContextHolder.getOneBean(OrderBudgetHandleService.class);
    private PurchaseRequisitionHeadService purchaseRequisitionHeadService = (PurchaseRequisitionHeadService)SpringContextHolder.getOneBean(PurchaseRequisitionHeadService.class);
    private PurchaseRequisitionItemService purchaseRequisitionItemService = (PurchaseRequisitionItemService)SpringContextHolder.getOneBean(PurchaseRequisitionItemService.class);
    private PurchaseRequisitionEventVO purchaseRequisitionEventVO;

    public SupOrderCommand(PurchaseRequisitionEventVO purchaseRequisitionEventVO) {
        this.purchaseRequisitionEventVO = purchaseRequisitionEventVO;
    }

    public String execute(ICommandInvoker invoker) {
        this.logger.debug("\u8fdb\u5165SupOrderCommand\u7c7bexecute\u65b9\u6cd5");
        this.logger.info("\u83b7\u53d6\u91c7\u8d2d\u7533\u8bf7\u4fe1\u606f");
        PurchaseRequisitionHead purchaseRequisition = this.purchaseRequisitionEventVO.getPurchaseRequisitionHead();
        this.logger.info("\u68c0\u67e5\u91c7\u8d2d\u7533\u8bf7\u5934\u662f\u5426\u4e3a\u7a7a");
        this.check(purchaseRequisition);
        this.logger.info("\u68c0\u67e5\u91c7\u8d2d\u7533\u8bf7\u884c\u662f\u5426\u4e3a\u7a7a");
        this.checkPurchaseRequisitionItem(purchaseRequisition);
        this.logger.info("\u4eac\u4e1c\u4e0b\u5355");
        this.toProcessOrder(purchaseRequisition);
        return null;
    }

    private void check(PurchaseRequisitionHead purchaseRequisitionHead) {
        if (ObjectUtils.isEmpty((Object)purchaseRequisitionHead)) {
            throw new CommonException("\u91c7\u8d2d\u7533\u8bf7\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)purchaseRequisitionHead.getId())) {
            throw new CommonException("\u91c7\u8d2d\u7533\u8bf7\u5934ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void checkPurchaseRequisitionItem(PurchaseRequisitionHead purchaseRequisitionHead) {
        if (CollectionUtils.isEmpty(purchaseRequisitionHead.getPurchaseRequisitionItemList())) {
            throw new CommonException("\u91c7\u8d2d\u7533\u8bf7\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    private void toProcessOrder(PurchaseRequisitionHead purchaseRequisition) {
        Company currentCompnay = CompanyUtils.currentCompany();
        User loginUser = SpringSecurityUtils.getLoginUser();
        Company supCompany = (Company)this.companyService.queryObjById((Object)purchaseRequisition.getSupCompanyId());
        User supUser = this.companyUserRefService.queryMainUserOfCompany(supCompany.getId());
        List<PurchaseRequisitionItem> prItemList = purchaseRequisition.getPurchaseRequisitionItemList();
        Map<String, List<PurchaseRequisitionItem>> prItemGroupMap = this.purchaseRequisitionItemService.groupingByConsigneeInfo(prItemList);
        if (MapUtils.isEmpty(prItemGroupMap)) {
            this.logger.info("\u6839\u636e\u6536\u8d27\u4eba\u4fe1\u606f\u5206\u7ec4\u540e\u7684map\u4e3a\u7a7a");
            return;
        }
        prItemGroupMap.forEach((key, itemList) -> {
            PurchaseOrder purchaseOrder = this.initPurchaseOrder(purchaseRequisition, loginUser, supCompany, supUser);
            this.initPurchaseOrderItem(purchaseOrder, purchaseRequisition, (List<PurchaseRequisitionItem>)itemList, supUser);
            String orderNo = this.purchaseOrderService.createPurOrder(purchaseOrder, currentCompnay, loginUser);
            Date now = new Date();
            purchaseRequisition.getPurchaseRequisitionItemList().stream().forEach(item -> this.purchaseRequisitionItemService.update((PurchaseRequisitionItem)item, it -> {
                it.setOrderNoWx(orderNo);
                it.setPurOrderNo(orderNo);
                it.setPurOrderingDate(now);
            }));
        });
        this.purchaseRequisitionHeadService.updateApplyStatus(purchaseRequisition, PurchaseRequisitionStatusEnum.ORDER_TRANSFORMED, pr -> pr.setTransformedType("O"));
        this.orderBudgetHandleService.ordering(purchaseRequisition);
        if (purchaseRequisition.getPurchaseRequisitionItemList().stream().filter(item -> Objects.equals((Object)item.getPrepay(), (Object)1)).count() > 0L) {
            this.purchaseRequisitionHeadService.prepay(purchaseRequisition);
        }
    }

    private PurchaseOrder initPurchaseOrder(PurchaseRequisitionHead purchaseRequisition, User planUser, Company supCompany, User supUser) {
        PurchaseOrder purchaseOrder = new PurchaseOrder();
        purchaseOrder.setProjectId(ProjectUtils.getProjectId());
        purchaseOrder.setPurchaseApplyNo(purchaseRequisition.getApplyNo());
        purchaseOrder.setBepVoucherNo(purchaseRequisition.getBepApplyNo());
        purchaseOrder.setExpensesApplyNo(purchaseRequisition.getBepApplySn());
        purchaseOrder.setSupCompanyId(supCompany.getId());
        purchaseOrder.setSupCompanyName(supCompany.getCompanyFullName());
        purchaseOrder.setSupCompanyShortName(supCompany.getCompanyName());
        purchaseOrder.setSupCompanySrmCode(supCompany.getCompanyCode());
        purchaseOrder.setSupUserId(supUser.getId());
        purchaseOrder.setSupUserName(supUser.getNickName());
        List contacts = this.contactsService.queryAllContacts(supCompany.getId());
        if (CollectionUtils.isNotEmpty((Collection)contacts)) {
            purchaseOrder.setSupplierPerson(((Contacts)contacts.get(0)).getName());
            purchaseOrder.setSupplierTel(((Contacts)contacts.get(0)).getMobilePhone());
            purchaseOrder.setSupplierFax(((Contacts)contacts.get(0)).getFax());
        }
        purchaseOrder.setPurPlanerId(planUser.getId());
        purchaseOrder.setPurPlanerName(planUser.getNickName());
        purchaseOrder.setCurrency(purchaseRequisition.getCurrencyCode());
        purchaseOrder.setContractNumber(purchaseRequisition.getContractNo());
        purchaseOrder.setDataSource(purchaseRequisition.getDataSource());
        return purchaseOrder;
    }

    private List<PurchaseOrderItem> initPurchaseOrderItem(PurchaseOrder purchaseOrder, PurchaseRequisitionHead purchaseRequisition, List<PurchaseRequisitionItem> itemList, User supUser) {
        String projectId = ProjectUtils.getProjectId();
        ObjectHolder totalMoney = ObjectHolder.of((Object)BigDecimal.ZERO);
        List<PurchaseOrderItem> poiList = itemList.stream().map(pri -> {
            PurchaseOrderItem poi = new PurchaseOrderItem();
            poi.setProjectId(projectId);
            poi.setSupCompanyId(pri.getSupCompanyId());
            poi.setSupCompanySrmCode(pri.getSupCompanyCode());
            poi.setSupCompanyName(pri.getSupCompanyName());
            poi.setSupUserId(supUser.getId());
            poi.setSupUserName(supUser.getNickName());
            Material material = this.materialService.queryObjByCode(pri.getMaterialCode());
            poi.setMaterialCategoryName(material.getMaterialSpecification());
            poi.setMaterialId(material.getId());
            poi.setMaterialCode(material.getMaterialCode());
            poi.setMaterialName(material.getDescription());
            poi.setQuantity(new BigDecimal(pri.getDemandAmount()));
            poi.setPriceUnit(null);
            poi.setOrderUnit(material.getBasicUnit());
            poi.setWarehouseCode(pri.getStoreId());
            poi.setWarehouseName(pri.getStoreName());
            poi.setCurrency(purchaseRequisition.getCurrencyCode());
            poi.setDeliveryLocation(pri.getDeliveryAddress());
            poi.setConsignee(pri.getConsignee());
            poi.setConsigneeId(pri.getConsigneeId());
            poi.setPurchasePhone(pri.getPurchasePhone());
            poi.setOrderStatus(Integer.valueOf(1));
            poi.setPurReqNo(purchaseRequisition.getApplyNo());
            poi.setPurReqItemNo(String.valueOf(pri.getItemNo()));
            poi.setOrderItemNo(String.valueOf(pri.getItemNo()));
            BigDecimal up = pri.getUnitPrice();
            BigDecimal total = up.multiply(new BigDecimal(pri.getDemandAmount())).setScale(2, 4);
            poi.setTaxUnitPrice(up);
            poi.setTaxTotalPrice(total);
            poi.setTotalPrice(total);
            totalMoney.value = BigDecimalFunction.ADD.apply(totalMoney.value, total);
            poi.setBudgetCore(pri.getBudgetCenterCode());
            poi.setBudgetCoreDesc(pri.getBudgetCenterName());
            poi.setEconomicMatters(pri.getEconomicIssuesNo());
            poi.setEconomicMattersDesc(pri.getEconomicIssuesDesc());
            poi.setUses(Integer.toString(pri.getDonate()));
            poi.setProductCode(pri.getProductCode());
            poi.setProductCodeWx(pri.getProductCodeWx());
            return poi;
        }).collect(Collectors.toList());
        purchaseOrder.setTaxTotalPrice((BigDecimal)totalMoney.value);
        purchaseOrder.setOrderTotal((BigDecimal)totalMoney.value);
        purchaseOrder.setItems(poiList);
        PurchaseRequisitionItem first = itemList.get(0);
        purchaseOrder.setAccountCode(first.getCtBusinessBook());
        purchaseOrder.setAccountSetId(first.getCtAccountSetId());
        purchaseOrder.setAccountSetName(first.getCtAccountSetName());
        purchaseOrder.setInTheOrganizationId(first.getBranchId());
        purchaseOrder.setInTheOrganizationName(first.getBranchName());
        purchaseOrder.setDepartId(first.getCtAccountDeptCode());
        purchaseOrder.setDepartName(first.getCtAccountDeptName());
        return poiList;
    }
}

