/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.listener;

import com.els.base.company.functional.BigDecimalFunction;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.user.User;
import com.els.base.core.service.user.UserService;
import com.els.base.msg.mail.entity.MailAccount;
import com.els.base.msg.mail.service.MailAccountService;
import com.els.base.msg.mail.utils.SmtpSendUtils;
import com.els.base.product.vo.ProductOriginEnum;
import com.els.base.purchase.entity.PurchaseRequisitionHead;
import com.els.base.purchase.entity.PurchaseRequisitionItem;
import com.els.base.purchase.event.JdOrderPassEvent;
import com.els.base.purchase.vo.OrderMoneyVO;
import com.els.base.purchase.vo.PurchaseRequisitionEventVO;
import com.els.base.template.center.entity.TemplateCenter;
import com.els.base.template.center.service.TemplateCenterService;
import com.els.base.template.center.utils.TemplateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Component
public class JdOrderPassListener
implements ApplicationListener<JdOrderPassEvent> {
    private Logger logger = LoggerFactory.getLogger(JdOrderPassListener.class);
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;
    @Resource
    private CompanyService companyService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private TemplateCenterService templateCenterService;
    @Resource
    private MailAccountService mailAccountService;
    @Resource
    private UserService userService;

    @Async
    @Transactional
    public void onApplicationEvent(JdOrderPassEvent jdOrderPassEvent) {
        if (jdOrderPassEvent == null) {
            return;
        }
        Object source = jdOrderPassEvent.getSource();
        if (ObjectUtils.isEmpty((Object)source)) {
            return;
        }
        if (source instanceof PurchaseRequisitionEventVO) {
            this.sendEmailToJD((PurchaseRequisitionEventVO)source);
        }
    }

    private void sendEmailToJD(PurchaseRequisitionEventVO eventSource) {
        PurchaseRequisitionHead purchaseRequisition = eventSource.getPurchaseRequisitionHead();
        if (purchaseRequisition == null) {
            this.logger.warn("\u53d1\u9001\u90ae\u4ef6\u7ed9\u4eac\u4e1c\u65f6purchaseRequisition\u4e3a{}", (Object)purchaseRequisition);
            return;
        }
        List<PurchaseRequisitionItem> itemList = purchaseRequisition.getPurchaseRequisitionItemList();
        if (CollectionUtils.isEmpty(itemList)) {
            this.logger.warn("\u53d1\u9001\u90ae\u4ef6\u7ed9\u4eac\u4e1c\u65f6itemList(\u91c7\u8d2d\u7533\u8bf7\u884c\u5217\u8868)\u4e3a{}", itemList);
            return;
        }
        MailAccount sendMailAccount = this.mailAccountService.querySystemDefaultMailAccout();
        if (sendMailAccount == null) {
            this.logger.warn("\u6ca1\u6709\u914d\u7f6e\u7cfb\u7edf\u9ed8\u8ba4\u90ae\u7bb1\uff0c\u65e0\u6cd5\u53d1\u9001\u90ae\u4ef6");
            return;
        }
        String supCompanyId = purchaseRequisition.getSupCompanyId();
        if (StringUtils.isBlank((String)supCompanyId)) {
            this.logger.warn("purchaseRequisition\u4e2d\u7684\u4f9b\u5e94\u5546ID\u4e3a{}", (Object)supCompanyId);
            return;
        }
        List userList = this.companyUserRefService.queryUserListOfCompany(supCompanyId);
        if (CollectionUtils.isEmpty((Collection)userList) || StringUtils.isBlank((String)((User)userList.get(0)).getEmail())) {
            this.logger.warn("\u4f9b\u5e94\u5546 {}({}) \u6ca1\u6709\u5728\u7528\u6237\u8868\u914d\u7f6e\u4fe1\u606f\u6216\u90ae\u7bb1", (Object)purchaseRequisition.getSupCompanyName(), (Object)purchaseRequisition.getSupCompanyCode());
            return;
        }
        User initiatorUser = (User)this.userService.queryObjById((Object)purchaseRequisition.getInitiatorId());
        if (CollectionUtils.isEmpty((Collection)userList) || StringUtils.isBlank((String)((User)userList.get(0)).getEmail())) {
            this.logger.warn("\u53d1\u8d77\u4eba {} \u6ca1\u6709\u5728\u7528\u6237\u8868\u914d\u7f6e\u4fe1\u606f\u6216\u90ae\u7bb1", (Object)purchaseRequisition.getInitiatorName());
            return;
        }
        TemplateCenter templateCenter = this.templateCenterService.queryObjByTemplateNo("ORDER_CANCELLATION");
        if (templateCenter == null || StringUtils.isBlank((String)templateCenter.getTemplateContent())) {
            this.logger.warn("\u5728\u6a21\u677f\u4e2d\u5fc3\u6ca1\u6709\u914d\u7f6e\u6a21\u677f\u7f16\u53f7\u4e3a\uff1aORDER_CANCELLATION \u7684\u6a21\u677f");
            return;
        }
        Map<String, List<PurchaseRequisitionItem>> orderNoListMap = itemList.stream().filter(item -> StringUtils.isNotBlank((String)item.getOrderNoWx())).collect(Collectors.groupingBy(PurchaseRequisitionItem::getOrderNoWx));
        if (MapUtils.isEmpty(orderNoListMap)) {
            this.logger.warn("\u6ca1\u6709\u5df2\u4e0b\u5355\u7684\u8ba2\u5355,{}", orderNoListMap);
            return;
        }
        ArrayList omList = new ArrayList(orderNoListMap.size());
        orderNoListMap.forEach((orderNo, tmpList) -> {
            BigDecimal orderTotal = tmpList.stream().map(item -> {
                BigDecimal amountWithTax = item.getAmountWithTax() != null ? item.getAmountWithTax() : BigDecimal.ZERO;
                BigDecimal freight = item.getFreight() != null ? item.getFreight() : BigDecimal.ZERO;
                return (BigDecimal)BigDecimalFunction.ADD.apply(amountWithTax, freight);
            }).reduce(BigDecimalFunction.ADD).orElse(BigDecimal.ZERO);
            omList.add(OrderMoneyVO.of(orderNo, orderTotal));
        });
        BigDecimal totalMoney = omList.stream().map(OrderMoneyVO::getMoney).reduce(BigDecimalFunction.ADD).orElse(BigDecimal.ZERO);
        Map<String, Object> resultMap = eventSource.getResultMap();
        resultMap.put("orderMoneyList", omList);
        resultMap.put("totalMoney", totalMoney);
        String receiveName = ((User)userList.get(0)).getNickName() + "," + initiatorUser.getNickName();
        String receiveEmailAddress = ((User)userList.get(0)).getEmail() + "," + initiatorUser.getEmail();
        String content = TemplateUtils.process((String)templateCenter.getTemplateContent(), resultMap);
        String subject = "\u8ba2\u5355\u6838\u9500";
        if (ProductOriginEnum.JD.getValue().equals(purchaseRequisition.getDataSource())) {
            this.defaultThreadPool.execute(() -> {
                this.logger.debug("--------\u8ba2\u5355\u6838\u9500\u5f00\u59cb\u53d1\u9001\u90ae\u4ef6------");
                try {
                    SmtpSendUtils.sendMail((MailAccount)sendMailAccount, (String)receiveEmailAddress, (String)receiveName, (String)subject, (String)content);
                }
                catch (Exception e) {
                    this.logger.error("\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
                }
                this.logger.debug("--------\u8ba2\u5355\u6838\u9500\u7ed3\u675f\u53d1\u9001\u90ae\u4ef6------");
            });
        }
    }
}

