/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.listener.impl;

import com.els.base.company.functional.BigDecimalFunction;
import com.els.base.company.utils.ObjectHolder;
import com.els.base.core.entity.IExample;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.inquiry.listener.QuotationListener;
import com.els.base.purchase.entity.PurchaseRequisitionHead;
import com.els.base.purchase.entity.PurchaseRequisitionHeadExample;
import com.els.base.purchase.entity.PurchaseRequisitionItem;
import com.els.base.purchase.entity.PurchaseRequisitionItemExample;
import com.els.base.purchase.enumerate.PurchaseRequisitionStatusEnum;
import com.els.base.purchase.service.PurchaseRequisitionHeadService;
import com.els.base.purchase.service.PurchaseRequisitionItemService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PurchaseRequisition2QuotationListener
implements QuotationListener {
    @Autowired
    private PurchaseRequisitionHeadService purchaseRequisitionHeadService;
    @Autowired
    private PurchaseRequisitionItemService purchaseRequisitionItemService;

    public void pricingOrder(PurOrder purOrder) {
        if (purOrder != null && CollectionUtils.isNotEmpty((Collection)purOrder.getItemList())) {
            PurchaseRequisitionHeadExample headExample = new PurchaseRequisitionHeadExample();
            headExample.createCriteria().andTransformedTypeEqualTo("Q").andTransformedNoEqualTo(purOrder.getOrderNo());
            List list = this.purchaseRequisitionHeadService.queryAllObjByExample((IExample)headExample);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            PurchaseRequisitionHead purchaseRequisition = (PurchaseRequisitionHead)list.get(0);
            PurchaseRequisitionItemExample itemExample = new PurchaseRequisitionItemExample();
            itemExample.createCriteria().andHeadIdEqualTo(purchaseRequisition.getId());
            List itemList = this.purchaseRequisitionItemService.queryAllObjByExample((IExample)itemExample);
            ObjectHolder totalMoney = ObjectHolder.of((Object)BigDecimal.ZERO);
            List<PurchaseRequisitionItem> tmpItemList = itemList.stream().map(item -> {
                PurchaseRequisitionItem tmpItem = new PurchaseRequisitionItem();
                tmpItem.setId(item.getId());
                tmpItem.setMaterialCode(item.getMaterialCode());
                tmpItem.setDemandAmount(item.getDemandAmount());
                return tmpItem;
            }).collect(Collectors.toList());
            tmpItemList.stream().forEach(item -> purOrder.getItemList().stream().filter(tmp -> OperationTypeEnum.ACCEPTED.getCode().equals(tmp.getOperation()) && item.getMaterialCode().equals(tmp.getMaterialCode())).findFirst().ifPresent(orderItem -> {
                item.setSupCompanyId(orderItem.getSupCompanyId());
                item.setSupCompanyCode(orderItem.getSupCompanySrmCode());
                item.setSupCompanyName(orderItem.getSupCompanyName());
                item.setUnitPrice(orderItem.getUntaxedUnitPrice());
                BigDecimal amountWithTax = (BigDecimal)BigDecimalFunction.MULTIPLY.apply(orderItem.getUntaxedUnitPrice(), new BigDecimal(item.getDemandAmount()));
                item.setAmountWithTax(amountWithTax);
                totalMoney.value = ((BigDecimal)totalMoney.value).add(amountWithTax);
            }));
            PurchaseRequisitionHead tmpHead = new PurchaseRequisitionHead();
            tmpHead.setId(purchaseRequisition.getId());
            tmpHead.setApplyStatusCode(PurchaseRequisitionStatusEnum.QUOTATION_FINISHED.code());
            tmpHead.setApplyStatusDesc(PurchaseRequisitionStatusEnum.QUOTATION_FINISHED.desc());
            tmpHead.setSupCompanyId(((PurchaseRequisitionItem)tmpItemList.get(0)).getSupCompanyId());
            tmpHead.setSupCompanyCode(((PurchaseRequisitionItem)tmpItemList.get(0)).getSupCompanyCode());
            tmpHead.setSupCompanyName(((PurchaseRequisitionItem)tmpItemList.get(0)).getSupCompanyName());
            tmpHead.setTotalMoney((BigDecimal)totalMoney.value);
            tmpHead.setPurchaseRequisitionItemList(tmpItemList);
            this.purchaseRequisitionHeadService.updateSupplierInfo(tmpHead);
        }
    }
}

