/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.schedule;

import com.els.base.company.utils.Objects;
import com.els.base.core.entity.IExample;
import com.els.base.purchase.entity.PurchaseRequisitionHead;
import com.els.base.purchase.entity.PurchaseRequisitionHeadExample;
import com.els.base.purchase.enumerate.PurchaseRequisitionStatusEnum;
import com.els.base.purchase.service.OrderBudgetHandleService;
import com.els.base.purchase.service.PurchaseRequisitionHeadService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PurchaseRequisitionPrepayScheduleImpl {
    private static final Logger logger = LoggerFactory.getLogger(PurchaseRequisitionPrepayScheduleImpl.class);
    private static final String PREFIX = "\u6267\u884c\u91c7\u8d2d\u7533\u8bf7\u9884\u4ed8\u64cd\u4f5c---";
    @Resource
    private PurchaseRequisitionHeadService purchaseRequisitionHeadService;
    @Resource
    private OrderBudgetHandleService orderBudgetHandleService;

    public void prepay() {
        logger.info("{}\u5f00\u59cb", (Object)PREFIX);
        PurchaseRequisitionHeadExample example = new PurchaseRequisitionHeadExample();
        example.or().andApplyStatusCodeEqualTo(PurchaseRequisitionStatusEnum.PREPAY_FAILED.code());
        List prList = this.purchaseRequisitionHeadService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)prList)) {
            logger.info("{}\u6ca1\u6709\u8981\u5904\u7406\u7684\u6570\u636e", (Object)PREFIX);
            return;
        }
        prList.stream().forEach(pr -> {
            try {
                logger.info("{}\u5904\u7406{}---\u5f00\u59cb", (Object)PREFIX, (Object)pr.getApplyNo());
                this.purchaseRequisitionHeadService.checkOutDetailLine((PurchaseRequisitionHead)pr);
                ArrayList<PurchaseRequisitionHead> tmpPrList = new ArrayList<PurchaseRequisitionHead>(1);
                tmpPrList.add((PurchaseRequisitionHead)pr);
                this.orderBudgetHandleService.ordering(tmpPrList);
                long count = pr.getPurchaseRequisitionItemList().stream().filter(item -> !Objects.equals((Object)1, (Object)item.getBepBudgetFrozen())).count();
                if (count == 0L) {
                    this.purchaseRequisitionHeadService.prepay((PurchaseRequisitionHead)pr);
                }
                logger.info("{}\u5904\u7406{}---\u7ed3\u675f", (Object)PREFIX, (Object)pr.getApplyNo());
            }
            catch (Exception e) {
                logger.info("{}\u5904\u7406{}---\u7ed3\u675f => {}", new Object[]{PREFIX, pr.getApplyNo(), e});
            }
        });
        logger.info("{}\u7ed3\u675f", (Object)PREFIX);
    }
}

