/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.exception.CommonException;
import com.els.base.purchase.entity.PurchaseRequisitionHead;
import com.els.base.purchase.entity.PurchaseRequisitionItem;
import com.els.base.purchase.service.OrderBudgetHandleService;
import com.els.base.purchase.service.PurchaseRequisitionItemService;
import com.els.sinolifesdk.service.SinoLifeApiService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

@Service
public class OrderBudgetHandleServiceImpl
implements OrderBudgetHandleService {
    private static final String ORDER_INFO_BUDGET_SERVICE = "orderInfoBudgetService";
    @Autowired
    private SinoLifeApiService sinoLifeApiService;
    @Autowired
    private PurchaseRequisitionItemService purchaseRequisitionItemService;

    @Override
    @CacheEvict(value={"purchaseRequisitionItem"}, allEntries=true)
    public void ordering(PurchaseRequisitionHead purchaseRequisition) {
        ArrayList<PurchaseRequisitionHead> prList = new ArrayList<PurchaseRequisitionHead>(1);
        prList.add(purchaseRequisition);
        this.ordering(prList);
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionItem"}, allEntries=true)
    public void ordering(List<PurchaseRequisitionHead> prList) {
        LinkedList toBeUpdatedList = new LinkedList();
        LinkedList orderInfoList = new LinkedList();
        prList.stream().forEach(purchaseRequisition -> {
            HashMap<String, List> itemMap = new HashMap<String, List>();
            purchaseRequisition.getPurchaseRequisitionItemList().stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getPurOrderNo()) && !Objects.equals(it.getBepBudgetFrozen(), 1)).forEach(it -> {
                itemMap.computeIfAbsent(it.getPurOrderNo(), orderNo -> new LinkedList()).add(it);
                toBeUpdatedList.add(it);
            });
            itemMap.forEach((orderNo, itemList) -> {
                HashMap<String, Object> orderInfo = new HashMap<String, Object>();
                orderInfo.put("bepVoucherNo", purchaseRequisition.getBepApplyNo());
                orderInfo.put("orderId", orderNo);
                orderInfo.put("applyEmpId", purchaseRequisition.getInitiatorEmpId());
                orderInfo.put("orderTime", ((PurchaseRequisitionItem)itemList.get(0)).getPurOrderingDate());
                List dtlList = itemList.stream().map(item -> {
                    HashMap<String, Object> detailInfo = new HashMap<String, Object>();
                    detailInfo.put("branchId", item.getBranchId());
                    detailInfo.put("budgetCenter", item.getBudgetCenterCode());
                    detailInfo.put("economicIssuesNo", item.getEconomicIssuesNo());
                    detailInfo.put("isDonation", Objects.equals(item.getDonate(), 1) ? "Y" : "N");
                    detailInfo.put("donationType", item.getDonationType());
                    BigDecimal applyAmount = item.getFreight() != null ? item.getFreight().add(item.getAmountWithTax()) : item.getAmountWithTax();
                    detailInfo.put("applyAmount", applyAmount);
                    return detailInfo;
                }).collect(Collectors.toList());
                orderInfo.put("orderDtlList", dtlList);
                orderInfoList.add(orderInfo);
            });
        });
        if (CollectionUtils.isNotEmpty(orderInfoList)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("orderInfoList", orderInfoList);
            paramMap.put("type", "01");
            Map resultMap = this.sinoLifeApiService.executeForPcp(ORDER_INFO_BUDGET_SERVICE, paramMap);
            if (!"Y".equals(resultMap.get("p_flag"))) {
                throw new CommonException("\u8c03\u7528BEP\u9884\u7b97\u5904\u7406\u5931\u8d25: " + resultMap.get("p_msg"));
            }
            toBeUpdatedList.stream().forEach(item -> this.purchaseRequisitionItemService.update((PurchaseRequisitionItem)item, it -> it.setBepBudgetFrozen(1)));
        }
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionItem"}, allEntries=true)
    public void cancelOrder(PurchaseRequisitionHead purchaseRequisition) {
        ArrayList<PurchaseRequisitionHead> prList = new ArrayList<PurchaseRequisitionHead>(1);
        prList.add(purchaseRequisition);
        this.cancelOrder(prList);
    }

    @Override
    @CacheEvict(value={"purchaseRequisitionItem"}, allEntries=true)
    public void cancelOrder(List<PurchaseRequisitionHead> prList) {
        LinkedList toBeUpdatedList = new LinkedList();
        LinkedList orderInfoList = new LinkedList();
        prList.stream().forEach(purchaseRequisition -> {
            HashMap<String, List> itemMap = new HashMap<String, List>();
            purchaseRequisition.getPurchaseRequisitionItemList().stream().filter(it -> Objects.equals(it.getBepBudgetFrozen(), 1)).forEach(it -> {
                itemMap.computeIfAbsent(it.getPurOrderNo(), orderNo -> itemMap.put((String)orderNo, new LinkedList())).add(it);
                toBeUpdatedList.add(it);
            });
            itemMap.forEach((orderNo, itemList) -> {
                HashMap<String, String> orderInfo = new HashMap<String, String>();
                orderInfo.put("bepVoucherNo", purchaseRequisition.getBepApplyNo());
                orderInfo.put("orderId", (String)orderNo);
                orderInfoList.add(orderInfo);
            });
        });
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("orderInfoList", orderInfoList);
        paramMap.put("type", "02");
        Map resultMap = this.sinoLifeApiService.executeForPcp(ORDER_INFO_BUDGET_SERVICE, paramMap);
        if (!"Y".equals(resultMap.get("p_flag"))) {
            throw new CommonException("\u8c03\u7528BEP\u9884\u7b97\u5904\u7406\u5931\u8d25: " + resultMap.get("p_msg"));
        }
        toBeUpdatedList.stream().forEach(item -> this.purchaseRequisitionItemService.update((PurchaseRequisitionItem)item, it -> it.setBepBudgetFrozen(2)));
    }
}

