/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.dao.PurchaseBargainConfigMapper;
import com.els.base.purchase.entity.PurchaseBargainConfig;
import com.els.base.purchase.entity.PurchaseBargainConfigExample;
import com.els.base.purchase.service.PurchaseBargainConfigService;
import com.els.base.purchase.vo.PurchaseBargainConfigVO;
import com.els.base.purchase.vo.PurchaseBargainConfigVOExample;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurchaseBargainConfigService")
public class PurchaseBargainConfigServiceImpl
implements PurchaseBargainConfigService {
    @Resource
    protected PurchaseBargainConfigMapper purchaseBargainConfigMapper;

    @CacheEvict(value={"purchaseBargainConfig"}, allEntries=true)
    public void addObj(PurchaseBargainConfig t) {
        this.purchaseBargainConfigMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purchaseBargainConfig"}, allEntries=true)
    public void addAll(List<PurchaseBargainConfig> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseBargainConfigMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseBargainConfig"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseBargainConfigMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseBargainConfig"}, allEntries=true)
    public void deleteByExample(PurchaseBargainConfigExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseBargainConfigMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseBargainConfig"}, allEntries=true)
    public void modifyObj(PurchaseBargainConfig t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purchaseBargainConfigMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseBargainConfig"}, keyGenerator="redisKeyGenerator")
    public PurchaseBargainConfig queryObjById(String id) {
        return this.purchaseBargainConfigMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseBargainConfig"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseBargainConfig> queryAllObjByExample(PurchaseBargainConfigExample example) {
        return this.purchaseBargainConfigMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseBargainConfig"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseBargainConfig> queryObjByPage(PurchaseBargainConfigExample example) {
        PageView<PurchaseBargainConfig> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseBargainConfigMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"purchaseBargainConfig"}, allEntries=true)
    public void config(List<PurchaseBargainConfig> configList) {
        PurchaseBargainConfig config = configList.get(0);
        PurchaseBargainConfigExample example = new PurchaseBargainConfigExample();
        example.createCriteria().andBranchIdEqualTo(config.getBranchId());
        this.deleteByExample(example);
        this.addAll(configList);
    }

    @Override
    public PageView<PurchaseBargainConfigVO> findTreeByPage(PurchaseBargainConfigVOExample example) {
        PageView<PurchaseBargainConfigVO> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseBargainConfigMapper.findTreeByExampleByPage(example));
        return pageView;
    }

    @Override
    public PurchaseBargainConfig determineBargainType(String branchId, BigDecimal amount) {
        return this.purchaseBargainConfigMapper.determineBargainType(branchId, amount);
    }
}

